/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;

public class BoxPopupMenu
extends SIPCommPopupMenu {
    private static final long serialVersionUID = -8488327445916201464L;
    private int itemsCount;
    private int gridRowCount = 0;
    private int gridColCount = 0;

    public BoxPopupMenu() {
    }

    public BoxPopupMenu(int itemsCount) {
        this.itemsCount = itemsCount;
        this.calculateGridDimensions();
        this.setLayout(new GridLayout(this.gridRowCount, this.gridColCount, 5, 5));
    }

    private void calculateGridDimensions() {
        this.gridRowCount = (int)Math.round(Math.sqrt(this.itemsCount));
        this.gridColCount = this.itemsCount / this.gridRowCount;
    }

    public Point getPopupLocation() {
        Component component = this.getInvoker();
        Point point = new Point();
        int x = component.getX();
        int y = component.getY();
        while (component.getParent() != null) {
            component = component.getParent();
            x += component.getX();
            y += component.getY();
        }
        point.x = x;
        point.y = y + this.getInvoker().getHeight();
        return point;
    }

    public void setItemsCount(int itemsCount) {
        this.itemsCount = itemsCount;
        this.calculateGridDimensions();
        this.setLayout(new GridLayout(this.gridRowCount, this.gridColCount, 5, 5));
    }

    public int getItemsCount() {
        return this.itemsCount;
    }
}

