/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.VideoMediaFormat;
import org.jitsi.util.OSUtils;
import org.jitsi.util.swing.VideoContainer;

public class SelectScreenDialog
extends SIPCommDialog {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(SelectScreenDialog.class);
    private final DeviceComboBoxField deviceComboBox;
    private final JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private static MediaDevice videoDeviceInPreview;
    private MediaDevice selectedDevice;

    public SelectScreenDialog(List<MediaDevice> desktopDevices) {
        this.setModal(true);
        this.setPreferredSize(new Dimension(400, 300));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.deviceComboBox = new DeviceComboBoxField(contentPane, desktopDevices);
        contentPane.add(SelectScreenDialog.createPreview(this.deviceComboBox));
        contentPane.add(this.createButtonsPanel(), "South");
    }

    public MediaDevice getSelectedDevice() {
        return this.selectedDevice;
    }

    private Component createButtonsPanel() {
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectScreenDialog.this.selectedDevice = (MediaDevice)SelectScreenDialog.this.deviceComboBox.getSelectedItem();
                SelectScreenDialog.this.dispose();
            }
        });
        buttonsPanel.add(okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectScreenDialog.this.selectedDevice = null;
                SelectScreenDialog.this.dispose();
            }
        });
        buttonsPanel.add(this.cancelButton);
        return buttonsPanel;
    }

    private static Component createPreview(final DeviceComboBoxField comboBox) {
        JLabel noPreview = new JLabel(GuiActivator.getResources().getI18NString("impl.media.configform.NO_PREVIEW"));
        noPreview.setHorizontalAlignment(0);
        noPreview.setVerticalAlignment(0);
        final JComponent preview = SelectScreenDialog.createVideoContainer(noPreview);
        preview.setPreferredSize(new Dimension(1, 280));
        preview.setMaximumSize(new Dimension(1, 280));
        final DeviceComboBoxField.Listener comboBoxListener = new DeviceComboBoxField.Listener(){

            @Override
            public void onAction() {
                Throwable exception;
                MediaDevice device = (MediaDevice)comboBox.getSelectedItem();
                if (device != null && device.equals(videoDeviceInPreview)) {
                    return;
                }
                try {
                    SelectScreenDialog.createPreview(device, preview);
                    exception = null;
                }
                catch (IOException ex) {
                    exception = ex;
                }
                catch (MediaException ex) {
                    exception = ex;
                }
                if (exception != null) {
                    logger.error((Object)("Failed to create preview for device " + device), exception);
                    device = null;
                }
                videoDeviceInPreview = device;
            }
        };
        comboBox.addListener(comboBoxListener);
        comboBox.getComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent event) {
                if ((event.getChangeFlags() & 2L) != 0L && comboBox.getComponent().isDisplayable()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            comboBoxListener.onAction();
                        }
                    });
                } else if (!comboBox.getComponent().isDisplayable()) {
                    videoDeviceInPreview = null;
                }
            }
        });
        return preview;
    }

    private static void createPreview(MediaDevice device, JComponent videoContainer) throws IOException, MediaException {
        videoContainer.removeAll();
        videoContainer.revalidate();
        videoContainer.repaint();
        if (device == null) {
            return;
        }
        Component c = (Component)GuiActivator.getMediaService().getVideoPreviewComponent(device, videoContainer.getSize().width, videoContainer.getSize().height);
        videoContainer.add(c);
    }

    private static JComponent createVideoContainer(Component noVideoComponent) {
        return new VideoContainer(noVideoComponent, false);
    }

    protected void close(boolean escaped) {
        if (escaped) {
            this.cancelButton.doClick();
        }
    }

    private static class ComboRenderer
    extends DefaultListCellRenderer {
        private ComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            MediaDevice mediaDevice = (MediaDevice)value;
            Dimension screenSize = null;
            if (mediaDevice != null) {
                screenSize = ((VideoMediaFormat)mediaDevice.getFormat()).getSize();
            }
            this.setText(screenSize.width + "x" + screenSize.height);
            return this;
        }
    }

    private static class DeviceComboBoxField {
        private JComboBox deviceComboBox = null;
        private JList deviceList = null;
        private Component deviceComponent;
        private Listener listener;

        public DeviceComboBoxField(Container devicePanel, List<MediaDevice> desktopDevices) {
            if (!OSUtils.IS_WINDOWS) {
                this.deviceComboBox = new JComboBox<Object>(desktopDevices.toArray());
                this.deviceComboBox.setRenderer(new ComboRenderer());
                devicePanel.add(this.deviceComboBox);
                this.deviceComponent = this.deviceComboBox;
            } else {
                this.deviceList = new JList<Object>(desktopDevices.toArray());
                this.deviceList.setCellRenderer(new ComboRenderer());
                JScrollPane listScroller = new JScrollPane(this.deviceList);
                listScroller.setPreferredSize(new Dimension(200, 38));
                this.deviceList.setSelectionMode(1);
                this.deviceList.setLayoutOrientation(0);
                this.deviceList.setVisibleRowCount(-1);
                this.deviceList.setSelectedValue(desktopDevices.get(0), true);
                devicePanel.add((Component)listScroller, "North");
                this.deviceComponent = this.deviceList;
            }
        }

        public Component getComponent() {
            return this.deviceComponent;
        }

        public Object getSelectedItem() {
            return this.deviceComboBox != null ? this.deviceComboBox.getSelectedItem() : this.deviceList.getSelectedValue();
        }

        public void addListener(final Listener listener) {
            this.listener = listener;
            if (this.deviceComboBox != null) {
                this.deviceComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        listener.onAction();
                    }
                });
            } else {
                this.deviceList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        listener.onAction();
                    }
                });
            }
        }

        public static interface Listener {
            public void onAction();
        }
    }
}

