/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

public class ListenerStatus<T extends EventListener> {
    public static final boolean SYNCHONEOUS = true;
    public static final boolean ASYNCHONEOUS = false;
    private final T _listener;
    private final boolean _synch;

    public ListenerStatus(T t, boolean bl) {
        this._listener = t;
        this._synch = bl;
    }

    public T getListener() {
        return this._listener;
    }

    public boolean isSynchronous() {
        return this._synch;
    }

    public int hashCode() {
        return this.getListener().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ListenerStatus && this.getListener().equals(((ListenerStatus)object).getListener());
    }

    public String toString() {
        return "[Status for " + this.getListener().toString() + "]";
    }

    public static class ServiceTypeListenerStatus
    extends ListenerStatus<ServiceTypeListener> {
        private static Logger logger = Logger.getLogger(ServiceTypeListenerStatus.class.getName());
        private final ConcurrentMap<String, String> _addedTypes = new ConcurrentHashMap<String, String>(32);

        public ServiceTypeListenerStatus(ServiceTypeListener serviceTypeListener, boolean bl) {
            super(serviceTypeListener, bl);
        }

        void serviceTypeAdded(ServiceEvent serviceEvent) {
            if (null == this._addedTypes.putIfAbsent(serviceEvent.getType(), serviceEvent.getType())) {
                ((ServiceTypeListener)this.getListener()).serviceTypeAdded(serviceEvent);
            } else {
                logger.finest("Service Type Added called for a service type already added: " + serviceEvent);
            }
        }

        void subTypeForServiceTypeAdded(ServiceEvent serviceEvent) {
            if (null == this._addedTypes.putIfAbsent(serviceEvent.getType(), serviceEvent.getType())) {
                ((ServiceTypeListener)this.getListener()).subTypeForServiceTypeAdded(serviceEvent);
            } else {
                logger.finest("Service Sub Type Added called for a service sub type already added: " + serviceEvent);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(2048);
            stringBuilder.append("[Status for ");
            stringBuilder.append(((ServiceTypeListener)this.getListener()).toString());
            if (this._addedTypes.isEmpty()) {
                stringBuilder.append(" no type event ");
            } else {
                stringBuilder.append(" (");
                for (String string : this._addedTypes.keySet()) {
                    stringBuilder.append(string + ", ");
                }
                stringBuilder.append(") ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static class ServiceListenerStatus
    extends ListenerStatus<ServiceListener> {
        private static Logger logger = Logger.getLogger(ServiceListenerStatus.class.getName());
        private final ConcurrentMap<String, ServiceInfo> _addedServices = new ConcurrentHashMap<String, ServiceInfo>(32);

        public ServiceListenerStatus(ServiceListener serviceListener, boolean bl) {
            super(serviceListener, bl);
        }

        void serviceAdded(ServiceEvent serviceEvent) {
            String string = serviceEvent.getName() + "." + serviceEvent.getType();
            if (null == this._addedServices.putIfAbsent(string, serviceEvent.getInfo().clone())) {
                ((ServiceListener)this.getListener()).serviceAdded(serviceEvent);
                ServiceInfo serviceInfo = serviceEvent.getInfo();
                if (serviceInfo != null && serviceInfo.hasData()) {
                    ((ServiceListener)this.getListener()).serviceResolved(serviceEvent);
                }
            } else {
                logger.finer("Service Added called for a service already added: " + serviceEvent);
            }
        }

        void serviceRemoved(ServiceEvent serviceEvent) {
            String string = serviceEvent.getName() + "." + serviceEvent.getType();
            if (this._addedServices.remove(string, this._addedServices.get(string))) {
                ((ServiceListener)this.getListener()).serviceRemoved(serviceEvent);
            } else {
                logger.finer("Service Removed called for a service already removed: " + serviceEvent);
            }
        }

        synchronized void serviceResolved(ServiceEvent serviceEvent) {
            ServiceInfo serviceInfo = serviceEvent.getInfo();
            if (serviceInfo != null && serviceInfo.hasData()) {
                String string = serviceEvent.getName() + "." + serviceEvent.getType();
                ServiceInfo serviceInfo2 = (ServiceInfo)this._addedServices.get(string);
                if (!ServiceListenerStatus._sameInfo(serviceInfo, serviceInfo2)) {
                    if (null == serviceInfo2) {
                        if (null == this._addedServices.putIfAbsent(string, serviceInfo.clone())) {
                            ((ServiceListener)this.getListener()).serviceResolved(serviceEvent);
                        }
                    } else if (this._addedServices.replace(string, serviceInfo2, serviceInfo.clone())) {
                        ((ServiceListener)this.getListener()).serviceResolved(serviceEvent);
                    }
                } else {
                    logger.finer("Service Resolved called for a service already resolved: " + serviceEvent);
                }
            } else {
                logger.warning("Service Resolved called for an unresolved event: " + serviceEvent);
            }
        }

        private static final boolean _sameInfo(ServiceInfo serviceInfo, ServiceInfo serviceInfo2) {
            byte[] byArray;
            if (serviceInfo == null) {
                return false;
            }
            if (serviceInfo2 == null) {
                return false;
            }
            if (!serviceInfo.equals(serviceInfo2)) {
                return false;
            }
            byte[] byArray2 = serviceInfo.getTextBytes();
            if (byArray2.length != (byArray = serviceInfo2.getTextBytes()).length) {
                return false;
            }
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(2048);
            stringBuilder.append("[Status for ");
            stringBuilder.append(((ServiceListener)this.getListener()).toString());
            if (this._addedServices.isEmpty()) {
                stringBuilder.append(" no type event ");
            } else {
                stringBuilder.append(" (");
                for (String string : this._addedServices.keySet()) {
                    stringBuilder.append(string + ", ");
                }
                stringBuilder.append(") ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

