/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.NetworkTopologyDiscovery;

public class NetworkTopologyDiscoveryImpl
implements NetworkTopologyDiscovery {
    private static final Logger logger = Logger.getLogger(NetworkTopologyDiscoveryImpl.class.getName());
    private final Method _isUp;
    private final Method _supportsMulticast;

    public NetworkTopologyDiscoveryImpl() {
        Method method;
        Method method2;
        try {
            method2 = NetworkInterface.class.getMethod("isUp", null);
        }
        catch (Exception exception) {
            method2 = null;
        }
        this._isUp = method2;
        try {
            method = NetworkInterface.class.getMethod("supportsMulticast", null);
        }
        catch (Exception exception) {
            method = null;
        }
        this._supportsMulticast = method;
    }

    @Override
    public InetAddress[] getInetAddresses() {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Found NetworkInterface/InetAddress: " + networkInterface + " -- " + inetAddress);
                    }
                    if (!this.useInetAddress(networkInterface, inetAddress)) continue;
                    hashSet.add(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            logger.warning("Error while fetching network interfaces addresses: " + socketException);
        }
        return hashSet.toArray(new InetAddress[hashSet.size()]);
    }

    @Override
    public boolean useInetAddress(NetworkInterface networkInterface, InetAddress inetAddress) {
        try {
            if (this._isUp != null) {
                try {
                    if (!((Boolean)this._isUp.invoke((Object)networkInterface, (Object[])null)).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._supportsMulticast != null) {
                try {
                    if (!((Boolean)this._supportsMulticast.invoke((Object)networkInterface, (Object[])null)).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return !inetAddress.isLoopbackAddress();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void lockInetAddress(InetAddress inetAddress) {
    }

    @Override
    public void unlockInetAddress(InetAddress inetAddress) {
    }
}

