/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSMessage;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.tasks.DNSTask;

public class Responder
extends DNSTask {
    static Logger logger = Logger.getLogger(Responder.class.getName());
    private final DNSIncoming _in;
    private final boolean _unicast;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, int n) {
        super(jmDNSImpl);
        this._in = dNSIncoming;
        this._unicast = n != DNSConstants.MDNS_PORT;
    }

    @Override
    public String getName() {
        return "Responder(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public String toString() {
        return super.toString() + " incomming: " + this._in;
    }

    @Override
    public void start(Timer timer) {
        int n;
        boolean bl = true;
        for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.getName() + "start() question=" + dNSQuestion);
            }
            if (bl = dNSQuestion.iAmTheOnlyOne(this.getDns())) continue;
            break;
        }
        int n2 = n = bl && !this._in.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this._in.elapseSinceArrival();
        if (n < 0) {
            n = 0;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.getName() + "start() Responder chosen delay=" + n);
        }
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, n);
        }
    }

    @Override
    public void run() {
        this.getDns().respondToQuery(this._in);
        HashSet<DNSQuestion> hashSet = new HashSet<DNSQuestion>();
        HashSet<DNSRecord> hashSet2 = new HashSet<DNSRecord>();
        if (this.getDns().isAnnounced()) {
            try {
                for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.getName() + "run() JmDNS responding to: " + dNSQuestion);
                    }
                    if (this._unicast) {
                        hashSet.add(dNSQuestion);
                    }
                    dNSQuestion.addAnswers(this.getDns(), hashSet2);
                }
                long l = System.currentTimeMillis();
                for (DNSRecord object : this._in.getAnswers()) {
                    if (!object.isStale(l)) continue;
                    hashSet2.remove(object);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.finer(this.getName() + "JmDNS Responder Known Answer Removed");
                }
                if (!hashSet2.isEmpty()) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.getName() + "run() JmDNS responding");
                    }
                    Object object = new DNSOutgoing(33792, !this._unicast, this._in.getSenderUDPPayload());
                    ((DNSMessage)object).setId(this._in.getId());
                    for (DNSQuestion dNSQuestion : hashSet) {
                        if (dNSQuestion == null) continue;
                        object = this.addQuestion((DNSOutgoing)object, dNSQuestion);
                    }
                    for (DNSRecord dNSRecord : hashSet2) {
                        if (dNSRecord == null) continue;
                        object = this.addAnswer((DNSOutgoing)object, this._in, dNSRecord);
                    }
                    if (!((DNSMessage)object).isEmpty()) {
                        this.getDns().send((DNSOutgoing)object);
                    }
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, this.getName() + "run() exception ", throwable);
                this.getDns().close();
            }
        }
    }
}

