/*
 * Decompiled with CFR 0.152.
 */
package org.jmock;

import java.util.Collection;
import org.jmock.Mock;
import org.jmock.core.CoreMock;
import org.jmock.core.DynamicMock;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.InvocationMocker;
import org.jmock.core.MockObjectSupportTestCase;
import org.jmock.core.Stub;
import org.jmock.core.matcher.InvokeAtLeastOnceMatcher;
import org.jmock.core.matcher.InvokeAtMostOnceMatcher;
import org.jmock.core.matcher.InvokeCountMatcher;
import org.jmock.core.matcher.InvokeOnceMatcher;
import org.jmock.core.matcher.StatelessInvocationMatcher;
import org.jmock.core.matcher.TestFailureMatcher;
import org.jmock.core.stub.CustomStub;
import org.jmock.core.stub.DoAllStub;
import org.jmock.core.stub.ReturnIteratorStub;
import org.jmock.core.stub.ReturnStub;
import org.jmock.core.stub.StubSequence;
import org.jmock.core.stub.ThrowStub;
import org.jmock.util.NotImplementedException;

public abstract class MockObjectTestCase
extends MockObjectSupportTestCase {
    public MockObjectTestCase() {
    }

    public MockObjectTestCase(String string) {
        super(string);
    }

    public Mock mock(Class clazz) {
        return this.mock(clazz, this.defaultMockNameForType(clazz));
    }

    public Mock mock(Class clazz, String string) {
        Mock mock = new Mock(this.newCoreMock(clazz, string));
        this.registerToVerify(mock);
        return mock;
    }

    protected DynamicMock newCoreMock(Class clazz, String string) {
        return new CoreMock(clazz, string);
    }

    @Override
    public Object newDummy(Class clazz) {
        return this.newDummy(clazz, "dummy" + Formatting.classShortName(clazz));
    }

    @Override
    public Object newDummy(final Class clazz, final String string) {
        DynamicMock dynamicMock = this.newCoreMock(clazz, string);
        InvocationMocker invocationMocker = new InvocationMocker();
        invocationMocker.addMatcher(new StatelessInvocationMatcher(){

            @Override
            public boolean matches(Invocation invocation) {
                return invocation.invokedMethod.getDeclaringClass() == clazz;
            }

            @Override
            public StringBuffer describeTo(StringBuffer stringBuffer) {
                return stringBuffer.append("any invokedMethod declared in " + clazz);
            }
        });
        invocationMocker.setStub(new CustomStub("dummy invokedMethod"){

            @Override
            public Object invoke(Invocation invocation) throws Throwable {
                throw new NotImplementedException(invocation.invokedMethod.getName() + " called on " + string);
            }
        });
        dynamicMock.addInvokable(invocationMocker);
        return dynamicMock.proxy();
    }

    @Override
    public Object newDummy(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    public String defaultMockNameForType(Class clazz) {
        return "mock" + Formatting.classShortName(clazz);
    }

    public Stub returnValue(Object object) {
        return new ReturnStub(object);
    }

    public Stub returnValue(boolean bl) {
        return this.returnValue(new Boolean(bl));
    }

    public Stub returnValue(byte by) {
        return this.returnValue(new Byte(by));
    }

    public Stub returnValue(char c) {
        return this.returnValue(new Character(c));
    }

    public Stub returnValue(short s) {
        return this.returnValue(new Short(s));
    }

    public Stub returnValue(int n) {
        return this.returnValue(new Integer(n));
    }

    public Stub returnValue(long l) {
        return this.returnValue(new Long(l));
    }

    public Stub returnValue(float f) {
        return this.returnValue(new Float(f));
    }

    public Stub returnValue(double d) {
        return this.returnValue(new Double(d));
    }

    public Stub returnIterator(Collection collection) {
        return new ReturnIteratorStub(collection);
    }

    public Stub returnIterator(Object[] objectArray) {
        return new ReturnIteratorStub(objectArray);
    }

    public Stub throwException(Throwable throwable) {
        return new ThrowStub(throwable);
    }

    public InvocationMatcher once() {
        return new InvokeOnceMatcher();
    }

    public InvocationMatcher atLeastOnce() {
        return new InvokeAtLeastOnceMatcher();
    }

    public InvocationMatcher atMostOnce() {
        return new InvokeAtMostOnceMatcher();
    }

    public InvocationMatcher exactly(int n) {
        return new InvokeCountMatcher(n);
    }

    public InvocationMatcher never() {
        return new TestFailureMatcher("not expected");
    }

    public InvocationMatcher never(String string) {
        return new TestFailureMatcher("not expected (" + string + ")");
    }

    public Stub onConsecutiveCalls(Stub stub, Stub stub2) {
        return this.onConsecutiveCalls(new Stub[]{stub, stub2});
    }

    public Stub onConsecutiveCalls(Stub stub, Stub stub2, Stub stub3) {
        return this.onConsecutiveCalls(new Stub[]{stub, stub2, stub3});
    }

    public Stub onConsecutiveCalls(Stub stub, Stub stub2, Stub stub3, Stub stub4) {
        return this.onConsecutiveCalls(new Stub[]{stub, stub2, stub3, stub4});
    }

    public Stub onConsecutiveCalls(Stub[] stubArray) {
        return new StubSequence(stubArray);
    }

    public Stub doAll(Stub stub, Stub stub2) {
        return this.doAll(new Stub[]{stub, stub2});
    }

    public Stub doAll(Stub stub, Stub stub2, Stub stub3) {
        return this.doAll(new Stub[]{stub, stub2, stub3});
    }

    public Stub doAll(Stub stub, Stub stub2, Stub stub3, Stub stub4) {
        return this.doAll(new Stub[]{stub, stub2, stub3, stub4});
    }

    public Stub doAll(Stub[] stubArray) {
        return new DoAllStub(stubArray);
    }
}

