/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Method;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.jmock.core.Constraint;
import org.jmock.core.DynamicMock;
import org.jmock.core.DynamicMockError;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationDispatcher;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.InvocationMocker;
import org.jmock.core.Invokable;
import org.jmock.core.LIFOInvocationDispatcher;
import org.jmock.core.Stub;
import org.jmock.core.constraint.IsAnything;
import org.jmock.core.matcher.ArgumentsMatcher;
import org.jmock.core.matcher.MethodNameMatcher;
import org.jmock.core.matcher.NoArgumentsMatcher;
import org.jmock.core.stub.CustomStub;
import org.jmock.core.stub.ReturnStub;

public abstract class AbstractDynamicMock
implements DynamicMock {
    private InvocationDispatcher invocationDispatcher;
    private Class mockedType;
    private String name;
    private DynamicMockError failure = null;
    private static final InvocationMocker.Describer NO_DESCRIPTION = new InvocationMocker.Describer(){

        @Override
        public boolean hasDescription() {
            return false;
        }

        @Override
        public void describeTo(StringBuffer stringBuffer, List list, Stub stub, String string) {
        }
    };

    public AbstractDynamicMock(Class clazz, String string) {
        this(clazz, string, new LIFOInvocationDispatcher());
    }

    public AbstractDynamicMock(Class clazz, String string, InvocationDispatcher invocationDispatcher) {
        this.mockedType = clazz;
        this.name = string;
        this.invocationDispatcher = invocationDispatcher;
        this.setupDefaultBehaviour();
    }

    @Override
    public abstract Object proxy();

    @Override
    public Class getMockedType() {
        return this.mockedType;
    }

    @Override
    public void setDefaultStub(Stub stub) {
        this.invocationDispatcher.setDefaultStub(stub);
    }

    @Override
    public void addInvokable(Invokable invokable) {
        this.invocationDispatcher.add(invokable);
    }

    @Override
    public void reset() {
        this.invocationDispatcher.clear();
        this.forgetFailure();
        this.setupDefaultBehaviour();
    }

    @Override
    public void verify() {
        this.forgetFailure();
        try {
            this.invocationDispatcher.verify();
        }
        catch (AssertionFailedError assertionFailedError) {
            throw new AssertionFailedError("mock object " + this.name + ": " + assertionFailedError.getMessage());
        }
    }

    public String toString() {
        return this.name;
    }

    public String getMockName() {
        return this.name;
    }

    public static String mockNameFromClass(Class clazz) {
        return "mock" + Formatting.classShortName(clazz);
    }

    protected Object mockInvocation(Invocation invocation) throws Throwable {
        if (this.failure != null && !this.isObjectMethod(invocation.invokedMethod)) {
            throw this.failure;
        }
        try {
            Object object = this.invocationDispatcher.dispatch(invocation);
            invocation.checkReturnTypeCompatibility(object);
            return object;
        }
        catch (AssertionFailedError assertionFailedError) {
            this.failure = new DynamicMockError(this, invocation, this.invocationDispatcher, assertionFailedError.getMessage());
            this.failure.fillInStackTrace();
            throw this.failure;
        }
    }

    private boolean isObjectMethod(Method method) {
        return this.isToString(method) || this.isEquals(method) || this.isHashCode(method);
    }

    private boolean isEquals(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        return method.getName().equals("equals") && classArray.length == 1 && classArray[0] == Object.class;
    }

    private boolean isToString(Method method) {
        return method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    private boolean isHashCode(Method method) {
        return method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    private void setupDefaultBehaviour() {
        this.addInvokable(this.hiddenInvocationMocker("toString", NoArgumentsMatcher.INSTANCE, new ReturnStub(this.name)));
        this.addInvokable(this.hiddenInvocationMocker("equals", new ArgumentsMatcher(new Constraint[]{new IsAnything()}), new IsSameAsProxyStub()));
        this.addInvokable(this.hiddenInvocationMocker("hashCode", NoArgumentsMatcher.INSTANCE, new HashCodeStub()));
    }

    private void forgetFailure() {
        this.failure = null;
    }

    private InvocationMocker hiddenInvocationMocker(String string, InvocationMatcher invocationMatcher, Stub stub) {
        InvocationMocker invocationMocker = new InvocationMocker(NO_DESCRIPTION);
        invocationMocker.addMatcher(new MethodNameMatcher(string));
        invocationMocker.addMatcher(invocationMatcher);
        invocationMocker.setStub(stub);
        return invocationMocker;
    }

    private class HashCodeStub
    extends CustomStub {
        public HashCodeStub() {
            super("returns hashCode for proxy");
        }

        @Override
        public Object invoke(Invocation invocation) throws Throwable {
            return new Integer(AbstractDynamicMock.this.hashCode());
        }
    }

    private class IsSameAsProxyStub
    extends CustomStub {
        public IsSameAsProxyStub() {
            super("returns whether equal to proxy");
        }

        @Override
        public Object invoke(Invocation invocation) throws Throwable {
            return new Boolean(invocation.parameterValues.get(0) == AbstractDynamicMock.this.proxy());
        }
    }
}

