/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Array;
import java.util.Collection;

public class Formatting {
    public static String toReadableString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return Formatting.toJavaSyntax((String)object);
        }
        if (object instanceof Character) {
            return "'" + Formatting.toJavaSyntax(((Character)object).charValue()) + "'";
        }
        if (object instanceof Short) {
            return "<" + object.toString() + "s>";
        }
        if (object instanceof Long) {
            return "<" + object.toString() + "L>";
        }
        if (object instanceof Float) {
            return "<" + object.toString() + "F>";
        }
        if (object.getClass().isArray()) {
            return Formatting.join(object, new StringBuffer()).toString();
        }
        return "<" + object.toString() + ">";
    }

    private static String toJavaSyntax(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(Formatting.toJavaSyntax(string.charAt(i)));
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static String toJavaSyntax(char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return new String(new char[]{c});
    }

    public static StringBuffer join(Object object, StringBuffer stringBuffer) {
        return Formatting.join(object, stringBuffer, "[", "]");
    }

    public static StringBuffer join(Collection collection, StringBuffer stringBuffer, String string, String string2) {
        return Formatting.join(collection.toArray(), stringBuffer, string, string2);
    }

    public static StringBuffer join(Collection collection, StringBuffer stringBuffer, String string, String string2, String string3) {
        return Formatting.join(collection.toArray(), stringBuffer, string, string2, string3);
    }

    public static StringBuffer join(Object object, StringBuffer stringBuffer, String string, String string2) {
        return Formatting.join(object, stringBuffer, string, ", ", string2);
    }

    public static StringBuffer join(Object object, StringBuffer stringBuffer, String string, String string2, String string3) {
        stringBuffer.append(string);
        for (int i = 0; i < Array.getLength(object); ++i) {
            if (i > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(Formatting.toReadableString(Array.get(object, i)));
        }
        stringBuffer.append(string3);
        return stringBuffer;
    }

    public static String classShortName(Class clazz) {
        String string = clazz.getName();
        return string.substring(Math.max(string.lastIndexOf(46), string.lastIndexOf(36)) + 1);
    }
}

