/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jmock.core.Constraint;
import org.jmock.util.PropertyUtil;

public class HasPropertyWithValue
implements Constraint {
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private String propertyName;
    private Constraint expectation;

    public HasPropertyWithValue(String string, Constraint constraint) {
        this.propertyName = string;
        this.expectation = constraint;
    }

    @Override
    public boolean eval(Object object) {
        try {
            Method method = this.getReadMethod(object);
            return method != null && this.expectation.eval(method.invoke(object, NO_ARGUMENTS));
        }
        catch (IntrospectionException introspectionException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    private Method getReadMethod(Object object) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = PropertyUtil.getPropertyDescriptor(this.propertyName, object);
        return propertyDescriptor == null ? null : propertyDescriptor.getReadMethod();
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        stringBuffer.append("hasProperty(\"");
        stringBuffer.append(this.propertyName);
        stringBuffer.append("\", ");
        this.expectation.describeTo(stringBuffer);
        stringBuffer.append(")");
        return stringBuffer;
    }
}

