/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Deflate;
import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.JZlib;
import com.jcraft.jzlib.ZStream;

public final class Deflater
extends ZStream {
    private static final int MAX_WBITS = 15;
    private static final int DEF_WBITS = 15;
    private static final int Z_NO_FLUSH = 0;
    private static final int Z_PARTIAL_FLUSH = 1;
    private static final int Z_SYNC_FLUSH = 2;
    private static final int Z_FULL_FLUSH = 3;
    private static final int Z_FINISH = 4;
    private static final int MAX_MEM_LEVEL = 9;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private boolean finished = false;

    public Deflater() {
    }

    public Deflater(int n) throws GZIPException {
        this(n, 15);
    }

    public Deflater(int n, boolean bl) throws GZIPException {
        this(n, 15, bl);
    }

    public Deflater(int n, int n2) throws GZIPException {
        this(n, n2, false);
    }

    public Deflater(int n, int n2, boolean bl) throws GZIPException {
        int n3 = this.init(n, n2, bl);
        if (n3 != 0) {
            throw new GZIPException(n3 + ": " + this.msg);
        }
    }

    public Deflater(int n, int n2, int n3, JZlib.WrapperType wrapperType) throws GZIPException {
        int n4 = this.init(n, n2, n3, wrapperType);
        if (n4 != 0) {
            throw new GZIPException(n4 + ": " + this.msg);
        }
    }

    public Deflater(int n, int n2, int n3) throws GZIPException {
        int n4 = this.init(n, n2, n3);
        if (n4 != 0) {
            throw new GZIPException(n4 + ": " + this.msg);
        }
    }

    public int init(int n) {
        return this.init(n, 15);
    }

    public int init(int n, boolean bl) {
        return this.init(n, 15, bl);
    }

    public int init(int n, int n2) {
        return this.init(n, n2, false);
    }

    public int init(int n, int n2, int n3, JZlib.WrapperType wrapperType) {
        if (n2 < 9 || n2 > 15) {
            return -2;
        }
        if (wrapperType == JZlib.W_NONE) {
            n2 *= -1;
        } else if (wrapperType == JZlib.W_GZIP) {
            n2 += 16;
        } else {
            if (wrapperType == JZlib.W_ANY) {
                return -2;
            }
            if (wrapperType == JZlib.W_ZLIB) {
                // empty if block
            }
        }
        return this.init(n, n2, n3);
    }

    public int init(int n, int n2, int n3) {
        this.finished = false;
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(n, n2, n3);
    }

    public int init(int n, int n2, boolean bl) {
        this.finished = false;
        this.dstate = new Deflate(this);
        return this.dstate.deflateInit(n, bl ? -n2 : n2);
    }

    @Override
    public int deflate(int n) {
        if (this.dstate == null) {
            return -2;
        }
        int n2 = this.dstate.deflate(n);
        if (n2 == 1) {
            this.finished = true;
        }
        return n2;
    }

    @Override
    public int end() {
        this.finished = true;
        if (this.dstate == null) {
            return -2;
        }
        int n = this.dstate.deflateEnd();
        this.dstate = null;
        this.free();
        return n;
    }

    public int params(int n, int n2) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateParams(n, n2);
    }

    public int setDictionary(byte[] byArray, int n) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflateSetDictionary(byArray, n);
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    public int copy(Deflater deflater) {
        this.finished = deflater.finished;
        return Deflate.deflateCopy(this, deflater);
    }
}

