#include "embedded.h"
#include <the_Foundation/file.h>
#include <the_Foundation/fileinfo.h>

iDeclareType(EmbedChunk)

struct Impl_EmbedChunk {
    size_t pos;
    size_t size;
};

static const iEmbedChunk chunks_Embed_[] = {
    { 0, 749 },
    { 749, 46159 },
    { 46908, 728 },
    { 47636, 9780 },
    { 57416, 43409 },
    { 100825, 980 },
    { 101805, 454360 },
    { 556165, 435536 },
    { 991701, 431016 },
    { 1422717, 1503504 },
    { 2926221, 438028 },
    { 3364249, 411640 },
    { 3775889, 397116 },
    { 4173005, 403924 },
    { 4576929, 437824 },
    { 5014753, 240196 },
    { 5254949, 241016 },
    { 5495965, 240008 },
    { 5735973, 232220 },
    { 5968193, 4091796 },
    { 10059989, 418804 },
    { 10478793, 138624 },
    { 10617417, 5636040 },
    { 16253457, 10237648 },
    { 26491105, 168520 },
    { 26659625, 583072 },
    { 27242697, 154140 },
    { 27396837, 156188 },
    { 27553025, 151356 },
    { 27704381, 157416 },
    { 27861797, 154312 },
    { 28016109, 57856 },
    { 28073965, 298256 },
    { 28372221, 293932 },
    { 28666153, 214992 },
    { 28881145, 299252 },
    { 29180397, 298888 },
    { 29479285, 22653 },
    { 29501938, 21161 },
    { 29523099, 23543 },
    { 29546642, 23771 },
    { 29570413, 24076 },
    { 29594489, 23381 },
    { 29617870, 23025 },
    { 29640895, 24314 },
    { 29665209, 35242 },
    { 29700451, 34870 },
    { 29735321, 21557 },
    { 29756878, 20333 },
    { 29777211, 20518 },
    { 29797729, 14917 },
    { 29812646, 21150 },
};

iBlock blobAbout_Embedded;
iBlock blobHelp_Embedded;
iBlock blobLagrange_Embedded;
iBlock blobLicense_Embedded;
iBlock blobVersion_Embedded;
iBlock blobArghelp_Embedded;
iBlock fontTinosRegular_Embedded;
iBlock fontTinosItalic_Embedded;
iBlock fontTinosBold_Embedded;
iBlock fontIosevkaTermExtended_Embedded;
iBlock fontFiraSansBold_Embedded;
iBlock fontFiraSansItalic_Embedded;
iBlock fontFiraSansLight_Embedded;
iBlock fontFiraSansRegular_Embedded;
iBlock fontFiraSansSemiBold_Embedded;
iBlock fontLiterataRegularopsz14_Embedded;
iBlock fontLiterataBoldopsz36_Embedded;
iBlock fontLiterataExtraLightopsz18_Embedded;
iBlock fontLiterataLightItalicopsz10_Embedded;
iBlock fontNanumGothicRegular_Embedded;
iBlock fontNotoEmojiRegular_Embedded;
iBlock fontNotoSansArabicUIRegular_Embedded;
iBlock fontNotoSansJPRegular_Embedded;
iBlock fontNotoSansSCRegular_Embedded;
iBlock fontNotoSansSymbolsRegular_Embedded;
iBlock fontNotoSansSymbols2Regular_Embedded;
iBlock fontNunitoBold_Embedded;
iBlock fontNunitoExtraBold_Embedded;
iBlock fontNunitoExtraLight_Embedded;
iBlock fontNunitoLightItalic_Embedded;
iBlock fontNunitoRegular_Embedded;
iBlock fontSmolEmojiRegular_Embedded;
iBlock fontSourceSans3Bold_Embedded;
iBlock fontSourceSans3ExtraLight_Embedded;
iBlock fontSourceSans3It_Embedded;
iBlock fontSourceSans3Regular_Embedded;
iBlock fontSourceSans3Semibold_Embedded;
iBlock blobDe_Embedded;
iBlock blobEn_Embedded;
iBlock blobEs_Embedded;
iBlock blobFi_Embedded;
iBlock blobFr_Embedded;
iBlock blobIa_Embedded;
iBlock blobIe_Embedded;
iBlock blobPl_Embedded;
iBlock blobRu_Embedded;
iBlock blobSr_Embedded;
iBlock blobTok_Embedded;
iBlock blobZh_Hans_Embedded;
iBlock blobZh_Hant_Embedded;
iBlock imageShadow_Embedded;
iBlock imageLagrange64_Embedded;

static iBlock *blocks_Embed_[] = {
   &blobAbout_Embedded,
   &blobHelp_Embedded,
   &blobLagrange_Embedded,
   &blobLicense_Embedded,
   &blobVersion_Embedded,
   &blobArghelp_Embedded,
   &fontTinosRegular_Embedded,
   &fontTinosItalic_Embedded,
   &fontTinosBold_Embedded,
   &fontIosevkaTermExtended_Embedded,
   &fontFiraSansBold_Embedded,
   &fontFiraSansItalic_Embedded,
   &fontFiraSansLight_Embedded,
   &fontFiraSansRegular_Embedded,
   &fontFiraSansSemiBold_Embedded,
   &fontLiterataRegularopsz14_Embedded,
   &fontLiterataBoldopsz36_Embedded,
   &fontLiterataExtraLightopsz18_Embedded,
   &fontLiterataLightItalicopsz10_Embedded,
   &fontNanumGothicRegular_Embedded,
   &fontNotoEmojiRegular_Embedded,
   &fontNotoSansArabicUIRegular_Embedded,
   &fontNotoSansJPRegular_Embedded,
   &fontNotoSansSCRegular_Embedded,
   &fontNotoSansSymbolsRegular_Embedded,
   &fontNotoSansSymbols2Regular_Embedded,
   &fontNunitoBold_Embedded,
   &fontNunitoExtraBold_Embedded,
   &fontNunitoExtraLight_Embedded,
   &fontNunitoLightItalic_Embedded,
   &fontNunitoRegular_Embedded,
   &fontSmolEmojiRegular_Embedded,
   &fontSourceSans3Bold_Embedded,
   &fontSourceSans3ExtraLight_Embedded,
   &fontSourceSans3It_Embedded,
   &fontSourceSans3Regular_Embedded,
   &fontSourceSans3Semibold_Embedded,
   &blobDe_Embedded,
   &blobEn_Embedded,
   &blobEs_Embedded,
   &blobFi_Embedded,
   &blobFr_Embedded,
   &blobIa_Embedded,
   &blobIe_Embedded,
   &blobPl_Embedded,
   &blobRu_Embedded,
   &blobSr_Embedded,
   &blobTok_Embedded,
   &blobZh_Hans_Embedded,
   &blobZh_Hant_Embedded,
   &imageShadow_Embedded,
   &imageLagrange64_Embedded,
};

iBool load_Embed(const char *path) {
    const size_t fileSize = (size_t) fileSizeCStr_FileInfo(path);
    iFile *f = iClob(newCStr_File(path));
    if (open_File(f, readOnly_FileMode)) {
        iForIndices(i, blocks_Embed_) {
            const iEmbedChunk *chunk = &chunks_Embed_[i];
            iBlock *data = blocks_Embed_[i];
            if (chunk->pos + chunk->size > fileSize) {
                return iFalse;
            }
            init_Block(data, chunk->size);
            fill_Block(data, 0);
            seek_File(f, chunk->pos);
            readData_File(f, chunk->size, data_Block(data));
        }
        return iTrue;
    }
    return iFalse;
}
