/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.Timer;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Transform;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

class BenchmarkMatrix2D {
    protected BenchmarkMatrix2D() {
        throw new RuntimeException("Non instantiable");
    }

    public static void doubleBenchmark(int runs, int rows, int columns, String kind, boolean print, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int column;
        int row;
        int i;
        System.out.println("benchmarking double matrix");
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer emptyLoop = new Timer();
        Timer emptyLoop2 = new Timer();
        emptyLoop.start();
        int dummy = 0;
        for (int i2 = 0; i2 < runs; ++i2) {
            for (int column2 = 0; column2 < columns; ++column2) {
                for (int row2 = 0; row2 < rows; ++row2) {
                    ++dummy;
                }
            }
        }
        emptyLoop.stop();
        System.out.println(dummy);
        emptyLoop2.start();
        dummy = 3;
        double dummy2 = 0.0;
        for (int i3 = 0; i3 < runs; ++i3) {
            boolean value = false;
            for (int column3 = 0; column3 < columns; ++column3) {
                for (int row3 = 0; row3 < rows; ++row3) {
                    dummy2 += (double)dummy;
                }
            }
        }
        emptyLoop2.stop();
        System.out.println(dummy2);
        long before = Runtime.getRuntime().freeMemory();
        long size = (long)rows * (long)columns * (long)runs;
        DoubleMatrix2D matrix = null;
        if (kind.equals("sparse")) {
            matrix = new SparseDoubleMatrix2D(rows, columns, initialCapacity, minLoadFactor, maxLoadFactor);
        } else if (kind.equals("dense")) {
            matrix = new DenseDoubleMatrix2D(rows, columns);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow filling...");
        for (int i4 = 0; i4 < runs; ++i4) {
            matrix.assign(0.0);
            matrix.ensureCapacity(initialCapacity);
            if (kind.equals("sparse")) {
                ((SparseDoubleMatrix2D)matrix).ensureCapacity(initialCapacity);
            }
            timer1.start();
            int value = 0;
            for (int row4 = 0; row4 < rows; ++row4) {
                for (int column4 = 0; column4 < columns; ++column4) {
                    matrix.setQuick(row4, column4, value++);
                }
            }
            timer1.stop();
        }
        timer1.display();
        timer1.minus(emptyLoop).display();
        System.out.println((float)size / timer1.minus(emptyLoop).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        long after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("bytes needed per non-zero=" + (double)(before - after) / (double)matrix.cardinality());
        if (print) {
            System.out.println(matrix);
            if (kind.equals("sparse")) {
                System.out.println("map=" + ((SparseDoubleMatrix2D)matrix).elements);
            }
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double element = 0.0;
        for (int i5 = 0; i5 < runs; ++i5) {
            for (int row5 = 0; row5 < rows; ++row5) {
                for (int column5 = 0; column5 < columns; ++column5) {
                    element += matrix.getQuick(row5, column5);
                }
            }
        }
        timer2.stop().display();
        timer2.minus(emptyLoop2).display();
        System.out.println((float)size / timer2.minus(emptyLoop2).seconds() + " elements / sec");
        if (print) {
            System.out.println(matrix);
        }
        System.out.println(element);
        System.out.println("\nNow reading view...");
        DoubleMatrix2D view = matrix.viewPart(0, 0, rows, columns);
        timer4.start();
        element = 0.0;
        for (i = 0; i < runs; ++i) {
            for (row = 0; row < rows; ++row) {
                for (column = 0; column < columns; ++column) {
                    element += view.getQuick(row, column);
                }
            }
        }
        timer4.stop().display();
        timer4.minus(emptyLoop2).display();
        System.out.println((float)size / timer4.minus(emptyLoop2).seconds() + " elements / sec");
        if (print) {
            System.out.println(view);
        }
        System.out.println(element);
        System.out.println("\nNow removing...");
        before = Runtime.getRuntime().freeMemory();
        for (i = 0; i < runs; ++i) {
            for (row = 0; row < rows; ++row) {
                for (column = 0; column < columns; ++column) {
                    matrix.setQuick(row, column, 1.0);
                }
            }
            timer3.start();
            for (row = 0; row < rows; ++row) {
                for (column = 0; column < columns; ++column) {
                    matrix.setQuick(row, column, 0.0);
                }
            }
            timer3.stop();
        }
        timer3.display();
        timer3.minus(emptyLoop).display();
        System.out.println((float)size / timer3.minus(emptyLoop).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("KB free=" + after / 1024L);
        if (print) {
            System.out.println(matrix);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkMult(int runs, int rows, int columns, String kind, boolean print, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int i;
        System.out.println("benchmarking double matrix");
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        long size = (long)rows * (long)columns * (long)runs;
        DoubleMatrix2D matrix = null;
        if (kind.equals("sparse")) {
            matrix = new SparseDoubleMatrix2D(rows, columns, initialCapacity, minLoadFactor, maxLoadFactor);
        } else if (kind.equals("dense")) {
            matrix = new DenseDoubleMatrix2D(rows, columns);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow multiplying...");
        matrix.assign(1.0);
        for (i = 0; i < runs; ++i) {
            timer1.start();
            Transform.mult(matrix, 3.0);
            timer1.stop();
        }
        timer1.display();
        System.out.println((float)size / timer1.seconds() + " elements / sec");
        if (print) {
            System.out.println(matrix);
        }
        System.out.println("\nNow multiplying2...");
        matrix.assign(1.0);
        for (i = 0; i < runs; ++i) {
            timer2.start();
            Transform.mult(matrix, 3.0);
            timer2.stop();
        }
        timer2.display();
        System.out.println((float)size / timer2.seconds() + " elements / sec");
        if (print) {
            System.out.println(matrix);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitive(int runs, int rows, int columns, boolean print) {
        int row;
        int column;
        int i;
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer emptyLoop = new Timer();
        Timer emptyLoop2 = new Timer();
        emptyLoop.start();
        int dummy = 0;
        for (int i2 = 0; i2 < runs; ++i2) {
            for (int column2 = 0; column2 < columns; ++column2) {
                for (int row2 = 0; row2 < rows; ++row2) {
                    ++dummy;
                }
            }
        }
        emptyLoop.stop();
        System.out.println(dummy);
        emptyLoop2.start();
        dummy = 3;
        double dummy2 = 0.0;
        for (int i3 = 0; i3 < runs; ++i3) {
            for (int column3 = 0; column3 < columns; ++column3) {
                for (int row3 = 0; row3 < rows; ++row3) {
                    dummy2 += (double)dummy;
                }
            }
        }
        emptyLoop2.stop();
        System.out.println(dummy2);
        long before = Runtime.getRuntime().freeMemory();
        long size = (long)rows * (long)columns * (long)runs;
        double[][] matrix = new double[rows][columns];
        System.out.println("\nNow filling...");
        for (int i4 = 0; i4 < runs; ++i4) {
            timer1.start();
            int value = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                for (int row4 = 0; row4 < rows; ++row4) {
                    matrix[row4][column4] = value++;
                }
            }
            timer1.stop();
        }
        timer1.display();
        timer1.minus(emptyLoop).display();
        System.out.println((float)size / timer1.minus(emptyLoop).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        long after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double element = 0.0;
        for (i = 0; i < runs; ++i) {
            for (column = 0; column < columns; ++column) {
                for (row = 0; row < rows; ++row) {
                    element += matrix[row][column];
                }
            }
        }
        timer2.stop().display();
        timer2.minus(emptyLoop2).display();
        System.out.println((float)size / timer2.minus(emptyLoop2).seconds() + " elements / sec");
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println(element);
        System.out.println("\nNow removing...");
        before = Runtime.getRuntime().freeMemory();
        for (i = 0; i < runs; ++i) {
            timer3.start();
            for (column = 0; column < columns; ++column) {
                for (row = 0; row < rows; ++row) {
                    matrix[row][column] = 0.0;
                }
            }
            timer3.stop();
        }
        timer3.display();
        timer3.minus(emptyLoop).display();
        System.out.println((float)size / timer3.minus(emptyLoop).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("KB free=" + after / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitiveOptimized(int runs, int rows, int columns, boolean print) {
        int column;
        double[] r;
        int row;
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer emptyLoop = new Timer();
        Timer emptyLoop2 = new Timer();
        emptyLoop.start();
        int dummy = 0;
        for (int i = 0; i < runs; ++i) {
            for (int column2 = 0; column2 < columns; ++column2) {
                for (int row2 = 0; row2 < rows; ++row2) {
                    ++dummy;
                }
            }
        }
        emptyLoop.stop();
        System.out.println(dummy);
        emptyLoop2.start();
        dummy = 3;
        double dummy2 = 0.0;
        for (int i = 0; i < runs; ++i) {
            for (int column3 = 0; column3 < columns; ++column3) {
                for (int row3 = 0; row3 < rows; ++row3) {
                    dummy2 += (double)dummy;
                }
            }
        }
        emptyLoop2.stop();
        System.out.println(dummy2);
        long before = Runtime.getRuntime().freeMemory();
        long size = (long)rows * (long)columns * (long)runs;
        double[][] matrix = new double[rows][columns];
        System.out.println("\nNow filling...");
        for (int i = 0; i < runs; ++i) {
            timer1.start();
            int value = 0;
            for (int row4 = 0; row4 < rows; ++row4) {
                double[] r2 = matrix[row4];
                for (int column4 = 0; column4 < columns; ++column4) {
                    r2[column4] = value++;
                }
            }
            timer1.stop();
        }
        timer1.display();
        timer1.minus(emptyLoop).display();
        System.out.println((float)size / timer1.minus(emptyLoop).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        long after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double element = 0.0;
        for (int i = 0; i < runs; ++i) {
            for (row = 0; row < rows; ++row) {
                r = matrix[row];
                for (column = 0; column < columns; ++column) {
                    element += r[column];
                }
            }
        }
        timer2.stop().display();
        timer2.minus(emptyLoop2).display();
        System.out.println((float)size / timer2.minus(emptyLoop2).seconds() + " elements / sec");
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println(element);
        System.out.println("\nNow removing...");
        before = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < runs; ++i) {
            timer3.start();
            for (row = 0; row < rows; ++row) {
                r = matrix[row];
                for (column = 0; column < columns; ++column) {
                    r[column] = 0.0;
                }
            }
            timer3.stop();
        }
        timer3.display();
        timer3.minus(emptyLoop).display();
        System.out.println((float)size / timer3.minus(emptyLoop).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        after = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (before - after) / 1024L);
        System.out.println("KB free=" + after / 1024L);
        if (print) {
            DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(rows, columns);
            m.assign(matrix);
            System.out.println(m);
        }
        System.out.println("bye bye.");
    }

    public static void intBenchmark(int runs, int rows, int columns, String kind, boolean print, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitive(int runs, int rows, int columns, boolean print) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitiveOptimized(int runs, int rows, int columns, boolean print) {
        throw new InternalError();
    }

    public static void main(String[] args) {
        int runs = Integer.parseInt(args[0]);
        int rows = Integer.parseInt(args[1]);
        int columns = Integer.parseInt(args[2]);
        String kind = args[3];
        int initialCapacity = Integer.parseInt(args[4]);
        double minLoadFactor = new Double(args[5]);
        double maxLoadFactor = new Double(args[6]);
        boolean print = args[7].equals("print");
        String type = args[8];
        String command = args[9];
        if (type.equals("int")) {
            if (kind.equals("primitive")) {
                BenchmarkMatrix2D.intBenchmarkPrimitive(runs, rows, columns, print);
            } else if (kind.equals("primitiveOpt")) {
                BenchmarkMatrix2D.intBenchmarkPrimitiveOptimized(runs, rows, columns, print);
            } else {
                BenchmarkMatrix2D.intBenchmark(runs, rows, columns, kind, print, initialCapacity, minLoadFactor, maxLoadFactor);
            }
        } else if (type.equals("double")) {
            if (kind.equals("primitive")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitive(runs, rows, columns, print);
            } else if (kind.equals("primitiveOpt")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitiveOptimized(runs, rows, columns, print);
            } else if (command.equals("mult")) {
                BenchmarkMatrix2D.doubleBenchmarkMult(runs, rows, columns, kind, print, initialCapacity, minLoadFactor, maxLoadFactor);
            } else {
                BenchmarkMatrix2D.doubleBenchmark(runs, rows, columns, kind, print, initialCapacity, minLoadFactor, maxLoadFactor);
            }
        }
    }
}

