/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.ImmutableGraphEltSet;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.graphelements.TGForEachNodePair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GraphEltSet
implements ImmutableGraphEltSet {
    protected Vector nodes = new Vector();
    protected Vector edges = new Vector();
    protected Hashtable nodeIDRegistry = new Hashtable();

    protected Node nodeAt(int i) {
        if (this.nodes.size() == 0) {
            return null;
        }
        return (Node)this.nodes.elementAt(i);
    }

    @Override
    public int nodeNum() {
        return this.nodes.size();
    }

    @Override
    public int nodeCount() {
        return this.nodes.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addNode(Node node) throws TGException {
        String id = node.getID();
        if (id != null) {
            if (this.findNode(id) != null) throw new TGException(1, "node ID '" + id + "' already exists.");
            this.nodeIDRegistry.put(id, node);
            this.nodes.addElement(node);
            return;
        } else {
            String label = node.getLabel().trim();
            if (label == null) {
                label = "";
            }
            if (!label.equals("") && this.findNode(node.getLabel()) == null) {
                id = label;
            } else {
                int i = 1;
                while (this.findNode(label + "-" + i) != null) {
                    ++i;
                }
                id = label + "-" + i;
            }
            node.setID(id);
            this.nodeIDRegistry.put(id, node);
            this.nodes.addElement(node);
        }
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    protected Edge edgeAt(int index) {
        if (this.edges.size() == 0) {
            return null;
        }
        return (Edge)this.edges.elementAt(index);
    }

    @Override
    public int edgeNum() {
        return this.edges.size();
    }

    @Override
    public int edgeCount() {
        return this.edges.size();
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        if (!this.contains(edge)) {
            this.edges.addElement(edge);
            edge.from.addEdge(edge);
            edge.to.addEdge(edge);
        }
    }

    public Edge addEdge(Node from, Node to, int tension) {
        Edge edge = null;
        if (from != null && to != null) {
            edge = new Edge(from, to, tension);
            this.addEdge(edge);
        }
        return edge;
    }

    public boolean contains(Edge edge) {
        return this.edges.contains(edge);
    }

    @Override
    public Node findNode(String id) {
        if (id == null) {
            return null;
        }
        return (Node)this.nodeIDRegistry.get(id);
    }

    public Node findNodeByURL(String strURL) {
        Node retVal = null;
        if (strURL == null) {
            return null;
        }
        Enumeration myEnum = this.nodeIDRegistry.elements();
        while (myEnum.hasMoreElements()) {
            Node node = (Node)myEnum.nextElement();
            if (!node.getURL().equalsIgnoreCase(strURL)) continue;
            retVal = node;
            break;
        }
        return retVal;
    }

    @Override
    public Node findNodeLabelContaining(String substring) {
        int i;
        for (i = 0; i < this.nodeCount(); ++i) {
            if (this.nodeAt(i) == null || !this.nodeAt(i).getLabel().toLowerCase().equals(substring.toLowerCase())) continue;
            return this.nodeAt(i);
        }
        for (i = 0; i < this.nodeCount(); ++i) {
            if (this.nodeAt(i) == null || this.nodeAt(i).getLabel().toLowerCase().indexOf(substring.toLowerCase()) <= -1) continue;
            return this.nodeAt(i);
        }
        return null;
    }

    @Override
    public Edge findEdge(Node from, Node to) {
        for (int i = 0; i < from.edgeCount(); ++i) {
            Edge e = from.edgeAt(i);
            if (e.to != to) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEdge(Edge edge) {
        Vector vector = this.edges;
        synchronized (vector) {
            if (edge == null) {
                return false;
            }
            if (!this.edges.removeElement(edge)) {
                return false;
            }
            edge.from.removeEdge(edge);
            edge.to.removeEdge(edge);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEdges(Vector edgesToDelete) {
        Vector vector = this.edges;
        synchronized (vector) {
            for (int i = 0; i < edgesToDelete.size(); ++i) {
                this.deleteEdge((Edge)edgesToDelete.elementAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEdge(Node from, Node to) {
        Vector vector = this.edges;
        synchronized (vector) {
            Edge e = this.findEdge(from, to);
            if (e != null) {
                return this.deleteEdge(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNode(Node node) {
        Vector vector = this.nodes;
        synchronized (vector) {
            if (node == null) {
                return false;
            }
            if (!this.nodes.removeElement(node)) {
                return false;
            }
            String id = node.getID();
            if (id != null) {
                this.nodeIDRegistry.remove(id);
            }
            for (int i = 0; i < node.edgeCount(); ++i) {
                Edge e = node.edgeAt(i);
                if (e.from == node) {
                    this.edges.removeElement(e);
                    e.to.removeEdge(e);
                    continue;
                }
                if (e.to != node) continue;
                this.edges.removeElement(e);
                e.from.removeEdge(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNodes(Vector nodesToDelete) {
        Vector vector = this.nodes;
        synchronized (vector) {
            for (int i = 0; i < nodesToDelete.size(); ++i) {
                this.deleteNode((Node)nodesToDelete.elementAt(i));
            }
        }
    }

    @Override
    public Node getRandomNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        int r = (int)(Math.random() * (double)this.nodeCount());
        return this.nodeAt(r);
    }

    @Override
    public Node getFirstNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodeAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Vector vector = this.nodes;
        synchronized (vector) {
            Vector vector2 = this.edges;
            synchronized (vector2) {
                this.nodes.removeAllElements();
                this.edges.removeAllElements();
                this.nodeIDRegistry.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forAllNodes(TGForEachNode fen) {
        Vector vector = this.nodes;
        synchronized (vector) {
            for (int i = 0; i < this.nodeCount(); ++i) {
                Node n = this.nodeAt(i);
                fen.forEachNode(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forAllNodePairs(TGForEachNodePair fenp) {
        Vector vector = this.nodes;
        synchronized (vector) {
            for (int i = 0; i < this.nodeCount(); ++i) {
                Node n1 = this.nodeAt(i);
                fenp.beforeInnerLoop(n1);
                for (int j = i + 1; j < this.nodeCount(); ++j) {
                    fenp.forEachNodePair(n1, this.nodeAt(j));
                }
                fenp.afterInnerLoop(n1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forAllEdges(TGForEachEdge fee) {
        Vector vector = this.edges;
        synchronized (vector) {
            for (int i = 0; i < this.edgeCount(); ++i) {
                Edge e = this.edgeAt(i);
                fee.forEachEdge(e);
            }
        }
    }
}

