/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class GLNavigateUI
extends TGUserInterface {
    GLPanel glPanel;
    TGPanel tgPanel;
    GLNavigateMouseListener ml;
    TGAbstractDragUI hvDragUI;
    TGAbstractDragUI rotateDragUI;
    DragNodeUI dragNodeUI;
    LocalityScroll localityScroll;
    PopupMenu nodePopup;
    PopupMenu edgePopup;
    Node popupNode;
    Edge popupEdge;

    public GLNavigateUI(GLPanel glp) {
        this.glPanel = glp;
        this.tgPanel = this.glPanel.getTGPanel();
        this.localityScroll = this.glPanel.getLocalityScroll();
        this.hvDragUI = this.glPanel.getHVScroll().getHVDragUI();
        this.rotateDragUI = this.glPanel.getRotateScroll().getRotateDragUI();
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.ml = new GLNavigateMouseListener();
        this.setUpNodePopup(glp);
        this.setUpEdgePopup(glp);
    }

    @Override
    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
    }

    @Override
    public void deactivate() {
        this.tgPanel.removeMouseListener(this.ml);
    }

    private void setUpNodePopup(GLPanel glp) {
        this.nodePopup = new PopupMenu();
        glp.add(this.nodePopup);
        MenuItem menuItem = new MenuItem("Expand Node");
        ActionListener expandAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.expandNode(GLNavigateUI.this.popupNode);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(expandAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Collapse Node");
        ActionListener collapseAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.collapseNode(GLNavigateUI.this.popupNode);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(collapseAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Hide Node");
        ActionListener hideAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.hideNode(GLNavigateUI.this.popupNode);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(hideAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Center Node");
        ActionListener centerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.glPanel.getHVScroll().slowScrollToCenter(GLNavigateUI.this.popupNode);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(centerAction);
        this.nodePopup.add(menuItem);
    }

    private void setUpEdgePopup(GLPanel glp) {
        this.edgePopup = new PopupMenu();
        glp.add(this.edgePopup);
        MenuItem menuItem = new MenuItem("Hide Edge");
        ActionListener hideAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupEdge != null) {
                    GLNavigateUI.this.tgPanel.hideEdge(GLNavigateUI.this.popupEdge);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(hideAction);
        this.edgePopup.add(menuItem);
    }

    class GLNavigateMouseListener
    extends MouseAdapter {
        GLNavigateMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Node mouseOverN = GLNavigateUI.this.tgPanel.getMouseOverN();
            if (e.getModifiers() == 16) {
                if (mouseOverN == null) {
                    GLNavigateUI.this.hvDragUI.activate(e);
                } else {
                    GLNavigateUI.this.dragNodeUI.activate(e);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Node mouseOverN = GLNavigateUI.this.tgPanel.getMouseOverN();
            if (e.getModifiers() == 16 && mouseOverN != null) {
                GLNavigateUI.this.tgPanel.setSelect(mouseOverN);
                GLNavigateUI.this.glPanel.getHVScroll().slowScrollToCenter(mouseOverN);
                try {
                    GLNavigateUI.this.tgPanel.setLocale(mouseOverN, GLNavigateUI.this.localityScroll.getLocalityRadius());
                }
                catch (TGException ex) {
                    System.out.println("Error setting locale");
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GLNavigateUI.this.popupNode = GLNavigateUI.this.tgPanel.getMouseOverN();
                GLNavigateUI.this.popupEdge = GLNavigateUI.this.tgPanel.getMouseOverE();
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    GLNavigateUI.this.nodePopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                } else if (GLNavigateUI.this.popupEdge != null) {
                    GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    GLNavigateUI.this.edgePopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                } else {
                    GLNavigateUI.this.glPanel.glPopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                }
            } else {
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
            }
        }
    }
}

