/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class ZoomScroll
implements GraphListener {
    protected ZoomLens zoomLens;
    private Scrollbar zoomSB;
    private TGPanel tgPanel;

    public ZoomScroll(TGPanel tgp) {
        this.tgPanel = tgp;
        this.zoomSB = new Scrollbar(0, -4, 7, -31, 19);
        this.zoomSB.addAdjustmentListener(new zoomAdjustmentListener());
        this.zoomLens = new ZoomLens();
        this.tgPanel.addGraphListener(this);
    }

    public Scrollbar getZoomSB() {
        return this.zoomSB;
    }

    public ZoomLens getLens() {
        return this.zoomLens;
    }

    @Override
    public void graphMoved() {
    }

    @Override
    public void graphReset() {
        this.zoomSB.setValue(-10);
    }

    public int getZoomValue() {
        double orientedValue = this.zoomSB.getValue() - this.zoomSB.getMinimum();
        double range = this.zoomSB.getMaximum() - this.zoomSB.getMinimum() - this.zoomSB.getVisibleAmount();
        return (int)(orientedValue / range * 200.0 - 100.0);
    }

    public void setZoomValue(int value) {
        double range = this.zoomSB.getMaximum() - this.zoomSB.getMinimum() - this.zoomSB.getVisibleAmount();
        this.zoomSB.setValue((int)((double)(value + 100) / 200.0 * range + 0.5) + this.zoomSB.getMinimum());
    }

    class ZoomLens
    extends TGAbstractLens {
        ZoomLens() {
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            p.x *= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
            p.y *= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            p.x /= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
            p.y /= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
        }
    }

    private class zoomAdjustmentListener
    implements AdjustmentListener {
        private zoomAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            ZoomScroll.this.tgPanel.repaintAfterMove();
        }
    }
}

