/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.picking;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;

public class ClosestShapePickSupport<V, E>
implements GraphElementAccessor<V, E> {
    protected VisualizationServer<V, E> vv;
    protected float pickSize;

    public ClosestShapePickSupport(VisualizationServer<V, E> vv, float pickSize) {
        this.vv = vv;
        this.pickSize = pickSize;
    }

    public ClosestShapePickSupport(VisualizationServer<V, E> vv) {
        this.vv = vv;
    }

    @Override
    public E getEdge(Layout<V, E> layout, double x, double y) {
        return null;
    }

    @Override
    public V getVertex(Layout<V, E> layout, double x, double y) {
        double oy;
        double minDistance = Double.MAX_VALUE;
        V closest = null;
        while (true) {
            try {
                for (Object v : layout.getGraph().getVertices()) {
                    double dy;
                    Point2D p = (Point2D)layout.transform(v);
                    double dx = p.getX() - x;
                    double dist = dx * dx + (dy = p.getY() - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        Shape shape = this.vv.getRenderContext().getVertexShapeTransformer().transform(closest);
        Point2D p = (Point2D)layout.transform(closest);
        p = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, p);
        double ox = x - p.getX();
        if (shape.contains(ox, oy = y - p.getY())) {
            return closest;
        }
        return null;
    }

    @Override
    public Collection<V> getVertices(Layout<V, E> layout, Shape rectangle) {
        return null;
    }
}

