/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Collections;
import javax.swing.Icon;

public class Checkmark
implements Icon {
    GeneralPath path = new GeneralPath();
    AffineTransform highlight = AffineTransform.getTranslateInstance(-1.0, -1.0);
    AffineTransform lowlight = AffineTransform.getTranslateInstance(1.0, 1.0);
    AffineTransform shadow = AffineTransform.getTranslateInstance(2.0, 2.0);
    Color color;

    public Checkmark() {
        this(Color.green);
    }

    public Checkmark(Color color) {
        this.color = color;
        this.path.moveTo(10.0f, 17.0f);
        this.path.lineTo(13.0f, 20.0f);
        this.path.lineTo(20.0f, 13.0f);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Shape shape = AffineTransform.getTranslateInstance(x, y).createTransformedShape(this.path);
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(Collections.singletonMap(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Stroke stroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(4.0f));
        g2d.setColor(Color.darkGray);
        g2d.draw(this.shadow.createTransformedShape(shape));
        g2d.setColor(Color.black);
        g2d.draw(this.lowlight.createTransformedShape(shape));
        g2d.setColor(Color.white);
        g2d.draw(this.highlight.createTransformedShape(shape));
        g2d.setColor(this.color);
        g2d.draw(shape);
        g2d.setStroke(stroke);
    }

    @Override
    public int getIconWidth() {
        return 20;
    }

    @Override
    public int getIconHeight() {
        return 20;
    }
}

