/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import ch.ethz.ssh2.KnownHosts;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.Clusters;
import lcmc.data.Host;
import lcmc.data.Hosts;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.map.MultiKeyMap;

public final class ConfigData {
    private static final long serialVersionUID = 1L;
    private static final String OP_MODE_RO = Tools.getString("ConfigData.OpMode.RO");
    private static final String OP_MODE_OP = Tools.getString("ConfigData.OpMode.OP");
    private static final String OP_MODE_ADMIN = Tools.getString("ConfigData.OpMode.ADMIN");
    public static final String OP_MODE_GOD = Tools.getString("ConfigData.OpMode.GOD");
    public static final Map<AccessType, String> OP_MODES_MAP = new LinkedHashMap<AccessType, String>();
    public static final Map<String, AccessType> ACCESS_TYPE_MAP = new LinkedHashMap<String, AccessType>();
    private final Hosts hosts;
    private final Clusters clusters;
    private String downloadUser = Tools.getDefault("DownloadLogin.User");
    private String downloadPassword = Tools.getDefault("DownloadLogin.Password");
    private String savedDownloadUser = "";
    private String savedDownloadPassword = "";
    private boolean loginSave = true;
    private boolean advancedMode = false;
    private String saveFile = Tools.getDefault("MainMenu.DrbdGuiFiles.Default");
    private final KnownHosts knownHosts = new KnownHosts();
    private String knownHostPath;
    private String idDSAPath;
    private String idRSAPath;
    private String lastInstalledClusterStack = null;
    private String lastHbPmInstalledMethod = null;
    private String lastDrbdInstalledMethod = null;
    private String lastEnteredUser = null;
    private Boolean lastEnteredUseSudo = null;
    private String lastEnteredSSHPort = null;
    private boolean keepHelper = false;
    private final List<String> autoHosts = new ArrayList<String>();
    private final List<String> autoClusters = new ArrayList<String>();
    private final MultiKeyMap<String, String> autoOptions = new MultiKeyMap();
    public static final String HEARTBEAT_NAME = "Heartbeat";
    public static final String COROSYNC_NAME = "Corosync/OpenAIS";
    public static final String PM_CLONE_SET_NAME = "Clone Set";
    public static final String PM_MASTER_SLAVE_SET_NAME = "Master/Slave Set";
    public static final String PM_GROUP_NAME = "Group";
    private int vncPortOffset = 0;
    private boolean tightvnc = false;
    private boolean ultravnc = false;
    private boolean realvnc = false;
    private boolean stagingDrbd = false;
    private boolean stagingPacemaker = false;
    private boolean noLRM = false;
    private float animFPS = 15.0f;
    private AccessType accessType = AccessType.ADMIN;
    private AccessType maxAccessType = AccessType.ADMIN;
    private boolean upgradeCheckEnabled = true;
    private boolean bigDRBDConf = false;
    private boolean oneHostCluster = false;
    private int scale = 100;
    private boolean noPassphrase = false;

    public ConfigData() {
        this.hosts = new Hosts();
        this.clusters = new Clusters();
    }

    public Hosts getHosts() {
        return this.hosts;
    }

    public int danglingHostsCount() {
        Hosts hosts = Tools.getConfigData().getHosts();
        int c = 0;
        for (Host host : hosts.getHostSet()) {
            if (host.isInCluster()) continue;
            ++c;
        }
        return c;
    }

    public Clusters getClusters() {
        return this.clusters;
    }

    public String getDownloadUser() {
        if (this.savedDownloadUser != null && !this.savedDownloadUser.equals("")) {
            this.downloadUser = this.savedDownloadUser;
            this.savedDownloadUser = "";
        }
        return this.downloadUser;
    }

    public String getDownloadPassword() {
        if (this.savedDownloadPassword != null && !this.savedDownloadPassword.equals("")) {
            this.downloadPassword = this.savedDownloadPassword;
            this.savedDownloadPassword = "";
        }
        return this.downloadPassword;
    }

    public boolean getLoginSave() {
        return this.loginSave;
    }

    public void setDownloadLogin(String downloadUser, String downloadPassword, boolean loginSave) {
        this.downloadUser = downloadUser;
        this.downloadPassword = downloadPassword;
        this.loginSave = loginSave;
        if (loginSave) {
            this.savedDownloadUser = downloadUser;
            this.savedDownloadPassword = downloadPassword;
        } else {
            this.savedDownloadUser = "";
            this.savedDownloadPassword = "";
        }
    }

    public boolean existsHost(Host host) {
        return this.hosts.existsHost(host);
    }

    public void addHostToHosts(Host host) {
        this.hosts.addHost(host);
    }

    public void removeHostFromHosts(Host host) {
        this.hosts.removeHost(host);
    }

    public boolean existsCluster(Cluster cluster) {
        return this.clusters.existsCluster(cluster);
    }

    public void addClusterToClusters(Cluster cluster) {
        this.clusters.addCluster(cluster);
    }

    public void removeClusterFromClusters(Cluster cluster) {
        this.clusters.removeCluster(cluster);
    }

    public void disconnectAllHosts() {
        this.hosts.disconnectAllHosts();
    }

    public void setAdvancedMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }

    public void setSaveFile(String saveFile) {
        this.saveFile = saveFile;
    }

    public String getSaveFile() {
        return this.saveFile;
    }

    public String getSaveFileOld() {
        return Tools.getDefault("MainMenu.DrbdGuiFiles.Old");
    }

    public String getKnownHostPath() {
        return this.knownHostPath;
    }

    public void setKnownHostPath(String knownHostPath) {
        this.knownHostPath = knownHostPath;
        File knownHostFile = new File(knownHostPath);
        if (knownHostFile.exists()) {
            try {
                this.knownHosts.addHostkeys(knownHostFile);
            }
            catch (IOException e) {
                Tools.appError("SSH.knowHostFile.NotExists", "", e);
            }
        }
    }

    public String getIdDSAPath() {
        return this.idDSAPath;
    }

    public void setIdDSAPath(String idDSAPath) {
        this.idDSAPath = idDSAPath;
    }

    public String getIdRSAPath() {
        return this.idRSAPath;
    }

    public void setIdRSAPath(String idRSAPath) {
        this.idRSAPath = idRSAPath;
    }

    public KnownHosts getKnownHosts() {
        return this.knownHosts;
    }

    public void setLastInstalledClusterStack(String lastInstalledClusterStack) {
        this.lastInstalledClusterStack = lastInstalledClusterStack;
    }

    public String getLastInstalledClusterStack() {
        return this.lastInstalledClusterStack;
    }

    public void setLastHbPmInstalledMethod(String lastHbPmInstalledMethod) {
        this.lastHbPmInstalledMethod = lastHbPmInstalledMethod;
    }

    public String getLastHbPmInstalledMethod() {
        return this.lastHbPmInstalledMethod;
    }

    public void setLastDrbdInstalledMethod(String lastDrbdInstalledMethod) {
        this.lastDrbdInstalledMethod = lastDrbdInstalledMethod;
    }

    public String getLastDrbdInstalledMethod() {
        return this.lastDrbdInstalledMethod;
    }

    public void setLastEnteredUser(String lastEnteredUser) {
        this.lastEnteredUser = lastEnteredUser;
    }

    public String getLastEnteredUser() {
        return this.lastEnteredUser;
    }

    public void setLastEnteredUseSudo(Boolean lastEnteredUseSudo) {
        this.lastEnteredUseSudo = lastEnteredUseSudo;
    }

    public Boolean getLastEnteredUseSudo() {
        return this.lastEnteredUseSudo;
    }

    public void setLastEnteredSSHPort(String lastEnteredSSHPort) {
        this.lastEnteredSSHPort = lastEnteredSSHPort;
    }

    public String getLastEnteredSSHPort() {
        return this.lastEnteredSSHPort;
    }

    public void setKeepHelper(boolean keepHelper) {
        this.keepHelper = keepHelper;
    }

    public boolean getKeepHelper() {
        return this.keepHelper;
    }

    public void addAutoOption(String hostOrCluster, String option, String value) {
        this.autoOptions.put(hostOrCluster, option, value);
    }

    public void addAutoHost(String host) {
        this.autoHosts.add(host);
    }

    public List<String> getAutoHosts() {
        return this.autoHosts;
    }

    public void removeAutoHost() {
        if (!this.autoHosts.isEmpty()) {
            this.autoHosts.remove(0);
        }
    }

    public void addAutoCluster(String cluster) {
        this.autoClusters.add(cluster);
    }

    public List<String> getAutoClusters() {
        return this.autoClusters;
    }

    public void removeAutoCluster() {
        if (!this.autoClusters.isEmpty()) {
            this.autoClusters.remove(0);
        }
    }

    String getAutoOption(String hostOrCluster, String option) {
        return this.autoOptions.get((K[])new String[]{hostOrCluster, option});
    }

    public String getAutoOptionHost(String option) {
        if (this.autoHosts.isEmpty()) {
            return null;
        }
        return this.autoOptions.get((K[])new String[]{this.autoHosts.get(0), option});
    }

    public String getAutoOptionCluster(String option) {
        if (this.autoClusters.isEmpty()) {
            return null;
        }
        return this.autoOptions.get((K[])new String[]{this.autoClusters.get(0), option});
    }

    public String getAutoOptionGlobal(String option) {
        return this.autoOptions.get((K[])new String[]{"global", option});
    }

    public int getVncPortOffset() {
        return this.vncPortOffset;
    }

    public void setVncPortOffset(int vncPortOffset) {
        this.vncPortOffset = vncPortOffset;
    }

    public void setTightvnc(boolean tightvnc) {
        this.tightvnc = tightvnc;
    }

    public void setUltravnc(boolean ultravnc) {
        this.ultravnc = ultravnc;
    }

    public void setRealvnc(boolean realvnc) {
        this.realvnc = realvnc;
    }

    public boolean isTightvnc() {
        return this.tightvnc;
    }

    public void setNoLRM(boolean noLRM) {
        this.noLRM = noLRM;
    }

    public boolean isNoLRM() {
        return this.noLRM;
    }

    public void setStagingDrbd(boolean stagingDrbd) {
        this.stagingDrbd = stagingDrbd;
    }

    public void setStagingPacemaker(boolean stagingPacemaker) {
        this.stagingPacemaker = stagingPacemaker;
    }

    public boolean isStagingPacemaker() {
        return this.stagingPacemaker;
    }

    public boolean isStagingDrbd() {
        return this.stagingDrbd;
    }

    public boolean isUltravnc() {
        return this.ultravnc;
    }

    public boolean isRealvnc() {
        return this.realvnc;
    }

    public float getAnimFPS() {
        return this.animFPS;
    }

    public void setAnimFPS(float animFPS) {
        this.animFPS = animFPS;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setMaxAccessType(AccessType maxAccessType) {
        this.maxAccessType = maxAccessType;
    }

    AccessType getMaxAccessType() {
        return this.maxAccessType;
    }

    public boolean isAccessible(AccessMode required) {
        return this.getAccessType().compareTo(required.getAccessType()) > 0 || this.getAccessType().compareTo(required.getAccessType()) == 0 && (this.advancedMode || !required.isAdvancedMode());
    }

    public String[] getOperatingModes() {
        ArrayList<String> modes = new ArrayList<String>();
        for (AccessType at : OP_MODES_MAP.keySet()) {
            modes.add(OP_MODES_MAP.get((Object)at));
            if (!at.equals((Object)this.maxAccessType)) continue;
            break;
        }
        return modes.toArray(new String[modes.size()]);
    }

    public void setUpgradeCheckEnabled(boolean upgradeCheckEnabled) {
        this.upgradeCheckEnabled = upgradeCheckEnabled;
    }

    public boolean isUpgradeCheckEnabled() {
        return this.upgradeCheckEnabled;
    }

    public boolean getBigDRBDConf() {
        return this.bigDRBDConf;
    }

    public void setBigDRBDConf(boolean bigDRBDConf) {
        this.bigDRBDConf = bigDRBDConf;
    }

    public final boolean isOneHostCluster() {
        return this.oneHostCluster;
    }

    public final void setOneHostCluster(boolean oneHostCluster) {
        this.oneHostCluster = oneHostCluster;
    }

    public final int scaled(int size) {
        return size * this.scale / 100;
    }

    public final int getScale() {
        return this.scale;
    }

    public final void setScale(int scale) {
        this.scale = scale;
    }

    public void setNoPassphrase(boolean noPassphrase) {
        this.noPassphrase = noPassphrase;
    }

    public boolean isNoPassphrase() {
        return this.noPassphrase;
    }

    static {
        OP_MODES_MAP.put(AccessType.RO, OP_MODE_RO);
        OP_MODES_MAP.put(AccessType.OP, OP_MODE_OP);
        OP_MODES_MAP.put(AccessType.ADMIN, OP_MODE_ADMIN);
        OP_MODES_MAP.put(AccessType.GOD, OP_MODE_GOD);
        ACCESS_TYPE_MAP.put(OP_MODE_RO, AccessType.RO);
        ACCESS_TYPE_MAP.put(OP_MODE_OP, AccessType.OP);
        ACCESS_TYPE_MAP.put(OP_MODE_ADMIN, AccessType.ADMIN);
        ACCESS_TYPE_MAP.put(OP_MODE_GOD, AccessType.GOD);
    }

    public static enum AccessType {
        RO,
        OP,
        ADMIN,
        GOD,
        NEVER;

    }
}

