/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ViewScalingControl;
import edu.uci.ics.jung.visualization.decorators.AbstractEdgeShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.AbstractVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.ConstantDirectionalEdgeValueTransformer;
import edu.uci.ics.jung.visualization.decorators.DirectionalEdgeArrowTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.util.VertexShapeFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import lcmc.data.Host;
import lcmc.data.Subtext;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.Info;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.TransformerUtils;

public abstract class ResourceGraph {
    private final ClusterBrowser clusterBrowser;
    private final MyPluggableRenderer<Vertex, Edge> pr = new MyPluggableRenderer();
    private final Map<Vertex, Info> vertexToInfoMap = new LinkedHashMap<Vertex, Info>();
    private final Map<Info, Vertex> infoToVertexMap = new LinkedHashMap<Info, Vertex>();
    private final Map<Edge, JPopupMenu> edgeToPopupMap = new LinkedHashMap<Edge, JPopupMenu>();
    private final Map<Vertex, List<MyMenuItem>> vertexToMenus = new LinkedHashMap<Vertex, List<MyMenuItem>>();
    private final Map<Edge, List<MyMenuItem>> edgeToMenus = new LinkedHashMap<Edge, List<MyMenuItem>>();
    private static final Area EMPTY_SHAPE = new Area();
    private final Lock mGraphLock = new ReentrantLock();
    private Graph<Vertex, Edge> graph;
    private VisualizationViewer<Vertex, Edge> vv;
    private StaticLayout<Vertex, Edge> layout;
    private GraphZoomScrollPane scrollPane;
    private final Lock mVertexLocationsLock = new ReentrantLock();
    private final Map<Vertex, Point2D> vertexLocations = new HashMap<Vertex, Point2D>();
    private ViewScalingControl myScaler;
    private final List<Info> animationList = new ArrayList<Info>();
    private final Lock mAnimationListLock = new ReentrantLock();
    private final List<JComponent> testAnimationList = new ArrayList<JComponent>();
    private final Lock mTestAnimationListLock = new ReentrantLock();
    private volatile Thread animationThread = null;
    private final Lock mAnimationThreadLock = new ReentrantLock();
    private final Map<Vertex, Integer> vertexWidth = new HashMap<Vertex, Integer>();
    private final Map<Vertex, Integer> vertexHeight = new HashMap<Vertex, Integer>();
    private volatile boolean changed = false;
    private volatile boolean testOnlyFlag = false;
    private final Lock mTestOnlyFlag = new ReentrantLock();
    private volatile Thread testAnimationThread = null;
    private final Lock mTestAnimationThreadLock = new ReentrantLock();
    private volatile Edge testEdge = null;
    private volatile Edge existingTestEdge = null;
    private final Lock mTestEdgeLock = new ReentrantLock();
    private final int animInterval = (int)(1000.0f / Tools.getConfigData().getAnimFPS());
    private static final Line2D INSTANCE = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
    private static final Path2D HOLLOW_INSTANCE = new Path2D.Float();
    private static final Paint EDGE_DRAW_PAINT = Tools.getDefaultColor("ResourceGraph.EdgeDrawPaint");
    private static final Paint EDGE_PICKED_PAINT = Tools.getDefaultColor("ResourceGraph.EdgePickedPaint");
    private final Map<String, TextLayout> textLayoutCache = new HashMap<String, TextLayout>();
    private double scaledSoFar = 1.0;

    ResourceGraph(ClusterBrowser clusterBrowser) {
        this.clusterBrowser = clusterBrowser;
        this.initGraph();
    }

    public final void startAnimation(Info info) {
        this.mAnimationListLock.lock();
        if (this.animationList.isEmpty()) {
            this.mAnimationThreadLock.lock();
            if (this.animationThread == null) {
                this.animationThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                Thread.sleep(ResourceGraph.this.animInterval);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            ResourceGraph.this.mAnimationListLock.lock();
                            if (ResourceGraph.this.animationList.isEmpty()) break;
                            for (Info info : ResourceGraph.this.animationList) {
                                info.incAnimationIndex();
                            }
                            ResourceGraph.this.mAnimationListLock.unlock();
                            ResourceGraph.this.repaint();
                        }
                        ResourceGraph.this.mAnimationListLock.unlock();
                        ResourceGraph.this.repaint();
                        ResourceGraph.this.mAnimationThreadLock.lock();
                        ResourceGraph.this.animationThread = null;
                        ResourceGraph.this.mAnimationThreadLock.unlock();
                    }
                });
                this.animationThread.start();
            }
            this.mAnimationThreadLock.unlock();
        }
        this.animationList.add(info);
        this.mAnimationListLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopAnimation(Info info) {
        this.mAnimationListLock.lock();
        try {
            this.animationList.remove(info);
        }
        finally {
            this.mAnimationListLock.unlock();
        }
    }

    public final void startTestAnimation(final JComponent component, final CountDownLatch startTestLatch) {
        this.mTestAnimationListLock.lock();
        this.mTestOnlyFlag.lock();
        this.testOnlyFlag = false;
        this.mTestOnlyFlag.unlock();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Tools.setMenuOpaque(component, false);
            }
        });
        if (this.testAnimationList.isEmpty()) {
            this.mTestAnimationThreadLock.lock();
            if (this.testAnimationThread == null) {
                this.testAnimationThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        block2: while (true) {
                            try {
                                startTestLatch.await();
                            }
                            catch (InterruptedException ignored) {
                                Thread.currentThread().interrupt();
                            }
                            ResourceGraph.this.mTestOnlyFlag.lock();
                            ResourceGraph.this.testOnlyFlag = !ResourceGraph.this.testOnlyFlag;
                            boolean testOnlyFlagLast = ResourceGraph.this.testOnlyFlag;
                            ResourceGraph.this.mTestOnlyFlag.unlock();
                            ResourceGraph.this.repaint();
                            int sleep = 300;
                            if (ResourceGraph.this.testOnlyFlag) {
                                sleep = 1200;
                            }
                            int s = 0;
                            while (true) {
                                if (s >= sleep) continue block2;
                                ResourceGraph.this.mTestOnlyFlag.lock();
                                if (ResourceGraph.this.testOnlyFlag == testOnlyFlagLast) {
                                    ResourceGraph.this.mTestOnlyFlag.unlock();
                                } else {
                                    ResourceGraph.this.mTestOnlyFlag.unlock();
                                    ResourceGraph.this.repaint();
                                }
                                if (!component.isShowing()) {
                                    ResourceGraph.this.stopTestAnimation(component);
                                }
                                ResourceGraph.this.mTestAnimationListLock.lock();
                                if (ResourceGraph.this.testAnimationList.isEmpty()) {
                                    ResourceGraph.this.mTestAnimationListLock.unlock();
                                    ResourceGraph.this.mTestOnlyFlag.lock();
                                    ResourceGraph.this.testOnlyFlag = false;
                                    ResourceGraph.this.mTestOnlyFlag.unlock();
                                    ResourceGraph.this.repaint();
                                    ResourceGraph.this.mTestAnimationThreadLock.lock();
                                    ResourceGraph.this.testAnimationThread = null;
                                    ResourceGraph.this.mTestAnimationThreadLock.unlock();
                                    break block2;
                                }
                                ResourceGraph.this.mTestAnimationListLock.unlock();
                                Tools.sleep(ResourceGraph.this.animInterval);
                                s += ResourceGraph.this.animInterval;
                            }
                            break;
                        }
                    }
                });
                this.testAnimationThread.start();
            }
            this.mTestAnimationThreadLock.unlock();
        }
        this.testAnimationList.add(component);
        this.mTestAnimationListLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopTestAnimation(final JComponent component) {
        this.mTestAnimationListLock.lock();
        try {
            this.testAnimationList.remove(component);
        }
        finally {
            this.mTestAnimationListLock.unlock();
        }
        this.removeExistingTestEdge();
        this.removeTestEdge();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Tools.setMenuOpaque(component, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isTestAnimation() {
        boolean running;
        this.mTestAnimationListLock.lock();
        try {
            running = !this.testAnimationList.isEmpty();
        }
        finally {
            this.mTestAnimationListLock.unlock();
        }
        return running;
    }

    protected final ClusterBrowser getClusterBrowser() {
        return this.clusterBrowser;
    }

    protected abstract void initGraph();

    protected final void initGraph(Graph<Vertex, Edge> graph) {
        this.graph = graph;
        Transformer<Vertex, Point2D> vlf = TransformerUtils.mapTransformer(this.getVertexLocations());
        this.putVertexLocations();
        this.layout = new StaticLayout<Vertex, Edge>(graph, vlf){

            @Override
            public final void setSize(Dimension size) {
                if (size != null) {
                    this.size = size;
                    this.initialize();
                }
            }
        };
        this.vv = new VisualizationViewer<Vertex, Edge>(this.layout);
        this.vv.getRenderContext().setEdgeArrowTransformer(new MyEdgeArrowFunction());
        this.vv.getRenderContext().setEdgeLabelClosenessTransformer(new ConstantDirectionalEdgeValueTransformer(0.5, 0.5));
        this.vv.getRenderContext().setVertexShapeTransformer(new MyVertexShapeSize<Vertex, Edge>(graph, vlf));
        this.vv.getRenderContext().setVertexFillPaintTransformer(new MyPickableVertexPaintFunction(this.vv.getPickedVertexState(), false));
        this.vv.getRenderContext().setVertexDrawPaintTransformer(new MyPickableVertexPaintFunction(this.vv.getPickedVertexState(), true));
        this.vv.getRenderer().setVertexRenderer(this.pr);
        this.vv.getRenderContext().setEdgeLabelTransformer(new ToStringLabeller());
        this.vv.setBackground(Tools.getDefaultColor("ResourceGraph.Background"));
        this.vv.setVertexToolTipTransformer(new MyVertexToolTipFunction());
        this.vv.setEdgeToolTipTransformer(new MyEdgeToolTipFunction());
        this.vv.getRenderContext().setEdgeShapeTransformer(new MyLine());
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new MyPickableEdgePaintFunction(this.vv.getPickedEdgeState(), EDGE_DRAW_PAINT, EDGE_PICKED_PAINT));
        this.vv.getRenderContext().setEdgeFillPaintTransformer(new MyPickableEdgePaintFunction(this.vv.getPickedEdgeState(), EDGE_DRAW_PAINT, EDGE_PICKED_PAINT));
        this.vv.getRenderContext().setArrowDrawPaintTransformer(new MyPickableEdgePaintFunction(this.vv.getPickedEdgeState(), EDGE_DRAW_PAINT, EDGE_PICKED_PAINT));
        this.vv.getRenderContext().setArrowFillPaintTransformer(new MyPickableArrowEdgePaintFunction(this.vv.getPickedEdgeState(), EDGE_DRAW_PAINT, EDGE_PICKED_PAINT));
        this.myScaler = this.getScalingControl();
        DefaultModalGraphMouse<Vertex, Edge> graphMouse = new DefaultModalGraphMouse<Vertex, Edge>(){

            @Override
            protected void loadPlugins() {
                super.loadPlugins();
                ((ScalingGraphMousePlugin)this.scalingPlugin).setScaler(ResourceGraph.this.myScaler);
                this.remove(this.animatedPickingPlugin);
                this.animatedPickingPlugin = null;
            }
        };
        this.vv.setGraphMouse(graphMouse);
        graphMouse.add(new MyPopupGraphMousePlugin());
        this.vv.addGraphMouseListener(new MyGraphMouseListener());
        this.vv.setPickSupport(new ShapePickSupport<Vertex, Edge>(this.vv, 50.0f));
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        this.layout.initialize();
        this.scrollPane = new GraphZoomScrollPane(this.vv);
        final JScrollBar vScrollBar = this.scrollPane.getVerticalScrollBar();
        this.vv.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if ((e.getModifiers() & 2) > 0) {
                    int amount = e.getWheelRotation();
                    vScrollBar.setValue(vScrollBar.getValue() + amount * 20);
                    e.consume();
                    ResourceGraph.this.vv.repaint();
                }
            }
        });
    }

    public final void repaint() {
        this.vv.repaint();
    }

    protected final Graph<Vertex, Edge> getGraph() {
        return this.graph;
    }

    protected final Map<Vertex, Point2D> getVertexLocations() {
        this.mVertexLocationsLock.lock();
        return this.vertexLocations;
    }

    protected final void putVertexLocations() {
        this.mVertexLocationsLock.unlock();
    }

    protected final StaticLayout<Vertex, Edge> getLayout() {
        return this.layout;
    }

    public final VisualizationViewer<Vertex, Edge> getVisualizationViewer() {
        return this.vv;
    }

    protected final Map<Vertex, List<MyMenuItem>> getVertexToMenus() {
        return this.vertexToMenus;
    }

    public Vertex getVertex(Info i) {
        return this.infoToVertexMap.get(i);
    }

    protected final void removeVertex(Info i) {
        this.infoToVertexMap.remove(i);
    }

    protected final void putInfoToVertex(Info i, Vertex v) {
        this.infoToVertexMap.remove(i);
        this.infoToVertexMap.put(i, v);
    }

    public final Set<Info> infoToVertexKeySet() {
        return this.infoToVertexMap.keySet();
    }

    protected final Info getInfo(Vertex v) {
        return this.vertexToInfoMap.get(v);
    }

    protected final void removeInfo(Vertex v) {
        this.vertexToInfoMap.remove(v);
    }

    protected final void putVertexToInfo(Vertex v, Info i) {
        this.vertexToInfoMap.remove(v);
        this.vertexToInfoMap.put(v, i);
    }

    protected final JPopupMenu getPopup(Edge e) {
        return this.edgeToPopupMap.get(e);
    }

    protected final void removePopup(Edge e) {
        this.edgeToPopupMap.remove(e);
    }

    protected final boolean popupExists(Edge v) {
        return this.edgeToPopupMap.containsKey(v);
    }

    protected final void putEdgeToPopup(Edge e, JPopupMenu p) {
        this.edgeToPopupMap.remove(e);
        this.edgeToPopupMap.put(e, p);
    }

    public void scale() {
        Point2D max = this.getLastPosition();
        float maxXPos = (float)max.getX();
        float maxYPos = (float)max.getY();
        if (maxXPos <= 0.0f || maxYPos <= 0.0f) {
            return;
        }
        Float vvX = new Float(this.getLayout().getSize().getWidth());
        Float vvY = new Float(this.getLayout().getSize().getHeight());
        if (maxXPos > vvX.floatValue() || maxYPos > vvY.floatValue()) {
            float x = maxXPos > vvX.floatValue() ? maxXPos : vvX.floatValue();
            float y = maxYPos > vvY.floatValue() ? maxYPos : vvY.floatValue();
            this.getLayout().setSize(new Dimension((int)x, (int)y));
            this.vv.setGraphLayout(this.getLayout());
        }
        if (this.changed) {
            this.somethingChangedReset();
        }
        this.vv.repaint();
    }

    protected Point2D posWithScrollbar(Point2D oldPos) {
        double newX = oldPos.getX() + (double)this.scrollPane.getHorizontalScrollBar().getValue();
        double newY = oldPos.getY() + (double)this.scrollPane.getVerticalScrollBar().getValue();
        return new Point2D.Double(newX, newY);
    }

    public final JPanel getGraphPanel() {
        return this.scrollPane;
    }

    final GraphZoomScrollPane getScrollPane() {
        return this.scrollPane;
    }

    protected abstract String getMainText(Vertex var1, boolean var2);

    protected abstract String getLabelForEdgeStringer(Edge var1);

    abstract String getVertexToolTip(Vertex var1);

    abstract String getEdgeToolTip(Edge var1);

    protected int getVertexWidth(Vertex v) {
        if (this.vertexWidth.containsKey(v)) {
            return this.vertexWidth.get(v);
        }
        return this.getDefaultVertexWidth(v);
    }

    protected int getVertexHeight(Vertex v) {
        if (this.vertexHeight.containsKey(v)) {
            return this.vertexHeight.get(v);
        }
        return this.getDefaultVertexHeight(v);
    }

    protected int getDefaultVertexWidth(Vertex v) {
        return 1;
    }

    protected int getDefaultVertexHeight(Vertex v) {
        return 1;
    }

    protected void setVertexWidth(Vertex v, int size) {
        this.vertexWidth.put(v, size);
    }

    protected void setVertexHeight(Vertex v, int size) {
        this.vertexHeight.put(v, size);
    }

    protected float getVertexAspectRatio(Vertex v) {
        return (float)this.getVertexHeight(v) / (float)this.getVertexWidth(v);
    }

    protected Shape getVertexShape(Vertex v, VertexShapeFactory<Vertex> factory) {
        return factory.getEllipse(v);
    }

    protected abstract JPopupMenu handlePopupVertex(Vertex var1, List<Vertex> var2, Point2D var3);

    final void addPopupItem(Vertex v, MyMenuItem item) {
        this.vertexToMenus.get(v).add(item);
    }

    final void addPopupItem(Edge e, MyMenuItem item) {
        this.edgeToMenus.get(e).add(item);
    }

    protected abstract JPopupMenu handlePopupEdge(Edge var1);

    protected JPopupMenu handlePopupBackground(Point2D pos) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updatePopupMenus() {
        this.mGraphLock.lock();
        try {
            for (Vertex v : this.graph.getVertices()) {
                this.vertexToMenus.remove(v);
            }
            for (Edge e : this.graph.getEdges()) {
                this.edgeToMenus.remove(e);
                this.updatePopupEdge(e);
            }
        }
        finally {
            this.mGraphLock.unlock();
        }
    }

    protected final void updatePopupEdge(Edge edge) {
        List<MyMenuItem> menus = this.edgeToMenus.get(edge);
        if (menus != null) {
            for (MyMenuItem menu : menus) {
                menu.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInfo(Info i) {
        this.mGraphLock.lock();
        try {
            this.graph.removeVertex(this.getVertex(i));
        }
        finally {
            this.mGraphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pickInfo(Info i) {
        this.mGraphLock.lock();
        try {
            Vertex v = this.getVertex(i);
            PickedState psEdge = this.vv.getRenderContext().getPickedEdgeState();
            PickedState psVertex = this.vv.getRenderContext().getPickedVertexState();
            psEdge.clear();
            psVertex.clear();
            psVertex.pick(v, true);
        }
        finally {
            this.mGraphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void pickEdge(Edge e) {
        this.mGraphLock.lock();
        try {
            PickedState psEdge = this.vv.getRenderContext().getPickedEdgeState();
            PickedState psVertex = this.vv.getRenderContext().getPickedVertexState();
            psEdge.clear();
            psVertex.clear();
            psEdge.pick(e, true);
        }
        finally {
            this.mGraphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void pickVertex(Vertex v) {
        this.mGraphLock.lock();
        try {
            PickedState psEdge = this.vv.getRenderContext().getPickedEdgeState();
            PickedState psVertex = this.vv.getRenderContext().getPickedVertexState();
            psEdge.clear();
            psVertex.clear();
            psVertex.pick(v, true);
        }
        finally {
            this.mGraphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pickBackground() {
        this.mGraphLock.lock();
        try {
            PickedState psEdge = this.vv.getRenderContext().getPickedEdgeState();
            PickedState psVertex = this.vv.getRenderContext().getPickedVertexState();
            psEdge.clear();
            psVertex.clear();
        }
        finally {
            this.mGraphLock.unlock();
        }
    }

    protected abstract void vertexReleased(Vertex var1, Point2D var2);

    protected abstract void oneVertexPressed(Vertex var1);

    protected abstract void oneEdgePressed(Edge var1);

    protected abstract void backgroundClicked();

    protected final Paint getVertexDrawPaint(Vertex v) {
        return Tools.getDefaultColor("ResourceGraph.DrawPaint");
    }

    protected Paint getVertexDrawPaintNotPicked(Vertex v) {
        return null;
    }

    protected Color getVertexFillColor(Vertex v) {
        return Tools.getDefaultColor("ResourceGraph.FillPaint");
    }

    protected final Color getVertexFillColor(Info i) {
        return this.getVertexFillColor(this.infoToVertexMap.get(i));
    }

    protected Color getVertexFillSecondaryColor(Vertex v) {
        return Color.WHITE;
    }

    final boolean isPicked(Vertex v) {
        return this.vv.getPickedVertexState().isPicked(v);
    }

    final boolean isPicked(Edge e) {
        return this.vv.getPickedEdgeState().isPicked(e);
    }

    protected Paint getEdgeDrawPaint(Edge e) {
        return EDGE_DRAW_PAINT;
    }

    protected Paint getEdgePickedPaint(Edge e) {
        return EDGE_PICKED_PAINT;
    }

    protected boolean showHollowArrow(Edge e) {
        return false;
    }

    protected abstract boolean showEdgeArrow(Edge var1);

    protected abstract List<ImageIcon> getIconsForVertex(Vertex var1, boolean var2);

    protected final void drawInsideVertex(Graphics2D g2d, Vertex v, Color[] colors, double x, double y, float height, float width) {
        int number = colors.length;
        if (number > 1) {
            for (int i = 1; i < number; ++i) {
                GradientPaint p = new GradientPaint((float)x + width / (float)number, (float)y, this.getVertexFillSecondaryColor(v), (float)x + width / (float)number, (float)y + height, colors[i], false);
                g2d.setPaint(p);
                Rectangle2D.Double s = new Rectangle2D.Double(x + (double)(width / 2.0f) + (double)(width / (float)number / 2.0f * (float)i), y, width / (float)number / 2.0f, height - 2.0f);
                g2d.fill(s);
            }
        }
    }

    protected abstract void drawInside(Vertex var1, Graphics2D var2, double var3, double var5, Shape var7);

    protected abstract String getIconText(Vertex var1, boolean var2);

    protected abstract Subtext getRightCornerText(Vertex var1, boolean var2);

    protected abstract Subtext[] getSubtexts(Vertex var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getPositions(Map<String, Point2D> positions) {
        this.mGraphLock.lock();
        try {
            for (Vertex v : this.graph.getVertices()) {
                String id;
                Info info = this.getInfo(v);
                Point2D.Double p = new Point2D.Double();
                Object loc = this.layout.transform((Object)v);
                if (loc == null) continue;
                p.setLocation((Point2D)loc);
                ((Point2D)p).setLocation(((Point2D)p).getX() + (double)((this.getDefaultVertexWidth(v) - this.getVertexWidth(v)) / 2), ((Point2D)p).getY() + (double)((this.getDefaultVertexHeight(v) - this.getVertexHeight(v)) / 2));
                if (info == null || (id = this.getId(info)) == null) continue;
                positions.put(id, p);
            }
        }
        finally {
            this.mGraphLock.unlock();
        }
    }

    protected abstract String getId(Info var1);

    protected abstract void multiSelection();

    final Point2D getSavedPosition(Info info) {
        Host host;
        if (info == null) {
            return null;
        }
        Host[] hosts = this.clusterBrowser.getClusterHosts();
        Point2D p = null;
        Host[] arr$ = hosts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (p = (host = arr$[i$]).getGraphPosition(this.getId(info))) == null; ++i$) {
        }
        return p;
    }

    final void resetSavedPosition(Info info) {
        Host[] hosts;
        for (Host host : hosts = this.clusterBrowser.getClusterHosts()) {
            host.resetGraphPosition(this.getId(info));
        }
    }

    private TextLayout getVertexTextLayout(Graphics2D g2d, String text, double fontSizeFactor) {
        TextLayout ctl = this.textLayoutCache.get(fontSizeFactor + 58.0 + text);
        if (ctl != null) {
            return ctl;
        }
        Font font = Tools.getGUIData().getMainFrame().getFont();
        FontRenderContext context = g2d.getFontRenderContext();
        TextLayout tl = new TextLayout(text, new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * fontSizeFactor)), context);
        this.textLayoutCache.put(fontSizeFactor + 58.0 + text, tl);
        return tl;
    }

    private void drawVertexText(Graphics2D g2d, TextLayout textLayout, double x, double y, Color color, int alpha) {
        if (color != null) {
            g2d.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
        }
        textLayout.draw(g2d, (float)x, (float)y);
    }

    private void somethingChangedReset() {
        this.changed = false;
    }

    protected final void somethingChanged() {
        this.changed = true;
    }

    protected final boolean isTestOnly() {
        this.mTestOnlyFlag.lock();
        boolean tof = this.testOnlyFlag;
        this.mTestOnlyFlag.unlock();
        return tof;
    }

    protected final boolean isTestOnlyAnimation() {
        this.mTestAnimationListLock.lock();
        boolean empty = this.testAnimationList.isEmpty();
        this.mTestAnimationListLock.unlock();
        return !empty;
    }

    protected final void removeTestEdge() {
        if (this.testEdge != null) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ResourceGraph.this.mTestEdgeLock.lock();
                    ResourceGraph.this.mGraphLock.lock();
                    try {
                        ResourceGraph.this.getGraph().removeEdge(ResourceGraph.this.testEdge);
                    }
                    finally {
                        ResourceGraph.this.mGraphLock.unlock();
                    }
                    ResourceGraph.this.testEdge = null;
                    ResourceGraph.this.mTestEdgeLock.unlock();
                }
            });
        }
    }

    protected final void addTestEdge(final Vertex vP, final Vertex v) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!ResourceGraph.this.mTestEdgeLock.tryLock()) {
                    return;
                }
                if (ResourceGraph.this.testEdge != null) {
                    ResourceGraph.this.mGraphLock.lock();
                    try {
                        ResourceGraph.this.getGraph().removeEdge(ResourceGraph.this.testEdge);
                    }
                    finally {
                        ResourceGraph.this.mGraphLock.unlock();
                    }
                }
                if (!ResourceGraph.this.isTestAnimation()) {
                    ResourceGraph.this.mTestEdgeLock.unlock();
                    return;
                }
                Edge edge = new Edge(vP, v);
                ResourceGraph.this.mGraphLock.lock();
                try {
                    ResourceGraph.this.getGraph().addEdge(edge, vP, v);
                }
                finally {
                    ResourceGraph.this.mGraphLock.unlock();
                }
                ResourceGraph.this.testEdge = edge;
                ResourceGraph.this.mTestEdgeLock.unlock();
            }
        });
    }

    protected final void addExistingTestEdge(Edge edge) {
        if (!this.mTestEdgeLock.tryLock()) {
            return;
        }
        if (!this.isTestAnimation()) {
            this.existingTestEdge = null;
            this.mTestEdgeLock.unlock();
            return;
        }
        this.existingTestEdge = edge;
        this.mTestEdgeLock.unlock();
    }

    protected final void removeExistingTestEdge() {
        this.mTestEdgeLock.lock();
        this.existingTestEdge = null;
        this.mTestEdgeLock.unlock();
    }

    protected final boolean isTestEdge(Edge e) {
        this.mTestEdgeLock.lock();
        boolean is = this.testEdge == e || this.existingTestEdge == e;
        this.mTestEdgeLock.unlock();
        return is;
    }

    protected final void lockGraph() {
        this.mGraphLock.lock();
    }

    protected final void unlockGraph() {
        this.mGraphLock.unlock();
    }

    protected final ViewScalingControl getScalingControl() {
        return new ViewScalingControl(){

            void superScale(VisualizationServer thisVV, float amount, Point2D from) {
                super.scale(thisVV, amount, from);
            }

            @Override
            public void scale(final VisualizationServer thisVV, final float amount, final Point2D from) {
                final JScrollBar sbV = ResourceGraph.this.getScrollPane().getVerticalScrollBar();
                final JScrollBar sbH = ResourceGraph.this.getScrollPane().getHorizontalScrollBar();
                Point2D last = ResourceGraph.this.posWithScrollbar(ResourceGraph.this.getLastPosition());
                double fromX = from.getX() < last.getX() ? from.getX() : last.getX();
                double fromY = from.getY() < last.getY() ? from.getY() : last.getY();
                double width = ResourceGraph.this.getVisualizationViewer().getSize().getWidth();
                double height = ResourceGraph.this.getVisualizationViewer().getSize().getHeight();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Point2D prevPoint = ResourceGraph.this.getVisualizationViewer().getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, from);
                        double scaledSoFar = ResourceGraph.this.getScaledSoFar();
                        float am = amount;
                        if (am < 1.0f) {
                            if (scaledSoFar < 0.3) {
                                am = 1.0f;
                            } else {
                                this.superScale(thisVV, 1.0f / am, new Point2D.Double(0.0, 0.0));
                            }
                        } else if (am > 1.0f) {
                            if (scaledSoFar > 5.0) {
                                am = 1.0f;
                            } else {
                                this.superScale(thisVV, 1.0f / am, new Point2D.Double(0.0, 0.0));
                            }
                        }
                        ResourceGraph.this.setScaledSoFar(scaledSoFar * (double)am);
                        Point2D p2 = ResourceGraph.this.getVisualizationViewer().getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, from);
                        int valueY = (int)((double)sbV.getValue() + prevPoint.getY() - p2.getY());
                        sbV.setValue(valueY);
                        sbV.repaint();
                        int valueX = (int)((double)sbH.getValue() + prevPoint.getX() - p2.getX());
                        sbH.setValue(valueX);
                        sbH.repaint();
                        thisVV.repaint();
                    }
                });
            }
        };
    }

    protected final double getScaledSoFar() {
        return this.scaledSoFar;
    }

    protected final void setScaledSoFar(double scaledSoFar) {
        this.scaledSoFar = scaledSoFar;
    }

    protected final Point2D getLastPosition() {
        double lastX = 0.0;
        double lastY = 0.0;
        Map<Vertex, Point2D> vl = this.getVertexLocations();
        for (Vertex v : vl.keySet()) {
            Point2D last = vl.get(v);
            if (last == null) continue;
            if (last.getX() > lastX) {
                lastX = last.getX();
            }
            if (!(last.getY() > lastY)) continue;
            lastY = last.getY();
        }
        this.putVertexLocations();
        return new Point2D.Double(lastX, lastY + 40.0);
    }

    public List<Info> getSelectedComponents() {
        String cn = this.getClusterBrowser().getCluster().getName();
        Tools.startProgressIndicator(cn, "copy");
        ArrayList<Info> selected = new ArrayList<Info>();
        PickedState ps = this.getVisualizationViewer().getRenderContext().getPickedVertexState();
        for (Vertex v : ps.getPicked()) {
            Info i = this.getInfo(v);
            selected.add(i);
        }
        Tools.stopProgressIndicator(cn, "copy");
        return selected;
    }

    public final Point2D getLocation(Info i) {
        return this.layout.transform((Object)this.getVertex(i));
    }

    public int getNumberOfVertices() {
        return this.getGraph().getVertices().size();
    }

    static {
        float d = 0.05f;
        for (float i = 0.0f; i < 1.0f; i += 0.05f) {
            HOLLOW_INSTANCE.moveTo(i, 0.0);
            HOLLOW_INSTANCE.lineTo((double)i + 0.03500000052154064, 0.0);
        }
        HOLLOW_INSTANCE.lineTo(1.0, 0.0);
    }

    private class MyLine<V, E>
    extends AbstractEdgeShapeTransformer<V, E> {
        private MyLine() {
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            boolean isLoop;
            Graph g = (Graph)context.graph;
            Object e = context.element;
            if (!(e instanceof Edge)) {
                return null;
            }
            Pair endpoints = g.getEndpoints(e);
            if (endpoints != null && (isLoop = endpoints.getFirst().equals(endpoints.getSecond()))) {
                Tools.appWarning("an ilegal loop: " + ResourceGraph.this.vertexToInfoMap.get(endpoints.getFirst()) + " " + e + " " + ResourceGraph.this.vertexToInfoMap.get(endpoints.getSecond()));
                return EMPTY_SHAPE;
            }
            if (ResourceGraph.this.showHollowArrow((Edge)e)) {
                return HOLLOW_INSTANCE;
            }
            return INSTANCE;
        }
    }

    class MyPluggableRenderer<V, E>
    extends BasicVertexRenderer<V, E> {
        MyPluggableRenderer() {
        }

        @Override
        protected final void paintShapeForVertex(RenderContext<V, E> rc, V v, Shape shape) {
            boolean heightChanged;
            int rightCornerTextWidth;
            Graphics2D g2d = rc.getGraphicsContext().getDelegate();
            int shapeWidth = ResourceGraph.this.getDefaultVertexWidth((Vertex)v);
            int shapeHeight = ResourceGraph.this.getDefaultVertexHeight((Vertex)v);
            List<ImageIcon> icons = ResourceGraph.this.getIconsForVertex((Vertex)v, ResourceGraph.this.isTestOnly());
            String mainText = ResourceGraph.this.getMainText((Vertex)v, ResourceGraph.this.isTestOnly());
            TextLayout mainTextLayout = null;
            if (mainText != null && !mainText.equals("")) {
                int mainTextWidth;
                mainTextLayout = ResourceGraph.this.getVertexTextLayout(g2d, mainText, 1.0);
                int iconWidth = 64;
                if (icons == null) {
                    iconWidth = 4;
                }
                if ((mainTextWidth = (int)mainTextLayout.getBounds().getWidth() + iconWidth) > shapeWidth) {
                    shapeWidth = mainTextWidth;
                }
            }
            String iconText = ResourceGraph.this.getIconText((Vertex)v, ResourceGraph.this.isTestOnly());
            int iconTextWidth = 0;
            TextLayout iconTextLayout = null;
            if (iconText != null && !iconText.equals("")) {
                iconTextLayout = ResourceGraph.this.getVertexTextLayout(g2d, iconText, 0.8);
                iconTextWidth = (int)iconTextLayout.getBounds().getWidth();
            }
            Subtext rightCornerText = ResourceGraph.this.getRightCornerText((Vertex)v, ResourceGraph.this.isTestOnly());
            TextLayout rightCornerTextLayout = null;
            if (rightCornerText != null && !rightCornerText.equals("") && iconTextWidth + (rightCornerTextWidth = (int)(rightCornerTextLayout = ResourceGraph.this.getVertexTextLayout(g2d, rightCornerText.getSubtext(), 0.8)).getBounds().getWidth()) + 10 > shapeWidth) {
                shapeWidth = iconTextWidth + rightCornerTextWidth + 10;
            }
            Subtext[] subtexts = ResourceGraph.this.getSubtexts((Vertex)v, ResourceGraph.this.isTestOnly());
            TextLayout[] subtextLayouts = null;
            if (subtexts != null) {
                subtextLayouts = new TextLayout[subtexts.length];
                int i = 0;
                for (Subtext subtext : subtexts) {
                    subtextLayouts[i] = ResourceGraph.this.getVertexTextLayout(g2d, subtext.getSubtext(), 0.8);
                    int subtextWidth = (int)subtextLayouts[i].getBounds().getWidth();
                    if (subtextWidth + 10 > shapeWidth) {
                        shapeWidth = subtextWidth + 10;
                    }
                    ++i;
                }
                if (i > 1) {
                    shapeHeight += (i - 1) * 8;
                }
                shapeHeight += 3;
            }
            int oldShapeWidth = ResourceGraph.this.getVertexWidth((Vertex)v);
            int oldShapeHeight = ResourceGraph.this.getVertexHeight((Vertex)v);
            if (ResourceGraph.this.isTestOnlyAnimation()) {
                if (oldShapeWidth > shapeWidth) {
                    shapeWidth = oldShapeWidth;
                }
                if (oldShapeHeight > shapeHeight) {
                    shapeHeight = oldShapeHeight;
                }
            }
            boolean widthChanged = Math.abs(oldShapeWidth - shapeWidth) > 5;
            boolean bl = heightChanged = Math.abs(oldShapeHeight - shapeHeight) > 1;
            if (widthChanged || heightChanged) {
                ResourceGraph.this.somethingChanged();
                Object pos = ResourceGraph.this.layout.transform((Vertex)v);
                if (pos != null) {
                    double x = ((Point2D)pos).getX();
                    double y = ((Point2D)pos).getY();
                    if (widthChanged) {
                        ResourceGraph.this.setVertexWidth((Vertex)v, shapeWidth);
                        x -= (double)((oldShapeWidth - ResourceGraph.this.getVertexWidth((Vertex)v)) / 2);
                    }
                    if (heightChanged) {
                        ResourceGraph.this.setVertexHeight((Vertex)v, shapeHeight);
                        y -= (double)((oldShapeHeight - ResourceGraph.this.getVertexHeight((Vertex)v)) / 2);
                    }
                    ((Point2D)pos).setLocation(x, y);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResourceGraph.this.scale();
                        }
                    });
                }
            }
            super.paintShapeForVertex(rc, v, shape);
            Object loc = ResourceGraph.this.layout.transform((Vertex)v);
            loc = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)loc);
            double x = ((Point2D)loc).getX() - (double)(ResourceGraph.this.getVertexWidth((Vertex)v) / 2);
            double height = ResourceGraph.this.getDefaultVertexHeight((Vertex)v);
            double y = ((Point2D)loc).getY() - (double)(ResourceGraph.this.getVertexHeight((Vertex)v) / 2);
            ResourceGraph.this.drawInside((Vertex)v, g2d, x, y, shape);
            if (icons != null) {
                for (ImageIcon icon : icons) {
                    icon.setDescription("");
                    g2d.drawImage(icon.getImage(), (int)(x + 4.0), (int)(y + height / 2.0 - (double)(icon.getIconHeight() / 2)), null);
                }
            }
            if (mainTextLayout != null) {
                int textW = (int)mainTextLayout.getBounds().getWidth();
                int textH = (int)mainTextLayout.getBounds().getHeight();
                ResourceGraph.this.drawVertexText(g2d, mainTextLayout, x + (double)(shapeWidth / 2) - (double)(textW / 2), y + height / 2.0 + (double)(textH / 2), new Color(0, 0, 0), 255);
            }
            if (iconTextLayout != null) {
                ResourceGraph.this.drawVertexText(g2d, iconTextLayout, x + 4.0, y + 11.0, new Color(0, 0, 0), 255);
            }
            if (rightCornerTextLayout != null) {
                ResourceGraph.this.drawVertexText(g2d, rightCornerTextLayout, x + (double)shapeWidth - rightCornerTextLayout.getBounds().getWidth() - 4.0, y + 11.0, rightCornerText.getTextColor(), 255);
            }
            if (subtextLayouts != null) {
                int i = 0;
                for (TextLayout l : subtextLayouts) {
                    Color color;
                    int alpha = 255;
                    Subtext subtext = subtexts[i];
                    if (subtext.getSubtext().substring(0, 1).equals(" ")) {
                        alpha = 128;
                    }
                    if ((color = subtext.getColor()) != null) {
                        GradientPaint p = new GradientPaint((float)x + (float)(shapeWidth / 2), (float)y, ResourceGraph.this.getVertexFillSecondaryColor((Vertex)v), (float)x + (float)(shapeWidth / 2), (float)y + (float)shapeHeight, color, false);
                        g2d.setPaint(p);
                        g2d.fillRect((int)x + 4, (int)(y + height - 3.0 + (double)(8 * (i - 1))), shapeWidth - 8, 9);
                    }
                    Color textColor = subtext.getTextColor();
                    ResourceGraph.this.drawVertexText(g2d, l, x + 4.0, y + height - 4.0 + (double)(8 * i), textColor, alpha);
                    ++i;
                }
            }
            Info info = ResourceGraph.this.getInfo((Vertex)v);
            ResourceGraph.this.mAnimationListLock.lock();
            if (ResourceGraph.this.animationList.contains(info)) {
                double i = info.getAnimationIndex();
                ResourceGraph.this.mAnimationListLock.unlock();
                int barPos = (int)(i * (double)shapeWidth / 100.0);
                g2d.setColor(new Color(250, 133, 34, 50));
                if (barPos > shapeWidth / 2) {
                    g2d.fillRect((int)(x + (double)(barPos / 2)), (int)y, shapeWidth - barPos, shapeHeight);
                } else {
                    g2d.fillRect((int)(x + (double)(shapeWidth / 2) - (double)(barPos / 2)), (int)y, barPos, shapeHeight);
                }
            } else {
                ResourceGraph.this.mAnimationListLock.unlock();
            }
        }
    }

    class MyEdgeArrowFunction<V, E>
    extends DirectionalEdgeArrowTransformer<V, E> {
        MyEdgeArrowFunction() {
            super(20, 8, 4);
        }

        @Override
        public Shape transform(Context<Graph<V, E>, E> context) {
            if (ResourceGraph.this.showEdgeArrow((Edge)context.element)) {
                return super.transform(context);
            }
            return EMPTY_SHAPE;
        }
    }

    class MyPickableArrowEdgePaintFunction<E>
    extends PickableEdgePaintTransformer<E> {
        MyPickableArrowEdgePaintFunction(PickedState<E> ps, Paint drawPaint, Paint pickedPaint) {
            super(ps, drawPaint, pickedPaint);
        }

        public Paint getDrawPaint(Edge e) {
            if (ResourceGraph.this.isPicked(e)) {
                return ResourceGraph.this.getEdgePickedPaint(e);
            }
            return ResourceGraph.this.getEdgeDrawPaint(e);
        }

        @Override
        public Paint transform(E e) {
            if (ResourceGraph.this.showHollowArrow((Edge)e)) {
                return Color.WHITE;
            }
            return this.getDrawPaint((Edge)e);
        }
    }

    class MyPickableEdgePaintFunction<E>
    extends PickableEdgePaintTransformer<E> {
        MyPickableEdgePaintFunction(PickedState<E> ps, Paint drawPaint, Paint pickedPaint) {
            super(ps, drawPaint, pickedPaint);
        }

        Paint getDrawPaint(Edge e) {
            if (ResourceGraph.this.isPicked(e)) {
                return ResourceGraph.this.getEdgePickedPaint(e);
            }
            return ResourceGraph.this.getEdgeDrawPaint(e);
        }

        @Override
        public Paint transform(E e) {
            return this.getDrawPaint((Edge)e);
        }
    }

    class MyPickableVertexPaintFunction<V>
    extends PickableVertexPaintTransformer<V> {
        private final boolean draw;

        MyPickableVertexPaintFunction(PickedInfo<V> pi, boolean draw) {
            super(pi, null, null);
            this.draw = draw;
        }

        @Override
        public Paint transform(V v) {
            if (this.draw && this.isPicked(v)) {
                return ResourceGraph.this.getVertexDrawPaint((Vertex)v);
            }
            Paint drawPaintNotPicked = ResourceGraph.this.getVertexDrawPaintNotPicked((Vertex)v);
            if (drawPaintNotPicked == null) {
                return this.getFillPaint((Vertex)v);
            }
            return drawPaintNotPicked;
        }

        final boolean isPicked(V v) {
            return ResourceGraph.this.vv.getPickedVertexState().isPicked((Vertex)v);
        }

        public Paint getFillPaint(Vertex v) {
            Object p = ResourceGraph.this.layout.transform(v);
            p = ResourceGraph.this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, (Point2D)p);
            float x = (float)((Point2D)p).getX();
            float y = (float)((Point2D)p).getY();
            Color col = ResourceGraph.this.getVertexFillColor(v);
            Color secCol = ResourceGraph.this.getVertexFillSecondaryColor(v);
            if (col == null || secCol == null) {
                return null;
            }
            return new GradientPaint(x, y - (float)(ResourceGraph.this.getVertexHeight(v) / 2), secCol, x, y + (float)(ResourceGraph.this.getVertexHeight(v) / 2), col, false);
        }
    }

    class MyGraphMouseListener<V>
    implements GraphMouseListener<V> {
        private static final long serialVersionUID = 1L;

        MyGraphMouseListener() {
        }

        @Override
        public void graphClicked(V v, MouseEvent me) {
        }

        @Override
        public void graphReleased(V v, MouseEvent me) {
            PickedState ps = ResourceGraph.this.vv.getRenderContext().getPickedVertexState();
            for (Vertex vertex : ps.getPicked()) {
                if (vertex == null) continue;
                double x = ResourceGraph.this.layout.getX(vertex);
                double y = ResourceGraph.this.layout.getY(vertex);
                Point2D.Double p = new Point2D.Double(x, y);
                ResourceGraph.this.vertexReleased(vertex, p);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ResourceGraph.this.scale();
                }
            });
        }

        @Override
        public void graphPressed(final V v, final MouseEvent me) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    PickedState psVertex = ResourceGraph.this.vv.getRenderContext().getPickedVertexState();
                    if ((me.getModifiers() & 2) != 0) {
                        psVertex.pick((Vertex)v, true);
                    } else if (psVertex.getPicked().size() == 1 || !psVertex.getPicked().contains(v)) {
                        ResourceGraph.this.oneVertexPressed((Vertex)v);
                    }
                }
            });
            t.start();
        }
    }

    class MyPopupGraphMousePlugin<V, E>
    extends AbstractPopupGraphMousePlugin
    implements MouseListener {
        private static final long serialVersionUID = 1L;

        MyPopupGraphMousePlugin() {
            this(4);
        }

        MyPopupGraphMousePlugin(int modifiers) {
            super(modifiers);
        }

        @Override
        public void mouseReleased(final MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PickedState ps = ResourceGraph.this.vv.getRenderContext().getPickedVertexState();
                    if (ps.getPicked().size() > 1) {
                        ResourceGraph.this.multiSelection();
                    }
                }
            });
            if ((e.getModifiers() & 4) != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyPopupGraphMousePlugin.this.handlePopup0(e);
                    }
                });
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point popP = e.getPoint();
            int posX = (int)((Point2D)popP).getX();
            int posY = (int)((Point2D)popP).getY();
            super.mouseClicked(e);
            PickedState psEdge = ResourceGraph.this.vv.getRenderContext().getPickedEdgeState();
            PickedState psVertex = ResourceGraph.this.vv.getRenderContext().getPickedVertexState();
            if (psEdge.getPicked().size() == 1) {
                Edge edge = (Edge)psEdge.getPicked().toArray()[0];
                ResourceGraph.this.oneEdgePressed(edge);
            } else if (psVertex.getPicked().size() == 0 && psEdge.getPicked().size() == 0) {
                ResourceGraph.this.backgroundClicked();
            }
        }

        @Override
        protected void handlePopup(MouseEvent me) {
        }

        private void handlePopup0(final MouseEvent me) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Point popP = me.getPoint();
                    final int posX = (int)((Point2D)popP).getX();
                    final int posY = (int)((Point2D)popP).getY();
                    GraphElementAccessor pickSupport = ResourceGraph.this.vv.getPickSupport();
                    Vertex v = (Vertex)pickSupport.getVertex(ResourceGraph.this.layout, posX, posY);
                    if (v == null) {
                        Edge edge = (Edge)pickSupport.getEdge(ResourceGraph.this.layout, posX, posY);
                        if (edge == null) {
                            final JPopupMenu backgroundPopup = ResourceGraph.this.handlePopupBackground(popP);
                            if (backgroundPopup != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        backgroundPopup.show(ResourceGraph.this.vv, posX, posY);
                                    }
                                });
                            }
                            ResourceGraph.this.backgroundClicked();
                        } else {
                            final JPopupMenu edgePopup = ResourceGraph.this.handlePopupEdge(edge);
                            if (edgePopup != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        edgePopup.show(ResourceGraph.this.vv, posX, posY);
                                    }
                                });
                            }
                            ResourceGraph.this.oneEdgePressed(edge);
                        }
                    } else {
                        PickedState ps = ResourceGraph.this.vv.getRenderContext().getPickedVertexState();
                        ArrayList<Vertex> pickedV = new ArrayList<Vertex>(ps.getPicked());
                        final JPopupMenu vertexPopup = ResourceGraph.this.handlePopupVertex(v, pickedV, popP);
                        if (vertexPopup != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    vertexPopup.show(ResourceGraph.this.vv, posX, posY);
                                }
                            });
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    vertexPopup.pack();
                                }
                            });
                        }
                        if (pickedV.size() < 2) {
                            ResourceGraph.this.oneVertexPressed(v);
                        }
                    }
                }
            });
            thread.start();
        }
    }

    private final class MyVertexShapeSize<V, E>
    extends AbstractVertexShapeTransformer<V>
    implements Transformer<V, Shape> {
        private final Transformer<Vertex, Point2D> vlf;
        private final Graph<V, E> graph;

        MyVertexShapeSize(Graph<V, E> graphIn, Transformer<Vertex, Point2D> vlfIn) {
            this.graph = graphIn;
            this.vlf = vlfIn;
            this.setSizeTransformer(new Transformer<V, Integer>(){

                @Override
                public Integer transform(V v) {
                    return ResourceGraph.this.getVertexWidth((Vertex)v);
                }
            });
            this.setAspectRatioTransformer(new Transformer<V, Float>(){

                @Override
                public Float transform(V v) {
                    return Float.valueOf(ResourceGraph.this.getVertexAspectRatio((Vertex)v));
                }
            });
        }

        @Override
        public Shape transform(V v) {
            return ResourceGraph.this.getVertexShape((Vertex)v, this.factory);
        }
    }

    class MyEdgeToolTipFunction<E>
    implements Transformer<E, String> {
        MyEdgeToolTipFunction() {
        }

        @Override
        public String transform(E edge) {
            return Tools.html(ResourceGraph.this.getEdgeToolTip((Edge)edge));
        }
    }

    class MyVertexToolTipFunction<V>
    implements Transformer<V, String> {
        MyVertexToolTipFunction() {
        }

        @Override
        public String transform(V v) {
            return Tools.html(ResourceGraph.this.getVertexToolTip((Vertex)v));
        }
    }

    class Edge {
        private Vertex mFrom;
        private Vertex mTo;
        private final Vertex origFrom;
        private final Vertex origTo;
        private boolean wrongColocation = false;

        Edge(Vertex from, Vertex to) {
            this.mFrom = from;
            this.mTo = to;
            this.origFrom = from;
            this.origTo = to;
        }

        final Vertex getSource() {
            return this.mFrom;
        }

        final Vertex getDest() {
            return this.mTo;
        }

        void reverse() {
            this.setDirection(this.mTo, this.mFrom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDirection(Vertex from, Vertex to) {
            Edge thisEdge = this;
            if (this.mFrom != from || this.mTo != to) {
                ResourceGraph.this.mGraphLock.lock();
                try {
                    ResourceGraph.this.getGraph().removeEdge(thisEdge);
                    this.mFrom = from;
                    this.mTo = to;
                    ResourceGraph.this.getGraph().addEdge(thisEdge, this.mFrom, this.mTo);
                }
                finally {
                    ResourceGraph.this.mGraphLock.unlock();
                }
            }
        }

        void reset() {
            this.setDirection(this.origFrom, this.origTo);
        }

        public final String toString() {
            return " " + ResourceGraph.this.getLabelForEdgeStringer(this) + " ";
        }

        void setWrongColocation(boolean wrongColocation) {
            this.wrongColocation = wrongColocation;
        }

        boolean isWrongColocation() {
            return this.wrongColocation;
        }
    }

    static class Vertex {
        Vertex() {
        }

        public String toString() {
            return "V";
        }
    }
}

