/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.TerminalPanel;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.Configuration;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Tools;

public class NewHost
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private Widget hostField;
    private Widget usernameField;
    private Widget sshPortField;
    private Widget useSudoField;
    private boolean bigFields = false;
    private static final int FIELD_WIDTH = 120;
    private static final int BIG_FIELD_WIDTH = 400;
    private static final String SSH_ROOT_USER = Tools.getDefault("SSH.User");
    private static final String SSH_PORT = Tools.getDefault("SSH.Port");
    private boolean enableHostname = false;

    public NewHost(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected void finishDialog() {
        String hostnameEntered = this.hostField.getStringValue().trim();
        this.getHost().setHostnameEntered(hostnameEntered);
        String username = this.usernameField.getStringValue().trim();
        this.getHost().setUsername(username);
        Tools.getConfigData().setLastEnteredUser(username);
        String sshPort = this.sshPortField.getStringValue().trim();
        this.getHost().setSSHPort(sshPort);
        Tools.getConfigData().setLastEnteredSSHPort(sshPort);
        String useSudoString = this.useSudoField.getStringValue().trim();
        this.getHost().setUseSudo("true".equals(useSudoString));
        Tools.getConfigData().setLastEnteredUseSudo("true".equals(useSudoString));
        if (!Tools.getConfigData().existsHost(this.getHost())) {
            Tools.getConfigData().addHostToHosts(this.getHost());
            TerminalPanel terminalPanel = new TerminalPanel(this.getHost());
            Tools.getGUIData().setTerminalPanel(terminalPanel);
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return new Configuration(this, this.getHost());
    }

    @Override
    protected final void checkFields(Widget field) {
        String hs = this.hostField.getStringValue().trim();
        final String us = this.usernameField.getStringValue().trim();
        String ps = this.sshPortField.getStringValue().trim();
        boolean hf = hs.length() > 0;
        boolean uf = us.length() > 0;
        boolean pf = ps.length() > 0;
        int hc = Tools.charCount(hs, ',');
        int uc = Tools.charCount(us, ',');
        if (hf && uf) {
            if (hc != uc) {
                uf = false;
            } else if (uc > Tools.getDefaultInt("MaxHops") - 1) {
                uf = false;
            }
            if (hc > Tools.getDefaultInt("MaxHops") - 1) {
                hf = false;
            }
            if (hc > 0 || uc > 0) {
                if (!this.bigFields) {
                    this.hostField.setWidth(400);
                    this.usernameField.setWidth(400);
                    this.bigFields = true;
                }
            } else if (this.bigFields) {
                this.hostField.setWidth(120);
                this.usernameField.setWidth(120);
                this.bigFields = false;
            }
        }
        if (hf) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewHost.this.hostField.setBackground(NewHost.this.getHost().getHostnameEntered(), NewHost.this.getHost().getHostnameEntered(), true);
                }
            });
        } else {
            this.hostField.wrongValue();
        }
        if (uf) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewHost.this.usernameField.setBackground(NewHost.this.getHost().getUsername(), NewHost.this.getHost().getUsername(), true);
                    if (NewHost.this.useSudoField != null) {
                        if ("root".equals(us)) {
                            NewHost.this.useSudoField.setValueAndWait("false");
                            NewHost.this.useSudoField.setEnabled(false);
                        } else {
                            NewHost.this.useSudoField.setValueAndWait("true");
                            NewHost.this.useSudoField.setEnabled(true);
                        }
                    }
                }
            });
        } else {
            this.usernameField.wrongValue();
        }
        if (pf) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewHost.this.sshPortField.setBackground(NewHost.this.getHost().getSSHPort(), NewHost.this.getHost().getSSHPort(), true);
                }
            });
        } else {
            this.sshPortField.wrongValue();
        }
        final boolean hostField = hf;
        final boolean userField = hf;
        final boolean sshPortField = pf;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (JComponent btn : NewHost.this.nextButtons()) {
                    btn.setEnabled(hostField && userField && sshPortField);
                }
            }
        });
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.NewHost.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.NewHost.Description");
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(this.nextButtons());
    }

    @Override
    protected final void initDialogAfterVisible() {
        this.enableComponents();
        this.checkFields(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewHost.this.hostField.requestFocus();
            }
        });
        if (!Tools.getConfigData().getAutoHosts().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewHost.this.hostField.setValue(Tools.getConfigData().getAutoHosts().get(0));
                }
            });
            Tools.sleep(3000);
            this.pressNextButton();
        }
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel p = new JPanel(new BorderLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        inputPane.setAlignmentX(0.0f);
        JLabel hostLabel = new JLabel(Tools.getString("Dialog.Host.NewHost.EnterHost"));
        inputPane.add(hostLabel);
        String regexp = "^[,\\w.-]+$";
        String hostname = this.getHost().getHostname();
        String hn = hostname == null || "unknown".equals(hostname) ? this.getHost().getHostnameEntered() : hostname;
        this.hostField = WidgetFactory.createInstance(Widget.GUESS_TYPE, hn, Widget.NO_ITEMS, "^[,\\w.-]+$", 120, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        if (hostname == null || "unknown".equals(hostname)) {
            this.enableHostname = true;
        } else if (!this.enableHostname) {
            this.hostField.setEnabled(false);
        }
        this.addCheckField(this.hostField);
        hostLabel.setLabelFor(this.hostField);
        inputPane.add(this.hostField);
        this.hostField.setBackground(this.getHost().getHostnameEntered(), this.getHost().getHostnameEntered(), true);
        JLabel sshPortLabel = new JLabel(Tools.getString("Dialog.Host.NewHost.SSHPort"));
        inputPane.add(sshPortLabel);
        String sshPort = this.getHost().getSSHPort();
        if (sshPort == null && (sshPort = Tools.getConfigData().getLastEnteredSSHPort()) == null) {
            sshPort = SSH_PORT;
        }
        this.sshPortField = WidgetFactory.createInstance(Widget.GUESS_TYPE, sshPort, Widget.NO_ITEMS, "^\\d+$", 50, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.addCheckField(this.sshPortField);
        sshPortLabel.setLabelFor(this.sshPortField);
        inputPane.add(this.sshPortField);
        this.sshPortField.setBackground(this.getHost().getSSHPort(), this.getHost().getSSHPort(), true);
        JLabel usernameLabel = new JLabel(Tools.getString("Dialog.Host.NewHost.EnterUsername"));
        inputPane.add(usernameLabel);
        String userName = this.getHost().getUsername();
        if (userName == null && (userName = Tools.getConfigData().getLastEnteredUser()) == null) {
            userName = SSH_ROOT_USER;
        }
        ArrayList<String> users = new ArrayList<String>();
        String user = System.getProperty("user.name");
        if (!SSH_ROOT_USER.equals(user)) {
            users.add(SSH_ROOT_USER);
        }
        users.add(user);
        this.usernameField = WidgetFactory.createInstance(Widget.GUESS_TYPE, userName, users.toArray(new String[users.size()]), "^[,\\w.-]+$", 120, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.usernameField.setEditable(true);
        this.addCheckField(this.usernameField);
        usernameLabel.setLabelFor(this.usernameField);
        inputPane.add(this.usernameField);
        this.usernameField.setBackground(this.getHost().getUsername(), this.getHost().getUsername(), true);
        JLabel useSudoLabel = new JLabel(Tools.getString("Dialog.Host.NewHost.UseSudo"));
        inputPane.add(useSudoLabel);
        Boolean useSudo = this.getHost().isUseSudo();
        if (useSudo == null && (useSudo = Tools.getConfigData().getLastEnteredUseSudo()) == null) {
            useSudo = false;
        }
        this.useSudoField = WidgetFactory.createInstance(Widget.GUESS_TYPE, useSudo.toString(), new String[]{"true", "false"}, Widget.NO_REGEXP, 50, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        useSudoLabel.setLabelFor(this.useSudoField);
        inputPane.add(this.useSudoField);
        this.useSudoField.setBackground(useSudo, useSudo, true);
        SpringUtilities.makeCompactGrid(inputPane, 2, 4, 1, 1, 1, 1);
        p.add((Component)inputPane, "South");
        return p;
    }

    protected JComponent[] nextButtons() {
        return new JComponent[]{this.buttonClass(this.nextButton())};
    }
}

