/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import lcmc.AddDrbdConfigDialog;
import lcmc.Exceptions;
import lcmc.ProxyHostWizard;
import lcmc.configs.AppDefaults;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.DRBDtestData;
import lcmc.data.DrbdXML;
import lcmc.data.Host;
import lcmc.data.resources.Resource;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.dialog.cluster.DrbdLogs;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdGuiInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.resources.ProxyHostInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.DRBD;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class DrbdInfo
extends DrbdGuiInfo {
    private BlockDevInfo selectedBD = null;
    private JComponent infoPanel = null;
    private static final String SECTION_COMMON_PROXY = "proxy";
    private static final ImageIcon DRBD_ICON = Tools.createImageIcon(Tools.getDefault("ClusterBrowser.DRBDIconSmall"));
    private static final String ALL_LOGS_PATTERN = "/dev/drbd[0-9]*";

    public DrbdInfo(String name, Browser browser) {
        super(name, browser);
        this.setResource(new Resource(name));
        ((ClusterBrowser)browser).getDrbdGraph().setDrbdInfo(this);
    }

    public void setParameters() {
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        Cluster cluster = this.getCluster();
        for (String hostName : dxml.getProxyHostNames()) {
            Host proxyHost = cluster.getProxyHostByName(hostName);
            if (proxyHost == null) {
                Host hp = new Host();
                hp.setHostname(hostName);
                cluster.addProxyHost(hp);
                this.addProxyHostNode(hp);
                continue;
            }
            ProxyHostInfo phi = proxyHost.getBrowser().getProxyHostInfo();
            if (phi == null || phi.getNode() != null) continue;
            this.addProxyHostNode(proxyHost);
        }
        for (String param : this.getParametersFromXML()) {
            String value;
            String sectionString = dxml.getSection(param);
            String section = sectionString.replaceAll("-options$", "");
            String defaultValue = this.getParamDefault(param);
            if ("global".equals(section)) {
                value = dxml.getGlobalConfigValue(param);
                if (value == null) {
                    value = defaultValue;
                }
                if (value == null) {
                    value = "";
                }
            } else {
                value = dxml.getCommonConfigValue(section, param);
                if ("".equals(value)) {
                    value = defaultValue;
                }
            }
            if ("usage-count".equals(param) && "".equals(value = this.getComboBoxValue(param))) {
                value = "yes";
            }
            String oldValue = this.getParamSaved(param);
            Widget wi = this.getWidget(param, null);
            if (Tools.areEqual(value, oldValue)) continue;
            this.getResource().setValue(param, value);
            if (wi == null) continue;
            wi.setValue(value);
        }
    }

    public void setSelectedNode(BlockDevInfo bdi) {
        this.selectedBD = bdi;
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget wi = super.createWidget(param, prefix, width);
        if ("usage-count".equals(param)) {
            wi.setEnabled(false);
        }
        return wi;
    }

    public void createDrbdConfig(boolean testOnly) throws Exceptions.DrbdConfigException {
        LinkedHashSet<Host> hosts = new LinkedHashSet<Host>(this.getCluster().getHosts());
        hosts.addAll(this.getCluster().getProxyHosts());
        for (Host host : hosts) {
            String preCommand;
            boolean makeBackup;
            String configName;
            String dir;
            StringBuilder globalConfig = new StringBuilder(160);
            globalConfig.append("## generated by drbd-gui\n\n");
            StringBuilder global = new StringBuilder(80);
            DrbdXML dxml = this.getBrowser().getDrbdXML();
            String[] params = dxml.getSectionParams("global");
            global.append("global {\n");
            boolean volumesAvailable = host.hasVolumes();
            for (String param : params) {
                String value = this.getComboBoxValue(param);
                if (value == null || "".equals(value)) {
                    if (!"usage-count".equals(param)) continue;
                    value = "yes";
                }
                if (value.equals(dxml.getParamDefault(param))) continue;
                if ("disable-ip-verification".equals(param) || !volumesAvailable && (this.isCheckBox(param) || "booleanhandler".equals(this.getParamType(param)))) {
                    if (!value.equals("yes")) continue;
                    global.append("\t\t" + param + ";\n");
                    continue;
                }
                global.append("\t\t");
                global.append(param);
                global.append('\t');
                global.append(Tools.escapeConfig(value));
                global.append(";\n");
            }
            global.append("}\n");
            if (global.length() > 0) {
                globalConfig.append((CharSequence)global);
            }
            String common = this.drbdSectionsConfig(host);
            String commonSectionConfig = "";
            if (!"".equals(common)) {
                commonSectionConfig = "\ncommon {\n" + common + "}";
            }
            LinkedHashMap<String, String> resConfigs = new LinkedHashMap<String, String>();
            Set<Host> proxyHosts = this.getCluster().getProxyHosts();
            for (DrbdResourceInfo dri : this.getBrowser().getDrbdResHashValues()) {
                if (!dri.resourceInHost(host) && !proxyHosts.contains(host)) continue;
                String rConf = dri.drbdResourceConfig(host);
                resConfigs.put(dri.getName(), rConf);
            }
            boolean bigDRBDConf = true;
            try {
                bigDRBDConf = Tools.getConfigData().getBigDRBDConf() || Tools.compareVersions(host.getDrbdVersion(), "8.3.7") < 0;
            }
            catch (Exceptions.IllegalVersionException e) {
                Tools.appWarning(e.getMessage(), e);
            }
            if (testOnly) {
                dir = "/var/lib/drbd/";
                configName = "drbd.conf-lcmc-test";
                makeBackup = false;
                preCommand = null;
                bigDRBDConf = true;
            } else {
                dir = "/etc/";
                configName = "drbd.conf";
                makeBackup = true;
                preCommand = bigDRBDConf ? "mv /etc/drbd.d{,.bak.`date +'%s'`} 2>/dev/null" : "cp -r /etc/drbd.d{,.bak.`date +'%s'`} 2>/dev/null";
            }
            if (bigDRBDConf) {
                host.getSSH().createConfig(globalConfig.toString() + commonSectionConfig + "\n\n" + Tools.join("\n", resConfigs.values()), configName, dir, "0600", makeBackup, preCommand, null);
                continue;
            }
            host.getSSH().createConfig(globalConfig.toString() + commonSectionConfig, "global_common.conf", dir + "drbd.d.temp/", "0600", false, preCommand, null);
            for (String resConfigName : resConfigs.keySet()) {
                host.getSSH().createConfig(((String)resConfigs.get(resConfigName)).toString(), resConfigName + ".res", dir + "drbd.d.temp/", "0600", false, null, null);
            }
            StringBuilder tempDRBDConf = new StringBuilder(200);
            tempDRBDConf.append("## generated by drbd-gui\n\n");
            tempDRBDConf.append("include \"drbd.d/global_common.conf\";\n");
            tempDRBDConf.append("include \"drbd.d/*.res\";");
            host.getSSH().createConfig(tempDRBDConf.toString(), configName + ".temp", dir, "0600", false, null, null);
            StringBuilder drbdConf = new StringBuilder(200);
            drbdConf.append("## generated by drbd-gui\n\n");
            drbdConf.append("include \"drbd.d.temp/global_common.conf\";\n");
            drbdConf.append("include \"drbd.d.temp/*.res\";");
            host.getSSH().createConfig(drbdConf.toString(), configName, dir, "0600", makeBackup, null, "rm -rf /etc/drbd.d 2>/dev/null; cp -r /etc/drbd.d{.temp,} && mv /etc/drbd.conf{.temp,} && rm -rf /etc/drbd.d.temp/");
        }
    }

    @Override
    public String[] getParametersFromXML() {
        DrbdXML drbdXML = this.getBrowser().getDrbdXML();
        if (drbdXML == null) {
            return null;
        }
        return this.getEnabledSectionParams(drbdXML.getGlobalParams());
    }

    @Override
    protected String getSectionDisplayName(String section) {
        if ("global".equals(section)) {
            return super.getSectionDisplayName(section);
        }
        return Tools.getString("DrbdInfo.CommonSection") + super.getSectionDisplayName(section);
    }

    @Override
    protected String getSection(String param) {
        return this.getBrowser().getDrbdXML().getSection(param);
    }

    public void apply(boolean testOnly) {
        if (!testOnly) {
            String[] params = this.getParametersFromXML();
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DrbdInfo.this.getApplyButton().setEnabled(false);
                    DrbdInfo.this.getRevertButton().setEnabled(false);
                    DrbdInfo.this.getApplyButton().setToolTipText(null);
                }
            });
            this.storeComboBoxValues(params);
            for (DrbdResourceInfo dri : this.getDrbdResources()) {
                dri.setParameters();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DrbdInfo.this.setAllApplyButtons();
                }
            });
        }
    }

    @Override
    public JComponent getInfoPanel() {
        if (this.selectedBD != null) {
            return this.selectedBD.getInfoPanel();
        }
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        JPanel mainPanel = new JPanel();
        if (this.getBrowser().getDrbdXML() == null) {
            mainPanel.add(new JLabel("drbd info not available"));
            return mainPanel;
        }
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                Host dcHost = DrbdInfo.this.getBrowser().getDCHost();
                if (dcHost == null) {
                    return false;
                }
                return !Tools.versionBeforePacemaker(dcHost);
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                DrbdInfo.this.getBrowser().getDrbdGraph().stopTestAnimation(DrbdInfo.this.getApplyButton());
                DrbdInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                DrbdInfo.this.getApplyButton().setToolTipText(Tools.getString("ClusterBrowser.StartingDRBDtest"));
                DrbdInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                DrbdInfo.this.getBrowser().getDrbdGraph().startTestAnimation(DrbdInfo.this.getApplyButton(), startTestLatch);
                DrbdInfo.this.getBrowser().drbdtestLockAcquire();
                DrbdInfo.this.getBrowser().setDRBDtestData(null);
                LinkedHashMap<Host, String> testOutput = new LinkedHashMap<Host, String>();
                try {
                    DrbdInfo.this.createDrbdConfig(true);
                    for (Host h : DrbdInfo.this.getCluster().getHostsArray()) {
                        DRBD.adjust(h, "all", null, true);
                        testOutput.put(h, DRBD.getDRBDtest());
                    }
                }
                catch (Exceptions.DrbdConfigException dce) {
                    DrbdInfo.this.getBrowser().drbdtestLockRelease();
                    Tools.appError("config failed");
                    return;
                }
                DRBDtestData dtd = new DRBDtestData(testOutput);
                DrbdInfo.this.getApplyButton().setToolTipText(dtd.getToolTip());
                DrbdInfo.this.getBrowser().setDRBDtestData(dtd);
                DrbdInfo.this.getBrowser().drbdtestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initApplyButton(buttonCallback);
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        mainPanel.add(buttonPanel);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        String[] params = this.getParametersFromXML();
        this.enableSection(SECTION_COMMON_PROXY, false, false);
        this.addParams(optionsPanel, params, Tools.getDefaultSize("ClusterBrowser.DrbdResLabelWidth"), Tools.getDefaultSize("ClusterBrowser.DrbdResFieldWidth"), null);
        this.getApplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                DrbdInfo.this.getApplyButton().setEnabled(false);
                                DrbdInfo.this.getRevertButton().setEnabled(false);
                            }
                        });
                        DrbdInfo.this.getBrowser().drbdStatusLock();
                        try {
                            DrbdInfo.this.createDrbdConfig(false);
                            for (Host h : DrbdInfo.this.getCluster().getHosts()) {
                                DRBD.adjust(h, "all", null, false);
                            }
                        }
                        catch (Exceptions.DrbdConfigException dce) {
                            DrbdInfo.this.getBrowser().drbdStatusUnlock();
                            Tools.appError("config failed");
                            return;
                        }
                        DrbdInfo.this.apply(false);
                        DrbdInfo.this.getBrowser().drbdStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.getRevertButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DrbdInfo.this.getBrowser().drbdStatusLock();
                        DrbdInfo.this.revert();
                        DrbdInfo.this.getBrowser().drbdStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        mainPanel.add(optionsPanel);
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(Tools.getDefaultSize("ClusterBrowser.DrbdResLabelWidth") + Tools.getDefaultSize("ClusterBrowser.DrbdResFieldWidth") + 4));
        newPanel.add(new JScrollPane(mainPanel));
        this.infoPanel = newPanel;
        this.infoPanelDone();
        return this.infoPanel;
    }

    @Override
    boolean selectAutomaticallyInTreeMenu() {
        return this.infoPanel == null;
    }

    @Override
    public JPanel getGraphicalView() {
        if (this.selectedBD != null) {
            this.getBrowser().getDrbdGraph().pickBlockDevice(this.selectedBD);
        }
        return this.getBrowser().getDrbdGraph().getGraphPanel();
    }

    @Override
    public void selectMyself() {
        if (this.selectedBD == null || !this.selectedBD.getBlockDevice().isDrbd()) {
            this.getBrowser().reload(this.getNode(), true);
            this.getBrowser().nodeChanged(this.getNode());
        } else {
            this.getBrowser().reload(this.selectedBD.getNode(), true);
            this.getBrowser().nodeChanged(this.selectedBD.getNode());
        }
    }

    private int getNewDrbdResourceIndex() {
        Iterator<String> it = this.getBrowser().getDrbdResHash().keySet().iterator();
        int index = -1;
        while (it.hasNext()) {
            int i;
            String name = it.next();
            Pattern p = Pattern.compile("^r(\\d+)$");
            Matcher m = p.matcher(name);
            if (!m.matches() || (i = Integer.parseInt(m.group(1))) <= index) continue;
            index = i;
        }
        this.getBrowser().putDrbdResHash();
        return index + 1;
    }

    public DrbdVolumeInfo addDrbdVolume(DrbdResourceInfo dri, String volumeNr, String drbdDevStr, List<BlockDevInfo> blockDevInfos, boolean testOnly) {
        DrbdVolumeInfo dvi = new DrbdVolumeInfo(volumeNr, drbdDevStr, dri, blockDevInfos, this.getBrowser());
        dri.addDrbdVolume(dvi);
        this.addDrbdVolume(dvi);
        return dvi;
    }

    public void addDrbdVolume(final BlockDevInfo bd1, final BlockDevInfo bd2, boolean interactive, final boolean testOnly) {
        if (interactive) {
            if (bd1 != null) {
                bd1.getBlockDevice().setNew(true);
            }
            if (bd2 != null) {
                bd2.getBlockDevice().setNew(true);
            }
            final DrbdInfo thisClass = this;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String configString2;
                    AddDrbdConfigDialog adrd = new AddDrbdConfigDialog(thisClass, bd1, bd2);
                    adrd.showDialogs();
                    for (String p : bd1.getParametersFromXML()) {
                        bd1.widgetRemove(p, "widget");
                        bd2.widgetRemove(p, "widget");
                    }
                    if (adrd.isCanceled()) {
                        DrbdVolumeInfo dvi = bd1.getDrbdVolumeInfo();
                        if (dvi != null) {
                            dvi.removeMyself(testOnly);
                        }
                        DrbdInfo.this.getBrowser().getDrbdGraph().stopAnimation(bd1);
                        DrbdInfo.this.getBrowser().getDrbdGraph().stopAnimation(bd2);
                        return;
                    }
                    DrbdInfo.this.getBrowser().updateCommonBlockDevices();
                    DrbdXML newDrbdXML = new DrbdXML(DrbdInfo.this.getCluster().getHostsArray(), DrbdInfo.this.getBrowser().getDrbdParameters());
                    String configString1 = newDrbdXML.getConfig(bd1.getHost());
                    if (configString1 != null) {
                        newDrbdXML.update(configString1);
                    }
                    if ((configString2 = newDrbdXML.getConfig(bd2.getHost())) != null) {
                        newDrbdXML.update(configString2);
                    }
                    DrbdInfo.this.getBrowser().setDrbdXML(newDrbdXML);
                    DrbdInfo.this.getBrowser().resetFilesystems();
                }
            });
            thread.start();
        } else {
            this.getBrowser().resetFilesystems();
        }
    }

    public DrbdResourceInfo getNewDrbdResource(Set<Host> hosts) {
        int index = this.getNewDrbdResourceIndex();
        String name = "r" + Integer.toString(index);
        DrbdResourceInfo dri = new DrbdResourceInfo(name, hosts, this.getBrowser());
        dri.getResource().setNew(true);
        return dri;
    }

    public DrbdVolumeInfo getNewDrbdVolume(DrbdResourceInfo dri, List<BlockDevInfo> blockDevInfos) {
        Map<String, DrbdVolumeInfo> drbdDevHash = this.getBrowser().getDrbdDevHash();
        int index = 0;
        String drbdDevStr = "/dev/drbd" + Integer.toString(index);
        while (drbdDevHash.containsKey(drbdDevStr)) {
            drbdDevStr = "/dev/drbd" + Integer.toString(++index);
        }
        this.getBrowser().putDrbdDevHash();
        String volumeNr = dri.getAvailVolumeNumber();
        DrbdVolumeInfo dvi = new DrbdVolumeInfo(volumeNr, drbdDevStr, dri, blockDevInfos, this.getBrowser());
        return dvi;
    }

    public void addDrbdResource(DrbdResourceInfo dri) {
        String name = dri.getName();
        dri.getDrbdResource().setDefaultValue("name", name);
        this.getBrowser().getDrbdResHash().put(name, dri);
        this.getBrowser().putDrbdResHash();
        DefaultMutableTreeNode drbdResourceNode = new DefaultMutableTreeNode(dri);
        this.getBrowser().reload(this.getBrowser().getDrbdNode(), true);
        dri.setNode(drbdResourceNode);
        this.getBrowser().getDrbdNode().add(drbdResourceNode);
        this.getBrowser().reload(drbdResourceNode, true);
    }

    public void addDrbdVolume(DrbdVolumeInfo dvi) {
        BlockDevInfo bdi1 = dvi.getFirstBlockDevInfo();
        BlockDevInfo bdi2 = dvi.getSecondBlockDevInfo();
        String device = dvi.getDevice();
        this.getBrowser().getDrbdDevHash().put(device, dvi);
        this.getBrowser().putDrbdDevHash();
        if (bdi1 != null) {
            bdi1.setDrbd(true);
            bdi1.setDrbdVolumeInfo(dvi);
            bdi1.getBlockDevice().setDrbdBlockDevice(bdi1.getHost().getDrbdBlockDevice(device));
            bdi1.cleanup();
            bdi1.setInfoPanel(null);
            bdi1.getInfoPanel();
        }
        if (bdi2 != null) {
            bdi2.setDrbd(true);
            bdi2.setDrbdVolumeInfo(dvi);
            bdi2.getBlockDevice().setDrbdBlockDevice(bdi2.getHost().getDrbdBlockDevice(device));
            bdi2.cleanup();
            bdi2.setInfoPanel(null);
            bdi2.getInfoPanel();
        }
        DefaultMutableTreeNode drbdVolumeNode = new DefaultMutableTreeNode(dvi);
        dvi.setNode(drbdVolumeNode);
        dvi.getDrbdResourceInfo().getNode().add(drbdVolumeNode);
        DefaultMutableTreeNode drbdBDNode1 = new DefaultMutableTreeNode(bdi1);
        bdi1.setNode(drbdBDNode1);
        DefaultMutableTreeNode drbdBDNode2 = new DefaultMutableTreeNode(bdi2);
        bdi2.setNode(drbdBDNode2);
        drbdVolumeNode.add(drbdBDNode1);
        drbdVolumeNode.add(drbdBDNode2);
        this.getBrowser().getDrbdGraph().addDrbdVolume(dvi, bdi1, bdi2);
        this.getBrowser().reload(drbdVolumeNode, true);
        this.getBrowser().resetFilesystems();
    }

    public DrbdResourceInfo addDrbdResource(String name, Set<Host> hosts, boolean testOnly) {
        String[] sections;
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        DrbdResourceInfo dri = new DrbdResourceInfo(name, hosts, this.getBrowser());
        for (String sectionString : sections = dxml.getSections()) {
            String[] params;
            String section = sectionString.replaceAll("-options$", "");
            for (String param : params = dxml.getSectionParams(section)) {
                String value = dxml.getConfigValue(name, section, param);
                if ("".equals(value)) {
                    value = dxml.getParamDefault(param);
                }
                dri.getDrbdResource().setValue(param, value);
            }
        }
        dri.getDrbdResource().setCommited(true);
        this.addDrbdResource(dri);
        this.getBrowser().resetFilesystems();
        return dri;
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        boolean changed = false;
        for (DrbdResourceInfo dri : this.getDrbdResources()) {
            if (!dri.checkResourceFieldsChanged(param, dri.getParametersFromXML(), true)) continue;
            changed = true;
        }
        return super.checkResourceFieldsChanged(param, params) || changed;
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromDrbdInfo) {
        boolean correct = true;
        for (DrbdResourceInfo dri : this.getDrbdResources()) {
            if (dri.checkResourceFieldsCorrect(param, dri.getParametersFromXML(), true)) continue;
            correct = false;
        }
        return super.checkResourceFieldsCorrect(param, params) && correct;
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        if (this.getBrowser().getDrbdResHash().isEmpty()) {
            this.getBrowser().putDrbdResHash();
            return false;
        }
        this.getBrowser().putDrbdResHash();
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        if (dxml != null && dxml.isDrbdDisabled()) {
            return false;
        }
        return super.checkResourceFieldsCorrect(param, params);
    }

    @Override
    public void revert() {
        super.revert();
        for (DrbdResourceInfo dri : this.getDrbdResources()) {
            dri.revert();
        }
    }

    public void setAllApplyButtons() {
        for (DrbdResourceInfo dri : this.getDrbdResources()) {
            dri.storeComboBoxValues(dri.getParametersFromXML());
            dri.setAllApplyButtons();
        }
    }

    public Set<DrbdResourceInfo> getDrbdResources() {
        LinkedHashSet<DrbdResourceInfo> resources = new LinkedHashSet<DrbdResourceInfo>();
        Host[] hosts = this.getCluster().getHostsArray();
        for (DrbdResourceInfo dri : this.getBrowser().getDrbdResHashValues()) {
            for (Host host : hosts) {
                if (!dri.resourceInHost(host)) continue;
                resources.add(dri);
            }
        }
        return resources;
    }

    public boolean atLeastVersion(String drbdVersion) {
        for (Host host : this.getCluster().getHostsArray()) {
            String hostDrbdVersion = host.getDrbdVersion();
            if (hostDrbdVersion == null) continue;
            try {
                if (Tools.compareVersions(hostDrbdVersion, drbdVersion) >= 0) continue;
                return false;
            }
            catch (Exceptions.IllegalVersionException e) {
                Tools.appWarning(e.getMessage(), e);
            }
        }
        return true;
    }

    public void reloadDRBDResourceComboBoxes() {
        for (DrbdResourceInfo dri : this.getDrbdResources()) {
            dri.reloadComboBoxes();
        }
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return DRBD_ICON;
    }

    @Override
    public ImageIcon getCategoryIcon(boolean testOnly) {
        return DRBD_ICON;
    }

    @Override
    protected Color getSectionColor(String section) {
        if (SECTION_COMMON_PROXY.equals(section)) {
            return AppDefaults.LIGHT_ORANGE;
        }
        return super.getSectionColor(section);
    }

    void enableProxySection(boolean wizard) {
        this.enableSection(SECTION_COMMON_PROXY, true, wizard);
    }

    public void addProxyHostNode(Host host) {
        ProxyHostInfo proxyHostInfo = new ProxyHostInfo(host, (Browser)host.getBrowser());
        host.getBrowser().setProxyHostInfo(proxyHostInfo);
        DefaultMutableTreeNode proxyHostNode = new DefaultMutableTreeNode(proxyHostInfo);
        this.getBrowser().reload(this.getBrowser().getDrbdNode(), true);
        proxyHostInfo.setNode(proxyHostNode);
        this.getBrowser().getDrbdNode().add(proxyHostNode);
        this.getBrowser().reload(proxyHostNode, true);
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        boolean testOnly = false;
        MyMenuItem addProxyHostMenu = new MyMenuItem(Tools.getString("DrbdInfo.AddProxyHost"), null, Tools.getString("DrbdInfo.AddProxyHost"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                DrbdInfo.this.addProxyHostWizard();
            }
        };
        items.add(addProxyHostMenu);
        MyMenuItem viewLogMenu = new MyMenuItem(Tools.getString("ClusterBrowser.Drbd.ViewLogs"), LOGFILE_ICON, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                DrbdInfo.this.hidePopup();
                DrbdLogs l = new DrbdLogs(DrbdInfo.this.getCluster(), DrbdInfo.ALL_LOGS_PATTERN);
                l.showDialog();
            }
        };
        items.add(viewLogMenu);
        return items;
    }

    private void addProxyHostWizard() {
        Host proxyHost = new Host();
        proxyHost.setCluster(this.getCluster());
        ProxyHostWizard w = new ProxyHostWizard(proxyHost, null);
        w.showDialogs();
    }
}

