/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.PtestData;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.HostDrbdInfo;
import lcmc.gui.resources.Info;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.DRBD;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class DrbdMultiSelectionInfo
extends EditableInfo {
    private final List<Info> selectedInfos;

    public DrbdMultiSelectionInfo(List<Info> selectedInfos, Browser browser) {
        super("selection", browser);
        this.selectedInfos = selectedInfos;
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return null;
    }

    @Override
    protected String getInfoType() {
        return "text/html";
    }

    @Override
    public String getInfo() {
        StringBuilder s = new StringBuilder(80);
        s.append(Tools.getString("DrbdMultiSelectionInfo.Selection"));
        for (Info si : this.selectedInfos) {
            s.append(si.toString());
            s.append("<br />");
        }
        return s.toString();
    }

    private void createSelectedHostsPopup(final List<HostDrbdInfo> selectedHostInfos, List<UpdatableItem> items) {
        MyMenuItem loadItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.LoadDrbd"), null, Tools.getString("DrbdMultiSelectionInfo.LoadDrbd"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    if (hi.getHost().isConnected()) {
                        if (!hi.getHost().isDrbdLoaded()) continue;
                        return "already loaded";
                    }
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DRBD.load(hi.getHost(), false);
                }
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DrbdMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        items.add(loadItem);
        MyMenuItem adjustAllItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.AdjustAllDrbd"), null, Tools.getString("DrbdMultiSelectionInfo.AdjustAllDrbd"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    if (hi.getHost().isConnected()) continue;
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DRBD.adjust(hi.getHost(), "all", null, false);
                }
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DrbdMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        items.add(adjustAllItem);
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.DRBDMenuItemCallback adjustAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, adjustAllItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DRBD.adjust(hi.getHost(), "all", null, true);
                }
            }
        };
        this.addMouseOverListener(adjustAllItem, adjustAllItemCallback);
        MyMenuItem upAllItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.UpAll"), null, Tools.getString("DrbdMultiSelectionInfo.UpAll"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    if (hi.getHost().isDrbdStatus()) continue;
                    return "drbd status is not available";
                }
                return null;
            }

            @Override
            public void action() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DRBD.up(hi.getHost(), "all", null, false);
                }
            }
        };
        items.add(upAllItem);
        ClusterBrowser clusterBrowser2 = this.getBrowser();
        clusterBrowser2.getClass();
        ClusterBrowser.DRBDMenuItemCallback upAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser2, upAllItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host host) {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DRBD.up(hi.getHost(), "all", null, true);
                }
            }
        };
        this.addMouseOverListener(upAllItem, upAllItemCallback);
        MyMenuItem stopProxyItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.HostStopProxy"), null, Tools.getString("DrbdMultiSelectionInfo.HostStopProxy"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    if (!hi.getHost().isDrbdProxyRunning()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void action() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DRBD.stopProxy(hi.getHost(), false);
                }
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DrbdMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        items.add(stopProxyItem);
        MyMenuItem startProxyItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.HostStartProxy"), null, Tools.getString("DrbdMultiSelectionInfo.HostStartProxy"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    if (hi.getHost().isDrbdProxyRunning()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void action() {
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DRBD.startProxy(hi.getHost(), false);
                }
                for (HostDrbdInfo hi : selectedHostInfos) {
                    DrbdMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        items.add(startProxyItem);
        MyMenuItem changeHostColorItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.ChangeHostColor"), null, "", new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                Host firstHost = ((HostDrbdInfo)selectedHostInfos.get(0)).getHost();
                Color newColor = JColorChooser.showDialog(Tools.getGUIData().getMainFrame(), "Choose " + selectedHostInfos + " color", firstHost.getPmColors()[0]);
                for (HostDrbdInfo hi : selectedHostInfos) {
                    if (newColor == null) continue;
                    hi.getHost().setSavedColor(newColor);
                }
            }
        };
        items.add(changeHostColorItem);
    }

    private void createSelectedBlockDevPopup(final List<BlockDevInfo> selectedBlockDevInfos, List<UpdatableItem> items) {
        MyMenuItem detachMenu = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.Detach"), BlockDevInfo.NO_HARDDISK_ICON_LARGE, Tools.getString("DrbdMultiSelectionInfo.Detach"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                boolean oneAttached = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || bdi.isDiskless(false)) continue;
                    oneAttached = true;
                }
                return oneAttached;
            }

            @Override
            public String enablePredicate() {
                boolean detachable = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing()) continue;
                    detachable = true;
                }
                if (detachable) {
                    return null;
                }
                return "nothing do detach";
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() || bdi.isDiskless(false)) continue;
                    bdi.detach(false);
                }
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.DRBDMenuItemCallback detachItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, detachMenu, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() || bdi.isDiskless(false)) continue;
                    bdi.detach(true);
                }
            }
        };
        this.addMouseOverListener(detachMenu, detachItemCallback);
        items.add(detachMenu);
        MyMenuItem attachMenu = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.Attach"), BlockDevInfo.HARDDISK_DRBD_ICON_LARGE, Tools.getString("DrbdMultiSelectionInfo.Attach"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                boolean oneDetached = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.isDiskless(false)) continue;
                    oneDetached = true;
                }
                return oneDetached;
            }

            @Override
            public String enablePredicate() {
                boolean attachable = true;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing()) continue;
                    attachable = true;
                }
                if (attachable) {
                    return null;
                }
                return "nothing to attach";
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() || !bdi.isDiskless(false)) continue;
                    bdi.attach(false);
                }
            }
        };
        ClusterBrowser clusterBrowser2 = this.getBrowser();
        clusterBrowser2.getClass();
        ClusterBrowser.DRBDMenuItemCallback attachItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser2, attachMenu, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() || !bdi.isDiskless(false)) continue;
                    bdi.attach(true);
                }
            }
        };
        this.addMouseOverListener(attachMenu, attachItemCallback);
        items.add(attachMenu);
        MyMenuItem connectMenu = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.Connect"), null, Tools.getString("DrbdMultiSelectionInfo.Connect"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                boolean oneDisconnected = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || bdi.isConnectedOrWF(false)) continue;
                    oneDisconnected = true;
                }
                return oneDisconnected;
            }

            @Override
            public String enablePredicate() {
                boolean connectable = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.isConnectedOrWF(false)) continue;
                    connectable = true;
                }
                if (connectable) {
                    return null;
                }
                return "nothing to connect";
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.isConnectedOrWF(false)) continue;
                    bdi.connect(false);
                }
            }
        };
        ClusterBrowser clusterBrowser3 = this.getBrowser();
        clusterBrowser3.getClass();
        ClusterBrowser.DRBDMenuItemCallback connectItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser3, connectMenu, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host host) {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.isConnectedOrWF(false)) continue;
                    bdi.connect(true);
                }
            }
        };
        this.addMouseOverListener(connectMenu, connectItemCallback);
        items.add(connectMenu);
        MyMenuItem disconnectMenu = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.Disconnect"), null, Tools.getString("DrbdMultiSelectionInfo.Disconnect"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                boolean oneConnected = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.isConnectedOrWF(false)) continue;
                    oneConnected = true;
                }
                return oneConnected;
            }

            @Override
            public String enablePredicate() {
                boolean disconnectable = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() && (bdi.getBlockDevice().isPrimary() && bdi.getBlockDevice().isSyncTarget() || bdi.getOtherBlockDevInfo().getBlockDevice().isPrimary() && bdi.getBlockDevice().isSyncSource()) || !bdi.isConnectedOrWF(false)) continue;
                    disconnectable = true;
                }
                if (disconnectable) {
                    return null;
                }
                return "nothing to disconnect";
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.isConnectedOrWF(false) || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() && (!bdi.getBlockDevice().isPrimary() || !bdi.getBlockDevice().isSyncSource()) && (!bdi.getOtherBlockDevInfo().getBlockDevice().isPrimary() || !bdi.getBlockDevice().isSyncTarget())) continue;
                    bdi.disconnect(false);
                }
            }
        };
        ClusterBrowser clusterBrowser4 = this.getBrowser();
        clusterBrowser4.getClass();
        ClusterBrowser.DRBDMenuItemCallback disconnectItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser4, disconnectMenu, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host host) {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.isConnectedOrWF(false) || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() && (!bdi.getBlockDevice().isPrimary() || !bdi.getBlockDevice().isSyncSource()) && (!bdi.getOtherBlockDevInfo().getBlockDevice().isPrimary() || !bdi.getBlockDevice().isSyncTarget())) continue;
                    bdi.disconnect(true);
                }
            }
        };
        this.addMouseOverListener(disconnectMenu, disconnectItemCallback);
        items.add(disconnectMenu);
        MyMenuItem setPrimaryItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.SetPrimary"), null, Tools.getString("DrbdMultiSelectionInfo.SetPrimary"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean oneSecondary = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM()) continue;
                    BlockDevInfo oBdi = bdi.getOtherBlockDevInfo();
                    if (!bdi.getBlockDevice().isSecondary() || (oBdi.getBlockDevice().isPrimary() || selectedBlockDevInfos.contains(oBdi)) && !bdi.allowTwoPrimaries()) continue;
                    oneSecondary = true;
                }
                if (!oneSecondary) {
                    return "nothing to promote";
                }
                return null;
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    BlockDevInfo oBdi;
                    if (!bdi.getBlockDevice().isDrbd() || bdi.getBlockDevice().isPrimary() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || (oBdi = bdi.getOtherBlockDevInfo()) != null && oBdi.getBlockDevice().isPrimary() && !selectedBlockDevInfos.contains(oBdi) && !bdi.allowTwoPrimaries()) continue;
                    bdi.setPrimary(false);
                }
            }
        };
        items.add(setPrimaryItem);
        MyMenuItem setSecondaryItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.SetSecondary"), null, Tools.getString("DrbdMultiSelectionInfo.SetSecondary"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean onePrimary = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || !bdi.getBlockDevice().isPrimary()) continue;
                    onePrimary = true;
                }
                if (!onePrimary) {
                    return "nothing to demote";
                }
                return null;
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.getBlockDevice().isPrimary() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM()) continue;
                    bdi.setSecondary(false);
                }
            }
        };
        items.add(setSecondaryItem);
        MyMenuItem forcePrimaryItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.ForcePrimary"), null, Tools.getString("DrbdMultiSelectionInfo.ForcePrimary"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean oneSecondary = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM()) continue;
                    BlockDevInfo oBdi = bdi.getOtherBlockDevInfo();
                    if (!bdi.getBlockDevice().isSecondary() || (oBdi.getBlockDevice().isPrimary() || selectedBlockDevInfos.contains(oBdi)) && !bdi.allowTwoPrimaries()) continue;
                    oneSecondary = true;
                }
                if (!oneSecondary) {
                    return "nothing to promote";
                }
                return null;
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    BlockDevInfo oBdi;
                    if (!bdi.getBlockDevice().isDrbd() || bdi.getBlockDevice().isPrimary() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || (oBdi = bdi.getOtherBlockDevInfo()) != null && oBdi.getBlockDevice().isPrimary() && !selectedBlockDevInfos.contains(oBdi) && !bdi.allowTwoPrimaries()) continue;
                    bdi.forcePrimary(false);
                }
            }
        };
        items.add(forcePrimaryItem);
        MyMenuItem invalidateItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.Invalidate"), null, Tools.getString("DrbdMultiSelectionInfo.Invalidate"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean canInvalidate = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() || bdi.getDrbdVolumeInfo().isVerifying() || selectedBlockDevInfos.contains(bdi.getOtherBlockDevInfo())) continue;
                    canInvalidate = true;
                }
                if (canInvalidate) {
                    return null;
                }
                return "nothing to invalidate";
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || bdi.getBlockDevice().isSyncing() || bdi.getDrbdVolumeInfo().isVerifying() || selectedBlockDevInfos.contains(bdi.getOtherBlockDevInfo()) || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM()) continue;
                    bdi.invalidateBD(false);
                }
            }
        };
        items.add(invalidateItem);
        MyMenuItem resumeSyncItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.ResumeSync"), null, Tools.getString("DrbdMultiSelectionInfo.ResumeSync"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean resumable = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.getBlockDevice().isSyncing() || bdi.getBlockDevice().isSyncTarget() || bdi.getBlockDevice().isSyncSource()) continue;
                    resumable = true;
                }
                if (!resumable) {
                    return "nothing to resume";
                }
                return null;
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.getBlockDevice().isSyncing() || bdi.getBlockDevice().isSyncTarget() || bdi.getBlockDevice().isSyncSource()) continue;
                    bdi.resumeSync(false);
                }
            }
        };
        items.add(resumeSyncItem);
        MyMenuItem pauseSyncItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.PauseSync"), null, Tools.getString("DrbdMultiSelectionInfo.PauseSync"), new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean pausable = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.getBlockDevice().isSyncTarget() && !bdi.getBlockDevice().isSyncSource()) continue;
                    pausable = true;
                }
                if (!pausable) {
                    return "nothing to pause";
                }
                return null;
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !bdi.getBlockDevice().isSyncTarget() && !bdi.getBlockDevice().isSyncSource()) continue;
                    bdi.pauseSync(false);
                }
            }
        };
        items.add(pauseSyncItem);
        MyMenuItem resizeItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.Resize"), null, Tools.getString("DrbdMultiSelectionInfo.Resize"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean resizable = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || bdi.getBlockDevice().isSyncing() || selectedBlockDevInfos.contains(bdi.getOtherBlockDevInfo())) continue;
                    resizable = true;
                }
                if (resizable) {
                    return null;
                }
                return "nothing to resize";
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || selectedBlockDevInfos.contains(bdi.getOtherBlockDevInfo()) || bdi.getBlockDevice().isSyncing()) continue;
                    bdi.resizeDrbd(false);
                }
            }
        };
        items.add(resizeItem);
        MyMenuItem discardDataItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.DiscardData"), null, Tools.getString("DrbdMultiSelectionInfo.DiscardData"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                boolean discardable = false;
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() || bdi.getBlockDevice().isPrimary() || selectedBlockDevInfos.contains(bdi.getOtherBlockDevInfo())) continue;
                    discardable = true;
                }
                if (discardable) {
                    return null;
                }
                return "nothing to discard";
            }

            @Override
            public void action() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd() || selectedBlockDevInfos.contains(bdi.getOtherBlockDevInfo()) || !Tools.getConfigData().isAdvancedMode() && bdi.getDrbdVolumeInfo().isUsedByCRM() || bdi.getBlockDevice().isSyncing() || bdi.getBlockDevice().isPrimary()) continue;
                    bdi.discardData(false);
                }
            }
        };
        items.add(discardDataItem);
        MyMenuItem proxyDownItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.ProxyDown"), null, Tools.getString("DrbdMultiSelectionInfo.ProxyDown"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    DrbdResourceInfo dri = bdi.getDrbdVolumeInfo().getDrbdResourceInfo();
                    Host pHost = dri.getProxyHost(bdi.getHost(), false);
                    if (pHost == null) {
                        return false;
                    }
                    if (!pHost.isDrbdProxyUp(dri.getName())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    DrbdResourceInfo dri = bdi.getDrbdVolumeInfo().getDrbdResourceInfo();
                    Host pHost = dri.getProxyHost(bdi.getHost(), false);
                    if (pHost == null) {
                        return "";
                    }
                    if (pHost.isConnected()) continue;
                    return "not connected to the proxy host";
                }
                return null;
            }

            @Override
            public void action() {
                HashSet<Host> hosts = new HashSet<Host>();
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    DrbdResourceInfo dri;
                    Host pHost;
                    if (!bdi.getBlockDevice().isDrbd() || !(pHost = (dri = bdi.getDrbdVolumeInfo().getDrbdResourceInfo()).getProxyHost(bdi.getHost(), false)).isDrbdProxyUp(dri.getName())) continue;
                    DRBD.proxyDown(pHost, dri.getName(), bdi.getDrbdVolumeInfo().getName(), false);
                    hosts.add(pHost);
                }
                for (Host h : hosts) {
                    DrbdMultiSelectionInfo.this.getBrowser().updateProxyHWInfo(h);
                }
            }
        };
        items.add(proxyDownItem);
        MyMenuItem proxyUpItem = new MyMenuItem(Tools.getString("DrbdMultiSelectionInfo.ProxyUp"), null, Tools.getString("DrbdMultiSelectionInfo.ProxyUp"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    DrbdResourceInfo dri = bdi.getDrbdVolumeInfo().getDrbdResourceInfo();
                    Host pHost = dri.getProxyHost(bdi.getHost(), false);
                    if (pHost == null) {
                        return false;
                    }
                    if (pHost.isDrbdProxyUp(dri.getName())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    if (!bdi.getBlockDevice().isDrbd()) continue;
                    DrbdResourceInfo dri = bdi.getDrbdVolumeInfo().getDrbdResourceInfo();
                    Host pHost = dri.getProxyHost(bdi.getHost(), false);
                    if (pHost == null) {
                        return "";
                    }
                    if (pHost.isConnected()) continue;
                    return "not connected to the proxy host";
                }
                return null;
            }

            @Override
            public void action() {
                HashSet<Host> hosts = new HashSet<Host>();
                for (BlockDevInfo bdi : selectedBlockDevInfos) {
                    DrbdResourceInfo dri;
                    Host pHost;
                    if (!bdi.getBlockDevice().isDrbd() || (pHost = (dri = bdi.getDrbdVolumeInfo().getDrbdResourceInfo()).getProxyHost(bdi.getHost(), false)).isDrbdProxyUp(dri.getName())) continue;
                    DRBD.proxyUp(pHost, dri.getName(), bdi.getDrbdVolumeInfo().getName(), false);
                    hosts.add(pHost);
                }
                for (Host h : hosts) {
                    DrbdMultiSelectionInfo.this.getBrowser().updateProxyHWInfo(h);
                }
            }
        };
        items.add(proxyUpItem);
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        ArrayList<BlockDevInfo> selectedBlockDevInfos = new ArrayList<BlockDevInfo>();
        ArrayList<HostDrbdInfo> selectedHostInfos = new ArrayList<HostDrbdInfo>();
        for (Info i : this.selectedInfos) {
            if (i instanceof BlockDevInfo) {
                selectedBlockDevInfos.add((BlockDevInfo)i);
                continue;
            }
            if (!(i instanceof HostDrbdInfo)) continue;
            selectedHostInfos.add((HostDrbdInfo)i);
        }
        if (!selectedHostInfos.isEmpty()) {
            this.createSelectedHostsPopup(selectedHostInfos, items);
        }
        if (!selectedBlockDevInfos.isEmpty()) {
            this.createSelectedBlockDevPopup(selectedBlockDevInfos, items);
        }
        return items;
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    @Override
    public JPanel getGraphicalView() {
        return this.getBrowser().getDrbdGraph().getGraphPanel();
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return null;
    }

    @Override
    protected String getSection(String param) {
        return null;
    }

    @Override
    protected boolean isRequired(String param) {
        return false;
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return null;
    }

    @Override
    public String[] getParametersFromXML() {
        return null;
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        return null;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return true;
    }

    @Override
    public String getParamDefault(String param) {
        return null;
    }

    @Override
    protected String getParamPreferred(String param) {
        return null;
    }

    @Override
    protected String getParamShortDesc(String param) {
        return null;
    }

    @Override
    protected String getParamLongDesc(String param) {
        return null;
    }

    @Override
    public JComponent getInfoPanel() {
        boolean abExisted = this.getApplyButton() != null;
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                Host dcHost = DrbdMultiSelectionInfo.this.getBrowser().getDCHost();
                if (dcHost == null) {
                    return false;
                }
                return !Tools.versionBeforePacemaker(dcHost);
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                DrbdMultiSelectionInfo.this.getBrowser().getCRMGraph().stopTestAnimation(DrbdMultiSelectionInfo.this.getApplyButton());
                DrbdMultiSelectionInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                DrbdMultiSelectionInfo.this.getApplyButton().setToolTipText(ClusterBrowser.STARTING_PTEST_TOOLTIP);
                DrbdMultiSelectionInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                DrbdMultiSelectionInfo.this.getBrowser().getCRMGraph().startTestAnimation(DrbdMultiSelectionInfo.this.getApplyButton(), startTestLatch);
                Host dcHost = DrbdMultiSelectionInfo.this.getBrowser().getDCHost();
                DrbdMultiSelectionInfo.this.getBrowser().ptestLockAcquire();
                ClusterStatus cs = DrbdMultiSelectionInfo.this.getBrowser().getClusterStatus();
                cs.setPtestData(null);
                DrbdMultiSelectionInfo.this.apply(dcHost, true);
                PtestData ptestData = new PtestData(CRM.getPtest(dcHost));
                DrbdMultiSelectionInfo.this.getApplyButton().setToolTipText(ptestData.getToolTip());
                cs.setPtestData(ptestData);
                DrbdMultiSelectionInfo.this.getBrowser().ptestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initApplyButton(buttonCallback);
        if (!abExisted) {
            this.getApplyButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DrbdMultiSelectionInfo.this.getBrowser().clStatusLock();
                            DrbdMultiSelectionInfo.this.apply(DrbdMultiSelectionInfo.this.getBrowser().getDCHost(), false);
                            DrbdMultiSelectionInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
            this.getRevertButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DrbdMultiSelectionInfo.this.getBrowser().clStatusLock();
                            DrbdMultiSelectionInfo.this.revert();
                            DrbdMultiSelectionInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        JMenuBar mb = new JMenuBar();
        mb.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        JToggleButton serviceMenu = this.getActionsButton();
        buttonPanel.add((Component)serviceMenu, "East");
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        final String[] params = this.getParametersFromXML();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrbdMultiSelectionInfo.this.setApplyButtons(null, params);
            }
        });
        mainPanel.add(optionsPanel);
        mainPanel.add(super.getInfoPanel());
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH + 4));
        newPanel.add(new JScrollPane(mainPanel));
        this.infoPanelDone();
        return newPanel;
    }

    void apply(Host dcHost, boolean testOnly) {
    }
}

