/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import lcmc.data.resources.NetInterface;
import lcmc.gui.Browser;
import lcmc.gui.HostBrowser;
import lcmc.gui.resources.Info;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public class NetInfo
extends Info {
    static final ImageIcon NET_I_ICON = Tools.createImageIcon(Tools.getDefault("HostBrowser.NetIntIcon"));
    static final ImageIcon NET_I_ICON_LARGE = Tools.createImageIcon(Tools.getDefault("HostBrowser.NetIntIconLarge"));
    public static final String IP_PLACEHOLDER = "--.--.--.--";

    public NetInfo(String name, NetInterface netInterface, Browser browser) {
        super(name, browser);
        this.setResource(netInterface);
    }

    @Override
    protected final HostBrowser getBrowser() {
        return (HostBrowser)super.getBrowser();
    }

    @Override
    public final void updateInfo(final JEditorPane ep) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SSH.SSHOutput ret = Tools.execCommand(NetInfo.this.getBrowser().getHost(), "/sbin/ip a l " + NetInfo.this.getName(), null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
                ep.setText(ret.getOutput());
            }
        };
        Thread thread = new Thread(runnable);
        thread.setPriority(1);
        thread.start();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.getName());
        String ip = this.getNetInterface().getIp();
        if (ip != null) {
            s.append(" (" + ip + ")");
        }
        return s.toString();
    }

    @Override
    public final ImageIcon getMenuIcon(boolean testOnly) {
        return NET_I_ICON;
    }

    @Override
    public final String getInternalValue() {
        NetInterface ni = this.getNetInterface();
        if (ni == null) {
            return IP_PLACEHOLDER;
        }
        return ni.getIp();
    }

    public final NetInterface getNetInterface() {
        return (NetInterface)this.getResource();
    }

    public boolean equals(Object value) {
        if (Tools.isStringClass(value)) {
            NetInterface ni = this.getNetInterface();
            if (value == null) {
                return false;
            }
            if (ni == null) {
                return false;
            }
            String ip = ni.getIp();
            if (ip == null) {
                return false;
            }
            return ip.equals(value.toString());
        }
        return this.toString().equals(value.toString());
    }

    public final boolean isLocalHost() {
        return "lo".equals(this.getName());
    }
}

