/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.PtestData;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.GroupInfo;
import lcmc.gui.resources.HostInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.Corosync;
import lcmc.utilities.Heartbeat;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Openais;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class PcmkMultiSelectionInfo
extends EditableInfo {
    private final List<Info> selectedInfos;

    public PcmkMultiSelectionInfo(List<Info> selectedInfos, Browser browser) {
        super("selection", browser);
        this.selectedInfos = selectedInfos;
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return null;
    }

    @Override
    protected String getInfoType() {
        return "text/html";
    }

    @Override
    public String getInfo() {
        StringBuilder s = new StringBuilder(80);
        s.append(Tools.getString("PcmkMultiSelectionInfo.Selection"));
        for (Info si : this.selectedInfos) {
            if (si != null) {
                s.append(si.toString());
            }
            s.append("<br />");
        }
        return s.toString();
    }

    private void createSelectedHostsPopup(final List<HostInfo> selectedHostInfos, List<UpdatableItem> items) {
        int size = selectedHostInfos.size();
        MyMenuItem standbyItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StandByOn"), HostInfo.HOST_STANDBY_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    if (hi.isStandby(false)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                if (!dcHost.isClStatus()) {
                    return "cluster status is not available (" + dcHost.getName() + ")";
                }
                return null;
            }

            @Override
            public void action() {
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (HostInfo hi : selectedHostInfos) {
                    if (hi.isStandby(false)) continue;
                    CRM.standByOn(dcHost, hi.getHost(), false);
                }
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback standbyItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, standbyItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (HostInfo hi : selectedHostInfos) {
                    if (hi.isStandby(false)) continue;
                    CRM.standByOn(dcHost, hi.getHost(), true);
                }
            }
        };
        this.addMouseOverListener(standbyItem, standbyItemCallback);
        items.add(standbyItem);
        MyMenuItem onlineItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StandByOff"), HostInfo.HOST_STANDBY_OFF_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    if (!hi.isStandby(false)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                if (!dcHost.isClStatus()) {
                    return "cluster status is not available (" + dcHost.getName() + ")";
                }
                return null;
            }

            @Override
            public void action() {
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (HostInfo hi : selectedHostInfos) {
                    if (!hi.isStandby(false)) continue;
                    CRM.standByOff(dcHost, hi.getHost(), false);
                }
            }
        };
        ClusterBrowser clusterBrowser2 = this.getBrowser();
        clusterBrowser2.getClass();
        ClusterBrowser.ClMenuItemCallback onlineItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser2, onlineItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (HostInfo hi : selectedHostInfos) {
                    if (!hi.isStandby(false)) continue;
                    CRM.standByOff(dcHost, hi.getHost(), true);
                }
            }
        };
        this.addMouseOverListener(onlineItem, onlineItemCallback);
        items.add(onlineItem);
        MyMenuItem stopCorosyncItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StopCorosync"), HostInfo.HOST_STOP_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("PcmkMultiSelectionInfo.StopOpenais"), HostInfo.HOST_STOP_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                HostInfo hi = (HostInfo)selectedHostInfos.get(0);
                return hi.getHost().isCsRunning() && !hi.getHost().isAisRunning();
            }

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    if (!hi.getHost().isCsRunning() && !hi.getHost().isAisRunning()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void action() {
                if (Tools.confirmDialog(Tools.getString("HostInfo.confirmCorosyncStop.Title"), Tools.getString("HostInfo.confirmCorosyncStop.Desc"), Tools.getString("HostInfo.confirmCorosyncStop.Yes"), Tools.getString("HostInfo.confirmCorosyncStop.No"))) {
                    for (HostInfo hi : selectedHostInfos) {
                        hi.getHost().setCommLayerStopping(true);
                    }
                    for (HostInfo hi : selectedHostInfos) {
                        Host host = hi.getHost();
                        if (!host.isPcmkStartedByCorosync() && host.isPcmkInit() && host.isPcmkRunning()) {
                            Corosync.stopCorosyncWithPcmk(host);
                            continue;
                        }
                        Corosync.stopCorosync(host);
                    }
                    for (HostInfo hi : selectedHostInfos) {
                        PcmkMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                    }
                }
            }
        };
        ClusterBrowser clusterBrowser3 = this.getBrowser();
        clusterBrowser3.getClass();
        ClusterBrowser.ClMenuItemCallback stopCorosyncItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser3, stopCorosyncItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dchost) {
                for (HostInfo hi : selectedHostInfos) {
                    if (hi.isStandby(false)) continue;
                    CRM.standByOn(dchost, hi.getHost(), true);
                }
            }
        };
        this.addMouseOverListener(stopCorosyncItem, stopCorosyncItemCallback);
        items.add(stopCorosyncItem);
        MyMenuItem stopHeartbeatItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StopHeartbeat"), HostInfo.HOST_STOP_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    if (!hi.getHost().isHeartbeatRunning()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void action() {
                if (Tools.confirmDialog(Tools.getString("HostInfo.confirmHeartbeatStop.Title"), Tools.getString("HostInfo.confirmHeartbeatStop.Desc"), Tools.getString("HostInfo.confirmHeartbeatStop.Yes"), Tools.getString("HostInfo.confirmHeartbeatStop.No"))) {
                    for (HostInfo hi : selectedHostInfos) {
                        hi.getHost().setCommLayerStopping(true);
                    }
                    for (HostInfo hi : selectedHostInfos) {
                        Host host = hi.getHost();
                        Heartbeat.stopHeartbeat(host);
                    }
                    for (HostInfo hi : selectedHostInfos) {
                        PcmkMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                    }
                }
            }
        };
        ClusterBrowser clusterBrowser4 = this.getBrowser();
        clusterBrowser4.getClass();
        ClusterBrowser.ClMenuItemCallback stopHeartbeatItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser4, stopHeartbeatItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (HostInfo hi : selectedHostInfos) {
                    if (hi.isStandby(false)) continue;
                    CRM.standByOn(dcHost, hi.getHost(), true);
                }
            }
        };
        this.addMouseOverListener(stopHeartbeatItem, stopHeartbeatItemCallback);
        items.add(stopHeartbeatItem);
        MyMenuItem startCorosyncItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StartCorosync"), HostInfo.HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    Host h = hi.getHost();
                    if (!h.isCorosync() || !h.isCsInit() || !h.isCsAisConf() || h.isCsRunning() || h.isAisRunning() || h.isHeartbeatRunning() || h.isHeartbeatRc()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    Host h = hi.getHost();
                    if (!h.isAisRc() || h.isCsRc()) continue;
                    return "Openais is in rc.d";
                }
                return null;
            }

            @Override
            public void action() {
                for (HostInfo hi : selectedHostInfos) {
                    hi.getHost().setCommLayerStarting(true);
                }
                for (HostInfo hi : selectedHostInfos) {
                    Host h = hi.getHost();
                    if (h.isPcmkRc()) {
                        Corosync.startCorosyncWithPcmk(h);
                        continue;
                    }
                    Corosync.startCorosync(h);
                }
                for (HostInfo hi : selectedHostInfos) {
                    PcmkMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        ClusterBrowser clusterBrowser5 = this.getBrowser();
        clusterBrowser5.getClass();
        ClusterBrowser.ClMenuItemCallback startCorosyncItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser5, startCorosyncItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
            }
        };
        this.addMouseOverListener(startCorosyncItem, startCorosyncItemCallback);
        items.add(startCorosyncItem);
        MyMenuItem startOpenaisItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StartOpenais"), HostInfo.HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    Host h = hi.getHost();
                    if (!h.isAisInit() || !h.isCsAisConf() || h.isCsRunning() || h.isAisRunning() || h.isHeartbeatRunning() || h.isHeartbeatRc()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    Host h = hi.getHost();
                    if (!h.isCsRc() || h.isAisRc()) continue;
                    return "Corosync is in rc.d";
                }
                return null;
            }

            @Override
            public void action() {
                for (HostInfo hi : selectedHostInfos) {
                    hi.getHost().setCommLayerStarting(true);
                    Openais.startOpenais(hi.getHost());
                }
                for (HostInfo hi : selectedHostInfos) {
                    PcmkMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        ClusterBrowser clusterBrowser6 = this.getBrowser();
        clusterBrowser6.getClass();
        ClusterBrowser.ClMenuItemCallback startOpenaisItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser6, startOpenaisItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host host) {
            }
        };
        this.addMouseOverListener(startOpenaisItem, startOpenaisItemCallback);
        items.add(startOpenaisItem);
        MyMenuItem startHeartbeatItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StartHeartbeat"), HostInfo.HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    Host h = hi.getHost();
                    if (!h.isHeartbeatInit() || !h.isHeartbeatConf() || h.isCsRunning() || h.isAisRunning() || h.isHeartbeatRunning()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void action() {
                for (HostInfo hi : selectedHostInfos) {
                    hi.getHost().setCommLayerStarting(true);
                }
                for (HostInfo hi : selectedHostInfos) {
                    Heartbeat.startHeartbeat(hi.getHost());
                }
                for (HostInfo hi : selectedHostInfos) {
                    PcmkMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        ClusterBrowser clusterBrowser7 = this.getBrowser();
        clusterBrowser7.getClass();
        ClusterBrowser.ClMenuItemCallback startHeartbeatItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser7, startHeartbeatItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host host) {
            }
        };
        this.addMouseOverListener(startHeartbeatItem, startHeartbeatItemCallback);
        items.add(startHeartbeatItem);
        MyMenuItem startPcmkItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StartPacemaker"), HostInfo.HOST_START_COMM_LAYER_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (HostInfo hi : selectedHostInfos) {
                    Host h = hi.getHost();
                    if (h.isPcmkStartedByCorosync() || h.isPcmkRunning() || !h.isCsRunning() && !h.isAisRunning() || h.isHeartbeatRunning()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                for (HostInfo hi : selectedHostInfos) {
                    Corosync.startPacemaker(hi.getHost());
                }
                for (HostInfo hi : selectedHostInfos) {
                    PcmkMultiSelectionInfo.this.getBrowser().updateHWInfo(hi.getHost());
                }
            }
        };
        ClusterBrowser clusterBrowser8 = this.getBrowser();
        clusterBrowser8.getClass();
        ClusterBrowser.ClMenuItemCallback startPcmkItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser8, startPcmkItem, this.getBrowser().getDCHost()){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host host) {
            }
        };
        this.addMouseOverListener(startPcmkItem, startPcmkItemCallback);
        items.add(startPcmkItem);
        MyMenuItem changeHostColorItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.ChangeHostColor"), null, "", new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                Host firstHost = ((HostInfo)selectedHostInfos.get(0)).getHost();
                Color newColor = JColorChooser.showDialog(Tools.getGUIData().getMainFrame(), "Choose " + selectedHostInfos + " color", firstHost.getPmColors()[0]);
                for (HostInfo hi : selectedHostInfos) {
                    if (newColor == null) continue;
                    hi.getHost().setSavedColor(newColor);
                }
            }
        };
        items.add(changeHostColorItem);
    }

    private void createSelectedServicesPopup(final List<ServiceInfo> selectedServiceInfos, List<UpdatableItem> items) {
        MyMenuItem startMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StartSelectedResources"), ServiceInfo.START_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return true;
            }

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                boolean allStarted = true;
                for (ServiceInfo si : selectedServiceInfos) {
                    String avail;
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    if (!si.isStarted(false)) {
                        allStarted = false;
                    }
                    if ((avail = si.getService().isAvailableWithText()) == null) continue;
                    return avail;
                }
                if (allStarted) {
                    return Tools.getString("ServiceInfo.AlreadyStarted");
                }
                return null;
            }

            @Override
            public void action() {
                PcmkMultiSelectionInfo.this.hidePopup();
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.startResource(dcHost, false);
                }
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback startItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, startMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.startResource(dcHost, true);
                }
            }
        };
        this.addMouseOverListener(startMenuItem, startItemCallback);
        items.add(startMenuItem);
        MyMenuItem stopMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.StopSelectedResources"), ServiceInfo.STOP_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return true;
            }

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                boolean allStopped = true;
                for (ServiceInfo si : selectedServiceInfos) {
                    String avail;
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    if (!si.isStopped(false)) {
                        allStopped = false;
                    }
                    if ((avail = si.getService().isAvailableWithText()) == null) continue;
                    return avail;
                }
                if (allStopped) {
                    return Tools.getString("ServiceInfo.AlreadyStopped");
                }
                return null;
            }

            @Override
            public void action() {
                PcmkMultiSelectionInfo.this.hidePopup();
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.stopResource(dcHost, false);
                }
            }
        };
        ClusterBrowser clusterBrowser2 = this.getBrowser();
        clusterBrowser2.getClass();
        ClusterBrowser.ClMenuItemCallback stopItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser2, stopMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.stopResource(dcHost, true);
                }
            }
        };
        this.addMouseOverListener(stopMenuItem, stopItemCallback);
        items.add(stopMenuItem);
        MyMenuItem cleanupMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.CleanUpFailedResource"), ServiceInfo.SERVICE_RUNNING_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("PcmkMultiSelectionInfo.CleanUpResource"), ServiceInfo.SERVICE_RUNNING_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (!si.getService().isAvailable() || !si.isOneFailed(false)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                boolean failCount = false;
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned() || !si.isOneFailedCount(false)) continue;
                    failCount = true;
                }
                if (!failCount) {
                    return "no fail count";
                }
                for (ServiceInfo si : selectedServiceInfos) {
                    String avail;
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned() || (avail = si.getService().isAvailableWithText()) == null) continue;
                    return avail;
                }
                return null;
            }

            @Override
            public void action() {
                PcmkMultiSelectionInfo.this.hidePopup();
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.cleanupResource(dcHost, false);
                }
            }
        };
        items.add(cleanupMenuItem);
        MyMenuItem manageMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.ManageResource"), ServiceInfo.MANAGE_BY_CRM_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned() || si.isManaged(false)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                for (ServiceInfo si : selectedServiceInfos) {
                    String avail;
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned() || (avail = si.getService().isAvailableWithText()) == null) continue;
                    return avail;
                }
                return null;
            }

            @Override
            public void action() {
                PcmkMultiSelectionInfo.this.hidePopup();
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.setManaged(true, dcHost, false);
                }
            }
        };
        ClusterBrowser clusterBrowser3 = this.getBrowser();
        clusterBrowser3.getClass();
        ClusterBrowser.ClMenuItemCallback manageItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser3, manageMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.setManaged(true, dcHost, true);
                }
            }
        };
        this.addMouseOverListener(manageMenuItem, manageItemCallback);
        items.add(manageMenuItem);
        MyMenuItem unmanageMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.UnmanageResource"), ServiceInfo.UNMANAGE_BY_CRM_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned() || !si.isManaged(false)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                for (ServiceInfo si : selectedServiceInfos) {
                    String avail;
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned() || (avail = si.getService().isAvailableWithText()) == null) continue;
                    return avail;
                }
                return null;
            }

            @Override
            public void action() {
                PcmkMultiSelectionInfo.this.hidePopup();
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.setManaged(false, dcHost, false);
                }
            }
        };
        ClusterBrowser clusterBrowser4 = this.getBrowser();
        clusterBrowser4.getClass();
        ClusterBrowser.ClMenuItemCallback unmanageItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser4, unmanageMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.setManaged(false, dcHost, true);
                }
            }
        };
        this.addMouseOverListener(unmanageMenuItem, unmanageItemCallback);
        items.add(unmanageMenuItem);
        for (final Host host : this.getBrowser().getClusterHosts()) {
            final String hostName = host.getName();
            MyMenuItem migrateFromMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.MigrateFromResource") + " " + hostName, ServiceInfo.MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("PcmkMultiSelectionInfo.MigrateFromResource") + " " + hostName + " (offline)", ServiceInfo.MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean predicate() {
                    return host.isClStatus();
                }

                @Override
                public boolean visiblePredicate() {
                    return !host.isClStatus() || this.enablePredicate() == null;
                }

                @Override
                public String enablePredicate() {
                    for (ServiceInfo si : selectedServiceInfos) {
                        if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                        if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed() || !host.isClStatus()) {
                            return "not available on this host";
                        }
                        List<String> runningOnNodes = si.getRunningOnNodes(false);
                        if (runningOnNodes == null || runningOnNodes.size() < 1) {
                            return "must run";
                        }
                        boolean runningOnNode = false;
                        for (String ron : runningOnNodes) {
                            if (!hostName.toLowerCase(Locale.US).equals(ron.toLowerCase(Locale.US))) continue;
                            runningOnNode = true;
                            break;
                        }
                        if (si.getService().isAvailable() && runningOnNode) continue;
                        return "not available";
                    }
                    return null;
                }

                @Override
                public void action() {
                    PcmkMultiSelectionInfo.this.hidePopup();
                    Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                    for (ServiceInfo si : selectedServiceInfos) {
                        if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                        si.migrateFromResource(dcHost, hostName, false);
                    }
                }
            };
            ClusterBrowser clusterBrowser5 = this.getBrowser();
            clusterBrowser5.getClass();
            ClusterBrowser.ClMenuItemCallback migrateItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser5, migrateFromMenuItem, null){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    for (ServiceInfo si : selectedServiceInfos) {
                        if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                        si.migrateFromResource(dcHost, hostName, true);
                    }
                }
            };
            this.addMouseOverListener(migrateFromMenuItem, migrateItemCallback);
            items.add(migrateFromMenuItem);
        }
        MyMenuItem unmigrateMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.UnmigrateResource"), ServiceInfo.UNMIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return this.enablePredicate() == null;
            }

            @Override
            public String enablePredicate() {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned() || !PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed() && si.getService().isAvailable() && (si.getMigratedTo(false) != null || si.getMigratedFrom(false) != null)) continue;
                    return "not available";
                }
                return null;
            }

            @Override
            public void action() {
                PcmkMultiSelectionInfo.this.hidePopup();
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.unmigrateResource(dcHost, false);
                }
            }
        };
        ClusterBrowser clusterBrowser6 = this.getBrowser();
        clusterBrowser6.getClass();
        ClusterBrowser.ClMenuItemCallback unmigrateItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser6, unmigrateMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                for (ServiceInfo si : selectedServiceInfos) {
                    if (si.isConstraintPH() || si.getService().isNew() || si.getService().isOrphaned()) continue;
                    si.unmigrateResource(dcHost, true);
                }
            }
        };
        this.addMouseOverListener(unmigrateMenuItem, unmigrateItemCallback);
        items.add(unmigrateMenuItem);
        MyMenuItem removeMenuItem = new MyMenuItem(Tools.getString("PcmkMultiSelectionInfo.RemoveService"), ClusterBrowser.REMOVE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (PcmkMultiSelectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                ClusterStatus cs = PcmkMultiSelectionInfo.this.getBrowser().getClusterStatus();
                for (ServiceInfo si : selectedServiceInfos) {
                    List<String> gr;
                    if (si.getService().isNew()) continue;
                    if (si.getService().isRemoved()) {
                        return "it is being removed";
                    }
                    if (si.isRunning(false) && !Tools.getConfigData().isAdvancedMode()) {
                        return "cannot remove running resource<br>(advanced mode only)";
                    }
                    GroupInfo gi = si.getGroupInfo();
                    if (gi == null || (gr = cs.getGroupResources(gi.getHeartbeatId(false), false)) != null && gr.size() > 1) continue;
                    return "you can remove the group";
                }
                return null;
            }

            @Override
            public void action() {
                PcmkMultiSelectionInfo.this.hidePopup();
                if (!Tools.confirmDialog(Tools.getString("PcmkMultiSelectionInfo.confirmRemove.Title"), Tools.getString("PcmkMultiSelectionInfo.confirmRemove.Desc"), Tools.getString("PcmkMultiSelectionInfo.confirmRemove.Yes"), Tools.getString("PcmkMultiSelectionInfo.confirmRemove.No"))) {
                    return;
                }
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : selectedServiceInfos) {
                    ServiceInfo cs = si.getContainedService();
                    if (cs != null) {
                        si = cs;
                    }
                    if (si.getService().isOrphaned()) {
                        si.cleanupResource(dcHost, false);
                        continue;
                    }
                    si.removeMyselfNoConfirm(dcHost, false);
                }
                PcmkMultiSelectionInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        ClusterBrowser clusterBrowser7 = this.getBrowser();
        clusterBrowser7.getClass();
        ClusterBrowser.ClMenuItemCallback removeItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser7, removeMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public boolean isEnabled() {
                if (!super.isEnabled()) {
                    return false;
                }
                for (ServiceInfo si : selectedServiceInfos) {
                    if (!si.getService().isNew()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void action(Host dcHost) {
                for (ServiceInfo si : selectedServiceInfos) {
                    si.removeMyselfNoConfirm(dcHost, true);
                }
            }
        };
        this.addMouseOverListener(removeMenuItem, removeItemCallback);
        items.add(removeMenuItem);
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        ArrayList<ServiceInfo> selectedServiceInfos = new ArrayList<ServiceInfo>();
        ArrayList<HostInfo> selectedHostInfos = new ArrayList<HostInfo>();
        for (Info i : this.selectedInfos) {
            if (i instanceof ServiceInfo) {
                selectedServiceInfos.add((ServiceInfo)i);
                continue;
            }
            if (!(i instanceof HostInfo)) continue;
            selectedHostInfos.add((HostInfo)i);
        }
        if (!selectedHostInfos.isEmpty()) {
            this.createSelectedHostsPopup(selectedHostInfos, items);
        }
        if (!selectedServiceInfos.isEmpty()) {
            this.createSelectedServicesPopup(selectedServiceInfos, items);
        }
        return items;
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    @Override
    public JPanel getGraphicalView() {
        return this.getBrowser().getCRMGraph().getGraphPanel();
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return null;
    }

    @Override
    protected String getSection(String param) {
        return null;
    }

    @Override
    protected boolean isRequired(String param) {
        return false;
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return null;
    }

    @Override
    public String[] getParametersFromXML() {
        return null;
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        return null;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return true;
    }

    @Override
    public String getParamDefault(String param) {
        return null;
    }

    @Override
    protected String getParamPreferred(String param) {
        return null;
    }

    @Override
    protected String getParamShortDesc(String param) {
        return null;
    }

    @Override
    protected String getParamLongDesc(String param) {
        return null;
    }

    @Override
    public JComponent getInfoPanel() {
        boolean abExisted = this.getApplyButton() != null;
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                if (dcHost == null) {
                    return false;
                }
                return !Tools.versionBeforePacemaker(dcHost);
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                PcmkMultiSelectionInfo.this.getBrowser().getCRMGraph().stopTestAnimation(PcmkMultiSelectionInfo.this.getApplyButton());
                PcmkMultiSelectionInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                PcmkMultiSelectionInfo.this.getApplyButton().setToolTipText(ClusterBrowser.STARTING_PTEST_TOOLTIP);
                PcmkMultiSelectionInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                PcmkMultiSelectionInfo.this.getBrowser().getCRMGraph().startTestAnimation(PcmkMultiSelectionInfo.this.getApplyButton(), startTestLatch);
                Host dcHost = PcmkMultiSelectionInfo.this.getBrowser().getDCHost();
                PcmkMultiSelectionInfo.this.getBrowser().ptestLockAcquire();
                ClusterStatus cs = PcmkMultiSelectionInfo.this.getBrowser().getClusterStatus();
                cs.setPtestData(null);
                PcmkMultiSelectionInfo.this.apply(dcHost, true);
                PtestData ptestData = new PtestData(CRM.getPtest(dcHost));
                PcmkMultiSelectionInfo.this.getApplyButton().setToolTipText(ptestData.getToolTip());
                cs.setPtestData(ptestData);
                PcmkMultiSelectionInfo.this.getBrowser().ptestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initApplyButton(buttonCallback);
        if (!abExisted) {
            this.getApplyButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PcmkMultiSelectionInfo.this.getBrowser().clStatusLock();
                            PcmkMultiSelectionInfo.this.apply(PcmkMultiSelectionInfo.this.getBrowser().getDCHost(), false);
                            PcmkMultiSelectionInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
            this.getRevertButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PcmkMultiSelectionInfo.this.getBrowser().clStatusLock();
                            PcmkMultiSelectionInfo.this.revert();
                            PcmkMultiSelectionInfo.this.getBrowser().clStatusUnlock();
                        }
                    });
                    thread.start();
                }
            });
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        JMenuBar mb = new JMenuBar();
        mb.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        JToggleButton serviceMenu = this.getActionsButton();
        buttonPanel.add((Component)serviceMenu, "East");
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        final String[] params = this.getParametersFromXML();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PcmkMultiSelectionInfo.this.setApplyButtons(null, params);
            }
        });
        mainPanel.add(optionsPanel);
        mainPanel.add(super.getInfoPanel());
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH + 4));
        newPanel.add(new JScrollPane(mainPanel));
        this.infoPanelDone();
        return newPanel;
    }

    void apply(Host dcHost, boolean testOnly) {
    }
}

