/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.CRMXML;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.resources.ConstraintPHInfo;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.HbConstraintInterface;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.CRM;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

final class PcmkRscSetsInfo
extends HbConnectionInfo {
    private final Set<ConstraintPHInfo> constraintPHInfos = new LinkedHashSet<ConstraintPHInfo>();
    private final Lock mConstraintPHLock = new ReentrantLock();

    PcmkRscSetsInfo(Browser browser) {
        super(browser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PcmkRscSetsInfo(Browser browser, ConstraintPHInfo cphi) {
        this(browser);
        this.mConstraintPHLock.lock();
        try {
            this.constraintPHInfos.add(cphi);
        }
        finally {
            this.mConstraintPHLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addColocation(String colId, ConstraintPHInfo cphi) {
        this.mConstraintPHLock.lock();
        try {
            this.constraintPHInfos.add(cphi);
        }
        finally {
            this.mConstraintPHLock.unlock();
        }
        this.addColocation(colId, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOrder(String ordId, ConstraintPHInfo cphi) {
        this.mConstraintPHLock.lock();
        try {
            this.constraintPHInfos.add(cphi);
        }
        finally {
            this.mConstraintPHLock.unlock();
        }
        this.addOrder(ordId, null, null);
    }

    JComponent getInfoPanel(ConstraintPHInfo constraintPHInfo) {
        return super.getInfoPanel();
    }

    @Override
    protected JPanel getLabels(HbConstraintInterface c) {
        JPanel panel = this.getParamPanel(c.getName());
        panel.setLayout(new SpringLayout());
        boolean rows = true;
        int height = Tools.getDefaultSize("Browser.LabelFieldHeight");
        c.addLabelField(panel, Tools.getString("ClusterBrowser.HeartbeatId"), c.getService().getHeartbeatId(), ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, height);
        SpringUtilities.makeCompactGrid(panel, 1, 2, 1, 1, 1, 1);
        return panel;
    }

    public Map<CRMXML.RscSet, Map<String, String>> getAllAttributes(Host dcHost, CRMXML.RscSet appliedRscSet, Map<String, String> appliedAttrs, boolean isColocation, boolean testOnly) {
        LinkedHashMap<CRMXML.RscSet, Map<String, String>> rscSetsAttrs = new LinkedHashMap<CRMXML.RscSet, Map<String, String>>();
        List<ConstraintPHInfo> allCphis = this.getAllConstrainPHInfos();
        if (isColocation) {
            for (ConstraintPHInfo cphi : allCphis) {
                for (Boolean first : new Boolean[]{false, true}) {
                    cphi.getAttributes(isColocation, first, rscSetsAttrs);
                }
            }
        } else {
            for (int i = allCphis.size() - 1; i >= 0; --i) {
                for (Boolean first : new Boolean[]{true, false}) {
                    allCphis.get(i).getAttributes(isColocation, first, rscSetsAttrs);
                }
            }
        }
        rscSetsAttrs.put(appliedRscSet, appliedAttrs);
        return rscSetsAttrs;
    }

    private List<ConstraintPHInfo> getAllConstrainPHInfos() {
        Map<String, ServiceInfo> idToInfoHash = this.getBrowser().getNameToServiceInfoHash("Placeholder");
        ArrayList<ConstraintPHInfo> allCphis = new ArrayList<ConstraintPHInfo>();
        if (idToInfoHash != null) {
            for (String id : idToInfoHash.keySet()) {
                ConstraintPHInfo cphi = (ConstraintPHInfo)idToInfoHash.get(id);
                allCphis.add(cphi);
            }
        }
        return allCphis;
    }

    @Override
    void apply(Host dcHost, boolean testOnly) {
        super.apply(dcHost, testOnly);
        Map<String, ServiceInfo> idToInfoHash = this.getBrowser().getNameToServiceInfoHash("Placeholder");
        List<ConstraintPHInfo> allCphis = this.getAllConstrainPHInfos();
        this.mConstraintPHLock.lock();
        HashMap<ConstraintPHInfo, ConstraintPHInfo> parentToChild = new HashMap<ConstraintPHInfo, ConstraintPHInfo>();
        block0: for (ConstraintPHInfo cphi : this.constraintPHInfos) {
            Set<ServiceInfo> cphiParents = this.getBrowser().getCRMGraph().getParents(cphi);
            boolean startComparing = false;
            for (ConstraintPHInfo withCphi : allCphis) {
                Set<ServiceInfo> withCphiChildren;
                if (cphi == withCphi) {
                    startComparing = true;
                    continue;
                }
                if (!startComparing || !Tools.serviceInfoListEquals(cphiParents, withCphiChildren = this.getBrowser().getCRMGraph().getChildren(withCphi))) continue;
                parentToChild.put(cphi, withCphi);
                continue block0;
            }
        }
        ArrayList<CRMXML.RscSet> rscSetsCol = new ArrayList<CRMXML.RscSet>();
        ArrayList<CRMXML.RscSet> rscSetsOrd = new ArrayList<CRMXML.RscSet>();
        for (ConstraintPHInfo cphi : this.constraintPHInfos) {
            if (!cphi.getService().isNew()) continue;
            List<CRMXML.RscSet> sets = cphi.addConstraintWithPlaceholder(this.getBrowser().getCRMGraph().getChildrenAndParents(cphi), this.getBrowser().getCRMGraph().getParents(cphi), true, true, dcHost, false, testOnly);
            rscSetsCol.add(sets.get(0));
            rscSetsOrd.add(0, sets.get(3));
            ConstraintPHInfo parent = cphi;
            if (parentToChild.containsKey(parent)) {
                List<CRMXML.RscSet> childSets = null;
                while (parentToChild.containsKey(parent)) {
                    ConstraintPHInfo child = (ConstraintPHInfo)parentToChild.get(parent);
                    if (child.getService().isNew()) {
                        childSets = child.addConstraintWithPlaceholder(this.getBrowser().getCRMGraph().getChildrenAndParents(child), this.getBrowser().getCRMGraph().getParents(child), true, true, dcHost, false, testOnly);
                        rscSetsCol.add(childSets.get(0));
                        rscSetsOrd.add(0, childSets.get(3));
                    }
                    parent = child;
                }
                if (childSets == null) continue;
                rscSetsCol.add((CRMXML.RscSet)childSets.get(1));
                rscSetsOrd.add(0, (CRMXML.RscSet)childSets.get(2));
                continue;
            }
            rscSetsCol.add(sets.get(1));
            rscSetsOrd.add(0, sets.get(2));
        }
        this.mConstraintPHLock.unlock();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("score", "INFINITY");
        String colId = null;
        String ordId = null;
        LinkedHashMap<CRMXML.RscSet, Map<String, String>> rscSetsColAttrs = new LinkedHashMap<CRMXML.RscSet, Map<String, String>>();
        for (CRMXML.RscSet colSet : rscSetsCol) {
            if (colId == null && colSet != null) {
                colId = colSet.getId();
            }
            rscSetsColAttrs.put(colSet, null);
        }
        LinkedHashMap<CRMXML.RscSet, Map<String, String>> rscSetsOrdAttrs = new LinkedHashMap<CRMXML.RscSet, Map<String, String>>();
        for (CRMXML.RscSet ordSet : rscSetsOrd) {
            if (ordId == null && ordSet != null) {
                ordId = ordSet.getId();
            }
            rscSetsOrdAttrs.put(ordSet, null);
        }
        boolean createCol = true;
        boolean createOrd = true;
        CRM.setRscSet(dcHost, colId, true, ordId, true, rscSetsColAttrs, rscSetsOrdAttrs, attrs, testOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        boolean oneIsNew = false;
        this.mConstraintPHLock.lock();
        try {
            for (ConstraintPHInfo cphi : this.constraintPHInfos) {
                if (!cphi.getService().isNew() || this.getBrowser().getCRMGraph().getChildrenAndParents(cphi).isEmpty()) continue;
                oneIsNew = true;
            }
        }
        finally {
            this.mConstraintPHLock.unlock();
        }
        return super.checkResourceFieldsChanged(param, params) || oneIsNew;
    }

    @Override
    public List<UpdatableItem> createPopup() {
        List<UpdatableItem> items = super.createPopup();
        return items;
    }
}

