/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.NetInfo;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

public final class VMSInterfaceInfo
extends VMSHardwareInfo {
    private final Map<String, Widget> sourceNetworkWi = new HashMap<String, Widget>();
    private final Map<String, Widget> sourceBridgeWi = new HashMap<String, Widget>();
    private static final String[] PARAMETERS = new String[]{"type", "mac_address", "source_network", "source_bridge", "script_path", "target_dev", "model_type"};
    private static final String[] NETWORK_PARAMETERS = new String[]{"type", "mac_address", "source_network", "script_path", "target_dev", "model_type"};
    private static final String[] BRIDGE_PARAMETERS = new String[]{"type", "mac_address", "source_bridge", "script_path", "target_dev", "model_type"};
    private static final Map<String, Widget.Type> FIELD_TYPES = new HashMap<String, Widget.Type>();
    private static final Map<String, String> SHORTNAME_MAP = new HashMap<String, String>();
    private static final Set<String> IS_ENABLED_ONLY_IN_ADVANCED;
    private static final Set<String> IS_REQUIRED;
    private static final Map<String, String> PREFERRED_MAP;
    private static final Map<String, String> DEFAULTS_MAP;
    private static final Map<String, Object[]> POSSIBLE_VALUES;
    private JComponent tablePanel = null;

    VMSInterfaceInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
    }

    @Override
    protected void addHardwareTable(JPanel mainPanel) {
        this.tablePanel = this.getTablePanel("Interfaces", "interfaces", VMSInterfaceInfo.getNewBtn(this.getVMSVirtualDomainInfo()));
        if (this.getResource().isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VMSInterfaceInfo.this.tablePanel.setVisible(false);
                }
            });
        }
        mainPanel.add(this.tablePanel);
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return NetInfo.NET_I_ICON;
    }

    @Override
    protected String getParamLongDesc(String param) {
        return this.getParamShortDesc(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        String name = SHORTNAME_MAP.get(param);
        if (name == null) {
            return param;
        }
        return name;
    }

    @Override
    protected String getParamPreferred(String param) {
        return PREFERRED_MAP.get(param);
    }

    @Override
    protected String getParamDefault(String param) {
        return DEFAULTS_MAP.get(param);
    }

    @Override
    public String[] getParametersFromXML() {
        return (String[])PARAMETERS.clone();
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        block3: {
            block2: {
                if (!"source_network".equals(param)) break block2;
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null) continue;
                    List<String> networks = vmsxml.getNetworks();
                    networks.add(0, null);
                    return networks.toArray(new String[networks.size()]);
                }
                break block3;
            }
            if (!"source_bridge".equals(param)) break block3;
            for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                if (vmsxml == null) continue;
                List<String> bridges = h.getBridges();
                bridges.add(0, null);
                return bridges.toArray(new String[bridges.size()]);
            }
        }
        return POSSIBLE_VALUES.get(param);
    }

    @Override
    protected String getSection(String param) {
        return "Interface Options";
    }

    @Override
    protected boolean isRequired(String param) {
        String type = this.getComboBoxValue("type");
        if ("source_network".equals(param) && "network".equals(type) || "source_bridge".equals(param) && "bridge".equals(type)) {
            return true;
        }
        return IS_REQUIRED.contains(param);
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return "undef";
    }

    @Override
    protected String getParamRegexp(String param) {
        if ("mac_address".equals(param)) {
            return "^((([0-9a-fA-F]{2}:){5}[0-9a-fA-F]{2})|generate)?$";
        }
        return null;
    }

    @Override
    protected Widget.Type getFieldType(String param) {
        return FIELD_TYPES.get(param);
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSInterfaceInfo.this.getInfoPanel();
            }
        });
        String[] params = this.getRealParametersFromXML();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (!allParams && !"source_network".equals(param) && !"source_bridge".equals(param) && Tools.areEqual(this.getParamSaved(param), value)) continue;
            if (Tools.areEqual(this.getParamDefault(param), value)) {
                parameters.put(param, null);
                continue;
            }
            parameters.put(param, value);
        }
        this.setName(this.getParamSaved("mac_address"));
        return parameters;
    }

    @Override
    protected void modifyXML(VMSXML vmsxml, Node node, String domainName, Map<String, String> params) {
        if (vmsxml != null) {
            vmsxml.modifyInterfaceXML(node, domainName, params);
        }
    }

    @Override
    void apply(boolean testOnly) {
        if (testOnly) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSInterfaceInfo.this.getApplyButton().setEnabled(false);
                VMSInterfaceInfo.this.getRevertButton().setEnabled(false);
            }
        });
        this.getInfoPanel();
        this.waitForInfoPanel();
        Map<String, String> parameters = this.getHWParameters(this.getResource().isNew());
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml != null) {
                parameters.put("saved_mac_address", this.getName());
                String domainName = this.getVMSVirtualDomainInfo().getDomainName();
                Node domainNode = vmsxml.getDomainNode(domainName);
                this.modifyXML(vmsxml, domainNode, domainName, parameters);
                String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
                vmsxml.saveAndDefine(domainNode, domainName, virshOptions);
            }
            this.getResource().setNew(false);
        }
        this.getBrowser().reload(this.getNode(), false);
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSInterfaceInfo.this.tablePanel.setVisible(true);
            }
        });
        String[] params = this.getRealParametersFromXML();
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
        this.checkResourceFieldsChanged(null, params);
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if ("header".equals(tableName)) {
            return this.getVMSVirtualDomainInfo().getMainTableData();
        }
        if ("interfaces".equals(tableName)) {
            if (this.getResource().isNew()) {
                return new Object[0][];
            }
            return new Object[][]{this.getVMSVirtualDomainInfo().getInterfaceDataRow(this.getName(), null, this.getVMSVirtualDomainInfo().getInterfaces(), true)};
        }
        return new Object[0][];
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return IS_ENABLED_ONLY_IN_ADVANCED.contains(param);
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        if ("type".equals(param)) {
            for (String p : this.sourceNetworkWi.keySet()) {
                this.sourceNetworkWi.get(p).setVisible("network".equals(newValue));
            }
            for (String p : this.sourceBridgeWi.keySet()) {
                this.sourceBridgeWi.get(p).setVisible("bridge".equals(newValue));
            }
            this.checkOneParam("source_network");
            this.checkOneParam("source_bridge");
        }
        return !this.isRequired(param) || newValue != null && !"".equals(newValue);
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi = super.createWidget(param, prefix, width);
        if ("type".equals(param)) {
            paramWi.setAlwaysEditable(false);
        } else if ("source_network".equals(param)) {
            if (prefix == null) {
                this.sourceNetworkWi.put("", paramWi);
            } else {
                this.sourceNetworkWi.put(prefix, paramWi);
            }
            paramWi.setAlwaysEditable(false);
        } else if ("source_bridge".equals(param)) {
            if (prefix == null) {
                this.sourceBridgeWi.put("", paramWi);
            } else {
                this.sourceBridgeWi.put(prefix, paramWi);
            }
            paramWi.setAlwaysEditable(false);
        }
        return paramWi;
    }

    @Override
    void updateParameters() {
        VMSXML.InterfaceData interfaceData;
        Map<String, VMSXML.InterfaceData> interfaces = this.getVMSVirtualDomainInfo().getInterfaces();
        if (interfaces != null && (interfaceData = interfaces.get(this.getName())) != null) {
            for (String param : this.getParametersFromXML()) {
                String oldValue = this.getParamSaved(param);
                String value = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    String savedValue;
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null || (savedValue = interfaceData.getValue(param)) == null) continue;
                    value = savedValue;
                }
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.updateTable("header");
        this.updateTable("interfaces");
        this.checkResourceFieldsChanged(null, this.getParametersFromXML());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String source = "network".equals(this.getParamSaved("type")) ? this.getParamSaved("source_network") : this.getParamSaved("source_bridge");
        if (source == null) {
            s.append("new interface...");
        } else {
            s.append(source);
        }
        String saved = this.getParamSaved("mac_address");
        if (saved != null) {
            s.append(" (");
            if (saved.length() > 8) {
                s.append(saved.substring(8));
            } else {
                s.append(saved);
            }
            s.append(')');
        }
        return s.toString();
    }

    @Override
    protected void removeMyselfNoConfirm(boolean testOnly) {
        if (testOnly) {
            return;
        }
        String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("saved_mac_address", this.getName());
            vmsxml.removeInterfaceXML(this.getVMSVirtualDomainInfo().getDomainName(), parameters, virshOptions);
        }
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        this.removeNode();
    }

    @Override
    protected String isRemoveable() {
        return null;
    }

    static MyButton getNewBtn(final VMSVirtualDomainInfo vdi) {
        MyButton newBtn = new MyButton("Add Interface");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vdi.addInterfacePanel();
                    }
                });
                t.start();
            }
        });
        return newBtn;
    }

    @Override
    public String[] getRealParametersFromXML() {
        if ("network".equals(this.getComboBoxValue("type"))) {
            return (String[])NETWORK_PARAMETERS.clone();
        }
        return (String[])BRIDGE_PARAMETERS.clone();
    }

    static {
        FIELD_TYPES.put("type", Widget.Type.RADIOGROUP);
        SHORTNAME_MAP.put("type", "Type");
        SHORTNAME_MAP.put("mac_address", "Mac Address");
        SHORTNAME_MAP.put("source_network", "Source Network");
        SHORTNAME_MAP.put("source_bridge", "Source Bridge");
        SHORTNAME_MAP.put("script_path", "Script Path");
        SHORTNAME_MAP.put("target_dev", "Target Device");
        SHORTNAME_MAP.put("model_type", "Model Type");
        IS_ENABLED_ONLY_IN_ADVANCED = new HashSet<String>(Arrays.asList("mac_address", "target_dev", "model_type"));
        IS_REQUIRED = new HashSet<String>(Arrays.asList("type"));
        PREFERRED_MAP = new HashMap<String, String>();
        DEFAULTS_MAP = new HashMap<String, String>();
        POSSIBLE_VALUES = new HashMap<String, Object[]>();
        DEFAULTS_MAP.put("mac_address", "generate");
        PREFERRED_MAP.put("source_network", "default");
        POSSIBLE_VALUES.put("model_type", new String[]{null, "default", "e1000", "ne2k_pci", "pcnet", "rtl8139", "virtio"});
        POSSIBLE_VALUES.put("type", new String[]{"network", "bridge"});
        POSSIBLE_VALUES.put("script_path", new String[]{null, "/etc/xen/scripts/vif-bridge"});
    }
}

