/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.ResourceAgent;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

final class VirtualDomainInfo
extends ServiceInfo {
    private VMSVirtualDomainInfo vmsVirtualDomainInfo = null;
    static final Pattern LIBVIRT_CONF_PATTERN = Pattern.compile(".*?([^/]+).xml$");
    private static final String CONFIG_PARAM = "config";
    private static final String HYPERVISOR_PARAM = "hypervisor";
    private static final String[] HYPERVISORS = new String[]{"qemu:///system", "xen:///", "lxc:///", "vbox:///", "openvz:///system", "uml:///system"};
    private static final String PARAM_ALLOW_MIGRATE = "allow-migrate";

    VirtualDomainInfo(String name, ResourceAgent ra, Browser browser) {
        super(name, ra, browser);
    }

    VirtualDomainInfo(String name, ResourceAgent ra, String hbId, Map<String, String> resourceNode, Browser browser) {
        super(name, ra, hbId, resourceNode, browser);
    }

    private Host getRunningOnHost() {
        List<String> nodes = this.getRunningOnNodes(false);
        if (nodes != null && !nodes.isEmpty()) {
            Host host = this.getBrowser().getCluster().getHostByName(nodes.get(0));
            return host;
        }
        return null;
    }

    VMSXML getVMSXML(Host host) {
        return this.getBrowser().getVMSXML(host);
    }

    @Override
    protected void removeMyselfNoConfirm(Host dcHost, boolean testOnly) {
        super.removeMyselfNoConfirm(dcHost, testOnly);
    }

    @Override
    void setParameters(Map<String, String> resourceNode) {
        super.setParameters(resourceNode);
        this.connectWithVMS();
    }

    @Override
    public VMSVirtualDomainInfo connectWithVMS() {
        String config = this.getParamSaved(CONFIG_PARAM);
        VMSVirtualDomainInfo newVMSVDI = null;
        for (Host host : this.getBrowser().getClusterHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            String name = vxml.getNameFromConfig(config);
            newVMSVDI = this.getBrowser().findVMSVirtualDomainInfo(name);
            if (newVMSVDI == null) continue;
            newVMSVDI.setUsedByCRM(true);
            break;
        }
        this.vmsVirtualDomainInfo = newVMSVDI;
        return newVMSVDI;
    }

    void addVncViewersToTheMenu(List<UpdatableItem> items) {
        boolean testOnly = false;
        if (Tools.getConfigData().isTightvnc()) {
            MyMenuItem tightvncViewerMenu = new MyMenuItem("start TIGHT VNC viewer", null, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public String enablePredicate() {
                    VMSXML vxml = VirtualDomainInfo.this.getVMSXML(VirtualDomainInfo.this.getRunningOnHost());
                    if (vxml == null || VirtualDomainInfo.this.vmsVirtualDomainInfo == null) {
                        return "VM is not available";
                    }
                    int remotePort = vxml.getRemotePort(VirtualDomainInfo.this.vmsVirtualDomainInfo.getName());
                    if (remotePort <= 0) {
                        return "remote port is not greater than 0";
                    }
                    return null;
                }

                @Override
                public void action() {
                    VirtualDomainInfo.this.hidePopup();
                    VMSVirtualDomainInfo vvdi = VirtualDomainInfo.this.vmsVirtualDomainInfo;
                    VMSXML vxml = VirtualDomainInfo.this.getVMSXML(VirtualDomainInfo.this.getRunningOnHost());
                    if (vxml != null && vvdi != null) {
                        int remotePort = vxml.getRemotePort(vvdi.getName());
                        Host host = vxml.getHost();
                        if (host != null && remotePort > 0) {
                            Tools.startTightVncViewer(host, remotePort);
                        }
                    }
                }
            };
            items.add(tightvncViewerMenu);
        }
        if (Tools.getConfigData().isUltravnc()) {
            MyMenuItem ultravncViewerMenu = new MyMenuItem("start ULTRA VNC viewer", null, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public String enablePredicate() {
                    VMSXML vxml = VirtualDomainInfo.this.getVMSXML(VirtualDomainInfo.this.getRunningOnHost());
                    if (vxml == null || VirtualDomainInfo.this.vmsVirtualDomainInfo == null) {
                        return "VM is not available";
                    }
                    int remotePort = vxml.getRemotePort(VirtualDomainInfo.this.vmsVirtualDomainInfo.getName());
                    if (remotePort <= 0) {
                        return "remote port is not greater than 0";
                    }
                    return null;
                }

                @Override
                public void action() {
                    VirtualDomainInfo.this.hidePopup();
                    VMSVirtualDomainInfo vvdi = VirtualDomainInfo.this.vmsVirtualDomainInfo;
                    VMSXML vxml = VirtualDomainInfo.this.getVMSXML(VirtualDomainInfo.this.getRunningOnHost());
                    if (vxml != null && vvdi != null) {
                        int remotePort = vxml.getRemotePort(vvdi.getName());
                        Host host = vxml.getHost();
                        if (host != null && remotePort > 0) {
                            Tools.startUltraVncViewer(host, remotePort);
                        }
                    }
                }
            };
            items.add(ultravncViewerMenu);
        }
        if (Tools.getConfigData().isRealvnc()) {
            MyMenuItem realvncViewerMenu = new MyMenuItem("start REAL VNC test", null, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public String enablePredicate() {
                    VMSXML vxml = VirtualDomainInfo.this.getVMSXML(VirtualDomainInfo.this.getRunningOnHost());
                    if (vxml == null || VirtualDomainInfo.this.vmsVirtualDomainInfo == null) {
                        return "VM is not available";
                    }
                    int remotePort = vxml.getRemotePort(VirtualDomainInfo.this.vmsVirtualDomainInfo.getName());
                    if (remotePort <= 0) {
                        return "remote port is not greater than 0";
                    }
                    return null;
                }

                @Override
                public void action() {
                    VirtualDomainInfo.this.hidePopup();
                    VMSVirtualDomainInfo vvdi = VirtualDomainInfo.this.vmsVirtualDomainInfo;
                    VMSXML vxml = VirtualDomainInfo.this.getVMSXML(VirtualDomainInfo.this.getRunningOnHost());
                    if (vxml != null && vvdi != null) {
                        int remotePort = vxml.getRemotePort(vvdi.getName());
                        Host host = vxml.getHost();
                        if (host != null && remotePort > 0) {
                            Tools.startRealVncViewer(host, remotePort);
                        }
                    }
                }
            };
            items.add(realvncViewerMenu);
        }
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if (CONFIG_PARAM.equals(param)) {
            TreeSet<String> configs = new TreeSet<String>();
            for (Host host : this.getBrowser().getClusterHosts()) {
                VMSXML vxml = this.getBrowser().getVMSXML(host);
                if (vxml == null) continue;
                configs.addAll(vxml.getConfigs());
            }
            return configs.toArray(new String[configs.size()]);
        }
        if (HYPERVISOR_PARAM.equals(param)) {
            return HYPERVISORS;
        }
        return super.getParamPossibleChoices(param);
    }

    @Override
    public List<UpdatableItem> createPopup() {
        List<UpdatableItem> items = super.createPopup();
        this.addVncViewersToTheMenu(items);
        return items;
    }

    @Override
    public String toString() {
        Matcher m;
        StringBuilder s = new StringBuilder(30);
        s.append(this.getName());
        String id = this.getService().getId();
        String configName = this.getParamSaved(CONFIG_PARAM);
        String string = configName == null ? id : ((m = LIBVIRT_CONF_PATTERN.matcher(configName)).matches() ? m.group(1) : id);
        if (string == null) {
            s.insert(0, "new ");
        } else if (!"".equals(string)) {
            s.append(" (");
            s.append(string);
            s.append(')');
        }
        return s.toString();
    }

    @Override
    void apply(Host dcHost, boolean testOnly) {
        super.apply(dcHost, testOnly);
    }

    @Override
    protected boolean isAdvanced(String param) {
        if (PARAM_ALLOW_MIGRATE.equals(param)) {
            return false;
        }
        return super.isAdvanced(param);
    }
}

