/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.utilities.MyList;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public class MyMenu
extends JMenu
implements UpdatableItem {
    private static final long serialVersionUID = 1L;
    private Point2D pos = null;
    private final AccessMode enableAccessMode;
    private final AccessMode visibleAccessMode;

    public MyMenu(String text, AccessMode enableAccessMode, AccessMode visibleAccessMode) {
        super(text);
        this.enableAccessMode = enableAccessMode;
        this.visibleAccessMode = visibleAccessMode;
        this.setOpaque(false);
        this.setEnabled(false);
    }

    @Override
    public final void setPos(Point2D pos) {
        this.pos = pos;
    }

    protected final Point2D getPos() {
        return this.pos;
    }

    boolean predicate() {
        return true;
    }

    public String enablePredicate() {
        return null;
    }

    boolean visiblePredicate() {
        return true;
    }

    @Override
    public void update() {
        this.processAccessMode();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                final ArrayList copy = new ArrayList();
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (Component m : MyMenu.this.getMenuComponents()) {
                            copy.add(m);
                        }
                    }
                });
                for (Component m : copy) {
                    if (!(m instanceof UpdatableItem)) continue;
                    ((UpdatableItem)((Object)m)).update();
                }
            }
        });
        t.start();
    }

    private void processAccessMode() {
        final boolean accessible = Tools.getConfigData().isAccessible(this.enableAccessMode);
        final String disableTooltip = this.enablePredicate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyMenu.this.setEnabled(disableTooltip == null && accessible);
            }
        });
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!accessible && MyMenu.this.enableAccessMode.getAccessType() != ConfigData.AccessType.NEVER) {
                        String advanced = "";
                        if (MyMenu.this.enableAccessMode.isAdvancedMode()) {
                            advanced = "Advanced ";
                        }
                        MyMenu.this.setToolTipText("<html><b>" + MyMenu.this.getText() + " (disabled)</b><br>available in \"" + advanced + ConfigData.OP_MODES_MAP.get((Object)MyMenu.this.enableAccessMode.getAccessType()) + "\" mode</html>");
                    } else if (disableTooltip != null) {
                        MyMenu.this.setToolTipText("<html><b>" + MyMenu.this.getText() + " (disabled)</b><br>" + disableTooltip + "</html>");
                    }
                }
            });
        }
    }

    @Override
    public final void cleanup() {
        for (Component m : this.getMenuComponents()) {
            if (m instanceof UpdatableItem) {
                ((UpdatableItem)((Object)m)).cleanup();
                continue;
            }
            if (!(m instanceof JScrollPane)) continue;
            ((MyList)((JScrollPane)m).getViewport().getView()).cleanup();
        }
    }

    @Override
    public final void removeAll() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem item = this.getItem(i);
            if (item instanceof MyMenuItem) {
                ((MyMenuItem)item).cleanup();
                continue;
            }
            if (!(item instanceof MyMenu)) continue;
            ((MyMenu)item).removeAll();
        }
        super.removeAll();
    }
}

