/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.MemoryImageSource;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.html.HTMLDocument;
import lcmc.Exceptions;
import lcmc.data.Cluster;
import lcmc.data.Clusters;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.HostOptions;
import lcmc.data.UserConfig;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.GUIData;
import lcmc.gui.dialog.ConfirmDialog;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.ComboInfo;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyList;
import lcmc.utilities.MyListModel;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.SSH;
import lcmc.utilities.Unit;
import tightvnc.VncViewer;
import vncviewer.VNCViewer;

public final class Tools {
    private static Tools instance = null;
    private static String release = null;
    private static int debugLevel = -1;
    private static boolean appWarning;
    private static boolean appError;
    private static Set<String> appWarningHash;
    private static Set<String> appErrorHash;
    private static Map<String, ImageIcon> imageIcons;
    private static ResourceBundle resource;
    private static ResourceBundle resourceAppDefaults;
    private static ConfigData configData;
    private static GUIData guiData;
    private static UserConfig userConfig;
    private static final String ERROR_STRING = "ERROR: ";
    private static final String INFO_STRING = "INFO: ";
    private static final String DEBUG_STRING = "DEBUG: ";
    private static final String APPWARNING_STRING = "APPWARNING: ";
    private static final String APPERROR_STRING = "APPERROR: ";
    private static final int DIALOG_PANEL_WIDTH = 400;
    private static final int DIALOG_PANEL_HEIGHT = 300;
    private static final Dimension DIALOG_PANEL_SIZE;
    private static volatile int prevScrollingMenuIndex;
    public static final String MIME_TYPE_TEXT_HTML = "text/html";
    public static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    private static final Pattern UNIT_PATTERN;
    private static final Random RANDOM;
    private static final long START_TIME;

    private Tools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tools getInstance() {
        Class<Tools> clazz = Tools.class;
        synchronized (Tools.class) {
            if (instance == null) {
                instance = new Tools();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void init() {
        Tools.setDefaults();
        configData = new ConfigData();
        guiData = new GUIData();
    }

    private static long seconds() {
        return System.currentTimeMillis() / 1000L - START_TIME;
    }

    public static ImageIcon createImageIcon(String imageFilename) {
        ImageIcon imageIcon = imageIcons.get(imageFilename);
        if (imageIcon != null) {
            return imageIcon;
        }
        URL imgURL = Tools.class.getResource("/images/" + imageFilename);
        if (imgURL == null) {
            Tools.appWarning("Couldn't find image: " + imageFilename);
            return null;
        }
        ImageIcon newIcon = new ImageIcon(imgURL);
        imageIcons.put(imageFilename, newIcon);
        return newIcon;
    }

    public static String getRelease() {
        if (release != null) {
            return release;
        }
        Properties p = new Properties();
        try {
            p.load(Tools.class.getResourceAsStream("/release.properties"));
            release = p.getProperty("release");
            return release;
        }
        catch (IOException e) {
            Tools.appError("cannot open release file", "", e);
            return "unknown";
        }
    }

    public static void info(String msg) {
        System.out.println(INFO_STRING + msg);
    }

    public static void setDefaults() {
        debugLevel = Tools.getDefaultInt("DebugLevel");
        if (Tools.getDefault("AppWarning").equals("y")) {
            appWarning = true;
        }
        if (Tools.getDefault("AppError").equals("y")) {
            appError = true;
        }
    }

    public static void incrementDebugLevel() {
        Tools.info("debug level: " + ++debugLevel);
    }

    public static void decrementDebugLevel() {
        Tools.info("debug level: " + --debugLevel);
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    private static void debug(String msg) {
        if (debugLevel > 0) {
            System.out.println("DEBUG: [" + Tools.seconds() + "s] " + msg + " (lcmc.utilities.Tools)");
        }
    }

    private static void debug(String msg, int level) {
        if (level <= debugLevel) {
            System.out.println("DEBUG: (" + level + ") " + "[" + Tools.seconds() + "s] " + msg + " (lcmc.utilities.Tools)");
        }
    }

    public static void debug(Object object, String msg) {
        if (debugLevel > -1) {
            if (object == null) {
                System.out.println("DEBUG: [" + Tools.seconds() + "s] " + msg);
            } else {
                System.out.println("DEBUG: [" + Tools.seconds() + "s] " + msg + " (" + object.getClass().getName() + ")");
            }
        }
    }

    public static void debug(Object object, String msg, int level) {
        if (level <= debugLevel) {
            String from = "";
            if (object != null) {
                from = " (" + object.getClass().getName() + ")";
            }
            System.out.println("DEBUG: (" + level + ") " + "[" + Tools.seconds() + "s] " + msg + from);
        }
    }

    public static void error(final String msg) {
        System.out.println(ERROR_STRING + Tools.getErrorString(msg));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(guiData.getMainFrame(), new JScrollPane(new JTextArea(Tools.getErrorString(msg), 20, 60)), Tools.getString("Error.Title"), 0);
            }
        });
    }

    public static void sshError(Host host, String command, String ans, String stacktrace, int exitCode) {
        StringBuilder onHost = new StringBuilder("");
        if (host != null) {
            onHost.append(" on host ");
            Cluster cluster = host.getCluster();
            if (cluster != null) {
                onHost.append(cluster.getName());
                onHost.append(" / ");
            }
            onHost.append(host.getName());
        }
        Tools.appWarning(Tools.getString("Tools.sshError.command") + " '" + command + "'" + onHost.toString() + "\n" + Tools.getString("Tools.sshError.returned") + " " + exitCode + "\n" + ans + "\n" + stacktrace);
    }

    public static boolean confirmDialog(String title, String desc, String yesButton, String noButton) {
        ConfirmDialog cd = new ConfirmDialog(title, desc, yesButton, noButton);
        cd.showDialog();
        return cd.isPressedYesButton();
    }

    public static SSH.SSHOutput execCommandProgressIndicator(final Host host, final String command, ExecCallback execCallback, final boolean outputVisible, String text, int commandTimeout) {
        ExecCallback ec;
        String hostName = host.getName();
        Tools.startProgressIndicator(hostName, text);
        final StringBuilder output = new StringBuilder("");
        final Integer[] exitCodeHolder = new Integer[]{0};
        if (execCallback == null) {
            final String stacktrace = Tools.getStackTrace();
            ec = new ExecCallback(){

                @Override
                public void done(String ans) {
                    output.append(ans);
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    Tools.appWarning(Tools.ERROR_STRING + command + " " + ans + " rc: " + exitCode);
                    if (outputVisible) {
                        Tools.sshError(host, command, ans, stacktrace, exitCode);
                    }
                    exitCodeHolder[0] = exitCode;
                    output.append(ans);
                }
            };
        } else {
            ec = execCallback;
        }
        SSH.ExecCommandThread commandThread = host.execCommandRaw(command, ec, outputVisible, true, commandTimeout);
        try {
            if (commandThread != null) {
                commandThread.join(0L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Tools.stopProgressIndicator(hostName, text);
        return new SSH.SSHOutput(output.toString(), exitCodeHolder[0]);
    }

    public static SSH.SSHOutput execCommand(final Host host, final String command, ExecCallback execCallback, final boolean outputVisible, int commandTimeout) {
        ExecCallback ec;
        final StringBuilder output = new StringBuilder("");
        final Integer[] exitCodeHolder = new Integer[]{0};
        if (execCallback == null) {
            final String stacktrace = Tools.getStackTrace();
            ec = new ExecCallback(){

                @Override
                public void done(String ans) {
                    output.append(ans);
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    if (outputVisible) {
                        Tools.sshError(host, command, ans, stacktrace, exitCode);
                    }
                    exitCodeHolder[0] = exitCode;
                    output.append(ans);
                }
            };
        } else {
            ec = execCallback;
        }
        SSH.ExecCommandThread commandThread = host.execCommandRaw(command, ec, outputVisible, true, commandTimeout);
        try {
            if (commandThread != null) {
                commandThread.join(0L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return new SSH.SSHOutput(output.toString(), exitCodeHolder[0]);
    }

    public static void appWarning(String msg) {
        if (!appWarningHash.contains(msg)) {
            appWarningHash.add(msg);
            if (appWarning) {
                System.out.println(APPWARNING_STRING + msg);
            } else {
                Tools.debug(APPWARNING_STRING + msg, 2);
            }
        }
    }

    public static void appWarning(String msg, Exception e) {
        if (!appWarningHash.contains(msg)) {
            appWarningHash.add(msg);
            if (appWarning) {
                System.out.println(APPWARNING_STRING + msg + ": " + e.getMessage());
            } else {
                Tools.debug(APPWARNING_STRING + msg, 2);
            }
        }
    }

    public static void appError(String msg) {
        Tools.appError(msg, "", null);
    }

    public static void appError(String msg, String msg2) {
        Tools.appError(msg, msg2, null);
    }

    public static void appError(String msg, Exception e) {
        Tools.appError(msg, "", e);
    }

    public static void appError(String msg, String msg2, Exception e) {
        if (appErrorHash.contains(msg + msg2)) {
            return;
        }
        appErrorHash.add(msg + msg2);
        StringBuilder errorString = new StringBuilder(300);
        errorString.append(Tools.getErrorString(msg));
        errorString.append('\n');
        errorString.append("\nrelease: ");
        errorString.append(Tools.getRelease());
        errorString.append("\njava: ");
        errorString.append(System.getProperty("java.vendor"));
        errorString.append(' ');
        errorString.append(System.getProperty("java.version"));
        errorString.append("\n\n");
        errorString.append(msg2);
        if (e != null) {
            errorString.append('\n');
            errorString.append(e.getMessage());
            StackTraceElement[] st = e.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                errorString.append('\n');
                errorString.append(e.getStackTrace()[i].toString());
            }
        }
        if (e == null) {
            Throwable th = new Throwable();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.close();
            errorString.append('\n');
            errorString.append(sw.toString());
        }
        System.out.println(APPERROR_STRING + errorString);
        if (!appError) {
            return;
        }
        final JEditorPane errorPane = new JEditorPane(MIME_TYPE_TEXT_PLAIN, errorString.toString());
        errorPane.setMinimumSize(DIALOG_PANEL_SIZE);
        errorPane.setMaximumSize(DIALOG_PANEL_SIZE);
        errorPane.setPreferredSize(DIALOG_PANEL_SIZE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(guiData.getMainFrame(), new JScrollPane(errorPane), Tools.getErrorString("AppError.Title"), 0);
            }
        });
    }

    public static void infoDialog(final String title, String info1, String info2) {
        final JEditorPane infoPane = new JEditorPane(MIME_TYPE_TEXT_PLAIN, info1 + "\n" + info2);
        infoPane.setEditable(false);
        infoPane.setMinimumSize(DIALOG_PANEL_SIZE);
        infoPane.setMaximumSize(DIALOG_PANEL_SIZE);
        infoPane.setPreferredSize(DIALOG_PANEL_SIZE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(guiData.getMainFrame(), new JScrollPane(infoPane), Tools.getErrorString(title), 0);
            }
        });
    }

    public static boolean isIp(String ipString) {
        boolean wasValid = true;
        Pattern pattern = null;
        String ipPattern = "([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})";
        if ("".equals(ipString)) {
            wasValid = false;
        } else {
            try {
                pattern = Pattern.compile("([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})");
            }
            catch (PatternSyntaxException exception) {
                return true;
            }
            Matcher myMatcher = pattern.matcher(ipString);
            if (myMatcher.matches()) {
                for (int i = 1; i < 5; ++i) {
                    if (Integer.parseInt(myMatcher.group(i)) <= 255) continue;
                    wasValid = false;
                    break;
                }
            } else {
                wasValid = false;
            }
        }
        return wasValid;
    }

    public static void printStackTrace(String text) {
        System.out.println(text);
        Tools.printStackTrace();
    }

    public static void printStackTrace() {
        System.out.println(Tools.getStackTrace());
    }

    public static String getStackTrace() {
        Throwable th = new Throwable();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String loadFile(String filename, boolean showError) {
        BufferedReader in = null;
        StringBuilder content = new StringBuilder("");
        try {
            in = new BufferedReader(new FileReader(filename));
            String line = "";
            while ((line = in.readLine()) != null) {
                content.append(line);
            }
        }
        catch (Exception ex) {
            if (showError) {
                Tools.infoDialog("Load Error", "The file " + filename + " failed to load", ex.getMessage());
            }
            return null;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                Tools.appError("Could not close: " + filename, ex);
            }
        }
        return content.toString();
    }

    public static void loadConfigData(String filename) {
        Tools.debug("load", 0);
        String xml = Tools.loadFile(filename, true);
        if (xml == null) {
            return;
        }
        userConfig.startClusters(null);
        Tools.getGUIData().allHostsUpdate();
    }

    public static void startClusters(List<Cluster> selectedClusters) {
        userConfig.startClusters(selectedClusters);
    }

    public static void stopClusters(List<Cluster> selectedClusters) {
        for (Cluster cluster : selectedClusters) {
            Tools.stopCluster(cluster);
        }
    }

    public static void stopCluster(Cluster cluster) {
        cluster.removeCluster();
        for (Host host : cluster.getHosts()) {
            host.disconnect();
        }
        Tools.getGUIData().getClustersPanel().removeTab(cluster);
    }

    public static void removeClusters(List<Cluster> selectedClusters) {
        for (Cluster cluster : selectedClusters) {
            Tools.getConfigData().removeClusterFromClusters(cluster);
            for (Host host : cluster.getHosts()) {
                host.setCluster(null);
            }
        }
    }

    public static void loadXML(String xml) {
        userConfig.loadXML(xml);
    }

    public static String setUserConfigFromOptions(Map<String, List<HostOptions>> clusters) {
        LinkedHashMap<String, List<Host>> hostMap = new LinkedHashMap<String, List<Host>>();
        for (String clusterName : clusters.keySet()) {
            for (HostOptions hostOptions : clusters.get(clusterName)) {
                String hostnameEntered = hostOptions.getHost();
                InetAddress[] addresses = null;
                try {
                    addresses = InetAddress.getAllByName(hostnameEntered);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                String ip = null;
                if (addresses != null) {
                    if (addresses.length == 0) {
                        Tools.debug("lookup failed");
                    } else {
                        ip = addresses[0].getHostAddress();
                    }
                }
                if (ip == null) {
                    return hostnameEntered;
                }
                userConfig.setHost(hostMap, hostOptions.getUser(), hostnameEntered, ip, hostOptions.getPort(), null, hostOptions.getSudo(), false);
            }
        }
        for (String clusterName : clusters.keySet()) {
            Cluster cluster = new Cluster();
            cluster.setName(clusterName);
            cluster.setSavable(false);
            Tools.getConfigData().addClusterToClusters(cluster);
            for (HostOptions ho : clusters.get(clusterName)) {
                userConfig.setHostCluster(hostMap, cluster, ho.getHost(), false);
            }
        }
        return null;
    }

    public static void removeEverything() {
        Tools.startProgressIndicator("Removing Everything");
        Tools.getConfigData().disconnectAllHosts();
        Tools.getGUIData().getClustersPanel().removeAllTabs();
        Tools.stopProgressIndicator("Removing Everything");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String filename, boolean saveAll) {
        Tools.debug("save");
        String text = Tools.getString("Tools.Saving").replaceAll("@FILENAME@", Matcher.quoteReplacement(filename));
        Tools.startProgressIndicator(text);
        try {
            FileOutputStream fileOut = new FileOutputStream(filename);
            userConfig.saveXML(fileOut, saveAll);
            Tools.debug("saved: " + filename, 0);
        }
        catch (IOException e) {
            Tools.appError("error saving: " + filename, "", e);
        }
        finally {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Clusters clusters = Tools.getConfigData().getClusters();
            if (clusters != null) {
                for (Cluster cluster : clusters.getClusterSet()) {
                    ClusterBrowser cb = cluster.getBrowser();
                    if (cb == null) continue;
                    cb.saveGraphPositions();
                }
            }
            Tools.stopProgressIndicator(text);
        }
    }

    public static ConfigData getConfigData() {
        return configData;
    }

    public static GUIData getGUIData() {
        return guiData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefault(String option) {
        Class<Tools> clazz = Tools.class;
        synchronized (Tools.class) {
            if (resourceAppDefaults == null) {
                resourceAppDefaults = ResourceBundle.getBundle("lcmc.configs.AppDefaults");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return resourceAppDefaults.getString(option);
            }
            catch (Exception e) {
                Tools.appError("unresolved config resource", option, e);
                return option;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getDefaultColor(String option) {
        Class<Tools> clazz = Tools.class;
        synchronized (Tools.class) {
            if (resourceAppDefaults == null) {
                resourceAppDefaults = ResourceBundle.getBundle("lcmc.configs.AppDefaults");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return (Color)resourceAppDefaults.getObject(option);
            }
            catch (Exception e) {
                Tools.appError("unresolved config resource", option, e);
                return Color.WHITE;
            }
        }
    }

    public static int getDefaultSize(String option) {
        return Tools.getConfigData().scaled(Tools.getDefaultInt(option));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultInt(String option) {
        Class<Tools> clazz = Tools.class;
        synchronized (Tools.class) {
            if (resourceAppDefaults == null) {
                resourceAppDefaults = ResourceBundle.getBundle("lcmc.configs.AppDefaults");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return (Integer)resourceAppDefaults.getObject(option);
            }
            catch (Exception e) {
                Tools.appError("AppError.getInt.Exception", option + ": " + Tools.getDefault(option), e);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String text) {
        Class<Tools> clazz = Tools.class;
        synchronized (Tools.class) {
            if (resource == null) {
                Locale currentLocale = Locale.getDefault();
                resource = ResourceBundle.getBundle("lcmc.configs.TextResource", currentLocale);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                return resource.getString(text);
            }
            catch (Exception e) {
                Tools.appError("unresolved resource: " + text);
                return text;
            }
        }
    }

    public static String getErrorString(String text) {
        return text;
    }

    public static String getDistString(String text, String dist, String version2, String arch) {
        String ret;
        if (dist == null) {
            dist = "";
        }
        if (version2 == null) {
            version2 = "";
        }
        Locale locale = new Locale(dist, version2);
        Tools.debug("getDistString text: " + text + " dist: " + dist + " version: " + version2, 2);
        ResourceBundle resourceString = ResourceBundle.getBundle("lcmc.configs.DistResource", locale);
        try {
            ret = resourceString.getString(text + "." + arch);
        }
        catch (Exception e) {
            ret = null;
        }
        if (ret == null) {
            try {
                if (ret == null) {
                    ret = resourceString.getString(text);
                }
                Tools.debug("ret: " + ret, 2);
                return ret;
            }
            catch (Exception e) {
                return null;
            }
        }
        return ret;
    }

    public static List<String> getDistStrings(String text, String dist, String version2, String arch) {
        ArrayList<String> ret;
        if (dist == null) {
            dist = "";
        }
        if (version2 == null) {
            version2 = "";
        }
        Locale locale = new Locale(dist, version2);
        Tools.debug("getDistStrings text: " + text + " dist: " + dist + " version: " + version2, 2);
        ResourceBundle resourceString = ResourceBundle.getBundle("lcmc.configs.DistResource", locale);
        try {
            ret = (ArrayList<String>)resourceString.getObject(text);
        }
        catch (Exception e) {
            ret = new ArrayList<String>();
        }
        return ret;
    }

    public static String getDistCommand(String text, String dist, String version2, String arch, ConvertCmdCallback convertCmdCallback, boolean inBash) {
        if (text == null) {
            return null;
        }
        String[] texts = text.split(";;;");
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        for (String t : texts) {
            String distString = Tools.getDistString(t, dist, version2, arch);
            if (distString == null) {
                Tools.appWarning("unknown command: " + t);
                distString = t;
            }
            if (inBash && i == 0) {
                results.add("@DMCSUDO@bash -c \"" + Tools.escapeQuotes(distString, 1) + "\"");
            } else {
                results.add(distString);
            }
            ++i;
        }
        String ret = results.isEmpty() ? text : Tools.join(";;;", results.toArray(new String[results.size()]));
        if (convertCmdCallback != null && ret != null) {
            ret = convertCmdCallback.convert(ret);
        }
        return ret;
    }

    public static String[] getServiceDefinition(String service) {
        ResourceBundle resourceSD = ResourceBundle.getBundle("lcmc.configs.ServiceDefinitions");
        try {
            return resourceSD.getStringArray(service);
        }
        catch (Exception e) {
            Tools.appWarning("cannot get service definition for service: " + service, e);
            return new String[0];
        }
    }

    public static String getKernelDownloadDir(String kernelVersion, String dist, String version2, String arch) {
        Pattern p;
        Matcher m;
        String regexp = Tools.getDistString("kerneldir", dist, version2, arch);
        if (regexp != null && kernelVersion != null && (m = (p = Pattern.compile(regexp)).matcher(kernelVersion)).matches()) {
            return m.group(1);
        }
        return null;
    }

    public static String getDistVersionString(String dist, String version2) {
        String distVersion;
        block6: {
            if (dist == null) {
                dist = "";
            }
            Tools.debug("dist: " + dist + ", version: " + version2, 2);
            Locale locale = new Locale(dist, "");
            ResourceBundle resourceCommand = ResourceBundle.getBundle("lcmc.configs.DistResource", locale);
            distVersion = null;
            try {
                distVersion = resourceCommand.getString("version:" + version2);
            }
            catch (Exception e) {
                StringBuilder buf = new StringBuilder(version2);
                for (int i = version2.length() - 1; i >= 0; --i) {
                    try {
                        distVersion = resourceCommand.getString("version:" + buf.toString() + "*");
                    }
                    catch (Exception e2) {
                        distVersion = null;
                    }
                    if (distVersion != null) break;
                    buf.setLength(i);
                }
                if (distVersion != null) break block6;
                distVersion = version2;
            }
        }
        Tools.debug("dist version: " + distVersion, 2);
        return distVersion;
    }

    public static String join(String delim, String[] strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        if (strings.length == 1 && strings[0] == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder("");
        for (int i = 0; i < strings.length - 1; ++i) {
            if (strings[i] == null) continue;
            ret.append(strings[i]);
            if (delim == null || strings[i + 1] == null) continue;
            ret.append(delim);
        }
        if (strings[strings.length - 1] != null) {
            ret.append(strings[strings.length - 1]);
        }
        return ret.toString();
    }

    public static String join(String delim, Collection<String> strings) {
        if (strings == null) {
            return "";
        }
        return Tools.join(delim, strings.toArray(new String[strings.size()]));
    }

    public static String join(String delim, String[] strings, int length) {
        int i;
        if (strings == null || strings.length == 0 || length <= 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder("");
        for (i = 0; i < length - 1 && i < strings.length - 1; ++i) {
            ret.append(strings[i]);
            if (delim == null) continue;
            ret.append(delim);
        }
        ret.append(strings[++i - 1]);
        return ret.toString();
    }

    public static String ucfirst(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        String f = s.substring(0, 1);
        return s.replaceFirst(".", f.toUpperCase(Locale.US));
    }

    public static String[] enumToStringArray(Enumeration<String> e) {
        if (e == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public static Set<String> getIntersection(Set<String> setA, Set<String> setB) {
        TreeSet<String> resultSet = new TreeSet<String>();
        if (setB == null) {
            return setA;
        }
        if (setA == null) {
            return setB;
        }
        for (String item : setA) {
            if (!setB.contains(item)) continue;
            resultSet.add(item);
        }
        return resultSet;
    }

    public static String html(String text) {
        if (text == null) {
            return "<html>\n</html>";
        }
        return "<html><p>" + text.replaceAll("\n", "<br>") + "\n</html>";
    }

    public static boolean isStringClass(Object o) {
        return o == null || o instanceof String;
    }

    public static boolean isStringInfoClass(Object o) {
        return o != null && o.getClass().getName().equals("lcmc.gui.resources.StringInfo");
    }

    public static String escapeConfig(String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(32) > -1 || value.indexOf(34) > -1) {
            return "\"" + value.replaceAll("\"", "\\\\\"") + "\"";
        }
        return value;
    }

    public static void startProgressIndicator(String text) {
        Tools.getGUIData().getMainGlassPane().start(text, null);
    }

    public static void startProgressIndicator(String name, String text) {
        Tools.startProgressIndicator(name + ": " + text);
    }

    public static void stopProgressIndicator(String text) {
        Tools.getGUIData().getMainGlassPane().stop(text);
    }

    public static void stopProgressIndicator(String name, String text) {
        Tools.stopProgressIndicator(name + ": " + text);
    }

    public static void progressIndicatorFailed(String text) {
        Tools.getGUIData().getMainGlassPane().failure(text);
    }

    public static void progressIndicatorFailed(String name, String text) {
        Tools.progressIndicatorFailed(name + ": " + text);
    }

    public static void progressIndicatorFailed(String text, int n) {
        Tools.getGUIData().getMainGlassPane().failure(text, n);
    }

    public static void progressIndicatorFailed(String name, String text, int n) {
        Tools.progressIndicatorFailed(name + ": " + text, n);
    }

    public static void setSize(Component c, int width, int height) {
        Dimension d = new Dimension(width, height);
        c.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
        c.setMinimumSize(d);
        c.setPreferredSize(d);
    }

    public static int compareVersions(String version1, String version2) throws Exceptions.IllegalVersionException {
        String version2a;
        int index;
        String version1a;
        if (version1 == null || version2 == null) {
            throw new Exceptions.IllegalVersionException(version1, version2);
        }
        Pattern p = Pattern.compile("(.*\\d+)rc(\\d+)$");
        Matcher m1 = p.matcher(version1);
        int rc1 = Integer.MAX_VALUE;
        if (m1.matches()) {
            version1a = m1.group(1);
            try {
                rc1 = Integer.parseInt(m1.group(2));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            version1a = version1;
        }
        if ((index = version1a.indexOf("-")) < 0) {
            index = version1a.indexOf("_");
        }
        if (index >= 0) {
            version1a = version1a.substring(0, index);
        }
        Matcher m2 = p.matcher(version2);
        int rc2 = Integer.MAX_VALUE;
        if (m2.matches()) {
            version2a = m2.group(1);
            try {
                rc2 = Integer.parseInt(m2.group(2));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            version2a = version2;
        }
        String[] v1a = version1a.split("\\.");
        String[] v2a = version2a.split("\\.");
        if (v1a.length < 1 || v2a.length < 1) {
            throw new Exceptions.IllegalVersionException(version1, version2);
        }
        for (int i = 0; i < v1a.length || i < v2a.length; ++i) {
            if (i >= v1a.length || i >= v2a.length) {
                return 0;
            }
            int v1i = 0;
            if (i < v1a.length) {
                String v1 = v1a[i];
                try {
                    v1i = Integer.parseInt(v1);
                }
                catch (NumberFormatException e) {
                    throw new Exceptions.IllegalVersionException(version1);
                }
            }
            int v2i = 0;
            if (i < v2a.length) {
                String v2 = v2a[i];
                try {
                    v2i = Integer.parseInt(v2);
                }
                catch (NumberFormatException e) {
                    throw new Exceptions.IllegalVersionException(version2);
                }
            }
            if (v1i < v2i) {
                return -1;
            }
            if (v1i <= v2i) continue;
            return 1;
        }
        if (rc1 < rc2) {
            return -1;
        }
        if (rc1 > rc2) {
            return 1;
        }
        return 0;
    }

    public static int charCount(String s, char c) {
        if (s == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static void createConfigOnAllHosts(Host[] hosts, String config, String fileName, String dir, String mode, boolean makeBackup) {
        for (Host host : hosts) {
            host.getSSH().createConfig(config, fileName, dir, mode, makeBackup, null, null);
        }
    }

    public static TitledBorder getBorder(String text) {
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), text);
        titledBorder.setTitleJustification(1);
        return titledBorder;
    }

    public static boolean getScrollingMenu(String name, JPanel optionsPanel, final MyMenu menu, final MyListModel<MyMenuItem> dlm, final MyList<MyMenuItem> list, final Info infoObject, final List<JDialog> popups, final Map<MyMenuItem, ButtonCallback> callbackHash) {
        int maxSize = dlm.getSize();
        if (maxSize <= 0) {
            return false;
        }
        prevScrollingMenuIndex = -1;
        list.setFixedCellHeight(25);
        if (maxSize > 10) {
            list.setVisibleRowCount(10);
        } else {
            list.setVisibleRowCount(maxSize);
        }
        JScrollPane sp = new JScrollPane(list);
        sp.setViewportBorder(null);
        sp.setBorder(null);
        final MyListModel.FilterField typeToSearchField = dlm.getFilterField();
        Container mainFrame = Tools.getGUIData().getMainFrame();
        final JDialog popup = mainFrame instanceof JApplet ? new JDialog(new JFrame(), name, false) : new JDialog((JFrame)mainFrame, name, false);
        popup.setUndecorated(true);
        popup.setAlwaysOnTop(true);
        JPanel popupPanel = new JPanel();
        popupPanel.setLayout(new BoxLayout(popupPanel, 3));
        if (maxSize > 10) {
            popupPanel.add(typeToSearchField);
        }
        popupPanel.add(sp);
        if (optionsPanel != null) {
            popupPanel.add(optionsPanel);
        }
        popup.setContentPane(popupPanel);
        popups.add(popup);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                prevScrollingMenuIndex = -1;
                if (callbackHash != null) {
                    for (MyMenuItem item : callbackHash.keySet()) {
                        ((ButtonCallback)callbackHash.get(item)).mouseOut();
                        list.clearSelection();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                list.requestFocus();
            }

            @Override
            public void mousePressed(final MouseEvent evt) {
                prevScrollingMenuIndex = -1;
                if (callbackHash != null) {
                    for (MyMenuItem item : callbackHash.keySet()) {
                        ((ButtonCallback)callbackHash.get(item)).mouseOut();
                    }
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final int index = list.locationToIndex(evt.getPoint());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                list.setSelectedIndex(index);
                                menu.setSelected(false);
                            }
                        });
                        MyMenuItem item = (MyMenuItem)dlm.getElementAt(index);
                        item.action();
                    }
                });
                thread.start();
            }
        });
        list.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(final MouseEvent evt) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int lastIndex;
                        int index;
                        int pIndex = list.locationToIndex(evt.getPoint());
                        Rectangle r = list.getCellBounds(pIndex, pIndex);
                        if (r == null) {
                            return;
                        }
                        if (!r.contains(evt.getPoint())) {
                            pIndex = -1;
                        }
                        if ((index = pIndex) == (lastIndex = prevScrollingMenuIndex)) {
                            return;
                        }
                        prevScrollingMenuIndex = index;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                list.setSelectedIndex(index);
                            }
                        });
                        if (callbackHash != null) {
                            MyMenuItem item;
                            MyMenuItem lastItem;
                            ButtonCallback bc;
                            if (lastIndex >= 0 && (bc = (ButtonCallback)callbackHash.get(lastItem = (MyMenuItem)dlm.getElementAt(lastIndex))) != null) {
                                bc.mouseOut();
                            }
                            if (index >= 0 && (bc = (ButtonCallback)callbackHash.get(item = (MyMenuItem)dlm.getElementAt(index))) != null) {
                                bc.mouseOver();
                            }
                        }
                    }
                });
                thread.start();
            }
        });
        list.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                MyMenuItem item;
                int ch = e.getKeyCode();
                if (ch == 38 && list.getSelectedIndex() == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            typeToSearchField.requestFocus();
                        }
                    });
                } else if (ch == 27) {
                    for (JDialog otherP : popups) {
                        otherP.dispose();
                    }
                    infoObject.hidePopup();
                } else if ((ch == 32 || ch == 10) && (item = (MyMenuItem)list.getSelectedValue()) != null) {
                    item.action();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        popup.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                popup.dispose();
            }
        });
        typeToSearchField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                MyMenuItem item;
                int ch = e.getKeyCode();
                if (ch == 40) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            list.requestFocus();
                            list.setSelectedIndex(0);
                        }
                    });
                } else if (ch == 27) {
                    for (JDialog otherP : popups) {
                        otherP.dispose();
                    }
                    infoObject.hidePopup();
                } else if ((ch == 32 || ch == 10) && (item = (MyMenuItem)list.getModel().getElementAt(0)) != null) {
                    item.action();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        for (MenuListener ml : menu.getMenuListeners()) {
            menu.removeMenuListener(ml);
        }
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean pVisible = false;
                        for (JPopupMenu p = (JPopupMenu)menu.getParent(); p != null; p = (JPopupMenu)p.getParent()) {
                            if (!p.isVisible()) continue;
                            pVisible = true;
                            break;
                        }
                        for (JDialog otherP : popups) {
                            if (popup == otherP && !pVisible) continue;
                            otherP.dispose();
                        }
                    }
                });
            }

            @Override
            public void menuSelected(MenuEvent e) {
                final Point l = menu.getLocationOnScreen();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (JDialog otherP : popups) {
                            otherP.dispose();
                        }
                        popup.setLocation((int)(l.getX() + menu.getBounds().getWidth()), (int)l.getY() - 1);
                        popup.pack();
                        popup.setVisible(true);
                        typeToSearchField.requestFocus();
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        popup.setLocation((int)(l.getX() + menu.getBounds().getWidth()), (int)l.getY());
                    }
                });
            }
        });
        return true;
    }

    public static boolean isLinux() {
        return "Linux".equals(System.getProperty("os.name"));
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") == 0;
    }

    public static void setEditorFont(JEditorPane ep) {
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)ep.getDocument()).getStyleSheet().addRule(bodyRule);
    }

    public static String getFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        URL url = Tools.class.getResource(fileName);
        if (url == null) {
            return null;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder content = new StringBuilder("");
            while (br.ready()) {
                content.append(br.readLine());
                content.append('\n');
            }
            return content.toString();
        }
        catch (IOException e) {
            Tools.appError("could not read: " + fileName, "", e);
            return null;
        }
    }

    public static void parseAutoArgs(String line) {
        if (line == null) {
            return;
        }
        String[] args = line.split(",");
        String host = null;
        String cluster = null;
        boolean global = false;
        for (String arg : args) {
            String[] pair = arg.split(":");
            if (pair == null || pair.length != 2) {
                Tools.appWarning("cannot parse: " + line);
                return;
            }
            String option = pair[0];
            String value = pair[1];
            if ("host".equals(option)) {
                cluster = null;
                host = value;
                Tools.getConfigData().addAutoHost(host);
                continue;
            }
            if ("cluster".equals(option)) {
                host = null;
                cluster = value;
                Tools.getConfigData().addAutoCluster(cluster);
                continue;
            }
            if ("global".equals(option)) {
                host = null;
                cluster = null;
                global = true;
                continue;
            }
            if (host != null) {
                Tools.getConfigData().addAutoOption(host, option, value);
                continue;
            }
            if (cluster != null) {
                Tools.getConfigData().addAutoOption(cluster, option, value);
                continue;
            }
            if (global) {
                Tools.getConfigData().addAutoOption("global", option, value);
                continue;
            }
            Tools.appWarning("cannot parse: " + line);
            return;
        }
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(float ms) {
        Tools.sleep((int)ms);
    }

    public static String getLatestVersion() {
        String version2 = null;
        Pattern vp = Pattern.compile(".*version:\\s+([0-9.]*)");
        try {
            String line;
            String url = "http://lcmc.sourceforge.net/version.html?lcmc-check-" + Tools.getRelease();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((line = reader.readLine()) != null) {
                Matcher m = vp.matcher(line);
                if (!m.matches()) continue;
                String v = m.group(1);
                try {
                    if (version2 != null && Tools.compareVersions(v, version2) <= 0) continue;
                    version2 = v;
                }
                catch (Exceptions.IllegalVersionException e) {
                    Tools.appWarning(e.getMessage(), e);
                }
            }
        }
        catch (MalformedURLException mue) {
            return null;
        }
        catch (IOException ioe) {
            return version2;
        }
        return version2;
    }

    public static void openBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e) {
            Tools.appError("wrong uri", e);
        }
        catch (URISyntaxException e) {
            Tools.appError("error opening browser", e);
        }
    }

    private static int prepareVncViewer(Host host, int remotePort) {
        if (remotePort < 0 || host == null) {
            return -1;
        }
        if (Tools.isLocalIp(host.getIp())) {
            return remotePort;
        }
        int localPort = remotePort + Tools.getConfigData().getVncPortOffset();
        Tools.debug("start port forwarding " + remotePort + " -> " + localPort);
        try {
            host.getSSH().startVncPortForwarding(host.getIp(), remotePort);
        }
        catch (IOException e) {
            Tools.appError("unable to create tunnel", e);
            return -1;
        }
        return localPort;
    }

    private static void cleanupVncViewer(Host host, int localPort) {
        if (Tools.isLocalIp(host.getIp())) {
            return;
        }
        int remotePort = localPort - Tools.getConfigData().getVncPortOffset();
        Tools.debug("stop port forwarding " + remotePort);
        try {
            host.getSSH().stopVncPortForwarding(remotePort);
        }
        catch (IOException e) {
            Tools.appError("unable to close tunnel", e);
        }
    }

    public static void startTightVncViewer(Host host, int remotePort) {
        int localPort = Tools.prepareVncViewer(host, remotePort);
        if (localPort < 0) {
            return;
        }
        VncViewer v = new VncViewer(new String[]{"HOST", "127.0.0.1", "PORT", Integer.toString(localPort)}, false, true);
        v.init();
        v.start();
        v.join();
        Tools.cleanupVncViewer(host, localPort);
    }

    public static void startUltraVncViewer(Host host, int remotePort) {
        int localPort = Tools.prepareVncViewer(host, remotePort);
        if (localPort < 0) {
            return;
        }
        JavaViewer.VncViewer v = new JavaViewer.VncViewer(new String[]{"HOST", "127.0.0.1", "PORT", Integer.toString(localPort)}, false, true);
        v.init();
        v.start();
        v.join();
        Tools.cleanupVncViewer(host, localPort);
    }

    public static void startRealVncViewer(Host host, int remotePort) {
        int localPort = Tools.prepareVncViewer(host, remotePort);
        if (localPort < 0) {
            return;
        }
        VNCViewer v = new VNCViewer(new String[]{"127.0.0.1:" + Integer.toString(localPort - 5900)});
        v.start();
        v.join();
        Tools.cleanupVncViewer(host, localPort);
    }

    public static void hideMousePointer(Component c) {
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        c.setCursor(transparentCursor);
    }

    public static boolean isNumber(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String shellList(String[] items) {
        StringBuilder list = new StringBuilder("");
        if (items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            list.append(items[0]);
        } else {
            list.append('{');
            for (int i = 0; i < items.length - 1; ++i) {
                list.append('\'');
                list.append(items[i]);
                list.append("',");
            }
            if (items.length != 0) {
                list.append('\'');
                list.append(items[items.length - 1]);
                list.append('\'');
            }
            list.append('}');
        }
        return list.toString();
    }

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o1 instanceof DrbdResourceInfo) {
            String device = ((DrbdResourceInfo)o1).getInternalValue();
            if (device != null && device.equals(o2)) {
                return true;
            }
            String res = ((DrbdResourceInfo)o1).getName();
            if (res == null) {
                return res == o2;
            }
            return res.equals(o2);
        }
        if (o1 != null && o1 instanceof Info) {
            String s1 = ((Info)o1).getInternalValue();
            if (s1 == null) {
                return o2 == null;
            }
            if (o2 == null) {
                return false;
            }
            if (o2 instanceof Info) {
                return s1.equals(((Info)o2).getInternalValue());
            }
            return s1.equals(o2) || o1.toString().equals(o2);
        }
        if (o2 != null && o2 instanceof Info) {
            String s2 = ((Info)o2).getInternalValue();
            if (s2 == null) {
                return o1 == null;
            }
            if (o1 == null) {
                return false;
            }
            if (o1 instanceof Info) {
                return s2.equals(((Info)o1).getInternalValue());
            }
            return s2.equals(o1) || o2.toString().equals(o1);
        }
        if (o1 == null && o2 != null) {
            return o2.toString().equals("");
        }
        if (o2 == null && o1 != null) {
            return o1.toString().equals("");
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            Object[] array1 = (Object[])o1;
            Object[] array2 = (Object[])o2;
            for (int i = 0; i < array1.length; ++i) {
                if (Tools.areEqual(array1[i], array2[i])) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof Unit) {
            return ((Unit)o1).equals(o2);
        }
        if (o2 instanceof Unit) {
            return ((Unit)o2).equals(o1);
        }
        if (o1 instanceof ComboInfo) {
            return ((ComboInfo)o1).equals(o2);
        }
        if (o2 instanceof ComboInfo) {
            return ((ComboInfo)o2).equals(o1);
        }
        return o1.equals(o2);
    }

    public static Object[] extractUnit(String time) {
        Object[] o = new Object[]{null, null};
        if (time == null) {
            return o;
        }
        Matcher m = UNIT_PATTERN.matcher(time);
        if (m.matches()) {
            o[0] = m.group(1);
            o[1] = m.group(2);
        }
        return o;
    }

    public static String getRandomSecret(int len) {
        int a;
        Random rand = new Random();
        ArrayList<Character> charsL = new ArrayList<Character>();
        for (a = 97; a <= 122; ++a) {
            charsL.add(Character.valueOf((char)a));
            charsL.add(Character.valueOf(Character.toUpperCase((char)a)));
        }
        for (a = 48; a <= 57; ++a) {
            charsL.add(Character.valueOf((char)a));
        }
        Character[] chars = charsL.toArray(new Character[charsL.size()]);
        StringBuilder s = new StringBuilder(len + 1);
        for (int i = 0; i < len; ++i) {
            s.append(chars[rand.nextInt(chars.length)]);
        }
        return s.toString();
    }

    public static boolean isLocalIp(String ip) {
        if (ip == null || "127.0.0.1".equals(ip) || "127.0.1.1".equals(ip)) {
            return true;
        }
        try {
            String localIp = InetAddress.getLocalHost().getHostAddress();
            return ip.equals(localIp);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static String convertKilobytes(String kb) {
        if (!Tools.isNumber(kb)) {
            return kb;
        }
        double k = Long.parseLong(kb);
        if (k == 0.0) {
            return "0K";
        }
        if (k / 1024.0 != (double)((long)(k / 1024.0))) {
            return kb + "K";
        }
        double m = k / 1024.0;
        if (m / 1024.0 != (double)((long)(m / 1024.0))) {
            return Long.toString((long)m) + "M";
        }
        double g = m / 1024.0;
        if (g / 1024.0 != (double)((long)(g / 1024.0))) {
            return Long.toString((long)g) + "G";
        }
        double t = g / 1024.0;
        if (t / 1024.0 != (double)((long)(t / 1024.0))) {
            return Long.toString((long)t) + "T";
        }
        return Long.toString((long)(t / 1024.0)) + "P";
    }

    public static long convertToKilobytes(String value) {
        Object[] v = Tools.extractUnit(value);
        if (v.length == 2 && Tools.isNumber((String)v[0])) {
            long num = Long.parseLong((String)v[0]);
            String unit = (String)v[1];
            if ("P".equalsIgnoreCase(unit)) {
                num = num * 1024L * 1024L * 1024L * 1024L;
            } else if ("T".equalsIgnoreCase(unit)) {
                num = num * 1024L * 1024L * 1024L;
            } else if ("G".equalsIgnoreCase(unit)) {
                num = num * 1024L * 1024L;
            } else if ("M".equalsIgnoreCase(unit)) {
                num *= 1024L;
            } else if (!"K".equalsIgnoreCase(unit)) {
                return -1L;
            }
            return num;
        }
        return -1L;
    }

    public static long convertUnits(String value) {
        Object[] v = Tools.extractUnit(value);
        if (v.length == 2 && Tools.isNumber((String)v[0])) {
            long num = Long.parseLong((String)v[0]);
            String unit = (String)v[1];
            if ("P".equalsIgnoreCase(unit)) {
                num = num * 1024L * 1024L * 1024L * 1024L * 1024L;
            } else if ("T".equalsIgnoreCase(unit)) {
                num = num * 1024L * 1024L * 1024L * 1024L;
            } else if ("G".equalsIgnoreCase(unit)) {
                num = num * 1024L * 1024L * 1024L;
            } else if ("M".equalsIgnoreCase(unit)) {
                num = num * 1024L * 1024L;
            } else if ("K".equalsIgnoreCase(unit)) {
                num *= 1024L;
            } else if (!"".equalsIgnoreCase(unit)) {
                return -1L;
            }
            return num;
        }
        return -1L;
    }

    public static void resizeTable(JTable table, Map<Integer, Integer> defaultWidths) {
        int margin = 3;
        if (table == null) {
            return;
        }
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int vColIndex = i;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            if (renderer == null) continue;
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            Integer dw = null;
            if (defaultWidths != null) {
                dw = defaultWidths.get(i);
            }
            if (dw == null) {
                width = comp.getPreferredSize().width;
                for (int r = 0; r < table.getRowCount(); ++r) {
                    renderer = table.getCellRenderer(r, vColIndex);
                    if (renderer == null) continue;
                    comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
            } else {
                width = dw;
                col.setMaxWidth(width);
            }
            col.setPreferredWidth(width += 6);
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
    }

    public static void setMenuVisible(JComponent menu, boolean visible) {
        JComponent parent = (JComponent)menu.getParent();
        if (parent instanceof JViewport) {
            parent = (JComponent)parent.getParent();
            parent = (JComponent)parent.getParent();
        }
        if (parent instanceof JPopupMenu) {
            JComponent invP;
            JComponent inv = (JComponent)((JPopupMenu)parent).getInvoker();
            while (inv != null && (invP = (JComponent)inv.getParent()) instanceof JPopupMenu) {
                invP.setVisible(visible);
                for (Component c : invP.getComponents()) {
                    ((JComponent)c).setVisible(visible);
                }
                JComponent pp = (JComponent)invP.getParent();
                if (pp != null) {
                    pp.setVisible(visible);
                }
                inv = (JComponent)((JPopupMenu)invP).getInvoker();
            }
            menu.setVisible(visible);
            parent.setVisible(visible);
            JComponent pp = (JComponent)parent.getParent();
            if (pp != null) {
                pp.setVisible(visible);
            }
            for (Component c : parent.getComponents()) {
                ((JComponent)c).setVisible(visible);
            }
            parent.repaint();
        }
    }

    private static void setBGColor(JComponent c, boolean opaque) {
        Color oc = c.getBackground();
        c.setBackground(new Color(oc.getRed(), oc.getGreen(), oc.getBlue(), opaque ? 255 : 120));
    }

    public static void setMenuOpaque(JComponent menu, boolean opaque) {
        JComponent parent = (JComponent)menu.getParent();
        if (parent instanceof JViewport) {
            parent = (JComponent)parent.getParent();
            parent = (JComponent)parent.getParent();
        }
        if (parent instanceof JPopupMenu) {
            JComponent invP;
            JComponent inv = (JComponent)((JPopupMenu)parent).getInvoker();
            while (inv != null && (invP = (JComponent)inv.getParent()) instanceof JPopupMenu) {
                Tools.setBGColor(invP, opaque);
                for (Component c : invP.getComponents()) {
                    Tools.setBGColor((JComponent)c, opaque);
                }
                JComponent pp = (JComponent)invP.getParent();
                if (pp != null) {
                    Tools.setBGColor(pp, opaque);
                }
                inv = (JComponent)((JPopupMenu)invP).getInvoker();
            }
            Tools.setBGColor(menu, opaque);
            Tools.setBGColor(parent, opaque);
            JComponent pp = (JComponent)parent.getParent();
            if (pp != null) {
                Tools.setBGColor(pp, opaque);
            }
            for (Component c : parent.getComponents()) {
                Tools.setBGColor((JComponent)c, opaque);
            }
            parent.repaint();
        }
    }

    public static String getUnixPath(String dir) {
        String unixPath;
        if (dir == null) {
            return null;
        }
        if (Tools.isWindows()) {
            unixPath = dir.replaceAll("\\\\", "/");
            if (unixPath.length() >= 2 && ":".equalsIgnoreCase(unixPath.substring(1, 2))) {
                unixPath = unixPath.substring(2);
            }
        } else {
            unixPath = dir;
        }
        return unixPath;
    }

    public static Rectangle getScreenBounds(JComponent component) {
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        Rectangle sBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        sBounds.x += screenInsets.left;
        sBounds.y += screenInsets.top;
        sBounds.width -= screenInsets.left + screenInsets.right;
        sBounds.height -= screenInsets.top + screenInsets.bottom;
        return sBounds;
    }

    public static boolean serviceInfoListEquals(Set<ServiceInfo> l1, Set<ServiceInfo> l2) {
        if (l1 == l2) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (ServiceInfo s1 : l1) {
            if (l2.contains(s1)) continue;
            return false;
        }
        return true;
    }

    public static String trimText(String text) {
        int pos;
        int width = 80;
        if (text == null || text.length() <= 80) {
            return text;
        }
        StringBuilder out = new StringBuilder(text.length() + 10);
        String t = text;
        while ((pos = t.indexOf(32, 80)) > 0) {
            out.append(t.substring(0, pos));
            out.append('\n');
            t = t.substring(pos + 1);
        }
        out.append(t);
        return out.toString();
    }

    public static void waitForSwing() {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException ix) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException x) {
            Tools.printStackTrace();
        }
    }

    public static String getDirectoryPart(String filename) {
        if (filename == null) {
            return null;
        }
        int i = filename.lastIndexOf(47);
        if (i < 0) {
            return filename;
        }
        return filename.substring(0, i + 1);
    }

    public static String escapeQuotes(String s, int count) {
        if (s == null) {
            return null;
        }
        if (count <= 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"' || c == '$' || c == '`') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\n') {
                sb.append("\n");
                continue;
            }
            sb.append(c);
        }
        return Tools.escapeQuotes(sb.toString(), count - 1);
    }

    public static String escapeSingleQuotes(String s, int count) {
        if (s == null) {
            return null;
        }
        if (count <= 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append("\n");
                continue;
            }
            if (c == '\'') {
                sb.append("'\\''");
                continue;
            }
            sb.append(c);
        }
        return Tools.escapeQuotes(sb.toString(), count - 1);
    }

    public static Map<Host, JCheckBox> getHostCheckBoxes(Cluster cluster) {
        LinkedHashMap<Host, JCheckBox> components = new LinkedHashMap<Host, JCheckBox>();
        for (Host host : cluster.getHosts()) {
            JCheckBox button = new JCheckBox(host.getName());
            button.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
            components.put(host, button);
        }
        return components;
    }

    public static boolean versionBeforePacemaker(Host host) {
        String hbV = host.getHeartbeatVersion();
        String pcmkV = host.getPacemakerVersion();
        try {
            return pcmkV == null && hbV != null && Tools.compareVersions(hbV, "2.99.0") < 0;
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
            return false;
        }
    }

    public static void makeMiniButton(AbstractButton ab) {
        Font font = ab.getFont();
        String name = font.getFontName();
        int style = font.getStyle();
        int size = font.getSize();
        ab.setFont(new Font(name, style, Tools.getConfigData().scaled(10)));
        ab.setMargin(new Insets(2, 2, 2, 2));
        ab.setIconTextGap(0);
    }

    public static void chomp(StringBuffer sb) {
        int l;
        int i;
        for (i = l = sb.length(); i > 0 && sb.charAt(i - 1) == '\n'; --i) {
        }
        if (i >= 0 && i < l - 1) {
            sb.delete(i, l - 1);
        }
    }

    public static void resizeFonts(int scale) {
        if (scale == 100) {
            return;
        }
        if (scale < 5) {
            scale = 5;
        }
        if (scale > 10000) {
            scale = 10000;
        }
        Enumeration e = UIManager.getDefaults().keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof Font)) continue;
            Font f = (Font)value;
            UIManager.put(key, new FontUIResource(f.getName(), f.getStyle(), Tools.getConfigData().scaled(f.getSize())));
        }
    }

    public static void setMaxAccessType(ConfigData.AccessType accessType) {
        Tools.getConfigData().setAccessType(ConfigData.AccessType.RO);
        Tools.getConfigData().setMaxAccessType(ConfigData.AccessType.RO);
        for (Cluster c : Tools.getConfigData().getClusters().getClusterSet()) {
            ClusterBrowser cb = c.getBrowser();
            if (cb == null) continue;
            cb.checkAccessOfEverything();
        }
    }

    public static Color brighterColor(Color c, double x) {
        double b;
        double g;
        double r = (double)c.getRed() * x;
        if (r > 255.0) {
            r = 255.0;
        }
        if ((g = (double)c.getGreen() * x) > 255.0) {
            g = 255.0;
        }
        if ((b = (double)c.getBlue() * x) > 255.0) {
            b = 255.0;
        }
        return new Color((int)r, (int)g, (int)b);
    }

    static {
        appWarningHash = new HashSet<String>();
        appErrorHash = new HashSet<String>();
        imageIcons = new HashMap<String, ImageIcon>();
        resource = null;
        resourceAppDefaults = null;
        userConfig = new UserConfig();
        DIALOG_PANEL_SIZE = new Dimension(400, 300);
        prevScrollingMenuIndex = -1;
        UNIT_PATTERN = Pattern.compile("(\\d*)(\\D*)");
        RANDOM = new Random();
        START_TIME = System.currentTimeMillis() / 1000L;
    }
}

