/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.functors.FunctorUtils;
import org.apache.commons.collections15.functors.NOPClosure;

public class ChainedClosure<T>
implements Closure<T>,
Serializable {
    static final long serialVersionUID = -3520677225766901240L;
    private final Closure<? super T>[] iClosures;

    public static <T> Closure<T> getInstance(Closure<? super T>[] closures) {
        FunctorUtils.validate(closures);
        if (closures.length == 0) {
            return NOPClosure.INSTANCE;
        }
        closures = FunctorUtils.copy(closures);
        return new ChainedClosure<T>(closures);
    }

    public static <T> Closure<T> getInstance(Collection<? super T> closures) {
        if (closures == null) {
            throw new IllegalArgumentException("Closure collection must not be null");
        }
        if (closures.size() == 0) {
            return NOPClosure.INSTANCE;
        }
        Closure[] cmds = new Closure[closures.size()];
        int i = 0;
        Iterator<T> it = closures.iterator();
        while (it.hasNext()) {
            cmds[i++] = (Closure)it.next();
        }
        FunctorUtils.validate(cmds);
        return new ChainedClosure<T>(cmds);
    }

    public static <T> Closure<T> getInstance(Closure<? super T> closure1, Closure<? super T> closure2) {
        if (closure1 == null || closure2 == null) {
            throw new IllegalArgumentException("Closures must not be null");
        }
        Closure[] closures = new Closure[]{closure1, closure2};
        return new ChainedClosure<T>(closures);
    }

    public ChainedClosure(Closure<? super T>[] closures) {
        this.iClosures = closures;
    }

    @Override
    public void execute(T input) {
        for (int i = 0; i < this.iClosures.length; ++i) {
            this.iClosures[i].execute(input);
        }
    }

    public Closure<? super T>[] getClosures() {
        return this.iClosures;
    }
}

