/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;

public class FactoryTransformer<I, T>
implements Transformer<I, T>,
Serializable {
    static final long serialVersionUID = -6817674502475353160L;
    private final Factory<T> iFactory;

    public static <K, T> Transformer<K, T> getInstance(Factory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        return new FactoryTransformer(factory);
    }

    public FactoryTransformer(Factory<T> factory) {
        this.iFactory = factory;
    }

    @Override
    public T transform(I input) {
        return this.iFactory.create();
    }

    public Factory<T> getFactory() {
        return this.iFactory;
    }
}

