/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

public class PredicateTransformer<T>
implements Transformer<T, Boolean>,
Serializable {
    static final long serialVersionUID = 5278818408044349346L;
    private final Predicate<T> iPredicate;

    public static <T> Transformer<T, Boolean> getInstance(Predicate<T> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        return new PredicateTransformer<T>(predicate);
    }

    public PredicateTransformer(Predicate<T> predicate) {
        this.iPredicate = predicate;
    }

    @Override
    public Boolean transform(T input) {
        return this.iPredicate.evaluate(input) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Predicate<T> getPredicate() {
        return this.iPredicate;
    }
}

