/*
 * Decompiled with CFR 0.152.
 */
package rfb;

public class LogWriter {
    String name;
    int level;
    LogWriter next;
    static LogWriter log_writers;
    static int globalLogLevel;

    public LogWriter(String name_) {
        this.name = name_;
        this.level = globalLogLevel;
        this.next = log_writers;
        log_writers = this;
    }

    public void setLevel(int level_) {
        this.level = level_;
    }

    public void write(int level, String str) {
        if (level <= this.level) {
            System.err.println(this.name + ": " + str);
        }
    }

    public void error(String str) {
        this.write(0, str);
    }

    public void status(String str) {
        this.write(10, str);
    }

    public void info(String str) {
        this.write(30, str);
    }

    public void debug(String str) {
        this.write(100, str);
    }

    public static boolean setLogParams(String params) {
        globalLogLevel = Integer.parseInt(params);
        LogWriter current = log_writers;
        while (current != null) {
            current.setLevel(globalLogLevel);
            current = current.next;
        }
        return true;
    }

    static LogWriter getLogWriter(String name) {
        LogWriter current = log_writers;
        while (current != null) {
            if (name.equalsIgnoreCase(current.name)) {
                return current;
            }
            current = current.next;
        }
        return null;
    }

    static {
        globalLogLevel = 30;
    }
}

