/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import vncviewer.Dialog;
import vncviewer.OptionsDialogCallback;

class OptionsDialog
extends Dialog {
    OptionsDialogCallback cb;
    Button encodingSel;
    Button inputSel;
    Button miscSel;
    GridBagConstraints mainGBC;
    GridBagLayout panelGB;
    GridBagConstraints panelGBC;
    Panel cardPanel;
    Panel panel;
    Checkbox autoSelect;
    CheckboxGroup encodingGroup;
    CheckboxGroup colourGroup;
    Checkbox zrle;
    Checkbox hextile;
    Checkbox raw;
    Checkbox fullColour;
    Checkbox mediumColour;
    Checkbox lowColour;
    Checkbox veryLowColour;
    Checkbox viewOnly;
    Checkbox acceptClipboard;
    Checkbox sendClipboard;
    Checkbox shared;
    Checkbox useLocalCursor;
    Checkbox fastCopyRect;
    Button okButton;
    Button cancelButton;

    public OptionsDialog(OptionsDialogCallback cb_) {
        super(false);
        this.cb = cb_;
        this.setTitle("VNC Viewer: Connection Options");
        this.setLayout(new BorderLayout());
        Panel tabPanel = new Panel();
        this.encodingSel = new Button("Encoding");
        tabPanel.add(this.encodingSel);
        this.inputSel = new Button("Inputs");
        tabPanel.add(this.inputSel);
        this.miscSel = new Button("Misc");
        tabPanel.add(this.miscSel);
        this.add((Component)tabPanel, "North");
        this.cardPanel = new Panel();
        this.cardPanel.setLayout(new CardLayout());
        this.add((Component)this.cardPanel, "Center");
        this.mainGBC = new GridBagConstraints();
        this.mainGBC.gridwidth = 0;
        this.mainGBC.anchor = 17;
        this.mainGBC.ipadx = 2;
        this.mainGBC.ipady = 2;
        this.startPanel("Encoding and Colour Level:");
        this.panelGBC.gridwidth = 1;
        this.autoSelect = this.addCheckbox("Auto select");
        this.encodingGroup = new CheckboxGroup();
        this.colourGroup = new CheckboxGroup();
        this.panelGBC.gridwidth = 0;
        this.fullColour = this.addRadioCheckbox("Full (all available colours)", this.colourGroup);
        this.panelGBC.gridwidth = 1;
        this.zrle = this.addRadioCheckbox("ZRLE", this.encodingGroup);
        this.panelGBC.gridwidth = 0;
        this.mediumColour = this.addRadioCheckbox("Medium (256 colours)", this.colourGroup);
        this.panelGBC.gridwidth = 1;
        this.hextile = this.addRadioCheckbox("Hextile", this.encodingGroup);
        this.panelGBC.gridwidth = 0;
        this.lowColour = this.addRadioCheckbox("Low (64 colours)", this.colourGroup);
        this.panelGBC.gridwidth = 1;
        this.raw = this.addRadioCheckbox("Raw", this.encodingGroup);
        this.panelGBC.gridwidth = 0;
        this.veryLowColour = this.addRadioCheckbox("Very low (8 colours)", this.colourGroup);
        this.startPanel("Inputs:");
        this.viewOnly = this.addCheckbox("View only (ignore mouse & keyboard)");
        this.acceptClipboard = this.addCheckbox("Accept clipboard from server");
        this.sendClipboard = this.addCheckbox("Send clipboard to server");
        this.startPanel("Misc:");
        this.shared = this.addCheckbox("Shared (don't disconnect other viewers)");
        this.useLocalCursor = this.addCheckbox("Render cursor locally");
        this.fastCopyRect = this.addCheckbox("Fast CopyRect");
        Panel pb = new Panel();
        this.okButton = new Button("OK");
        pb.add(this.okButton);
        this.cancelButton = new Button("Cancel");
        pb.add(this.cancelButton);
        this.add((Component)pb, "South");
        this.pack();
        this.makeBold(this.encodingSel);
    }

    @Override
    public void initDialog() {
        if (this.cb != null) {
            this.cb.setOptions();
        }
        this.zrle.setEnabled(!this.autoSelect.getState());
        this.hextile.setEnabled(!this.autoSelect.getState());
        this.raw.setEnabled(!this.autoSelect.getState());
    }

    void startPanel(String title) {
        this.panelGB = new GridBagLayout();
        this.panel = new Panel(this.panelGB);
        this.cardPanel.add((Component)this.panel, title);
        this.panelGBC = new GridBagConstraints();
        this.panelGBC.gridwidth = 0;
        this.panelGBC.anchor = 17;
        this.panelGBC.ipadx = 2;
        this.panelGBC.ipady = 2;
        this.panelGBC.insets = new Insets(0, 4, 0, 0);
        Label l = new Label(title);
        this.panelGB.setConstraints(l, this.panelGBC);
        this.panel.add(l);
    }

    Checkbox addCheckbox(String str) {
        Checkbox c = new Checkbox(str);
        this.panelGB.setConstraints(c, this.panelGBC);
        this.panel.add(c);
        return c;
    }

    Checkbox addRadioCheckbox(String str, CheckboxGroup group) {
        Checkbox c = new Checkbox(str, group, false);
        this.panelGB.setConstraints(c, this.panelGBC);
        this.panel.add(c);
        return c;
    }

    @Override
    public boolean action(Event event, Object arg) {
        if (event.target == this.okButton) {
            this.ok = true;
            if (this.cb != null) {
                this.cb.getOptions();
            }
            this.endDialog();
        } else if (event.target == this.cancelButton) {
            this.ok = false;
            this.endDialog();
        } else if (event.target == this.autoSelect) {
            this.zrle.setEnabled(!this.autoSelect.getState());
            this.hextile.setEnabled(!this.autoSelect.getState());
            this.raw.setEnabled(!this.autoSelect.getState());
        } else if (event.target == this.encodingSel) {
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "Encoding and Colour Level:");
            this.makeBold(this.encodingSel);
        } else if (event.target == this.inputSel) {
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "Inputs:");
            this.makeBold(this.inputSel);
        } else if (event.target == this.miscSel) {
            ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, "Misc:");
            this.makeBold(this.miscSel);
        }
        return true;
    }

    private void makeBold(Button b) {
        int size = b.getFont().getSize();
        String name = b.getFont().getName();
        this.encodingSel.setFont(new Font(name, b == this.encodingSel ? 1 : 0, size));
        this.inputSel.setFont(new Font(name, b == this.inputSel ? 1 : 0, size));
        this.miscSel.setFont(new Font(name, b == this.miscSel ? 1 : 0, size));
    }
}

