#ifndef _ASM_X86_CPUFEATUREMASKS_H
#define _ASM_X86_CPUFEATUREMASKS_H

/*
 * REQUIRED features:
 *
 *    FPU CX8 CMOV ALWAYS
 */
#define REQUIRED_MASK0	0x00008101U
#define REQUIRED_MASK1	0x00000000U
#define REQUIRED_MASK2	0x00000000U
#define REQUIRED_MASK3	0x00200000U
#define REQUIRED_MASK4	0x00000000U
#define REQUIRED_MASK5	0x00000000U
#define REQUIRED_MASK6	0x00000000U
#define REQUIRED_MASK7	0x00000000U
#define REQUIRED_MASK8	0x00000000U
#define REQUIRED_MASK9	0x00000000U
#define REQUIRED_MASK10	0x00000000U
#define REQUIRED_MASK11	0x00000000U
#define REQUIRED_MASK12	0x00000000U
#define REQUIRED_MASK13	0x00000000U
#define REQUIRED_MASK14	0x00000000U
#define REQUIRED_MASK15	0x00000000U
#define REQUIRED_MASK16	0x00000000U
#define REQUIRED_MASK17	0x00000000U
#define REQUIRED_MASK18	0x00000000U
#define REQUIRED_MASK19	0x00000000U
#define REQUIRED_MASK20	0x00000000U
#define REQUIRED_MASK21	0x00000000U

#define REQUIRED_MASK_BIT_SET(x)			\
	((						\
		((x) >> 5) ==  0 ? REQUIRED_MASK0 :	\
		((x) >> 5) ==  3 ? REQUIRED_MASK3 : 0	\
	) & (1U << ((x) & 31)))

/*
 * DISABLED features:
 *
 *    PCID PTI XENPV TDX_GUEST SGX UNRET CALL_DEPTH USER_SHSTK FRED LAM
 *    INVLPGB PKU OSPKE LA57 ENQCMD IBT SEV_SNP
 */
#define DISABLED_MASK0	0x00000000U
#define DISABLED_MASK1	0x00000000U
#define DISABLED_MASK2	0x00000000U
#define DISABLED_MASK3	0x00000000U
#define DISABLED_MASK4	0x00020000U
#define DISABLED_MASK5	0x00000000U
#define DISABLED_MASK6	0x00000000U
#define DISABLED_MASK7	0x00000800U
#define DISABLED_MASK8	0x00410000U
#define DISABLED_MASK9	0x00000004U
#define DISABLED_MASK10	0x00000000U
#define DISABLED_MASK11	0x00888000U
#define DISABLED_MASK12	0x04020000U
#define DISABLED_MASK13	0x00000008U
#define DISABLED_MASK14	0x00000000U
#define DISABLED_MASK15	0x00000000U
#define DISABLED_MASK16	0x20010018U
#define DISABLED_MASK17	0x00000000U
#define DISABLED_MASK18	0x00100000U
#define DISABLED_MASK19	0x00000010U
#define DISABLED_MASK20	0x00000000U
#define DISABLED_MASK21	0x00000000U

#define DISABLED_MASK_BIT_SET(x)			\
	((						\
		((x) >> 5) ==  4 ? DISABLED_MASK4 :	\
		((x) >> 5) ==  7 ? DISABLED_MASK7 :	\
		((x) >> 5) ==  8 ? DISABLED_MASK8 :	\
		((x) >> 5) ==  9 ? DISABLED_MASK9 :	\
		((x) >> 5) == 11 ? DISABLED_MASK11 :	\
		((x) >> 5) == 12 ? DISABLED_MASK12 :	\
		((x) >> 5) == 13 ? DISABLED_MASK13 :	\
		((x) >> 5) == 16 ? DISABLED_MASK16 :	\
		((x) >> 5) == 18 ? DISABLED_MASK18 :	\
		((x) >> 5) == 19 ? DISABLED_MASK19 : 0	\
	) & (1U << ((x) & 31)))

#endif /* _ASM_X86_CPUFEATUREMASKS_H */
