/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"

/* prologue */
#include "desktop/gui_internal.h"
#include "desktop/gui_table.h"
#include "netsurf/bitmap.h"
#include "utils/corestrings.h"
/* It's a smidge naughty of us to read
 * this particular header, but we're needing
 * to redraw the node we represent
 */
#include "content/handlers/html/private.h"

static void redraw_node(dom_node *node)
{
	struct box *box = NULL;
	html_content *htmlc = NULL;
	dom_exception exc;
	dom_document *doc;

	exc = dom_node_get_user_data(node,
				     corestring_dom___ns_key_box_node_data,
				     &box);
	if (exc != DOM_NO_ERR || box == NULL) {
		return;
	}

	exc = dom_node_get_owner_document(node, &doc);
	if (exc != DOM_NO_ERR || doc == NULL) {
		return;
	}

	exc = dom_node_get_user_data(doc,
				     corestring_dom___ns_key_html_content_data,
				     &htmlc);
	if (exc != DOM_NO_ERR || htmlc == NULL) {
		dom_node_unref(doc);
		return;
	}

	html__redraw_a_box(htmlc, box);

	dom_node_unref(doc);
}

/**
 * deal with events from the DOM for canvas node user data
 *
 * \param operation The DOM operation happening
 * \param key The user data key
 * \param data The user data (our bitmap)
 * \param src The DOM node emitting the event (our <canvas>)
 * \param dst The target DOM node if applicable
 */
static void
canvas2d_user_data_handler(dom_node_operation operation,
			   dom_string *key,
			   void *data,
			   struct dom_node *src,
			   struct dom_node *dst)
{
	struct bitmap *newbitmap, *bitmap = (struct bitmap*)data, *oldbitmap = NULL;
	int width, height;
	size_t stride;

	if (dom_string_isequal(key,corestring_dom___ns_key_canvas_node_data) == false || data == NULL) {
		/* Not for us */
		return;
	}

	switch (operation) {
	case DOM_NODE_CLONED:
		width = guit->bitmap->get_width(bitmap);
		height = guit->bitmap->get_height(bitmap);
		stride = guit->bitmap->get_rowstride(bitmap);
		newbitmap = guit->bitmap->create(width, height,
						 BITMAP_NEW);
		if (newbitmap != NULL) {
			if (guit->bitmap->get_rowstride(newbitmap) == stride) {
				// Compatible bitmap, bung the data over
				memcpy(guit->bitmap->get_buffer(newbitmap),
				       guit->bitmap->get_buffer(bitmap),
				       stride * height);
				guit->bitmap->modified(newbitmap);
			}
		}
		if (dom_node_set_user_data(dst,
					   corestring_dom___ns_key_canvas_node_data,
					   newbitmap, canvas2d_user_data_handler,
					   &oldbitmap) == DOM_NO_ERR) {
			if (oldbitmap != NULL)
				guit->bitmap->destroy(oldbitmap);
		}
		break;

	case DOM_NODE_RENAMED:
	case DOM_NODE_IMPORTED:
	case DOM_NODE_ADOPTED:
		break;

	case DOM_NODE_DELETED:
		guit->bitmap->destroy(bitmap);
		break;
	default:
		NSLOG(netsurf, INFO, "User data operation not handled.");
		assert(0);
	}
}

/**
 * Give the canvas element an appropriately sized bitmap
 *
 * \param node The DOM node being inserted
 * \param[out] bitmap_out The bitmap created
 * \return NSERROR_OK on success else appropriate error code
 */
static nserror canvas2d_create_bitmap(dom_node *node, struct bitmap **bitmap_out)
{
	dom_exception exc;
	dom_string *width_s = NULL, *height_s = NULL;
	unsigned long width = 300, height = 150;
	struct bitmap *bitmap, *oldbitmap = NULL;

	exc = dom_element_get_attribute(node,
					corestring_dom_width,
					&width_s);
	if (exc == DOM_NO_ERR && width_s != NULL) {
		const char *ptr = (const char *)dom_string_data(width_s);
		const char *endptr = ptr + dom_string_length(width_s);
		char * ended;
		unsigned long width_n = strtoul(ptr, &ended, 10);

		if (ended == endptr || strcasecmp(ended, "px") == 0) {
			/* parsed it all */
			width = width_n;
		}

		dom_string_unref(width_s);
	}

	exc = dom_element_get_attribute(node,
					corestring_dom_height,
					&height_s);
	if (exc == DOM_NO_ERR && height_s != NULL) {
		const char *ptr = (const char *)dom_string_data(height_s);
		const char *endptr = ptr + dom_string_length(height_s);
		char * ended;
		unsigned long height_n = strtoul(ptr, &ended, 10);

		if (ended == endptr || strcasecmp(ended, "px") == 0) {
			/* parsed it all */
			height = height_n;
		}

		dom_string_unref(height_s);
	}

	bitmap = guit->bitmap->create(
		(int)width, (int)height,
		BITMAP_NEW);

	if (bitmap == NULL) {
		return NSERROR_NOMEM;
	}

	memset(guit->bitmap->get_buffer(bitmap),
	       0, /* Transparent black */
	       height * guit->bitmap->get_rowstride(bitmap));
	guit->bitmap->modified(bitmap);

	exc = dom_node_set_user_data(node,
				     corestring_dom___ns_key_canvas_node_data,
				     bitmap,
				     canvas2d_user_data_handler,
				     &oldbitmap);

	if (exc != DOM_NO_ERR) {
		guit->bitmap->destroy(bitmap);
		return NSERROR_DOM;
	}

	assert(oldbitmap == NULL);

	if (bitmap_out != NULL)
		*bitmap_out = bitmap;

	return NSERROR_OK;
}

/**
 * Handle subtree modified events for our canvas node
 *
 * If width or height has changed relative to our priv, then
 * we need to recreate the bitmap and reset our cached width
 * and height values in order to be safe.  Plus redraw ourselves.
 *
 * \param evt The event which occurred
 * \param pw The private pointer for our canvas object
 */
static void
canvas2d__handle_dom_event(dom_event *evt, void *pw)
{
	canvas_rendering_context2d_private_t *priv = pw;
	dom_ulong width;
	dom_ulong height;
	dom_exception exc;
	struct bitmap *newbitmap, *oldbitmap = NULL;
	size_t stride;
	dom_event_flow_phase phase;
	
	exc = dom_event_get_event_phase(evt, &phase);
	assert(exc == DOM_NO_ERR);
	/* If we're not being hit right now, we're not up for it */
	if (phase != DOM_AT_TARGET) return;
	
	/* Rather than being complex about things, let's just work out
	 * what the width and height are and hope nothing else matters
	 */
	
	exc = dom_html_canvas_element_get_width(priv->canvas, &width);
	if (exc != DOM_NO_ERR) return;
	exc = dom_html_canvas_element_get_height(priv->canvas, &height);
	if (exc != DOM_NO_ERR) return;
	
	if ((int)height == priv->height && (int)width == priv->width) return;
	
	/* Okay, we need to reallocate our bitmap and re-cache values */
	
	newbitmap = guit->bitmap->create(width, height, BITMAP_NEW);
	stride = guit->bitmap->get_rowstride(newbitmap);

	if (newbitmap != NULL) {
		memset(guit->bitmap->get_buffer(newbitmap),
		       0,
		       stride * height);
		guit->bitmap->modified(newbitmap);
	}

	if (dom_node_set_user_data(priv->canvas,
				   corestring_dom___ns_key_canvas_node_data,
				   newbitmap, canvas2d_user_data_handler,
				   &oldbitmap) == DOM_NO_ERR) {
		if (oldbitmap != NULL)
			guit->bitmap->destroy(oldbitmap);
	} else {
		guit->bitmap->destroy(newbitmap);
		/* We'll stick with the old, odd though that might be */
		return;
	}

	/* Cache the new values */
	priv->width = (int)width;
	priv->height = (int)height;
	priv->stride = stride;
	priv->bitmap = newbitmap;
}

typedef struct {
	uint8_t *ptr;
	size_t stride;
	ssize_t width;
	ssize_t height;
} raw_bitmap;

typedef struct {
	raw_bitmap src;
	raw_bitmap dst;
	/* These are relative to the destination top/left */
	ssize_t dst_x;
	ssize_t dst_y;
	/* These are relative to the source top/left */
	ssize_t x1;
	ssize_t y1;
	/* And these are +1, so a 1x1 copy will have x2==x1+1 etc */
	ssize_t x2;
	ssize_t y2;
} copy_operation;

/**
 * Copy from src to dst
 *
 * Note, this is destructive to its copy_operation input
 *
 * \param op The copy operation to perform
 * \return Whether the destination bitmap was altered
 */
static bool
canvas2d__copy_bitmap_to_bitmap(copy_operation *op)
{
	/* Constrain src rectangle to src bitmap size */
	if (op->x1 < 0) op->x1 = 0;
	if (op->y1 < 0) op->y1 = 0;
	if (op->x2 > op->src.width) op->x2 = op->src.width;
	if (op->y2 > op->src.height) op->y2 = op->src.height;
	/* Offset the rectangle into dst coordinates */
	op->x1 += op->dst_x;
	op->x2 += op->dst_x;
	op->y1 += op->dst_y;
	op->y2 += op->dst_y;
	/* Constrain dst rectangle to dst bitmap */
	if (op->x1 < 0) op->x1 = 0;
	if (op->y1 < 0) op->y1 = 0;
	if (op->x2 > op->dst.width) op->x2 = op->dst.width;
	if (op->y2 > op->dst.height) op->y2 = op->dst.height;
	/* If we have nothing to copy, stop now */
	if ((op->x2 - op->x1) < 1 ||
	    (op->y2 - op->y1) < 1)
		return false;
	/* Okay, stuff to copy, so let's begin */
	op->src.ptr +=
		(op->src.stride * (op->y1 - op->dst_y)) + /* move down y1 rows */
		(op->x1 - op->dst_x) * 4; /* and across x1 pixels */
	op->dst.ptr +=
		(op->dst.stride * op->y1) + /* down down y1 rows */
		(op->x1 * 4); /* and across x1 pixels */
	for (ssize_t rowctr = op->y2 - op->y1; rowctr > 0; --rowctr) {
		memcpy(op->dst.ptr, op->src.ptr, (op->x2 - op->x1) * 4);
		op->src.ptr += op->src.stride;
		op->dst.ptr += op->dst.stride;
	}
	return true;
}

/* prologue ends */

static void dukky_canvas_rendering_context2d___init(duk_context *ctx, canvas_rendering_context2d_private_t *priv, struct dom_html_canvas_element *canvas)
{
#line 345 "CanvasRenderingContext2D.bnd"

	struct bitmap *bitmap;
	dom_exception exc;

	assert(canvas != NULL);
	
	priv->canvas = canvas;
	dom_node_ref(canvas);
	
	exc = dom_event_listener_create(canvas2d__handle_dom_event,
					priv,
					&priv->listener);
	assert(exc == DOM_NO_ERR);
	
	exc = dom_event_target_add_event_listener(
		canvas,
		corestring_dom_DOMSubtreeModified,
		priv->listener,
		false);
	assert(exc == DOM_NO_ERR);
	
	exc = dom_node_get_user_data(canvas,
				     corestring_dom___ns_key_canvas_node_data,
				     &bitmap);
	assert(exc == DOM_NO_ERR);
	
	if (bitmap == NULL) {
		if (canvas2d_create_bitmap((dom_node *)canvas,
					   &bitmap) != NSERROR_OK) {
			priv->bitmap = NULL;
			priv->width = -1;
			priv->height = -1;
			priv->stride = 0;
			return;
		}
	}

	assert(bitmap != NULL);
	
	priv->bitmap = bitmap;
	priv->width = guit->bitmap->get_width(bitmap);
	priv->height = guit->bitmap->get_height(bitmap);
	priv->stride = guit->bitmap->get_rowstride(bitmap);
#line 413 "canvas_rendering_context2d.c"
}

static void dukky_canvas_rendering_context2d___fini(duk_context *ctx, canvas_rendering_context2d_private_t *priv)
{

	dom_exception exc;
	exc = dom_event_target_remove_event_listener(
		priv->canvas,
		corestring_dom_DOMSubtreeModified,
		priv->listener,
		false);
	assert(exc == DOM_NO_ERR);
	dom_event_listener_unref(priv->listener);
	dom_node_unref(priv->canvas);
}

static duk_ret_t dukky_canvas_rendering_context2d___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	canvas_rendering_context2d_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_canvas_rendering_context2d___init(ctx, priv, duk_get_pointer(ctx, 1));
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_canvas_rendering_context2d___destructor(duk_context *ctx)
{
	canvas_rendering_context2d_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_canvas_rendering_context2d___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_commit(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_save(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_restore(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_scale(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_rotate(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "angle");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_translate(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_transform(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 6) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 6, dukky_argc);
	} else if (dukky_argc > 6) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 6);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "a");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "b");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "c");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "d");
		}
	}
	if (dukky_argc > 4) {
		if (!duk_is_number(ctx, 4)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 4, "e");
		}
	}
	if (dukky_argc > 5) {
		if (!duk_is_number(ctx, 5)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 5, "f");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_setTransform(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 6) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 6, dukky_argc);
	} else if (dukky_argc > 6) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 6);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "a");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "b");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "c");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "d");
		}
	}
	if (dukky_argc > 4) {
		if (!duk_is_number(ctx, 4)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 4, "e");
		}
	}
	if (dukky_argc > 5) {
		if (!duk_is_number(ctx, 5)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 5, "f");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_resetTransform(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_createLinearGradient(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 4) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 4, dukky_argc);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x0");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y0");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "x1");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "y1");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_createRadialGradient(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 6) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 6, dukky_argc);
	} else if (dukky_argc > 6) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 6);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x0");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y0");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "r0");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "x1");
		}
	}
	if (dukky_argc > 4) {
		if (!duk_is_number(ctx, 4)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 4, "y1");
		}
	}
	if (dukky_argc > 5) {
		if (!duk_is_number(ctx, 5)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 5, "r1");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_createPattern(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_clearRect(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 4) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 4, dukky_argc);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "w");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "h");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_fillRect(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 4) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 4, dukky_argc);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "w");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "h");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_strokeRect(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 4) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 4, dukky_argc);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "w");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "h");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_beginPath(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_fill(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_stroke(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_drawFocusIfNeeded(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_scrollPathIntoView(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_clip(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_resetClip(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_isPointInPath(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_isPointInStroke(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_fillText(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 3) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 3, dukky_argc);
	} else if (dukky_argc == 3) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "x");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "y");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "maxWidth");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_strokeText(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 3) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 3, dukky_argc);
	} else if (dukky_argc == 3) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "x");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "y");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "maxWidth");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_measureText(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_drawImage(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_addHitRegion(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_removeHitRegion(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_clearHitRegions(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_createImageData(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 456 "CanvasRenderingContext2D.bnd"

	/* Can be called either with width and height, or with a reference
	 * imagedata object
	 */
	image_data_private_t *idpriv;
	int width, height;

	if (duk_get_top(ctx) == 2) {
		width = duk_to_int(ctx, 0);
		height = duk_to_int(ctx, 1);
	} else if (dukky_instanceof(ctx, 0, PROTO_NAME(IMAGEDATA))) {
		duk_get_prop_string(ctx, 0, dukky_magic_string_private);
		idpriv = duk_get_pointer(ctx, -1);
		width = idpriv->width;
		height = idpriv->height;
		duk_pop(ctx);
	} else {
		duk_push_null(ctx);
		return 1;
	}

	duk_push_int(ctx, width);
	duk_push_int(ctx, height);
	if (dukky_create_object(ctx,
				PROTO_NAME(IMAGEDATA),
				2) != DUK_EXEC_SUCCESS) {
		return duk_error(ctx,
				 DUK_ERR_ERROR,
				 "Unable to create ImageData");
	}
	return 1;
#line 1459 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_getImageData(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 4) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 4, dukky_argc);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "sx");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "sy");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "sw");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "sh");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 490 "CanvasRenderingContext2D.bnd"

	/* called with x, y, width, height */
	int x = duk_get_int(ctx, 0);
	int y = duk_get_int(ctx, 1);
	int width = duk_get_int(ctx, 2);
	int height = duk_get_int(ctx, 3);
	image_data_private_t *idpriv;
	copy_operation copyop;

	if (priv->bitmap == NULL)
		return duk_generic_error(ctx, "Canvas in bad state, sorry");

	duk_push_int(ctx, width);
	duk_push_int(ctx, height);
	if (dukky_create_object(ctx,
				PROTO_NAME(IMAGEDATA),
				2) != DUK_EXEC_SUCCESS) {
		return duk_error(ctx,
				 DUK_ERR_ERROR,
				 "Unable to create ImageData");
	}

	/* ... imgdata */
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	idpriv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	/* We now have access to the imagedata private, so we need to copy
	 * the pixel range out of ourselves
	 */
	copyop.src.ptr = guit->bitmap->get_buffer(priv->bitmap);
	copyop.src.stride = priv->stride;
	copyop.src.width = priv->width;
	copyop.src.height = priv->height;

	copyop.dst.ptr = idpriv->data;
	copyop.dst.stride = idpriv->width * 4;
	copyop.dst.width = idpriv->width;
	copyop.dst.height = idpriv->height;

	/* Copying to top/left of our new bitmap */
	copyop.dst_x = 0;
	copyop.dst_y = 0;

	/* Copying from x,y for width,height */
	copyop.x1 = x;
	copyop.x2 = x + width;
	copyop.y1 = y;
	copyop.y2 = y + height;

	/* We don't care if the copy operation wrote or not because
	 * we don't need to invalidate ImageData objects
	 */
	(void)canvas2d__copy_bitmap_to_bitmap(&copyop);
	return 1;
#line 1561 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_putImageData(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 548 "CanvasRenderingContext2D.bnd"

	/* imgdata, x, y[, clipx, clipy, clipw, cliph] */
	/* If provided, the clip coordinates are within the input image data */
	/* We pretend the image is placed at x,y within ourselves, and then we
	 * copy the clip rectangle (defaults to whole image)
	 */
	image_data_private_t *idpriv;
	copy_operation copyop;

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(IMAGEDATA))) {
		return duk_generic_error(ctx, "Expected ImageData as first argument");
	}

	if (priv->bitmap == NULL)
		return duk_generic_error(ctx, "Canvas in bad state, sorry");

	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	idpriv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	/* Copying from the input ImageData object */
	copyop.src.ptr = idpriv->data;
	copyop.src.stride = idpriv->width * 4;
	copyop.src.width = idpriv->width;
	copyop.src.height = idpriv->height;

	/* Copying to ourselves */
	copyop.dst.ptr = guit->bitmap->get_buffer(priv->bitmap);
	copyop.dst.stride = priv->stride;
	copyop.dst.width = priv->width;
	copyop.dst.height = priv->height;

	/* X Y target coordinates */
	copyop.dst_x = duk_to_int(ctx, 1);
	copyop.dst_y = duk_to_int(ctx, 2);

	if (duk_get_top(ctx) < 7) {
		/* Clipping data not provided */
		copyop.x1 = 0;
		copyop.y1 = 0;
		copyop.x2 = idpriv->width;
		copyop.y2 = idpriv->height;
	} else {
		copyop.x1 = duk_to_int(ctx, 3);
		copyop.y1 = duk_to_int(ctx, 4);
		copyop.x2 = copyop.x1 + duk_to_int(ctx, 5);
		copyop.y2 = copyop.y1 + duk_to_int(ctx, 6);
	}

	if (canvas2d__copy_bitmap_to_bitmap(&copyop)) {
		guit->bitmap->modified(priv->bitmap);
		redraw_node((dom_node *)(priv->canvas));
	}

	return 0;
#line 1632 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_setLineDash(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_getLineDash(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_closePath(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_moveTo(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineTo(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_quadraticCurveTo(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 4) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 4, dukky_argc);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "cpx");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "cpy");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "x");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "y");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_bezierCurveTo(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 6) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 6, dukky_argc);
	} else if (dukky_argc > 6) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 6);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "cp1x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "cp1y");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "cp2x");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "cp2y");
		}
	}
	if (dukky_argc > 4) {
		if (!duk_is_number(ctx, 4)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 4, "x");
		}
	}
	if (dukky_argc > 5) {
		if (!duk_is_number(ctx, 5)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 5, "y");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_arcTo(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_rect(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 4) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 4, dukky_argc);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "w");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "h");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_arc(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 5) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 5, dukky_argc);
	} else if (dukky_argc == 5) {
		/* 1 optional arguments need adding */
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc > 6) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 6);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "radius");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "startAngle");
		}
	}
	if (dukky_argc > 4) {
		if (!duk_is_number(ctx, 4)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 4, "endAngle");
		}
	}
	if (dukky_argc > 5) {
		if (!duk_is_boolean(ctx, 5)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 5, "anticlockwise");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_ellipse(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 7) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 7, dukky_argc);
	} else if (dukky_argc == 7) {
		/* 1 optional arguments need adding */
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc > 8) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 8);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "x");
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_number(ctx, 1)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 1, "y");
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_number(ctx, 2)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 2, "radiusX");
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_number(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 3, "radiusY");
		}
	}
	if (dukky_argc > 4) {
		if (!duk_is_number(ctx, 4)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 4, "rotation");
		}
	}
	if (dukky_argc > 5) {
		if (!duk_is_number(ctx, 5)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 5, "startAngle");
		}
	}
	if (dukky_argc > 6) {
		if (!duk_is_number(ctx, 6)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 6, "endAngle");
		}
	}
	if (dukky_argc > 7) {
		if (!duk_is_boolean(ctx, 7)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 7, "anticlockwise");
		}
	}
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_canvas_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 404 "CanvasRenderingContext2D.bnd"

	dukky_push_node(ctx, (dom_node *)priv->canvas);
	return 1;
#line 2089 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_width_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 410 "CanvasRenderingContext2D.bnd"

	dom_exception exc;
	dom_ulong width;
	
	exc = dom_html_canvas_element_get_width(priv->canvas, &width);
	if (exc != DOM_NO_ERR) return 0;
	
	duk_push_number(ctx, (duk_double_t)width);
	return 1;
#line 2114 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_width_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 422 "CanvasRenderingContext2D.bnd"

	dom_exception exc;
	dom_ulong width = duk_get_uint(ctx, 0);

	exc = dom_html_canvas_element_set_width(priv->canvas, width);
	if (exc != DOM_NO_ERR) return 0;

	return 1;
#line 2138 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_height_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 433 "CanvasRenderingContext2D.bnd"

	dom_exception exc;
	dom_ulong height;
	
	exc = dom_html_canvas_element_get_height(priv->canvas, &height);
	if (exc != DOM_NO_ERR) return 0;
	
	duk_push_number(ctx, (duk_double_t)height);
	return 1;
#line 2163 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_height_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 445 "CanvasRenderingContext2D.bnd"

	dom_exception exc;
	dom_ulong height = duk_get_uint(ctx, 0);

	exc = dom_html_canvas_element_set_height(priv->canvas, height);
	if (exc != DOM_NO_ERR) return 0;

	return 1;
#line 2187 "canvas_rendering_context2d.c"
}

static duk_ret_t dukky_canvas_rendering_context2d_currentTransform_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_currentTransform_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_globalAlpha_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_globalAlpha_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_globalCompositeOperation_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_globalCompositeOperation_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_imageSmoothingEnabled_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_imageSmoothingEnabled_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_imageSmoothingQuality_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_imageSmoothingQuality_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_strokeStyle_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_strokeStyle_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_fillStyle_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_fillStyle_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowOffsetX_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowOffsetX_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowOffsetY_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowOffsetY_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowBlur_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowBlur_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowColor_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_shadowColor_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineWidth_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineWidth_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineCap_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineCap_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineJoin_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineJoin_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_miterLimit_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_miterLimit_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineDashOffset_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_lineDashOffset_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_font_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_font_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_textAlign_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_textAlign_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_textBaseline_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_textBaseline_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_direction_getter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_canvas_rendering_context2d_direction_setter(duk_context *ctx)
{
	/* Get private data for method */
	canvas_rendering_context2d_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

duk_ret_t dukky_canvas_rendering_context2d___proto(duk_context *ctx, void *udata)
{
	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "commit");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_commit, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "save");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_save, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "restore");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_restore, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "scale");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_scale, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "rotate");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_rotate, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "translate");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_translate, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "transform");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_transform, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "setTransform");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_setTransform, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "resetTransform");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_resetTransform, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createLinearGradient");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_createLinearGradient, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createRadialGradient");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_createRadialGradient, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createPattern");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_createPattern, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "clearRect");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_clearRect, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "fillRect");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_fillRect, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "strokeRect");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_strokeRect, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "beginPath");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_beginPath, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "fill");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_fill, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "stroke");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_stroke, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "drawFocusIfNeeded");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_drawFocusIfNeeded, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "scrollPathIntoView");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_scrollPathIntoView, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "clip");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_clip, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "resetClip");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_resetClip, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "isPointInPath");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_isPointInPath, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "isPointInStroke");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_isPointInStroke, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "fillText");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_fillText, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "strokeText");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_strokeText, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "measureText");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_measureText, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "drawImage");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_drawImage, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "addHitRegion");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_addHitRegion, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "removeHitRegion");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_removeHitRegion, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "clearHitRegions");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_clearHitRegions, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createImageData");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_createImageData, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getImageData");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_getImageData, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "putImageData");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_putImageData, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "setLineDash");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_setLineDash, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getLineDash");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_getLineDash, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "closePath");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_closePath, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "moveTo");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_moveTo, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lineTo");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineTo, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "quadraticCurveTo");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_quadraticCurveTo, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "bezierCurveTo");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_bezierCurveTo, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "arcTo");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_arcTo, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "rect");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_rect, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "arc");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_arc, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ellipse");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_ellipse, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "canvas");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_canvas_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "width");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_width_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_width_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "height");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_height_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_height_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "currentTransform");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_currentTransform_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_currentTransform_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "globalAlpha");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_globalAlpha_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_globalAlpha_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "globalCompositeOperation");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_globalCompositeOperation_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_globalCompositeOperation_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "imageSmoothingEnabled");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_imageSmoothingEnabled_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_imageSmoothingEnabled_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "imageSmoothingQuality");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_imageSmoothingQuality_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_imageSmoothingQuality_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "strokeStyle");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_strokeStyle_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_strokeStyle_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "fillStyle");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_fillStyle_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_fillStyle_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "shadowOffsetX");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowOffsetX_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowOffsetX_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "shadowOffsetY");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowOffsetY_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowOffsetY_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "shadowBlur");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowBlur_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowBlur_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "shadowColor");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowColor_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_shadowColor_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lineWidth");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineWidth_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineWidth_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lineCap");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineCap_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineCap_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lineJoin");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineJoin_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineJoin_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "miterLimit");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_miterLimit_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_miterLimit_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lineDashOffset");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineDashOffset_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_lineDashOffset_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "font");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_font_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_font_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "textAlign");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_textAlign_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_textAlign_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "textBaseline");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_textBaseline_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_textBaseline_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "direction");
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_direction_getter, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d_direction_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_canvas_rendering_context2d___constructor, 2);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


