/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"

#include "utils/corestrings.h"
#include "utils/nsurl.h"
#include "netsurf/browser_window.h"
#include "content/hlcache.h"
#include "html/html.h"
#include "html/private.h"
#include "desktop/gui_internal.h"
#include "netsurf/misc.h"
#include "utils/ring.h"
#include "netsurf/inttypes.h"

#define WINDOW_CALLBACKS MAGIC(WindowCallbacks)
#define HANDLER_MAGIC MAGIC(HANDLER_MAP)

static size_t next_handle = 0;

typedef struct window_schedule_s {
	window_private_t *owner;
	duk_context *ctx;
	struct window_schedule_s *r_next;
	struct window_schedule_s *r_prev;
	size_t handle;
	int repeat_timeout;
	bool running;
} window_schedule_t;

static void window_remove_callback_bits(duk_context *ctx, size_t handle) {
	/* stack is ... */
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, WINDOW_CALLBACKS);
	/* stack is ..., win, cbt */
	duk_push_int(ctx, (duk_int_t)handle);
	/* ..., win, cbt, handle */
	duk_del_prop(ctx, -2);
	/* ..., win, cbt */
	duk_pop_2(ctx);
	/* ... */
}

static void
window_call_callback(duk_context *ctx, size_t handle, bool clear_entry)
{
	NSLOG(dukky, DEEPDEBUG, "ctx=%p, handle=%"PRIsizet, ctx, handle);
	/* Stack is ... */
	duk_push_global_object(ctx);
	/* ..., win */
	duk_get_prop_string(ctx, -1, WINDOW_CALLBACKS);
	/* ..., win, cbt */
	duk_push_int(ctx, (duk_int_t)handle);
	/* ..., win, cbt, handle */
	duk_get_prop(ctx, -2);
	/* ..., win, cbt, cbo */
	//dukky_log_stack_frame(ctx, "On entry to callback");
	/* ..., win, cbt, cbo */
	/* What we want to do is call cbo.func passing all of cbo.args */
	duk_get_prop_string(ctx, -1, "func");
	duk_get_prop_string(ctx, -2, "args");
	/* ..., win, cbt, cbo, func, argarr */
	duk_size_t arrlen = duk_get_length(ctx, -1);
	for (duk_size_t i = 0; i < arrlen; ++i) {
		duk_push_int(ctx, (duk_int_t)i);
		duk_get_prop(ctx, -(2+i));
	}
	/* ..., win, cbt, cbo, func, argarr, args... */
	duk_remove(ctx, -(arrlen+1));
	/* ..., win, cbt, cbo, func, args... */
	//dukky_log_stack_frame(ctx, "Just before call");
	(void) dukky_pcall(ctx, arrlen, true);
	/* ..., win, cbt, cbo, retval */
	if (clear_entry) {
		NSLOG(dukky, DEEPDEBUG, "Not recurring callback, removing from cbt");
		duk_pop_n(ctx, 2);
		/* ..., win, cbt */
		duk_push_int(ctx, (duk_int_t)handle);
		/* ..., win, cbt, handle */
		duk_del_prop(ctx, -2);
		/* ..., win, cbt */
		duk_pop_n(ctx, 2);
	} else {
		duk_pop_n(ctx, 4);
	}
	/* ... */
	//dukky_log_stack_frame(ctx, "On leaving callback");
}


static void
window_schedule_callback(void *p)
{
	window_schedule_t *priv = (window_schedule_t *)p;

	NSLOG(dukky, DEEPDEBUG,
	      "Entered window scheduler callback: %"PRIsizet, priv->handle);

	priv->running = true;
	window_call_callback(priv->ctx,
			     priv->handle,
			     priv->repeat_timeout == 0);
	priv->running = false;

	if (priv->repeat_timeout > 0) {
		/* Reschedule */
		NSLOG(dukky, DEEPDEBUG,
		      "Rescheduling repeating callback %"PRIsizet,
		      priv->handle);
		guit->misc->schedule(priv->repeat_timeout,
				     window_schedule_callback,
				     priv);
	} else {
		NSLOG(dukky, DEEPDEBUG,
		      "Removing completed callback %"PRIsizet, priv->handle);
		/* Remove this from the ring */
		RING_REMOVE(priv->owner->schedule_ring, priv);
		window_remove_callback_bits(priv->ctx, priv->handle);
		free(priv);
	}
}

static size_t
window_alloc_new_callback(duk_context *ctx,
			  window_private_t *window,
			  bool repeating,
			  int timeout)
{
	size_t new_handle = next_handle++;
	window_schedule_t *sched = calloc(sizeof *sched, 1);
	if (sched == NULL) {
		return new_handle;
	}
	sched->owner = window;
	sched->ctx = ctx;
	sched->handle = new_handle;
	sched->repeat_timeout = repeating ? timeout : 0;
	sched->running = false;

	RING_INSERT(window->schedule_ring, sched);

	/* Next, the duktape stack looks like: func, timeout, ...
	 * In order to proceed, we want to put into the WINDOW_CALLBACKS
	 * keyed by the handle, an object containing the call to make and
	 * the array of arguments to call the function with
	 */
	duk_idx_t nargs = duk_get_top(ctx) - 2;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, WINDOW_CALLBACKS);
	duk_push_int(ctx, (duk_int_t)new_handle);
	duk_push_object(ctx);
	/* stack is: func, timeout, ..., win, cbt, handle, cbo */

	/* put the function into the cbo */
	duk_dup(ctx, 0);
	duk_put_prop_string(ctx, -2, "func");

	/* Now the arguments */
	duk_push_array(ctx);
	for (duk_idx_t i = 0; i < nargs; ++i) {
		duk_dup(ctx, 2 + i); /* Dup the arg */
		duk_put_prop_index(ctx, -2, i); /* arr[i] = arg[i] */
	}
	duk_put_prop_string(ctx, -2, "args");
	/* stack is: func, timeout, ..., win, cbt, handle, cbo */
	duk_put_prop(ctx, -3);
	/* stack is: func, timeout, ..., win, cbt */
	duk_pop_2(ctx);
	/* And we're back to func, timeout, ... */

	guit->misc->schedule(timeout, window_schedule_callback, sched);
	NSLOG(dukky, DEEPDEBUG, "Scheduled callback %"PRIsizet" for %d ms from now", new_handle, timeout);

	return new_handle;
}

static void
window_remove_callback_by_handle(duk_context *ctx,
				 window_private_t *window,
				 size_t handle)
{
	int res;

	RING_ITERATE_START(window_schedule_t, window->schedule_ring, sched) {
		if (sched->handle == handle) {
			if (sched->running) {
				NSLOG(dukky, DEEPDEBUG,
				      "Cancelling in-train callback %"PRIsizet,
				      sched->handle);
				sched->repeat_timeout = 0;
			} else {
				NSLOG(dukky, DEEPDEBUG,
				      "Cancelled callback %"PRIsizet,
				      sched->handle);
				res = guit->misc->schedule(-1,
							   window_schedule_callback,
							   sched);
				assert(res == NSERROR_OK);
				RING_REMOVE(window->schedule_ring, sched);
				window_remove_callback_bits(ctx, sched->handle);
				free(sched);
			}
			RING_ITERATE_STOP(window->schedule_ring, sched);
		}
	} RING_ITERATE_END(window->schedule_ring, sched);
}

/* This is the dodgy thread closedown method */
static duk_ret_t dukky_window_closedown_thread(duk_context *ctx)
{
	window_private_t *priv = NULL;

	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);

	if (priv == NULL) {
		return 0;
	}

	priv->closed_down = true;

	NSLOG(dukky, DEEPDEBUG, "Closing down thread");
	while (priv->schedule_ring != NULL) {
		window_schedule_t *to_remove = NULL;
		// Find a schedule item to remove
		RING_ITERATE_START(window_schedule_t, priv->schedule_ring, sched) {
			if (sched->running == false) {
				// This one is not running, we can remove it
				to_remove = sched;
				RING_ITERATE_STOP(window->schedule_ring, sched);
			} else if (sched->repeat_timeout != 0) {
				// This one is running and has yet to be
				// cancelled, so prevent it rescheduling itself
				NSLOG(dukky, DEEPDEBUG,
				      "Cancelling in-train callback %"PRIsizet,
				      sched->handle);
				sched->repeat_timeout = 0;
			}
		} RING_ITERATE_END(priv->schedule_ring, sched);

		if (to_remove == NULL) {
			// We didn't find any non-running callbacks
			// so let's log that and break out of the closedown
			// loop so we can continue and hopefully close down
			NSLOG(dukky, DEEPDEBUG,
			      "Leaving in-train callbacks to unwind");
			break;
		}
		
		// Remove the handle we found, this will reduce the callback
		// scheduler ring by one and perhaps leave it empty so we can
		// finish the closedown.
		window_remove_callback_by_handle(ctx,
						 priv,
						 to_remove->handle);
	}

	return 0;
}


static void dukky_window___init(duk_context *ctx, window_private_t *priv, struct browser_window *win, struct html_content *htmlc)
{
	dukky_event_target___init(ctx, &priv->parent);
#line 279 "Window.bnd"

	/* It makes no sense if win or htmlc are NULL */
	assert(win != NULL);
	assert(htmlc != NULL);
	/* element window */
	priv->win = win;
	priv->htmlc = htmlc;
	priv->schedule_ring = NULL;
	priv->closed_down = false;
	NSLOG(netsurf, DEEPDEBUG, "win=%p htmlc=%p", priv->win, priv->htmlc);

	NSLOG(netsurf, DEEPDEBUG,
	      "URL is %s", nsurl_access(browser_window_access_url(priv->win)));
	duk_push_object(ctx);
	duk_put_prop_string(ctx, 0, WINDOW_CALLBACKS);
#line 322 "window.c"
}

static void dukky_window___fini(duk_context *ctx, window_private_t *priv)
{

	NSLOG(dukky, DEEPDEBUG, "Shutting down Window %p", priv->win);
	/* Cheaply iterate the schedule ring, cancelling any pending callbacks */
	while (priv->schedule_ring != NULL) {
		window_remove_callback_by_handle(ctx, priv, priv->schedule_ring->handle);
	}
	dukky_event_target___fini(ctx, &priv->parent);
}

static duk_ret_t dukky_window___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	window_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_window___init(ctx, priv, duk_get_pointer(ctx, 1), duk_get_pointer(ctx, 2));
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_window___destructor(duk_context *ctx)
{
	window_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_window___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_window_close(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_stop(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_focus(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_blur(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_open(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 4 optional arguments need adding */
		duk_push_string(ctx, "about:blank");
		duk_push_string(ctx, "_blank");
		duk_push_string(ctx, "");
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc == 1) {
		/* 3 optional arguments need adding */
		duk_push_string(ctx, "_blank");
		duk_push_string(ctx, "");
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc == 2) {
		/* 2 optional arguments need adding */
		duk_push_string(ctx, "");
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc == 3) {
		/* 1 optional arguments need adding */
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc > 4) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 4);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_string(ctx, 2)) {
			duk_to_string(ctx, 2);
		}
	}
	if (dukky_argc > 3) {
		if (!duk_is_boolean(ctx, 3)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 3, "replace");
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_alert(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 499 "Window.bnd"

	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		NSLOG(netsurf, INFO, "JS ALERT");
	} else {
		duk_size_t msg_len;
		const char *msg;

		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
		msg = duk_safe_to_lstring(ctx, 0, &msg_len);
		NSLOG(netsurf, INFO, "JS ALERT: %*s", (int)msg_len, msg);
	}
	return 0;
#line 543 "window.c"
}

static duk_ret_t dukky_window_confirm(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 1 optional arguments need adding */
		duk_push_string(ctx, "");
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_prompt(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 2 optional arguments need adding */
		duk_push_string(ctx, "");
		duk_push_string(ctx, "");
	} else if (dukky_argc == 1) {
		/* 1 optional arguments need adding */
		duk_push_string(ctx, "");
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_print(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_showModalDialog(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc == 1) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_requestAnimationFrame(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_cancelAnimationFrame(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "handle");
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_postMessage(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc == 2) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 3) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 3);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	if (dukky_argc > 2) {
		/* unhandled type check */
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_captureEvents(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_releaseEvents(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_getComputedStyle(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc == 1) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_btoa(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_atob(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_setTimeout(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 517 "Window.bnd"

	duk_idx_t argc = duk_get_top(ctx);
	duk_int_t timeout = 10;

	if (priv->closed_down == true) {
		return 0; /* coerced to undefined */
	}

	if (argc >= 2) {
		timeout = duk_get_int(ctx, 1);
	}
	/* func, [timeout, args...] */
	if (timeout < 10) { timeout = 10; }
	size_t handle = window_alloc_new_callback(ctx, priv, false, (int)timeout);

	duk_push_int(ctx, (duk_int_t)handle);
	return 1;
#line 946 "window.c"
}

static duk_ret_t dukky_window_clearTimeout(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 1 optional arguments need adding */
		duk_push_int(ctx, 0);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "handle");
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 557 "Window.bnd"

	duk_int_t handle = duk_get_int(ctx, 0);
	window_remove_callback_by_handle(ctx, priv, (size_t) handle);

	return 0;
#line 983 "window.c"
}

static duk_ret_t dukky_window_setInterval(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 537 "Window.bnd"

	duk_idx_t argc = duk_get_top(ctx);
	duk_int_t timeout = 10;

	if (priv->closed_down == true) {
		return 0; /* coerced to undefined */
	}

	if (argc >= 2) {
		timeout = duk_get_int(ctx, 1);
	}
	/* func, [timeout, args...] */
	if (timeout < 10) { timeout = 10; }
	size_t handle = window_alloc_new_callback(ctx, priv, true, (int)timeout);

	duk_push_int(ctx, (duk_int_t)handle);
	return 1;
#line 1016 "window.c"
}

static duk_ret_t dukky_window_clearInterval(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 1 optional arguments need adding */
		duk_push_int(ctx, 0);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "handle");
		}
	}
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 565 "Window.bnd"

	duk_int_t handle = duk_get_int(ctx, 0);
	window_remove_callback_by_handle(ctx, priv, (size_t) handle);

	return 0;
#line 1053 "window.c"
}

static duk_ret_t dukky_window_createImageBitmap(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_window_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 422 "Window.bnd"

	duk_push_this(ctx);
	return 1;
#line 1087 "window.c"
}

static duk_ret_t dukky_window_self_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_document_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 414 "Window.bnd"

	NSLOG(netsurf, DEBUG, "priv=%p", priv);
	dom_document *doc = priv->htmlc->document;
	dukky_push_node(ctx, (struct dom_node *)doc);
	return 1;
#line 1123 "window.c"
}

static duk_ret_t dukky_window_name_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 483 "Window.bnd"

	const char *name;
	browser_window_get_name(priv->win, &name);
	duk_push_string(ctx, name);
	return 1;
#line 1144 "window.c"
}

static duk_ret_t dukky_window_name_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 491 "Window.bnd"

	const char *name;
	name = duk_to_string(ctx, -1);
	browser_window_set_name(priv->win, name);
	return 0;
#line 1165 "window.c"
}

static duk_ret_t dukky_window_location_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 443 "Window.bnd"

	/* obtain location object for this window (if it exists) */
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, MAGIC(Location));
	if (duk_is_undefined(ctx, -1)) {
		/* location object did not previously exist so create it */
		duk_pop(ctx);

		duk_push_pointer(ctx, llcache_handle_get_url(priv->htmlc->base.llcache));

		if (dukky_create_object(ctx, PROTO_NAME(LOCATION), 1) != DUK_EXEC_SUCCESS) {
			return duk_error(ctx, DUK_ERR_ERROR, "Unable to create location object");
		}
		duk_dup(ctx, -1);
		duk_put_prop_string(ctx, -3, MAGIC(Location));
	}
	return 1;
#line 1198 "window.c"
}

static duk_ret_t dukky_window_location_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	duk_ret_t get_ret;

	get_ret = dukky_window_location_getter(ctx);
	if (get_ret != 1) {
		return 0;
	}

	/* parameter ... attribute */

	duk_dup(ctx, 0);
	/* ... attribute parameter */

	/* call the putforward */
	duk_put_prop_string(ctx, -2, "href");

	return 0;
}

static duk_ret_t dukky_window_history_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_locationbar_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_menubar_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_personalbar_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_scrollbars_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_statusbar_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_toolbar_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_status_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_status_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_closed_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_frames_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_length_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_top_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_opener_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_opener_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_parent_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_frameElement_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_navigator_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 463 "Window.bnd"

	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, MAGIC(Navigator));
	if (duk_is_undefined(ctx, -1)) {
		duk_pop(ctx);

		if (dukky_create_object(ctx,
					PROTO_NAME(NAVIGATOR),
					0) != DUK_EXEC_SUCCESS) {
			return duk_error(ctx,
				  DUK_ERR_ERROR,
				  "Unable to create navigator object");
		}
		duk_dup(ctx, -1);
		duk_put_prop_string(ctx, -3, MAGIC(Navigator));
	}
	return 1;
#line 1516 "window.c"
}

static duk_ret_t dukky_window_external_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_applicationCache_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_console_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 428 "Window.bnd"

	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, MAGIC(Console));
	if (duk_is_undefined(ctx, -1)) {
		duk_pop(ctx);
		if (dukky_create_object(ctx, PROTO_NAME(CONSOLE), 0) != DUK_EXEC_SUCCESS) {
			return duk_error(ctx, DUK_ERR_ERROR, "Unable to create console object");
		}
		duk_dup(ctx, -1);
		duk_put_prop_string(ctx, -3, MAGIC(Console));
	}
	return 1;
#line 1574 "window.c"
}

static duk_ret_t dukky_window_onabort_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 573 "Window.bnd"
#line 1590 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"abort", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onabort_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 574 "Window.bnd"
#line 1624 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "abort", 5);
	/* handlerfn this handlers abort */
	duk_dup(ctx, -4);
	/* handlerfn this handlers abort handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_abort, false);
	return 0;
}

static duk_ret_t dukky_window_onautocomplete_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 579 "Window.bnd"
#line 1655 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"autocomplete", 12, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onautocomplete_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 580 "Window.bnd"
#line 1689 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "autocomplete", 12);
	/* handlerfn this handlers autocomplete */
	duk_dup(ctx, -4);
	/* handlerfn this handlers autocomplete handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_autocomplete, false);
	return 0;
}

static duk_ret_t dukky_window_onautocompleteerror_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 577 "Window.bnd"
#line 1720 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"autocompleteerror", 17, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onautocompleteerror_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 578 "Window.bnd"
#line 1754 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "autocompleteerror", 17);
	/* handlerfn this handlers autocompleteerror */
	duk_dup(ctx, -4);
	/* handlerfn this handlers autocompleteerror handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_autocompleteerror, false);
	return 0;
}

static duk_ret_t dukky_window_onblur_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 585 "Window.bnd"
#line 1785 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"blur", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onblur_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 586 "Window.bnd"
#line 1819 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "blur", 4);
	/* handlerfn this handlers blur */
	duk_dup(ctx, -4);
	/* handlerfn this handlers blur handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_blur, false);
	return 0;
}

static duk_ret_t dukky_window_oncancel_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 587 "Window.bnd"
#line 1850 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"cancel", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_oncancel_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 588 "Window.bnd"
#line 1884 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "cancel", 6);
	/* handlerfn this handlers cancel */
	duk_dup(ctx, -4);
	/* handlerfn this handlers cancel handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_cancel, false);
	return 0;
}

static duk_ret_t dukky_window_oncanplay_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 591 "Window.bnd"
#line 1915 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"canplay", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_oncanplay_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 592 "Window.bnd"
#line 1949 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "canplay", 7);
	/* handlerfn this handlers canplay */
	duk_dup(ctx, -4);
	/* handlerfn this handlers canplay handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_canplay, false);
	return 0;
}

static duk_ret_t dukky_window_oncanplaythrough_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 589 "Window.bnd"
#line 1980 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"canplaythrough", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_oncanplaythrough_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 590 "Window.bnd"
#line 2014 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "canplaythrough", 14);
	/* handlerfn this handlers canplaythrough */
	duk_dup(ctx, -4);
	/* handlerfn this handlers canplaythrough handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_canplaythrough, false);
	return 0;
}

static duk_ret_t dukky_window_onchange_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 593 "Window.bnd"
#line 2045 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"change", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onchange_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 594 "Window.bnd"
#line 2079 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "change", 6);
	/* handlerfn this handlers change */
	duk_dup(ctx, -4);
	/* handlerfn this handlers change handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_change, false);
	return 0;
}

static duk_ret_t dukky_window_onclick_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 595 "Window.bnd"
#line 2110 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"click", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onclick_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 596 "Window.bnd"
#line 2144 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "click", 5);
	/* handlerfn this handlers click */
	duk_dup(ctx, -4);
	/* handlerfn this handlers click handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_click, false);
	return 0;
}

static duk_ret_t dukky_window_onclose_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 597 "Window.bnd"
#line 2175 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"close", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onclose_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 598 "Window.bnd"
#line 2209 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "close", 5);
	/* handlerfn this handlers close */
	duk_dup(ctx, -4);
	/* handlerfn this handlers close handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_close, false);
	return 0;
}

static duk_ret_t dukky_window_oncontextmenu_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 599 "Window.bnd"
#line 2240 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"contextmenu", 11, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_oncontextmenu_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 600 "Window.bnd"
#line 2274 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "contextmenu", 11);
	/* handlerfn this handlers contextmenu */
	duk_dup(ctx, -4);
	/* handlerfn this handlers contextmenu handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_contextmenu, false);
	return 0;
}

static duk_ret_t dukky_window_oncuechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 601 "Window.bnd"
#line 2305 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"cuechange", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_oncuechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 602 "Window.bnd"
#line 2339 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "cuechange", 9);
	/* handlerfn this handlers cuechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers cuechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_cuechange, false);
	return 0;
}

static duk_ret_t dukky_window_ondblclick_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 603 "Window.bnd"
#line 2370 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dblclick", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondblclick_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 604 "Window.bnd"
#line 2404 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dblclick", 8);
	/* handlerfn this handlers dblclick */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dblclick handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dblclick, false);
	return 0;
}

static duk_ret_t dukky_window_ondrag_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 617 "Window.bnd"
#line 2435 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"drag", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondrag_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 618 "Window.bnd"
#line 2469 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "drag", 4);
	/* handlerfn this handlers drag */
	duk_dup(ctx, -4);
	/* handlerfn this handlers drag handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_drag, false);
	return 0;
}

static duk_ret_t dukky_window_ondragend_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 605 "Window.bnd"
#line 2500 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragend", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondragend_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 606 "Window.bnd"
#line 2534 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragend", 7);
	/* handlerfn this handlers dragend */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragend handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragend, false);
	return 0;
}

static duk_ret_t dukky_window_ondragenter_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 607 "Window.bnd"
#line 2565 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragenter", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondragenter_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 608 "Window.bnd"
#line 2599 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragenter", 9);
	/* handlerfn this handlers dragenter */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragenter handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragenter, false);
	return 0;
}

static duk_ret_t dukky_window_ondragexit_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 609 "Window.bnd"
#line 2630 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragexit", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondragexit_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 610 "Window.bnd"
#line 2664 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragexit", 8);
	/* handlerfn this handlers dragexit */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragexit handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragexit, false);
	return 0;
}

static duk_ret_t dukky_window_ondragleave_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 611 "Window.bnd"
#line 2695 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragleave", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondragleave_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 612 "Window.bnd"
#line 2729 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragleave", 9);
	/* handlerfn this handlers dragleave */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragleave handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragleave, false);
	return 0;
}

static duk_ret_t dukky_window_ondragover_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 613 "Window.bnd"
#line 2760 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragover", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondragover_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 614 "Window.bnd"
#line 2794 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragover", 8);
	/* handlerfn this handlers dragover */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragover handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragover, false);
	return 0;
}

static duk_ret_t dukky_window_ondragstart_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 615 "Window.bnd"
#line 2825 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"dragstart", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondragstart_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 616 "Window.bnd"
#line 2859 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "dragstart", 9);
	/* handlerfn this handlers dragstart */
	duk_dup(ctx, -4);
	/* handlerfn this handlers dragstart handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_dragstart, false);
	return 0;
}

static duk_ret_t dukky_window_ondrop_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 619 "Window.bnd"
#line 2890 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"drop", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondrop_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 620 "Window.bnd"
#line 2924 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "drop", 4);
	/* handlerfn this handlers drop */
	duk_dup(ctx, -4);
	/* handlerfn this handlers drop handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_drop, false);
	return 0;
}

static duk_ret_t dukky_window_ondurationchange_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 621 "Window.bnd"
#line 2955 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"durationchange", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ondurationchange_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 622 "Window.bnd"
#line 2989 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "durationchange", 14);
	/* handlerfn this handlers durationchange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers durationchange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_durationchange, false);
	return 0;
}

static duk_ret_t dukky_window_onemptied_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 623 "Window.bnd"
#line 3020 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"emptied", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onemptied_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 624 "Window.bnd"
#line 3054 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "emptied", 7);
	/* handlerfn this handlers emptied */
	duk_dup(ctx, -4);
	/* handlerfn this handlers emptied handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_emptied, false);
	return 0;
}

static duk_ret_t dukky_window_onended_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 625 "Window.bnd"
#line 3085 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"ended", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onended_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 626 "Window.bnd"
#line 3119 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "ended", 5);
	/* handlerfn this handlers ended */
	duk_dup(ctx, -4);
	/* handlerfn this handlers ended handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_ended, false);
	return 0;
}

static duk_ret_t dukky_window_onerror_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 627 "Window.bnd"
#line 3150 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"error", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onerror_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 628 "Window.bnd"
#line 3184 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "error", 5);
	/* handlerfn this handlers error */
	duk_dup(ctx, -4);
	/* handlerfn this handlers error handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_error, false);
	return 0;
}

static duk_ret_t dukky_window_onfocus_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 629 "Window.bnd"
#line 3215 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"focus", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onfocus_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 630 "Window.bnd"
#line 3249 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "focus", 5);
	/* handlerfn this handlers focus */
	duk_dup(ctx, -4);
	/* handlerfn this handlers focus handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_focus, false);
	return 0;
}

static duk_ret_t dukky_window_oninput_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 633 "Window.bnd"
#line 3280 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"input", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_oninput_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 634 "Window.bnd"
#line 3314 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "input", 5);
	/* handlerfn this handlers input */
	duk_dup(ctx, -4);
	/* handlerfn this handlers input handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_input, false);
	return 0;
}

static duk_ret_t dukky_window_oninvalid_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 635 "Window.bnd"
#line 3345 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"invalid", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_oninvalid_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 636 "Window.bnd"
#line 3379 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "invalid", 7);
	/* handlerfn this handlers invalid */
	duk_dup(ctx, -4);
	/* handlerfn this handlers invalid handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_invalid, false);
	return 0;
}

static duk_ret_t dukky_window_onkeydown_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 637 "Window.bnd"
#line 3410 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keydown", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onkeydown_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 638 "Window.bnd"
#line 3444 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keydown", 7);
	/* handlerfn this handlers keydown */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keydown handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keydown, false);
	return 0;
}

static duk_ret_t dukky_window_onkeypress_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 639 "Window.bnd"
#line 3475 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keypress", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onkeypress_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 640 "Window.bnd"
#line 3509 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keypress", 8);
	/* handlerfn this handlers keypress */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keypress handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keypress, false);
	return 0;
}

static duk_ret_t dukky_window_onkeyup_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 641 "Window.bnd"
#line 3540 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"keyup", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onkeyup_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 642 "Window.bnd"
#line 3574 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "keyup", 5);
	/* handlerfn this handlers keyup */
	duk_dup(ctx, -4);
	/* handlerfn this handlers keyup handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_keyup, false);
	return 0;
}

static duk_ret_t dukky_window_onload_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 651 "Window.bnd"
#line 3605 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"load", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onload_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 652 "Window.bnd"
#line 3639 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "load", 4);
	/* handlerfn this handlers load */
	duk_dup(ctx, -4);
	/* handlerfn this handlers load handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_load, false);
	return 0;
}

static duk_ret_t dukky_window_onloadeddata_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 645 "Window.bnd"
#line 3670 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadeddata", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onloadeddata_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 646 "Window.bnd"
#line 3704 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadeddata", 10);
	/* handlerfn this handlers loadeddata */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadeddata handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadeddata, false);
	return 0;
}

static duk_ret_t dukky_window_onloadedmetadata_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 647 "Window.bnd"
#line 3735 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadedmetadata", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onloadedmetadata_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 648 "Window.bnd"
#line 3769 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadedmetadata", 14);
	/* handlerfn this handlers loadedmetadata */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadedmetadata handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadedmetadata, false);
	return 0;
}

static duk_ret_t dukky_window_onloadstart_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 649 "Window.bnd"
#line 3800 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"loadstart", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onloadstart_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 650 "Window.bnd"
#line 3834 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "loadstart", 9);
	/* handlerfn this handlers loadstart */
	duk_dup(ctx, -4);
	/* handlerfn this handlers loadstart handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_loadstart, false);
	return 0;
}

static duk_ret_t dukky_window_onmousedown_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 655 "Window.bnd"
#line 3865 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mousedown", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmousedown_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 656 "Window.bnd"
#line 3899 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mousedown", 9);
	/* handlerfn this handlers mousedown */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mousedown handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mousedown, false);
	return 0;
}

static duk_ret_t dukky_window_onmouseenter_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 657 "Window.bnd"
#line 3930 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseenter", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmouseenter_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 658 "Window.bnd"
#line 3964 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseenter", 10);
	/* handlerfn this handlers mouseenter */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseenter handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseenter, false);
	return 0;
}

static duk_ret_t dukky_window_onmouseleave_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 659 "Window.bnd"
#line 3995 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseleave", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmouseleave_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 660 "Window.bnd"
#line 4029 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseleave", 10);
	/* handlerfn this handlers mouseleave */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseleave handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseleave, false);
	return 0;
}

static duk_ret_t dukky_window_onmousemove_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 661 "Window.bnd"
#line 4060 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mousemove", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmousemove_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 662 "Window.bnd"
#line 4094 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mousemove", 9);
	/* handlerfn this handlers mousemove */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mousemove handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mousemove, false);
	return 0;
}

static duk_ret_t dukky_window_onmouseout_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 663 "Window.bnd"
#line 4125 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseout", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmouseout_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 664 "Window.bnd"
#line 4159 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseout", 8);
	/* handlerfn this handlers mouseout */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseout handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseout, false);
	return 0;
}

static duk_ret_t dukky_window_onmouseover_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 665 "Window.bnd"
#line 4190 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseover", 9, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmouseover_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 666 "Window.bnd"
#line 4224 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseover", 9);
	/* handlerfn this handlers mouseover */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseover handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseover, false);
	return 0;
}

static duk_ret_t dukky_window_onmouseup_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 667 "Window.bnd"
#line 4255 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"mouseup", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmouseup_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 668 "Window.bnd"
#line 4289 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "mouseup", 7);
	/* handlerfn this handlers mouseup */
	duk_dup(ctx, -4);
	/* handlerfn this handlers mouseup handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_mouseup, false);
	return 0;
}

static duk_ret_t dukky_window_onwheel_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 723 "Window.bnd"
#line 4320 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"wheel", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onwheel_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 724 "Window.bnd"
#line 4354 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "wheel", 5);
	/* handlerfn this handlers wheel */
	duk_dup(ctx, -4);
	/* handlerfn this handlers wheel handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_wheel, false);
	return 0;
}

static duk_ret_t dukky_window_onpause_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 677 "Window.bnd"
#line 4385 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"pause", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onpause_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 678 "Window.bnd"
#line 4419 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "pause", 5);
	/* handlerfn this handlers pause */
	duk_dup(ctx, -4);
	/* handlerfn this handlers pause handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_pause, false);
	return 0;
}

static duk_ret_t dukky_window_onplay_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 681 "Window.bnd"
#line 4450 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"play", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onplay_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 682 "Window.bnd"
#line 4484 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "play", 4);
	/* handlerfn this handlers play */
	duk_dup(ctx, -4);
	/* handlerfn this handlers play handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_play, false);
	return 0;
}

static duk_ret_t dukky_window_onplaying_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 679 "Window.bnd"
#line 4515 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"playing", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onplaying_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 680 "Window.bnd"
#line 4549 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "playing", 7);
	/* handlerfn this handlers playing */
	duk_dup(ctx, -4);
	/* handlerfn this handlers playing handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_playing, false);
	return 0;
}

static duk_ret_t dukky_window_onprogress_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 685 "Window.bnd"
#line 4580 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"progress", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onprogress_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 686 "Window.bnd"
#line 4614 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "progress", 8);
	/* handlerfn this handlers progress */
	duk_dup(ctx, -4);
	/* handlerfn this handlers progress handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_progress, false);
	return 0;
}

static duk_ret_t dukky_window_onratechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 687 "Window.bnd"
#line 4645 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"ratechange", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onratechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 688 "Window.bnd"
#line 4679 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "ratechange", 10);
	/* handlerfn this handlers ratechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers ratechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_ratechange, false);
	return 0;
}

static duk_ret_t dukky_window_onreset_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 689 "Window.bnd"
#line 4710 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"reset", 5, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onreset_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 690 "Window.bnd"
#line 4744 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "reset", 5);
	/* handlerfn this handlers reset */
	duk_dup(ctx, -4);
	/* handlerfn this handlers reset handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_reset, false);
	return 0;
}

static duk_ret_t dukky_window_onresize_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 691 "Window.bnd"
#line 4775 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"resize", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onresize_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 692 "Window.bnd"
#line 4809 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "resize", 6);
	/* handlerfn this handlers resize */
	duk_dup(ctx, -4);
	/* handlerfn this handlers resize handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_resize, false);
	return 0;
}

static duk_ret_t dukky_window_onscroll_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 693 "Window.bnd"
#line 4840 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"scroll", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onscroll_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 694 "Window.bnd"
#line 4874 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "scroll", 6);
	/* handlerfn this handlers scroll */
	duk_dup(ctx, -4);
	/* handlerfn this handlers scroll handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_scroll, false);
	return 0;
}

static duk_ret_t dukky_window_onseeked_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 695 "Window.bnd"
#line 4905 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"seeked", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onseeked_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 696 "Window.bnd"
#line 4939 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "seeked", 6);
	/* handlerfn this handlers seeked */
	duk_dup(ctx, -4);
	/* handlerfn this handlers seeked handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_seeked, false);
	return 0;
}

static duk_ret_t dukky_window_onseeking_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 697 "Window.bnd"
#line 4970 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"seeking", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onseeking_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 698 "Window.bnd"
#line 5004 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "seeking", 7);
	/* handlerfn this handlers seeking */
	duk_dup(ctx, -4);
	/* handlerfn this handlers seeking handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_seeking, false);
	return 0;
}

static duk_ret_t dukky_window_onselect_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 699 "Window.bnd"
#line 5035 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"select", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onselect_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 700 "Window.bnd"
#line 5069 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "select", 6);
	/* handlerfn this handlers select */
	duk_dup(ctx, -4);
	/* handlerfn this handlers select handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_select, false);
	return 0;
}

static duk_ret_t dukky_window_onshow_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 701 "Window.bnd"
#line 5100 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"show", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onshow_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 702 "Window.bnd"
#line 5134 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "show", 4);
	/* handlerfn this handlers show */
	duk_dup(ctx, -4);
	/* handlerfn this handlers show handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_show, false);
	return 0;
}

static duk_ret_t dukky_window_onsort_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 703 "Window.bnd"
#line 5165 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"sort", 4, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onsort_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 704 "Window.bnd"
#line 5199 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "sort", 4);
	/* handlerfn this handlers sort */
	duk_dup(ctx, -4);
	/* handlerfn this handlers sort handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_sort, false);
	return 0;
}

static duk_ret_t dukky_window_onstalled_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 705 "Window.bnd"
#line 5230 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"stalled", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onstalled_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 706 "Window.bnd"
#line 5264 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "stalled", 7);
	/* handlerfn this handlers stalled */
	duk_dup(ctx, -4);
	/* handlerfn this handlers stalled handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_stalled, false);
	return 0;
}

static duk_ret_t dukky_window_onsubmit_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 709 "Window.bnd"
#line 5295 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"submit", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onsubmit_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 710 "Window.bnd"
#line 5329 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "submit", 6);
	/* handlerfn this handlers submit */
	duk_dup(ctx, -4);
	/* handlerfn this handlers submit handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_submit, false);
	return 0;
}

static duk_ret_t dukky_window_onsuspend_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 711 "Window.bnd"
#line 5360 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"suspend", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onsuspend_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 712 "Window.bnd"
#line 5394 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "suspend", 7);
	/* handlerfn this handlers suspend */
	duk_dup(ctx, -4);
	/* handlerfn this handlers suspend handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_suspend, false);
	return 0;
}

static duk_ret_t dukky_window_ontimeupdate_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 713 "Window.bnd"
#line 5425 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"timeupdate", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ontimeupdate_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 714 "Window.bnd"
#line 5459 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "timeupdate", 10);
	/* handlerfn this handlers timeupdate */
	duk_dup(ctx, -4);
	/* handlerfn this handlers timeupdate handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_timeupdate, false);
	return 0;
}

static duk_ret_t dukky_window_ontoggle_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 715 "Window.bnd"
#line 5490 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"toggle", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ontoggle_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 716 "Window.bnd"
#line 5524 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "toggle", 6);
	/* handlerfn this handlers toggle */
	duk_dup(ctx, -4);
	/* handlerfn this handlers toggle handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_toggle, false);
	return 0;
}

static duk_ret_t dukky_window_onvolumechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 719 "Window.bnd"
#line 5555 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"volumechange", 12, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onvolumechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 720 "Window.bnd"
#line 5589 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "volumechange", 12);
	/* handlerfn this handlers volumechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers volumechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_volumechange, false);
	return 0;
}

static duk_ret_t dukky_window_onwaiting_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 721 "Window.bnd"
#line 5620 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"waiting", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onwaiting_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 722 "Window.bnd"
#line 5654 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "waiting", 7);
	/* handlerfn this handlers waiting */
	duk_dup(ctx, -4);
	/* handlerfn this handlers waiting handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_waiting, false);
	return 0;
}

static duk_ret_t dukky_window_onafterprint_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 575 "Window.bnd"
#line 5685 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"afterprint", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onafterprint_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 576 "Window.bnd"
#line 5719 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "afterprint", 10);
	/* handlerfn this handlers afterprint */
	duk_dup(ctx, -4);
	/* handlerfn this handlers afterprint handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_afterprint, false);
	return 0;
}

static duk_ret_t dukky_window_onbeforeprint_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 581 "Window.bnd"
#line 5750 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"beforeprint", 11, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onbeforeprint_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 582 "Window.bnd"
#line 5784 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "beforeprint", 11);
	/* handlerfn this handlers beforeprint */
	duk_dup(ctx, -4);
	/* handlerfn this handlers beforeprint handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_beforeprint, false);
	return 0;
}

static duk_ret_t dukky_window_onbeforeunload_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 583 "Window.bnd"
#line 5815 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"beforeunload", 12, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onbeforeunload_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 584 "Window.bnd"
#line 5849 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "beforeunload", 12);
	/* handlerfn this handlers beforeunload */
	duk_dup(ctx, -4);
	/* handlerfn this handlers beforeunload handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_beforeunload, false);
	return 0;
}

static duk_ret_t dukky_window_onhashchange_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 631 "Window.bnd"
#line 5880 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"hashchange", 10, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onhashchange_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 632 "Window.bnd"
#line 5914 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "hashchange", 10);
	/* handlerfn this handlers hashchange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers hashchange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_hashchange, false);
	return 0;
}

static duk_ret_t dukky_window_onlanguagechange_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 643 "Window.bnd"
#line 5945 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"languagechange", 14, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onlanguagechange_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 644 "Window.bnd"
#line 5979 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "languagechange", 14);
	/* handlerfn this handlers languagechange */
	duk_dup(ctx, -4);
	/* handlerfn this handlers languagechange handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_languagechange, false);
	return 0;
}

static duk_ret_t dukky_window_onmessage_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 653 "Window.bnd"
#line 6010 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"message", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onmessage_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 654 "Window.bnd"
#line 6044 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "message", 7);
	/* handlerfn this handlers message */
	duk_dup(ctx, -4);
	/* handlerfn this handlers message handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_message, false);
	return 0;
}

static duk_ret_t dukky_window_onoffline_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 669 "Window.bnd"
#line 6075 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"offline", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onoffline_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 670 "Window.bnd"
#line 6109 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "offline", 7);
	/* handlerfn this handlers offline */
	duk_dup(ctx, -4);
	/* handlerfn this handlers offline handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_offline, false);
	return 0;
}

static duk_ret_t dukky_window_ononline_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 671 "Window.bnd"
#line 6140 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"online", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_ononline_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 672 "Window.bnd"
#line 6174 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "online", 6);
	/* handlerfn this handlers online */
	duk_dup(ctx, -4);
	/* handlerfn this handlers online handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_online, false);
	return 0;
}

static duk_ret_t dukky_window_onpagehide_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 673 "Window.bnd"
#line 6205 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"pagehide", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onpagehide_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 674 "Window.bnd"
#line 6239 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "pagehide", 8);
	/* handlerfn this handlers pagehide */
	duk_dup(ctx, -4);
	/* handlerfn this handlers pagehide handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_pagehide, false);
	return 0;
}

static duk_ret_t dukky_window_onpageshow_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 675 "Window.bnd"
#line 6270 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"pageshow", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onpageshow_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 676 "Window.bnd"
#line 6304 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "pageshow", 8);
	/* handlerfn this handlers pageshow */
	duk_dup(ctx, -4);
	/* handlerfn this handlers pageshow handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_pageshow, false);
	return 0;
}

static duk_ret_t dukky_window_onpopstate_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 683 "Window.bnd"
#line 6335 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"popstate", 8, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onpopstate_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 684 "Window.bnd"
#line 6369 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "popstate", 8);
	/* handlerfn this handlers popstate */
	duk_dup(ctx, -4);
	/* handlerfn this handlers popstate handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_popstate, false);
	return 0;
}

static duk_ret_t dukky_window_onstorage_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 707 "Window.bnd"
#line 6400 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"storage", 7, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onstorage_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 708 "Window.bnd"
#line 6434 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "storage", 7);
	/* handlerfn this handlers storage */
	duk_dup(ctx, -4);
	/* handlerfn this handlers storage handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_storage, false);
	return 0;
}

static duk_ret_t dukky_window_onunload_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 717 "Window.bnd"
#line 6465 "window.c"
	dom_event_target *et = NULL;
	dom_string *name;
	dom_exception exc;

	exc = dom_string_create((const uint8_t *)"unload", 6, &name);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_this(ctx);
	/* ... node */
	if (dukky_get_current_value_of_event_handler(ctx, name, et) == false) {
		dom_string_unref(name);
		return 0;
	}
	dom_string_unref(name);
	/* ... handler node */
	duk_pop(ctx);
	/* ... handler */
	return 1;
}

static duk_ret_t dukky_window_onunload_setter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 718 "Window.bnd"
#line 6499 "window.c"
	dom_element *et = NULL;
	/* handlerfn */
	duk_push_this(ctx);
	/* handlerfn this */
	duk_get_prop_string(ctx, -1, HANDLER_MAGIC);
	/* handlerfn this handlers */
	duk_push_lstring(ctx, "unload", 6);
	/* handlerfn this handlers unload */
	duk_dup(ctx, -4);
	/* handlerfn this handlers unload handlerfn */
	duk_put_prop(ctx, -3);
	/* handlerfn this handlers */
	dukky_register_event_listener_for(ctx, et,
		corestring_dom_unload, false);
	return 0;
}

static duk_ret_t dukky_window_sessionStorage_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_window_localStorage_getter(duk_context *ctx)
{
	/* Get private data for method */
	window_private_t *priv = NULL;
	duk_push_global_object(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

duk_ret_t dukky_window___proto(duk_context *ctx, void *udata)
{

#define EXPOSE(v) \
	duk_get_global_string(ctx, #v); \
	duk_put_prop_string(ctx, 0, #v)
	/* https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects */
	/* ** Value properties */
	EXPOSE(Infinity);
	EXPOSE(NaN);
	EXPOSE(undefined);
	EXPOSE(null);
	EXPOSE(globalThis);

	/* ** Function properties */
	EXPOSE(eval);
	/* EXPOSE(uneval); */ /* Not standard, maybe not available */
	EXPOSE(isFinite);
	EXPOSE(isNaN);
	EXPOSE(parseFloat);
	EXPOSE(parseInt);
	EXPOSE(decodeURI);
	EXPOSE(decodeURIComponent);
	EXPOSE(encodeURI);
	EXPOSE(encodeURIComponent);
	EXPOSE(escape);
	EXPOSE(unescape);

	/* ** Fundamental Objects */
	EXPOSE(Object);
	EXPOSE(Function);
	EXPOSE(Boolean);
	EXPOSE(Symbol);
	EXPOSE(Error);
	EXPOSE(EvalError);
	EXPOSE(InternalError);
	EXPOSE(RangeError);
	EXPOSE(ReferenceError);
	EXPOSE(SyntaxError);
	EXPOSE(TypeError);
	EXPOSE(URIError);

	/* ** Numbers and Dates */
	EXPOSE(Number);
	EXPOSE(BigInt);
	EXPOSE(Math);
	EXPOSE(Date);

	/* ** Text Processing */
	EXPOSE(String);
	EXPOSE(RegExp);

	/* ** Indexed Collections */
	EXPOSE(Array);
	EXPOSE(Int8Array);
	EXPOSE(Uint8Array);
	EXPOSE(Uint8ClampedArray);
	EXPOSE(Int16Array);
	EXPOSE(Uint16Array);
	EXPOSE(Int32Array);
	EXPOSE(Uint32Array);
	EXPOSE(Float32Array);
	EXPOSE(Float64Array);
	/* EXPOSE(BigInt64Array); */ /* Duktape lacks this - nonstandard API */
	/* EXPOSE(BigUint64Array); */ /* Duktape lacks this - nonstandard API */

	/* ** Keyed Collections */
	/* EXPOSE(Map); */ /* Duktape lacks this - ES6 */
	/* EXPOSE(Set); */ /* Duktape lacks this - ES6 */
	/* EXPOSE(WeakMap); */ /* Duktape lacks this - ES6 */
	/* EXPOSE(WeakSet); */ /* Duktape lacks this - ES6 */

	/* Structured Data */
	EXPOSE(ArrayBuffer);
	/* EXPOSE(SharedArrayBuffer); */ /* Duktape lacks this - experimental API */
	/* EXPOSE(Atomics); */ /* Duktape lacks this - experimental API */
	EXPOSE(DataView);
	EXPOSE(JSON);

	/* ** Control abstraction properties */
	/* EXPOSE(Promise); */ /* Probably ought to be one of ours? Also ES6 */
	/* EXPOSE(Generator); */ /* Duktape and async? ES6 */
	/* EXPOSE(GeneratorFunction); */ /* Duktape and async? ES6 */
	/* EXPOSE(AsyncFunction); */ /* Duktape lacks this - experimental API */

	/* Reflection */
	EXPOSE(Reflect);
	EXPOSE(Proxy);

	/* ** Internationalisation */
	/* Duktape lacks Intl - Maybe polyfill it? */
	/* There is suggestion that cdn.polyfill.io exists for it */

	/* ** WebAssembly */
	/* As yet, Duktape lacks WA */
#undef EXPOSE
	/* Add s3kr1t method to close the JS thread (browsing context) */
	duk_dup(ctx, 0);
	duk_push_string(ctx, MAGIC(closedownThread));
	duk_push_c_function(ctx, dukky_window_closedown_thread, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set this prototype's prototype (left-parent) */
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_EVENTTARGET");
	duk_replace(ctx, -2);
	duk_set_prototype(ctx, 0);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "close");
	duk_push_c_function(ctx, dukky_window_close, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "stop");
	duk_push_c_function(ctx, dukky_window_stop, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "focus");
	duk_push_c_function(ctx, dukky_window_focus, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "blur");
	duk_push_c_function(ctx, dukky_window_blur, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "open");
	duk_push_c_function(ctx, dukky_window_open, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "alert");
	duk_push_c_function(ctx, dukky_window_alert, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "confirm");
	duk_push_c_function(ctx, dukky_window_confirm, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "prompt");
	duk_push_c_function(ctx, dukky_window_prompt, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "print");
	duk_push_c_function(ctx, dukky_window_print, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "showModalDialog");
	duk_push_c_function(ctx, dukky_window_showModalDialog, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "requestAnimationFrame");
	duk_push_c_function(ctx, dukky_window_requestAnimationFrame, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "cancelAnimationFrame");
	duk_push_c_function(ctx, dukky_window_cancelAnimationFrame, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "postMessage");
	duk_push_c_function(ctx, dukky_window_postMessage, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "captureEvents");
	duk_push_c_function(ctx, dukky_window_captureEvents, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "releaseEvents");
	duk_push_c_function(ctx, dukky_window_releaseEvents, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "getComputedStyle");
	duk_push_c_function(ctx, dukky_window_getComputedStyle, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "btoa");
	duk_push_c_function(ctx, dukky_window_btoa, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "atob");
	duk_push_c_function(ctx, dukky_window_atob, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "setTimeout");
	duk_push_c_function(ctx, dukky_window_setTimeout, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "clearTimeout");
	duk_push_c_function(ctx, dukky_window_clearTimeout, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "setInterval");
	duk_push_c_function(ctx, dukky_window_setInterval, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "clearInterval");
	duk_push_c_function(ctx, dukky_window_clearInterval, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createImageBitmap");
	duk_push_c_function(ctx, dukky_window_createImageBitmap, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "window");
	duk_push_c_function(ctx, dukky_window_window_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "self");
	duk_push_c_function(ctx, dukky_window_self_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "document");
	duk_push_c_function(ctx, dukky_window_document_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "name");
	duk_push_c_function(ctx, dukky_window_name_getter, 0);
	duk_push_c_function(ctx, dukky_window_name_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "location");
	duk_push_c_function(ctx, dukky_window_location_getter, 0);
	duk_push_c_function(ctx, dukky_window_location_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "history");
	duk_push_c_function(ctx, dukky_window_history_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "locationbar");
	duk_push_c_function(ctx, dukky_window_locationbar_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "menubar");
	duk_push_c_function(ctx, dukky_window_menubar_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "personalbar");
	duk_push_c_function(ctx, dukky_window_personalbar_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "scrollbars");
	duk_push_c_function(ctx, dukky_window_scrollbars_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "statusbar");
	duk_push_c_function(ctx, dukky_window_statusbar_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "toolbar");
	duk_push_c_function(ctx, dukky_window_toolbar_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "status");
	duk_push_c_function(ctx, dukky_window_status_getter, 0);
	duk_push_c_function(ctx, dukky_window_status_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "closed");
	duk_push_c_function(ctx, dukky_window_closed_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "frames");
	duk_push_c_function(ctx, dukky_window_frames_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "length");
	duk_push_c_function(ctx, dukky_window_length_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "top");
	duk_push_c_function(ctx, dukky_window_top_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "opener");
	duk_push_c_function(ctx, dukky_window_opener_getter, 0);
	duk_push_c_function(ctx, dukky_window_opener_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "parent");
	duk_push_c_function(ctx, dukky_window_parent_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "frameElement");
	duk_push_c_function(ctx, dukky_window_frameElement_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "navigator");
	duk_push_c_function(ctx, dukky_window_navigator_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "external");
	duk_push_c_function(ctx, dukky_window_external_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "applicationCache");
	duk_push_c_function(ctx, dukky_window_applicationCache_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "console");
	duk_push_c_function(ctx, dukky_window_console_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onabort");
	duk_push_c_function(ctx, dukky_window_onabort_getter, 0);
	duk_push_c_function(ctx, dukky_window_onabort_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onautocomplete");
	duk_push_c_function(ctx, dukky_window_onautocomplete_getter, 0);
	duk_push_c_function(ctx, dukky_window_onautocomplete_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onautocompleteerror");
	duk_push_c_function(ctx, dukky_window_onautocompleteerror_getter, 0);
	duk_push_c_function(ctx, dukky_window_onautocompleteerror_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onblur");
	duk_push_c_function(ctx, dukky_window_onblur_getter, 0);
	duk_push_c_function(ctx, dukky_window_onblur_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncancel");
	duk_push_c_function(ctx, dukky_window_oncancel_getter, 0);
	duk_push_c_function(ctx, dukky_window_oncancel_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncanplay");
	duk_push_c_function(ctx, dukky_window_oncanplay_getter, 0);
	duk_push_c_function(ctx, dukky_window_oncanplay_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncanplaythrough");
	duk_push_c_function(ctx, dukky_window_oncanplaythrough_getter, 0);
	duk_push_c_function(ctx, dukky_window_oncanplaythrough_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onchange");
	duk_push_c_function(ctx, dukky_window_onchange_getter, 0);
	duk_push_c_function(ctx, dukky_window_onchange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onclick");
	duk_push_c_function(ctx, dukky_window_onclick_getter, 0);
	duk_push_c_function(ctx, dukky_window_onclick_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onclose");
	duk_push_c_function(ctx, dukky_window_onclose_getter, 0);
	duk_push_c_function(ctx, dukky_window_onclose_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncontextmenu");
	duk_push_c_function(ctx, dukky_window_oncontextmenu_getter, 0);
	duk_push_c_function(ctx, dukky_window_oncontextmenu_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oncuechange");
	duk_push_c_function(ctx, dukky_window_oncuechange_getter, 0);
	duk_push_c_function(ctx, dukky_window_oncuechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondblclick");
	duk_push_c_function(ctx, dukky_window_ondblclick_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondblclick_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondrag");
	duk_push_c_function(ctx, dukky_window_ondrag_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondrag_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragend");
	duk_push_c_function(ctx, dukky_window_ondragend_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondragend_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragenter");
	duk_push_c_function(ctx, dukky_window_ondragenter_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondragenter_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragexit");
	duk_push_c_function(ctx, dukky_window_ondragexit_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondragexit_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragleave");
	duk_push_c_function(ctx, dukky_window_ondragleave_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondragleave_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragover");
	duk_push_c_function(ctx, dukky_window_ondragover_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondragover_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondragstart");
	duk_push_c_function(ctx, dukky_window_ondragstart_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondragstart_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondrop");
	duk_push_c_function(ctx, dukky_window_ondrop_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondrop_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ondurationchange");
	duk_push_c_function(ctx, dukky_window_ondurationchange_getter, 0);
	duk_push_c_function(ctx, dukky_window_ondurationchange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onemptied");
	duk_push_c_function(ctx, dukky_window_onemptied_getter, 0);
	duk_push_c_function(ctx, dukky_window_onemptied_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onended");
	duk_push_c_function(ctx, dukky_window_onended_getter, 0);
	duk_push_c_function(ctx, dukky_window_onended_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onerror");
	duk_push_c_function(ctx, dukky_window_onerror_getter, 0);
	duk_push_c_function(ctx, dukky_window_onerror_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onfocus");
	duk_push_c_function(ctx, dukky_window_onfocus_getter, 0);
	duk_push_c_function(ctx, dukky_window_onfocus_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oninput");
	duk_push_c_function(ctx, dukky_window_oninput_getter, 0);
	duk_push_c_function(ctx, dukky_window_oninput_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "oninvalid");
	duk_push_c_function(ctx, dukky_window_oninvalid_getter, 0);
	duk_push_c_function(ctx, dukky_window_oninvalid_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeydown");
	duk_push_c_function(ctx, dukky_window_onkeydown_getter, 0);
	duk_push_c_function(ctx, dukky_window_onkeydown_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeypress");
	duk_push_c_function(ctx, dukky_window_onkeypress_getter, 0);
	duk_push_c_function(ctx, dukky_window_onkeypress_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onkeyup");
	duk_push_c_function(ctx, dukky_window_onkeyup_getter, 0);
	duk_push_c_function(ctx, dukky_window_onkeyup_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onload");
	duk_push_c_function(ctx, dukky_window_onload_getter, 0);
	duk_push_c_function(ctx, dukky_window_onload_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadeddata");
	duk_push_c_function(ctx, dukky_window_onloadeddata_getter, 0);
	duk_push_c_function(ctx, dukky_window_onloadeddata_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadedmetadata");
	duk_push_c_function(ctx, dukky_window_onloadedmetadata_getter, 0);
	duk_push_c_function(ctx, dukky_window_onloadedmetadata_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onloadstart");
	duk_push_c_function(ctx, dukky_window_onloadstart_getter, 0);
	duk_push_c_function(ctx, dukky_window_onloadstart_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmousedown");
	duk_push_c_function(ctx, dukky_window_onmousedown_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmousedown_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseenter");
	duk_push_c_function(ctx, dukky_window_onmouseenter_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmouseenter_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseleave");
	duk_push_c_function(ctx, dukky_window_onmouseleave_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmouseleave_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmousemove");
	duk_push_c_function(ctx, dukky_window_onmousemove_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmousemove_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseout");
	duk_push_c_function(ctx, dukky_window_onmouseout_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmouseout_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseover");
	duk_push_c_function(ctx, dukky_window_onmouseover_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmouseover_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmouseup");
	duk_push_c_function(ctx, dukky_window_onmouseup_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmouseup_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onwheel");
	duk_push_c_function(ctx, dukky_window_onwheel_getter, 0);
	duk_push_c_function(ctx, dukky_window_onwheel_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onpause");
	duk_push_c_function(ctx, dukky_window_onpause_getter, 0);
	duk_push_c_function(ctx, dukky_window_onpause_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onplay");
	duk_push_c_function(ctx, dukky_window_onplay_getter, 0);
	duk_push_c_function(ctx, dukky_window_onplay_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onplaying");
	duk_push_c_function(ctx, dukky_window_onplaying_getter, 0);
	duk_push_c_function(ctx, dukky_window_onplaying_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onprogress");
	duk_push_c_function(ctx, dukky_window_onprogress_getter, 0);
	duk_push_c_function(ctx, dukky_window_onprogress_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onratechange");
	duk_push_c_function(ctx, dukky_window_onratechange_getter, 0);
	duk_push_c_function(ctx, dukky_window_onratechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onreset");
	duk_push_c_function(ctx, dukky_window_onreset_getter, 0);
	duk_push_c_function(ctx, dukky_window_onreset_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onresize");
	duk_push_c_function(ctx, dukky_window_onresize_getter, 0);
	duk_push_c_function(ctx, dukky_window_onresize_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onscroll");
	duk_push_c_function(ctx, dukky_window_onscroll_getter, 0);
	duk_push_c_function(ctx, dukky_window_onscroll_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onseeked");
	duk_push_c_function(ctx, dukky_window_onseeked_getter, 0);
	duk_push_c_function(ctx, dukky_window_onseeked_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onseeking");
	duk_push_c_function(ctx, dukky_window_onseeking_getter, 0);
	duk_push_c_function(ctx, dukky_window_onseeking_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onselect");
	duk_push_c_function(ctx, dukky_window_onselect_getter, 0);
	duk_push_c_function(ctx, dukky_window_onselect_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onshow");
	duk_push_c_function(ctx, dukky_window_onshow_getter, 0);
	duk_push_c_function(ctx, dukky_window_onshow_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsort");
	duk_push_c_function(ctx, dukky_window_onsort_getter, 0);
	duk_push_c_function(ctx, dukky_window_onsort_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onstalled");
	duk_push_c_function(ctx, dukky_window_onstalled_getter, 0);
	duk_push_c_function(ctx, dukky_window_onstalled_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsubmit");
	duk_push_c_function(ctx, dukky_window_onsubmit_getter, 0);
	duk_push_c_function(ctx, dukky_window_onsubmit_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onsuspend");
	duk_push_c_function(ctx, dukky_window_onsuspend_getter, 0);
	duk_push_c_function(ctx, dukky_window_onsuspend_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ontimeupdate");
	duk_push_c_function(ctx, dukky_window_ontimeupdate_getter, 0);
	duk_push_c_function(ctx, dukky_window_ontimeupdate_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ontoggle");
	duk_push_c_function(ctx, dukky_window_ontoggle_getter, 0);
	duk_push_c_function(ctx, dukky_window_ontoggle_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onvolumechange");
	duk_push_c_function(ctx, dukky_window_onvolumechange_getter, 0);
	duk_push_c_function(ctx, dukky_window_onvolumechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onwaiting");
	duk_push_c_function(ctx, dukky_window_onwaiting_getter, 0);
	duk_push_c_function(ctx, dukky_window_onwaiting_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onafterprint");
	duk_push_c_function(ctx, dukky_window_onafterprint_getter, 0);
	duk_push_c_function(ctx, dukky_window_onafterprint_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onbeforeprint");
	duk_push_c_function(ctx, dukky_window_onbeforeprint_getter, 0);
	duk_push_c_function(ctx, dukky_window_onbeforeprint_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onbeforeunload");
	duk_push_c_function(ctx, dukky_window_onbeforeunload_getter, 0);
	duk_push_c_function(ctx, dukky_window_onbeforeunload_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onhashchange");
	duk_push_c_function(ctx, dukky_window_onhashchange_getter, 0);
	duk_push_c_function(ctx, dukky_window_onhashchange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onlanguagechange");
	duk_push_c_function(ctx, dukky_window_onlanguagechange_getter, 0);
	duk_push_c_function(ctx, dukky_window_onlanguagechange_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onmessage");
	duk_push_c_function(ctx, dukky_window_onmessage_getter, 0);
	duk_push_c_function(ctx, dukky_window_onmessage_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onoffline");
	duk_push_c_function(ctx, dukky_window_onoffline_getter, 0);
	duk_push_c_function(ctx, dukky_window_onoffline_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ononline");
	duk_push_c_function(ctx, dukky_window_ononline_getter, 0);
	duk_push_c_function(ctx, dukky_window_ononline_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onpagehide");
	duk_push_c_function(ctx, dukky_window_onpagehide_getter, 0);
	duk_push_c_function(ctx, dukky_window_onpagehide_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onpageshow");
	duk_push_c_function(ctx, dukky_window_onpageshow_getter, 0);
	duk_push_c_function(ctx, dukky_window_onpageshow_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onpopstate");
	duk_push_c_function(ctx, dukky_window_onpopstate_getter, 0);
	duk_push_c_function(ctx, dukky_window_onpopstate_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onstorage");
	duk_push_c_function(ctx, dukky_window_onstorage_getter, 0);
	duk_push_c_function(ctx, dukky_window_onstorage_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "onunload");
	duk_push_c_function(ctx, dukky_window_onunload_getter, 0);
	duk_push_c_function(ctx, dukky_window_onunload_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "sessionStorage");
	duk_push_c_function(ctx, dukky_window_sessionStorage_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "localStorage");
	duk_push_c_function(ctx, dukky_window_localStorage_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Create interface objects */
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CONSOLE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Console");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_URLSEARCHPARAMS");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "URLSearchParams");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_URL");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "URL");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_EVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Event");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MUTATIONEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MutationEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_UIEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "UIEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_COMPOSITIONEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CompositionEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_KEYBOARDEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "KeyboardEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MOUSEEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MouseEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_WHEELEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "WheelEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_FOCUSEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "FocusEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSS");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSS");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_PSEUDOELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "PseudoElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_SVGELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "SVGElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSSTYLEDECLARATION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSStyleDeclaration");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSRULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSNAMESPACERULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSNamespaceRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSMARGINRULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSMarginRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSGROUPINGRULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSGroupingRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSPAGERULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSPageRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSMEDIARULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSMediaRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSIMPORTRULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSImportRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSSTYLERULE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSStyleRule");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSRULELIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSRuleList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_STYLESHEETLIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "StyleSheetList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_STYLESHEET");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "StyleSheet");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CSSSTYLESHEET");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CSSStyleSheet");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MEDIALIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MediaList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_EVENTTARGET");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "EventTarget");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_NODE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Node");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_ELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Element");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLFONTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLFontElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLDIRECTORYELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLDirectoryElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLFRAMEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLFrameElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLFRAMESETELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLFrameSetElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMARQUEEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLMarqueeElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLAPPLETELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLAppletElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_STORAGEEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "StorageEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_STORAGE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Storage");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_WORKERLOCATION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "WorkerLocation");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_WORKERNAVIGATOR");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "WorkerNavigator");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_SHAREDWORKER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "SharedWorker");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_WORKER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Worker");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_WORKERGLOBALSCOPE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "WorkerGlobalScope");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_SHAREDWORKERGLOBALSCOPE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "SharedWorkerGlobalScope");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DEDICATEDWORKERGLOBALSCOPE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DedicatedWorkerGlobalScope");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_BROADCASTCHANNEL");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "BroadcastChannel");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MESSAGEPORT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MessagePort");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MESSAGECHANNEL");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MessageChannel");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CLOSEEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CloseEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_WEBSOCKET");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "WebSocket");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_EVENTSOURCE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "EventSource");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MESSAGEEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MessageEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_IMAGEBITMAP");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "ImageBitmap");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_EXTERNAL");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "External");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MIMETYPE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MimeType");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_PLUGIN");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Plugin");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MIMETYPEARRAY");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MimeTypeArray");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_PLUGINARRAY");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "PluginArray");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_NAVIGATOR");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Navigator");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_ERROREVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "ErrorEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_APPLICATIONCACHE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "ApplicationCache");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_BEFOREUNLOADEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "BeforeUnloadEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_PAGETRANSITIONEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "PageTransitionEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HASHCHANGEEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HashChangeEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_POPSTATEEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "PopStateEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_LOCATION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Location");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HISTORY");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "History");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_BARPROP");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "BarProp");
	duk_dup(ctx, 0);
	dukky_inject_not_ctr(ctx, 0, "Window");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DRAGEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DragEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DATATRANSFERITEM");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DataTransferItem");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DATATRANSFERITEMLIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DataTransferItemList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DATATRANSFER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DataTransfer");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TOUCH");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Touch");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_PATH2D");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Path2D");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DRAWINGSTYLE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DrawingStyle");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_IMAGEDATA");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "ImageData");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TEXTMETRICS");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TextMetrics");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CANVASPATTERN");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CanvasPattern");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CANVASGRADIENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CanvasGradient");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CANVASRENDERINGCONTEXT2D");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CanvasRenderingContext2D");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CANVASPROXY");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CanvasProxy");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLCANVASELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLCanvasElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTEMPLATEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTemplateElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLSCRIPTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLScriptElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLDIALOGELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLDialogElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_RELATEDEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "RelatedEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMENUITEMELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLMenuItemElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMENUELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLMenuElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLDETAILSELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLDetailsElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_VALIDITYSTATE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "ValidityState");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_AUTOCOMPLETEERROREVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "AutocompleteErrorEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLLEGENDELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLLegendElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLFIELDSETELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLFieldSetElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMETERELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLMeterElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLPROGRESSELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLProgressElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLOUTPUTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLOutputElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLKEYGENELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLKeygenElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTEXTAREAELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTextAreaElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLOPTIONELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLOptionElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLOPTGROUPELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLOptGroupElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLDATALISTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLDataListElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLSELECTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLSelectElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLBUTTONELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLButtonElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLINPUTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLInputElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLLABELELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLLabelElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLFORMELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLFormElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLECELLELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableCellElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLEHEADERCELLELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableHeaderCellElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLEDATACELLELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableDataCellElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLEROWELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableRowElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLESECTIONELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableSectionElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLECOLELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableColElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLECAPTIONELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableCaptionElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTABLEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTableElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLAREAELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLAreaElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMAPELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLMapElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TRACKEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TrackEvent");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TIMERANGES");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TimeRanges");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TEXTTRACKCUE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TextTrackCue");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TEXTTRACKCUELIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TextTrackCueList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TEXTTRACK");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TextTrack");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TEXTTRACKLIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TextTrackList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MEDIACONTROLLER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MediaController");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_VIDEOTRACK");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "VideoTrack");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_VIDEOTRACKLIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "VideoTrackList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_AUDIOTRACK");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "AudioTrack");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_AUDIOTRACKLIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "AudioTrackList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MEDIAERROR");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MediaError");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMEDIAELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLMediaElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTRACKELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTrackElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLAUDIOELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLAudioElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLVIDEOELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLVideoElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLPARAMELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLParamElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLOBJECTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLObjectElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLEMBEDELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLEmbedElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLIFRAMEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLIFrameElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLIMAGEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLImageElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLSOURCEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLSourceElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLPICTUREELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLPictureElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMODELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLModElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLBRELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLBRElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLSPANELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLSpanElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTIMEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTimeElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLDATAELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLDataElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLANCHORELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLAnchorElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLDIVELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLDivElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLDLISTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLDListElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLLIELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLLIElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLULISTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLUListElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLOLISTELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLOListElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLQUOTEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLQuoteElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLPREELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLPreElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLHRELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLHRElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLPARAGRAPHELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLParagraphElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLHEADINGELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLHeadingElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLBODYELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLBodyElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLSTYLEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLStyleElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLMETAELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLMetaElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLLINKELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLLinkElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLBASEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLBaseElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLTITLEELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLTitleElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLHEADELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLHeadElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLHTMLELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLHtmlElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLUNKNOWNELEMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLUnknownElement");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOMELEMENTMAP");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DOMElementMap");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOMSTRINGMAP");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DOMStringMap");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLCOLLECTION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLCollection");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLOPTIONSCOLLECTION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLOptionsCollection");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_NODELIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "NodeList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_RADIONODELIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "RadioNodeList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLFORMCONTROLSCOLLECTION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLFormControlsCollection");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_HTMLALLCOLLECTION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "HTMLAllCollection");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_XMLSERIALIZER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "XMLSerializer");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOMPARSER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DOMParser");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOMTOKENLIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DOMTokenList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOMSETTABLETOKENLIST");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DOMSettableTokenList");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_NODEFILTER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "NodeFilter");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TREEWALKER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "TreeWalker");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_NODEITERATOR");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "NodeIterator");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_RANGE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Range");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CHARACTERDATA");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CharacterData");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_COMMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Comment");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_PROCESSINGINSTRUCTION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "ProcessingInstruction");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_TEXT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Text");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_ATTR");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Attr");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_NAMEDNODEMAP");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "NamedNodeMap");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOMIMPLEMENTATION");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DOMImplementation");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOCUMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "Document");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_XMLDOCUMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "XMLDocument");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MUTATIONRECORD");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MutationRecord");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_MUTATIONOBSERVER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "MutationObserver");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOCUMENTTYPE");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DocumentType");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_DOCUMENTFRAGMENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "DocumentFragment");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_EVENTLISTENER");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "EventListener");
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_CUSTOMEVENT");
	duk_replace(ctx, -2);
	dukky_inject_not_ctr(ctx, 0, "CustomEvent");
	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_window___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_window___constructor, 3);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


