/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.android;

import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objenesis.ObjenesisException;
import org.objenesis.instantiator.ObjectInstantiator;

public class AndroidSerializationInstantiator<T>
implements ObjectInstantiator<T> {
    private final Class<T> type;
    private final ObjectStreamClass objectStreamClass;
    private final Method newInstanceMethod;

    public AndroidSerializationInstantiator(Class<T> clazz) {
        this.type = clazz;
        this.newInstanceMethod = AndroidSerializationInstantiator.getNewInstanceMethod();
        Method method = null;
        try {
            method = ObjectStreamClass.class.getMethod("lookupAny", Class.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjenesisException(noSuchMethodException);
        }
        try {
            this.objectStreamClass = (ObjectStreamClass)method.invoke(null, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjenesisException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjenesisException(invocationTargetException);
        }
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(this.newInstanceMethod.invoke((Object)this.objectStreamClass, this.type));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ObjenesisException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjenesisException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ObjenesisException(invocationTargetException);
        }
    }

    private static Method getNewInstanceMethod() {
        try {
            Method method = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class);
            method.setAccessible(true);
            return method;
        }
        catch (RuntimeException runtimeException) {
            throw new ObjenesisException(runtimeException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjenesisException(noSuchMethodException);
        }
    }
}

