/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.jrockit;

import java.lang.reflect.Method;
import org.objenesis.ObjenesisException;
import org.objenesis.instantiator.ObjectInstantiator;

public class JRockitLegacyInstantiator<T>
implements ObjectInstantiator<T> {
    private static Method safeAllocObjectMethod = null;
    private final Class<T> type;

    private static void initialize() {
        if (safeAllocObjectMethod == null) {
            try {
                Class<?> clazz = Class.forName("jrockit.vm.MemSystem");
                safeAllocObjectMethod = clazz.getDeclaredMethod("safeAllocObject", Class.class);
                safeAllocObjectMethod.setAccessible(true);
            }
            catch (RuntimeException runtimeException) {
                throw new ObjenesisException(runtimeException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ObjenesisException(classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ObjenesisException(noSuchMethodException);
            }
        }
    }

    public JRockitLegacyInstantiator(Class<T> clazz) {
        JRockitLegacyInstantiator.initialize();
        this.type = clazz;
    }

    @Override
    public T newInstance() {
        try {
            return this.type.cast(safeAllocObjectMethod.invoke(null, this.type));
        }
        catch (Exception exception) {
            throw new ObjenesisException(exception);
        }
    }
}

