/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | Website:  https://openfoam.org
    \\  /    A nd           | Copyright (C) 2011-2018 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::InfoProxy

Description
    A helper class for outputting values to Ostream

\*---------------------------------------------------------------------------*/

#ifndef InfoProxy_H
#define InfoProxy_H

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

class Ostream;

/*---------------------------------------------------------------------------*\
                           Class InfoProxy Declaration
\*---------------------------------------------------------------------------*/

template<class T> class InfoProxy;
template<class T> Ostream& operator<<(Ostream&, const InfoProxy<T>&);

template<class T>
class InfoProxy
{
public:

    const T& t_;

    InfoProxy(const T& t)
    :
        t_(t)
    {}

    friend Ostream& operator<< <T>
    (Ostream&, const InfoProxy<T>&);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
