/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.dmt.security.DmtPrincipalPermissionCollection;

public class DmtPrincipalPermission
extends Permission {
    private static final long serialVersionUID = 6388752177325038332L;
    private final boolean isPrefix;
    private final String principal;

    public DmtPrincipalPermission(String string) {
        super(string);
        if (string == null) {
            throw new NullPointerException("'target' parameter must not be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("'target' parameter must not be empty.");
        }
        this.isPrefix = string.endsWith("*");
        this.principal = this.isPrefix ? string.substring(0, string.length() - 1) : string;
    }

    public DmtPrincipalPermission(String string, String string2) {
        this(string);
        if (string2 == null) {
            throw new NullPointerException("'actions' parameter must not be null.");
        }
        if (!string2.equals("*")) {
            throw new IllegalArgumentException("'actions' parameter must be \"*\".");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DmtPrincipalPermission)) {
            return false;
        }
        DmtPrincipalPermission dmtPrincipalPermission = (DmtPrincipalPermission)object;
        return this.isPrefix == dmtPrincipalPermission.isPrefix && this.principal.equals(dmtPrincipalPermission.principal);
    }

    @Override
    public String getActions() {
        return "*";
    }

    @Override
    public int hashCode() {
        return new Boolean(this.isPrefix).hashCode() ^ this.principal.hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof DmtPrincipalPermission)) {
            return false;
        }
        DmtPrincipalPermission dmtPrincipalPermission = (DmtPrincipalPermission)permission;
        return this.impliesPrincipal(dmtPrincipalPermission);
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DmtPrincipalPermissionCollection();
    }

    boolean impliesPrincipal(DmtPrincipalPermission dmtPrincipalPermission) {
        return this.isPrefix ? dmtPrincipalPermission.principal.startsWith(this.principal) : !dmtPrincipalPermission.isPrefix && dmtPrincipalPermission.principal.equals(this.principal);
    }
}

