/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.remoteserviceadmin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class EndpointDescription {
    private final Map<String, Object> properties;
    private final List<String> interfaces;
    private final long serviceId;
    private final String frameworkUUID;
    private final String id;
    private static final String SERVICE_EXPORTED_ = "service.exported.";
    private static final int SERVICE_EXPORTED_length = "service.exported.".length();

    public EndpointDescription(Map<String, ?> map) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        try {
            treeMap.putAll(map);
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("non-String key in properties");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
        if (treeMap.size() < map.size()) {
            throw new IllegalArgumentException("duplicate keys with different cases in properties: " + new ArrayList(treeMap.keySet()).removeAll(map.keySet()));
        }
        this.conditionProperties(treeMap);
        this.properties = Collections.unmodifiableMap(treeMap);
        this.interfaces = this.verifyObjectClassProperty();
        this.serviceId = this.verifyLongProperty("endpoint.service.id");
        this.frameworkUUID = this.verifyStringProperty("endpoint.framework.uuid");
        String string = this.verifyStringProperty("endpoint.id");
        if (string == null) {
            throw new IllegalArgumentException("endpoint.id property must be set");
        }
        this.id = string.trim();
        if (this.getConfigurationTypes().isEmpty()) {
            throw new IllegalArgumentException("service.imported.configs property must be set and non-empty");
        }
    }

    public EndpointDescription(final ServiceReference<?> serviceReference, Map<String, ?> map) {
        Object object;
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (map != null) {
            try {
                treeMap.putAll(map);
            }
            catch (ClassCastException classCastException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("non-String key in properties");
                illegalArgumentException.initCause(classCastException);
                throw illegalArgumentException;
            }
            if (treeMap.size() < map.size()) {
                throw new IllegalArgumentException("duplicate keys with different cases in properties: " + new ArrayList(treeMap.keySet()).removeAll(map.keySet()));
            }
        }
        for (String string : serviceReference.getPropertyKeys()) {
            if (treeMap.containsKey(string)) continue;
            treeMap.put(string, serviceReference.getProperty(string));
        }
        if (!treeMap.containsKey("endpoint.service.id")) {
            treeMap.put("endpoint.service.id", serviceReference.getProperty("service.id"));
        }
        if (!treeMap.containsKey("endpoint.framework.uuid")) {
            object = null;
            try {
                object = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return serviceReference.getBundle().getBundleContext().getProperty("org.osgi.framework.uuid");
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (object != null) {
                treeMap.put("endpoint.framework.uuid", object);
            }
        }
        this.conditionProperties(treeMap);
        this.properties = Collections.unmodifiableMap(treeMap);
        this.interfaces = this.verifyObjectClassProperty();
        this.serviceId = this.verifyLongProperty("endpoint.service.id");
        this.frameworkUUID = this.verifyStringProperty("endpoint.framework.uuid");
        object = this.verifyStringProperty("endpoint.id");
        if (object == null) {
            throw new IllegalArgumentException("endpoint.id property must be set");
        }
        this.id = ((String)object).trim();
        if (this.getConfigurationTypes().isEmpty()) {
            throw new IllegalArgumentException("service.imported.configs property must be set and non-empty");
        }
    }

    private void conditionProperties(Map<String, Object> map) {
        if (!map.containsKey("service.imported")) {
            map.put("service.imported", Boolean.toString(true));
        }
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!SERVICE_EXPORTED_.regionMatches(true, 0, string, 0, SERVICE_EXPORTED_length)) continue;
            iterator.remove();
        }
    }

    private List<String> verifyObjectClassProperty() {
        Object object = this.properties.get("objectClass");
        if (!(object instanceof String[])) {
            throw new IllegalArgumentException("objectClass value must be of type String[]");
        }
        String[] stringArray = (String[])object;
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("objectClass is empty");
        }
        for (String string : stringArray) {
            int n = string.lastIndexOf(46);
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            try {
                this.getPackageVersion(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException("Improper version for package " + string2);
                illegalArgumentException2.initCause(illegalArgumentException);
                throw illegalArgumentException2;
            }
        }
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    private String verifyStringProperty(String string) {
        Object object = this.properties.get(string);
        try {
            return (String)object;
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("property value is not a String: " + string);
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
    }

    private long verifyLongProperty(String string) {
        Object object = this.properties.get(string);
        if (object == null) {
            return 0L;
        }
        try {
            return (Long)object;
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("property value is not a Long: " + string);
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public Version getPackageVersion(String string) {
        String string2;
        String string3 = "endpoint.package.version." + string;
        Object object = this.properties.get(string3);
        try {
            string2 = (String)object;
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3 + " property value is not a String");
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
        return Version.parseVersion((String)string2);
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public List<String> getConfigurationTypes() {
        return this.getStringPlusProperty("service.imported.configs");
    }

    public List<String> getIntents() {
        return this.getStringPlusProperty("service.intents");
    }

    private List<String> getStringPlusProperty(String string) {
        Object object = this.properties.get(string);
        if (object == null) {
            return EndpointDescription.emptyList();
        }
        if (object instanceof String) {
            return Collections.singletonList((String)object);
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                arrayList.add(string2);
            }
            return Collections.unmodifiableList(arrayList);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (Object e : collection) {
                if (!(e instanceof String)) continue;
                arrayList.add((String)e);
            }
            return Collections.unmodifiableList(arrayList);
        }
        return EndpointDescription.emptyList();
    }

    private static <T> List<T> emptyList() {
        return Collections.EMPTY_LIST;
    }

    public String getFrameworkUUID() {
        return this.frameworkUUID;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isSameService(EndpointDescription endpointDescription) {
        if (this.equals(endpointDescription)) {
            return true;
        }
        if (this.getFrameworkUUID() == null) {
            return false;
        }
        return this.getServiceId() == endpointDescription.getServiceId() && this.getFrameworkUUID().equals(endpointDescription.getFrameworkUUID());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EndpointDescription)) {
            return false;
        }
        return this.getId().equals(((EndpointDescription)object).getId());
    }

    public boolean matches(String string) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(invalidSyntaxException.getMessage());
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
        UnmodifiableDictionary<String, Object> unmodifiableDictionary = new UnmodifiableDictionary<String, Object>(this.properties);
        return filter.matchCase(unmodifiableDictionary);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Iterator<Map.Entry<String, Object>> iterator = this.properties.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Class<?> clazz;
            Map.Entry<String, Object> entry = iterator.next();
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            Object object = entry.getValue();
            if (object != null && Object[].class.isAssignableFrom(clazz = object.getClass())) {
                EndpointDescription.append(stringBuffer, (Object[])object);
                continue;
            }
            stringBuffer.append(object);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static void append(StringBuffer stringBuffer, Object[] objectArray) {
        stringBuffer.append('[');
        boolean bl = false;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(String.valueOf(objectArray[i]));
        }
        stringBuffer.append(']');
    }

    static final class UnmodifiableDictionary<K, V>
    extends Dictionary<K, V> {
        private final Map<K, V> wrapped;

        UnmodifiableDictionary(Map<K, V> map) {
            this.wrapped = map;
        }

        @Override
        public Enumeration<V> elements() {
            return Collections.enumeration(this.wrapped.values());
        }

        @Override
        public V get(Object object) {
            return this.wrapped.get(object);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public Enumeration<K> keys() {
            return Collections.enumeration(this.wrapped.keySet());
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }
}

