/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;
import java.util.Hashtable;

public class DistinctEnumeration
implements NodeEnumeration {
    private NodeEnumeration p1;
    private NodeEnumeration e1;
    private Hashtable lookup = new Hashtable();
    private Context context;
    private Expression expression;
    private Controller controller;
    NodeInfo nextNode = null;

    public DistinctEnumeration(NodeEnumeration nodeEnumeration, Controller controller) throws XPathException {
        this.p1 = nodeEnumeration;
        this.context = null;
        this.expression = null;
        this.controller = controller;
        this.e1 = nodeEnumeration;
        if (!this.e1.isSorted()) {
            this.e1 = new NodeSetExtent(this.e1, (NodeOrderComparer)controller).sort().enumerate();
        }
        if (this.e1.hasMoreElements()) {
            this.nextNode = this.e1.nextElement();
            this.advance();
        }
    }

    public DistinctEnumeration(Context context, NodeEnumeration nodeEnumeration, Expression expression) throws XPathException {
        this.p1 = nodeEnumeration;
        this.context = context.newContext();
        this.expression = expression;
        this.controller = context.getController();
        this.e1 = nodeEnumeration;
        if (!this.e1.isSorted()) {
            this.e1 = new NodeSetExtent(this.e1, (NodeOrderComparer)this.controller).sort().enumerate();
        }
        if (this.e1.hasMoreElements()) {
            this.nextNode = this.e1.nextElement();
            this.advance();
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextNode != null;
    }

    @Override
    public NodeInfo nextElement() throws XPathException {
        NodeInfo nodeInfo = this.nextNode;
        this.advance();
        return nodeInfo;
    }

    private void advance() throws XPathException {
        while (this.nextNode != null) {
            String string;
            if (this.expression == null) {
                string = this.nextNode.getStringValue();
            } else {
                this.context.setContextNode(this.nextNode);
                this.context.setPosition(1);
                this.context.setLast(1);
                string = this.expression.evaluateAsString(this.context);
            }
            if (this.lookup.get(string) == null) {
                this.lookup.put(string, this.nextNode);
                return;
            }
            if (this.e1.hasMoreElements()) {
                this.nextNode = this.e1.nextElement();
                continue;
            }
            this.nextNode = null;
        }
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public boolean isReverseSorted() {
        return false;
    }

    @Override
    public boolean isPeer() {
        return false;
    }
}

