/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.Tokenizer;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class SingletonComparison
extends Expression {
    SingletonExpression node;
    int operator;
    Value value;

    public SingletonComparison(SingletonExpression singletonExpression, int n, Value value) {
        this.node = singletonExpression;
        this.operator = n;
        this.value = value;
    }

    @Override
    public Expression simplify() throws XPathException {
        return this;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        boolean bl = this.node.evaluateAsBoolean(context);
        if (bl) {
            if (this.value instanceof StringValue || this.value instanceof FragmentValue || this.value instanceof TextFragmentValue) {
                switch (this.operator) {
                    case 11: {
                        return this.node.evaluateAsString(context).equals(this.value.asString());
                    }
                    case 34: {
                        return !this.node.evaluateAsString(context).equals(this.value.asString());
                    }
                    case 22: {
                        return this.node.evaluateAsNumber(context) < this.value.asNumber();
                    }
                    case 24: {
                        return this.node.evaluateAsNumber(context) <= this.value.asNumber();
                    }
                    case 21: {
                        return this.node.evaluateAsNumber(context) > this.value.asNumber();
                    }
                    case 23: {
                        return this.node.evaluateAsNumber(context) >= this.value.asNumber();
                    }
                }
                throw new XPathException("Bad operator in singleton comparison");
            }
            if (this.value instanceof NumericValue) {
                switch (this.operator) {
                    case 11: {
                        return this.node.evaluateAsNumber(context) == this.value.asNumber();
                    }
                    case 34: {
                        return this.node.evaluateAsNumber(context) != this.value.asNumber();
                    }
                    case 22: {
                        return this.node.evaluateAsNumber(context) < this.value.asNumber();
                    }
                    case 24: {
                        return this.node.evaluateAsNumber(context) <= this.value.asNumber();
                    }
                    case 21: {
                        return this.node.evaluateAsNumber(context) > this.value.asNumber();
                    }
                    case 23: {
                        return this.node.evaluateAsNumber(context) >= this.value.asNumber();
                    }
                }
                throw new XPathException("Bad operator in singleton comparison");
            }
            throw new XPathException("Unrecognized type in singleton comparison");
        }
        return false;
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public int getDependencies() {
        return this.node.getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if ((this.node.getDependencies() & n) != 0) {
            Expression expression = this.node.reduce(n, context);
            if (expression instanceof SingletonExpression) {
                expression = new SingletonComparison((SingletonExpression)expression, this.operator, this.value);
                expression.setStaticContext(this.getStaticContext());
                return expression.simplify();
            }
            if (expression instanceof NodeSetValue) {
                return new BooleanValue(((NodeSetValue)expression).compare(this.operator, this.value));
            }
            throw new XPathException("Failed to reduce SingletonComparison: returned " + expression.getClass());
        }
        return this;
    }

    @Override
    public void display(int n) {
        System.err.println(SingletonComparison.indent(n) + "SingletonComparison " + Tokenizer.tokens[this.operator]);
        this.node.display(n + 1);
        this.value.display(n + 1);
    }
}

