/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.SAXONFunction;
import javax.xml.transform.TransformerException;

public class StyleSheetFunctionCall
extends Function {
    private SAXONFunction function;
    private Controller boundController = null;
    private NodeInfo boundContextNode = null;
    private int boundContextPosition = -1;
    private int boundContextSize = -1;

    public void setFunction(SAXONFunction sAXONFunction) {
        this.function = sAXONFunction;
    }

    @Override
    public String getName() {
        return this.function.getAttribute("name");
    }

    @Override
    public int getDataType() {
        return -1;
    }

    @Override
    public Expression simplify() throws XPathException {
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            this.argument[i] = this.argument[i].simplify();
        }
        return this;
    }

    @Override
    public int getDependencies() {
        int n = 0;
        if (this.boundController == null) {
            n |= 0x40;
        }
        if (this.boundContextNode == null) {
            n |= 8;
        }
        if (this.boundContextPosition == -1) {
            n |= 0x10;
        }
        if (this.boundContextSize == -1) {
            n |= 0x20;
        }
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            n |= this.argument[i].getDependencies();
        }
        return n;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        StyleSheetFunctionCall styleSheetFunctionCall = new StyleSheetFunctionCall();
        styleSheetFunctionCall.setFunction(this.function);
        styleSheetFunctionCall.setStaticContext(this.getStaticContext());
        styleSheetFunctionCall.boundController = this.boundController;
        styleSheetFunctionCall.boundContextNode = this.boundContextNode;
        styleSheetFunctionCall.boundContextPosition = this.boundContextPosition;
        styleSheetFunctionCall.boundContextSize = this.boundContextSize;
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            styleSheetFunctionCall.addArgument(this.argument[i].reduce(n, context));
        }
        if (this.boundController == null && (n & 0x40) != 0) {
            styleSheetFunctionCall.boundController = context.getController();
        }
        if (this.boundContextNode == null && (n & 8) != 0) {
            styleSheetFunctionCall.boundContextNode = context.getContextNodeInfo();
        }
        if (this.boundContextPosition == -1 && (n & 0x10) != 0) {
            styleSheetFunctionCall.boundContextPosition = context.getContextPosition();
        }
        if (this.boundContextSize == -1 && (n & 0x20) != 0) {
            styleSheetFunctionCall.boundContextSize = context.getLast();
        }
        return styleSheetFunctionCall.simplify();
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        Context context2 = context.newContext();
        if (this.boundController != null) {
            context2.setController(this.boundController);
        }
        if (this.boundContextNode != null) {
            context2.setCurrentNode(this.boundContextNode);
            context2.setContextNode(this.boundContextNode);
        }
        if (this.boundContextPosition != -1) {
            context2.setPosition(this.boundContextPosition);
        }
        if (this.boundContextSize != -1) {
            context2.setLast(this.boundContextSize);
        }
        ParameterSet parameterSet = new ParameterSet();
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            int n = this.function.getNthParameter(i);
            if (n == -1) {
                throw new XPathException("Too many arguments");
            }
            parameterSet.put(n, this.argument[i].evaluate(context));
        }
        try {
            return this.function.call(parameterSet, context2);
        }
        catch (TransformerException transformerException) {
            throw new XPathException(transformerException);
        }
    }
}

