/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class Round
extends Function {
    @Override
    public String getName() {
        return "round";
    }

    @Override
    public int getDataType() {
        return 2;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        if (this.argument[0] instanceof Value) {
            return this.evaluate(null);
        }
        return this;
    }

    @Override
    public double evaluateAsNumber(Context context) throws XPathException {
        return Round.round(this.argument[0].evaluateAsNumber(context));
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new NumericValue(this.evaluateAsNumber(context));
    }

    @Override
    public int getDependencies() {
        return this.argument[0].getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        Round round = new Round();
        round.addArgument(this.argument[0].reduce(n, context));
        round.setStaticContext(this.getStaticContext());
        return round.simplify();
    }

    public static double round(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.isInfinite(d)) {
            return d;
        }
        if (d == 0.0) {
            return d;
        }
        if (d > -0.5 && d < 0.0) {
            return -0.0;
        }
        if (d > -9.223372036854776E18 && d < 9.223372036854776E18) {
            return Math.round(d);
        }
        double d2 = d % 1.0;
        if (d2 < 0.5) {
            return d - d2;
        }
        return d - d2 + 1.0;
    }
}

