/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.SAXONGroup;

public class GroupActivation
implements NodeEnumeration {
    private SAXONGroup group;
    private NodeEnumeration nodes;
    private Expression groupkey;
    private Context context;
    private NodeInfo next = null;
    private Value nextValue = null;
    private NodeInfo current = null;
    private Value currentValue = null;
    private int position = 0;

    public GroupActivation(SAXONGroup sAXONGroup, Expression expression, NodeEnumeration nodeEnumeration, Context context) throws XPathException {
        this.group = sAXONGroup;
        this.groupkey = expression;
        this.nodes = nodeEnumeration;
        this.context = context;
        this.position = 0;
        this.current = null;
        this.currentValue = null;
        this.lookAhead();
    }

    private void lookAhead() throws XPathException {
        if (this.nodes.hasMoreElements()) {
            this.next = this.nodes.nextElement();
            this.context.setCurrentNode(this.next);
            this.context.setContextNode(this.next);
            this.context.setPosition(this.position + 1);
            this.nextValue = this.groupkey.evaluate(this.context);
        } else {
            this.next = null;
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.next != null;
    }

    @Override
    public NodeInfo nextElement() throws XPathException {
        this.current = this.next;
        this.currentValue = this.nextValue;
        ++this.position;
        this.lookAhead();
        this.context.setCurrentNode(this.current);
        this.context.setContextNode(this.current);
        this.context.setPosition(this.position);
        return this.current;
    }

    public boolean sameAsNext() throws XPathException {
        if (this.next == null) {
            return false;
        }
        return this.currentValue.equals(this.nextValue);
    }

    @Override
    public boolean isSorted() {
        return this.nodes.isSorted();
    }

    @Override
    public boolean isReverseSorted() {
        return this.nodes.isReverseSorted();
    }

    @Override
    public boolean isPeer() {
        return this.nodes.isPeer();
    }
}

