/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.Mode;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.RuleManager;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONHandler
extends XSLTemplate {
    private NodeHandler handler;

    @Override
    public void checkUnknownAttribute(int n) throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n2 = n & 0xFFFFF;
        if (n2 == standardNames.HANDLER) {
            String string = attributeCollection.getValueByFingerprint(n2);
            this.handler = this.makeHandler(string);
        } else {
            super.checkUnknownAttribute(n);
        }
        if (this.handler == null) {
            this.reportAbsence("handler");
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        if (this.handler == null) {
            this.reportAbsence("handler");
        }
        this.checkTopLevel();
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        RuleManager ruleManager = this.getPrincipalStyleSheet().getRuleManager();
        Mode mode = ruleManager.getMode(this.modeNameCode);
        if (this.match != null) {
            if (this.prioritySpecified) {
                ruleManager.setHandler(this.match, this.handler, mode, this.getPrecedence(), this.priority);
            } else {
                ruleManager.setHandler(this.match, this.handler, mode, this.getPrecedence());
            }
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
    }

    @Override
    public void expand(Context context) throws TransformerException {
        this.handler.start(context.getCurrentNodeInfo(), context);
    }

    protected NodeHandler makeHandler(String string) throws TransformerConfigurationException {
        try {
            return (NodeHandler)Loader.getInstance(string);
        }
        catch (TransformerException transformerException) {
            this.compileError(transformerException);
        }
        catch (ClassCastException classCastException) {
            this.compileError("Node handler " + string + " does not implement the NodeHandler interface");
        }
        return null;
    }
}

