/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.tree.AttributeCollection;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONPreview
extends StyleElement {
    int previewModeNameCode = -1;
    String elements = null;

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.MODE) {
                String string = attributeCollection.getValue(i);
                try {
                    this.previewModeNameCode = this.makeNameCode(string, false);
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
                continue;
            }
            if (n2 == standardNames.ELEMENTS) {
                this.elements = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.previewModeNameCode == -1) {
            this.reportAbsence("mode");
        }
        if (this.elements == null) {
            this.reportAbsence("elements");
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        PreviewManager previewManager = xSLStyleSheet.getPreviewManager();
        if (previewManager == null) {
            previewManager = new PreviewManager();
            xSLStyleSheet.setPreviewManager(previewManager);
        }
        previewManager.setPreviewMode(this.previewModeNameCode);
        StringTokenizer stringTokenizer = new StringTokenizer(this.elements);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                previewManager.setPreviewElement(this.makeNameCode(string, true) & 0xFFFFF);
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
    }
}

