/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NamespaceTest;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;

public class XSLPreserveSpace
extends StyleElement {
    private String elements;

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.ELEMENTS) {
                this.elements = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.elements == null) {
            this.reportAbsence("elements");
            this.elements = "*";
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        Boolean bl = new Boolean(this.getFingerprint() == this.getStandardNames().XSL_PRESERVE_SPACE);
        Mode mode = this.getPrincipalStyleSheet().getStripperRules();
        StringTokenizer stringTokenizer = new StringTokenizer(this.elements);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                if (string.equals("*")) {
                    mode.addRule(AnyNodeTest.getInstance(), bl, this.getPrecedence(), -0.5);
                    continue;
                }
                if (string.endsWith(":*")) {
                    String string2 = string.substring(0, string.length() - 2);
                    mode.addRule(new NamespaceTest(this.getNamePool(), 1, this.getURICodeForPrefix(string2)), bl, this.getPrecedence(), -0.25);
                    continue;
                }
                if (!Name.isQName(string)) {
                    this.compileError("Element name " + string + " is not a valid QName");
                }
                mode.addRule(new NameTest(1, this.makeNameCode(string, false)), bl, this.getPrecedence(), 0.0);
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
        }
    }

    @Override
    public void process(Context context) {
    }
}

